/* Sfmview, to display an SFML (Starfleet Markup Language) page
	Usage: OpenSfml(char *filespec) to take a snapshot of the screen
		then restore it when the viewer closes, or
		or LcSfml(char *filespec) to call the viewer directly
*/

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "sfml.h"

void SfmReadSignageCode()
{
	char str[60];
	char keystr[12];
	int y,tx,ty,col,keycol;
	int iy;
	int x1,y1,x2,y2;

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<line ", Ln[y],6 )==0 ) {
			if(ParseTagbuf(Ln[y], "x1")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y1")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "x2")==0) x2=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y2")==0) y2=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			line(screen,x1,y1,x2,y2,col);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<draw ", Ln[y],6 )==0 ) {
			if(ParseTagbuf(Ln[y], "x1")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y1")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "x2")==0) x2=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y2")==0) y2=atoi(ParseResult);
			DrawLine(screen,x1,y1,x2,y2,SfmDrawColor,SfmLineThickness);
		}
		y++;
	} while(y < EndText);

	x1=x2;
	y1=y2;
	y=x2=y2=0;
	do {
		if(strnicmp( "<drawto ", Ln[y],8 )==0 ) {
			if(ParseTagbuf(Ln[y], "x2")==0) x2=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y2")==0) y2=atoi(ParseResult);
			DrawLine(screen,x1,y1,x2,y2,SfmDrawColor,SfmLineThickness);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<bar ", Ln[y],5 )==0 ) {
			if(ParseTagbuf(Ln[y], "x1")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y1")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "x2")==0) x2=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y2")==0) y2=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			rectfill(screen,x1,y1,x2,y2,col);
		}
		y++;
	} while(y < EndText);

	y=tx=ty=0;
	do {
		if(strnicmp( "<text10 ", Ln[y],8 )==0 ) {
			tx=ty=50;
			if(ParseTagbuf(Ln[y], "tx")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "ty")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			if(ty+tx !=0) PutsArial10(screen,tx,ty,col,str);
		}
		y++;
	} while(y < EndText);

	y=tx=ty=0;
	do {
		if(strnicmp( "<text14 ", Ln[y],8 )==0 ) {
			tx=ty=50;
			if(ParseTagbuf(Ln[y], "tx")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "ty")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			if(ty+tx !=0) PutsLuna(tx,ty,col,BLACK,str);
		}
		y++;
	} while(y < EndText);

	y=tx=ty=0;
	do {
		if(strnicmp( "<black14 ", Ln[y],8 )==0 ) {
			tx=ty=50;
			if(ParseTagbuf(Ln[y], "tx")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "ty")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "bg")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			if(ty+tx !=0) PutsLuna(tx,ty,BLACK,col,str);
		}
		y++;
	} while(y < EndText);

	y=tx=ty=0;
	do {
		if(strnicmp( "<text15 ", Ln[y],8 )==0 ) {
			tx=ty=50;
			if(ParseTagbuf(Ln[y], "tx")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "ty")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			if(ty+tx !=0) PutsLuna(tx,ty,col,BLACK,str);
		}
		y++;
	} while(y < EndText);

	y=tx=ty=0;
	do {
		if(strnicmp( "<text19 ", Ln[y],8 )==0 ) {
			tx=ty=50;
			if(ParseTagbuf(Ln[y], "tx")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "ty")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			if(ty+tx !=0) PutsFont19(tx,ty,col,str);
		}
		y++;
	} while(y < EndText);

	y=tx=ty=0;
	do {
		if(strnicmp( "<text21 ", Ln[y],8 )==0 ) {
			tx=ty=50;
			if(ParseTagbuf(Ln[y], "tx")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "ty")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			if(ty+tx !=0) PutsFont21(tx,ty,col,str);
		}
		y++;
	} while(y < EndText);

	y=tx=ty=0;
	do {
		if(strnicmp( "<text26 ", Ln[y],8 )==0 ) {
			tx=ty=50;
			if(ParseTagbuf(Ln[y], "tx")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "ty")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			if(ty+tx !=0) PutsScorpio(tx,ty,col,str);
		}
		y++;
	} while(y < EndText);

	y=tx=ty=0;
	do {
		if(strnicmp( "<text56 ", Ln[y],8 )==0 ) {
			tx=ty=50;
			if(ParseTagbuf(Ln[y], "tx")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "ty")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			if(ty+tx !=0) MarsF(tx,ty,2,col,BLACK,str);
		}
		y++;
	} while(y < EndText);

	y=tx=ty=0;
	do {
		if(strnicmp( "<text84 ", Ln[y],8 )==0 ) {
			tx=ty=50;
			if(ParseTagbuf(Ln[y], "tx")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "ty")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			if(ty+tx !=0) MarsF(tx,ty,3,col,BLACK,str);
		}
		y++;
	} while(y < EndText);

	y=tx=ty=0;
	do {
		if(strnicmp( "<text112 ", Ln[y],9 )==0 ) {
			tx=ty=50;
			if(ParseTagbuf(Ln[y], "tx")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "ty")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			if(ty+tx !=0) MarsF(tx,ty,4,col,BLACK,str);
		}
		y++;
	} while(y < EndText);

	y=tx=ty=0;
	do {
		if(strnicmp( "<text140 ", Ln[y],9 )==0 ) {
			tx=ty=50;
			if(ParseTagbuf(Ln[y], "tx")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "ty")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			if(ty+tx !=0) MarsF(tx,ty,5,col,BLACK,str);
		}
		y++;
	} while(y < EndText);

	y=0;
	do {
		if(strnicmp( "<ssf1box ", Ln[y],9 )==0 ) {
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			Br1F1Box(col, str, "F1");
		}
		y++;
	} while(y < EndText);
	y=0;
	do {
		if(strnicmp( "<ssf2box ", Ln[y],9 )==0 ) {
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			Br1F2Box(col, str, "F2");
		}
		y++;
	} while(y < EndText);
	y=0;
	do {
		if(strnicmp( "<ssf3box ", Ln[y],9 )==0 ) {
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			Br1F3Box(col, str, "F3");
		}
		y++;
	} while(y < EndText);
	y=0;
	do {
		if(strnicmp( "<ssf4box ", Ln[y],9 )==0 ) {
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			Br1F4Box(col, str, "F4");
		}
		y++;
	} while(y < EndText);
	y=0;
	do {
		if(strnicmp( "<ssf5box ", Ln[y],9 )==0 ) {
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			Br1F5Box(col, str, "F5");
		}
		y++;
	} while(y < EndText);
	y=0;
	do {
		if(strnicmp( "<ssf6box ", Ln[y],9 )==0 ) {
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			LowerElbowLabel(SfmBracketColor2, str, "F6");
		}
		y++;
	} while(y < EndText);
	y=0;
	do {
		if(strnicmp( "<ssf7box ", Ln[y],9 )==0 ) {
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			UpperElbowLabel(SfmBracketColor1, str, "F7");
		}
		y++;
	} while(y < EndText);

/* buttons, etc. */

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<pipe ", Ln[y],6 )==0 ) {
			if(ParseTagbuf(Ln[y], "x1")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y1")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "x2")==0) x2=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y2")==0) y2=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			Pipe(x1+54,19+(y1*47)-47+11,x2+54,19+(y2*47)-47+11,col);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<notchbox ", Ln[y],10 )==0 ) {
			if(ParseTagbuf(Ln[y], "x1")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y1")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			Notchbox(x1, y1, col, str);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<rr ", Ln[y],4 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			ButtonRR(x1, 19+(y1*47)-47, col, str);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<rs ", Ln[y],4 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			ButtonRS(x1, 19+(y1*47)-47, col, str);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<sr ", Ln[y],4 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			ButtonSR(x1, 19+(y1*47)-47, col, str);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<rfr ", Ln[y],5 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			ButtonType1(x1, 19+(y1*47)-47, col, str);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<sfs ", Ln[y],5 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			ButtonSFS(x1, 19+(y1*47)-47, col, str);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<rfs ", Ln[y],5 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			ButtonRFS(x1, 19+(y1*47)-47, col, str);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<sfr ", Ln[y],5 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			ButtonSFR(x1, 19+(y1*47)-47, col, str);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<rfkr ", Ln[y],6 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			if(ParseTagbuf(Ln[y], "keycolor")==0) keycol=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "kstr")==0) strcpy(keystr, ParseResult);
			ButtonType4(x1, 19+(y1*47)-47, col, str, keystr, keycol);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<sfkr ", Ln[y],6 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			if(ParseTagbuf(Ln[y], "keycolor")==0) keycol=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "kstr")==0) strcpy(keystr, ParseResult);
			ButtonType5(x1, 19+(y1*47)-47, col, str, keystr, keycol);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<rfks ", Ln[y],6 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			if(ParseTagbuf(Ln[y], "keycolor")==0) keycol=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "kstr")==0) strcpy(keystr, ParseResult);
			ButtonType6(x1, 19+(y1*47)-47, col, str, keystr, keycol);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<rfkb ", Ln[y],6 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			if(ParseTagbuf(Ln[y], "keycolor")==0) keycol=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "kstr")==0) strcpy(keystr, ParseResult);
			ButtonType7(x1, 19+(y1*47)-47, col, str, keystr, keycol);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<bbbr ", Ln[y],6 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			BrokenType4(x1, 19+(y1*47)-47, col);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<bbbk ", Ln[y],6 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "keycolor")==0) keycol=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "kstr")==0) strcpy(keystr, ParseResult);
			OfflineType6(x1,19+(y1*47)-47,keystr,keycol);
		}
		y++;
	} while(y < EndText);
	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<rb ", Ln[y],4 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			LeftBumper36(x1+36, 19+(y1*47)-47, col);
		}
		y++;
	} while(y < EndText);

/* ButtonType2 to be phased out */
	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<type2 ", Ln[y],7 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) y1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			ButtonType2(x1, 442, col, col, str);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<flange ", Ln[y],8 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			Flange(x1,col);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<hole ", Ln[y],6 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) x1=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "ypos")==0) y1=atoi(ParseResult);
			FlangeHole(x1, y1-1);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<arrowup ", Ln[y],9 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			UpArrowSymbol(tx,ty,col);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<arrowdown ", Ln[y],11 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			DownArrowSymbol(tx,ty,col);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<arrowleft ", Ln[y],11 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			LeftArrowSymbol(tx,ty,col);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<arrowright ", Ln[y],12 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			RightArrowSymbol(tx,ty,col);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<arrowheadup ", Ln[y],13 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			UpArrowHead(tx,ty,col);
		}
		y++;
	} while(y < EndText);

	y=x1=y1=x2=y2=0;
	do {
		if(strnicmp( "<bullet ", Ln[y],8 )==0 ) {
			if(ParseTagbuf(Ln[y], "x")==0) tx=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "y")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "color")==0) col=SfmGetNamedColor(ParseResult);
			Dot(tx,ty,col);
		}
		y++;
	} while(y < EndText);



}

void SfmReadDiagramCode()
{
	char str[60];
	int y,tx,ty,ix,tc,pc;
	int iy;
	int leftlen,leftpos,rightlen,rightpos;
	char Report[16];

	tc=SKYBLUE;
	pc=TAN;
	leftlen=rightlen=0;
	LabelNum=NumOfLabels=0;

	if( ! (__file_exists(SfmImage)) ) return;

/* find the longest label for each side, for justification */
	y=0;
	do {
		if(strnicmp( "<labelleft", Ln[y],10 )==0 ) {
			if(ParseTagbuf(Ln[y], "str")==0) {
				strcpy(str, ParseResult);
				leftpos=StrLenLuna(str);
				if(leftpos > leftlen) leftlen=leftpos;
			}
		}
		if(strnicmp( "<labelright", Ln[y],10 )==0 ) {
			if(ParseTagbuf(Ln[y], "str")==0) {
				strcpy(str, ParseResult);
				rightpos=StrLenLuna(str);
				if(rightpos > rightlen) rightlen=rightpos;
			}
		}
		y++;
	} while(y < EndText);

	y=0;
	do {
		if(ParseTagbuf(Ln[y], "labelcolor")==0) tc=SfmGetNamedColor(ParseResult);
		if(ParseTagbuf(Ln[y], "pointercolor")==0) pc=SfmGetNamedColor(ParseResult);

		if(strnicmp( "<labelleft", Ln[y],10 )==0 ) {
			tx=ty=ix=iy=0;
			if(ParseTagbuf(Ln[y], "ty")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "px")==0) ix=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "py")==0) iy=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			leftpos=StrLenLuna(str);
			tx=leftlen-leftpos+47;

			if(ty+ix+iy !=0)
				SchematicLabel(tx,ty,ix+SfmImageX,iy+SfmImageY,str,tc,pc);
				label[LabelNum].tx=tx;
				label[LabelNum].ty=ty;
				label[LabelNum].px=ix;
				label[LabelNum].py=iy;
				strcpy(label[LabelNum].Str,str);
				label[LabelNum].Col1=tc;
				LabelNum++;
				NumOfLabels++;
		}

		if(strnicmp( "<labelright", Ln[y],11 )==0 ) {
			tx=ty=ix=iy=0;
			if(ParseTagbuf(Ln[y], "ty")==0) ty=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "px")==0) ix=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "py")==0) iy=atoi(ParseResult);
			if(ParseTagbuf(Ln[y], "str")==0) strcpy(str, ParseResult);
			leftpos=StrLenLuna(str);
			tx=753-rightlen;
			if(ty+ix+iy !=0)
				SchematicLabel(tx,ty,ix+SfmImageX,iy+SfmImageY,str,tc,pc);
				label[LabelNum].tx=tx;
				label[LabelNum].ty=ty;
				label[LabelNum].px=ix;
				label[LabelNum].py=iy;
				strcpy(label[LabelNum].Str,str);
				label[LabelNum].Col1=tc;
				LabelNum++;
				NumOfLabels++;
		}
		y++;
	} while(y < EndText);
}

void SfmInit()
{
	int z;

	strcpy(SfmTitle, "LCARS");
	SfmTitleColor = BIGBLUE;
	strcpy(SfmCaption, "");
	strcpy(SfmPopsicleCaption, "");
	strcpy(SfmBottomCaption, "");
	SfmCaptionColor = SKYBLUE;
	SfmHeadlineColor = NAPLES;
	SfmTextColor = ORANGE;
	SfmScreentype = LCARS_SPLIT_SCREEN;
	SfmControltype= STATIC_CONTROL;
	SfmBracketColor1 = MANGO;
	SfmBracketColor2 = BRICK;
	SfmFrameColor = LILAC;
	strcpy(SfmButton1Label, "");
	SfmButton1Color=BLACK;
	strcpy(SfmButton2Label, "");
	SfmButton2Color=BLACK;
	strcpy(SfmButton3Label, "");
	SfmButton3Color=BLACK;
	strcpy(SfmButton4Label, "");
	SfmButton4Color=BLACK;
	strcpy(SfmFolder, "");
	strcpy(SfmIndex, "");
	SfmIndexLoaded=FALSE;
	strcpy(SfmImage, "");
	SfmImageX=0;
	SfmImageY=0;
	SfmScroll = FALSE;
	TextColor = ORANGE;
	strcpy(SfmWav, "");
	strcpy(SfmGif, "");
	AutocloseFlag=FALSE;
	null = 0;
	for(z=0; z<9; z++) strcpy(SfmLink[z], "");
	SfmDrawColor=SEABLUE;
	SfmLineThickness=1;
}

int SfmGetNamedColor(char *ColorName)
{  /* version for LCARS colors */
	if(strnicmp( "#", ColorName,1 )==0 ) return(ParseColorSpec(ColorName));
	if(stricmp(ColorName,"black")==0) return(BLACK);
	if(stricmp(ColorName,"orange")==0) return(ORANGE);
	if(stricmp(ColorName,"naples")==0) return(NAPLES);
	if(stricmp(ColorName,"mango")==0) return(MANGO);
	if(stricmp(ColorName,"brick")==0) return(BRICK);
	if(stricmp(ColorName,"lilac")==0) return(LILAC);
	if(stricmp(ColorName,"violet")==0) return(PURPLE);
	if(stricmp(ColorName,"purple")==0) return(PURPLE);
	if(stricmp(ColorName,"skyblue")==0) return(SKYBLUE);
	if(stricmp(ColorName,"paleblue")==0) return(PALEBLUE);
	if(stricmp(ColorName,"bigblue")==0) return(BIGBLUE);
	if(stricmp(ColorName,"tan")==0) return(TAN);
	if(stricmp(ColorName,"lavender")==0) return(LAVENDER);
	if(stricmp(ColorName,"darkgray")==0) return(DARKGRAY);
	if(stricmp(ColorName,"borg")==0) return(BORG);
	if(stricmp(ColorName,"seablue")==0) return(SEABLUE);
	if(stricmp(ColorName,"red")==0) return(RED);
	if(stricmp(ColorName,"darkred")==0) return(DARKRED);
	if(stricmp(ColorName,"white")==0) return(WHITE);
	if(stricmp(ColorName,"yellow")==0) return(KHAKI);
	if(stricmp(ColorName,"khaki")==0) return(KHAKI);
	if(stricmp(ColorName,"olive")==0) return(OLIVE);
	if(stricmp(ColorName,"brown")==0) return(OLIVE);

	return(-1);
}
int SfmDisplayBmp(char *filespec, int x, int y)
{
	BITMAP *sfm_image;
	PALETTE sfm_palette;
	int imageX, imageW, imageH;
	char Report[24];

	imageX=x;
	sfm_image=load_bitmap(filespec, sfm_palette);
	if (!sfm_image) {
		NormalLoadError(filespec);
		return(-1);
	}
	if(DepthFound > 8) set_palette(sfm_palette);

	if(SfmImageX == 0) {
		if(sfm_image->w < 790-x) imageX=790-sfm_image->w;
		imageW=sfm_image->w;
		if(sfm_image->w > 790-x) imageW=790-x;
	}

	imageW=sfm_image->w;
	imageH=sfm_image->h;
 	if(sfm_image->h > 590-y) imageH=590-y;


	if(SfmScreentype == LCARS_MSD_SCREEN) {
		floodfill(sfm_image, 1,1, makecol(0xff,0x00,0xff));
		masked_blit(sfm_image, screen, 0, 0, imageX, y, imageW,imageH);
	} else blit(sfm_image, screen, 0, 0, x,y,sfm_image->w,sfm_image->h);

	SfmImageX=imageX;
	SfmImageY=y;

/*
itoa(SfmImageX,Report,10);
rectfill(screen,216,13,264,39,LAVENDER);
PutsLuna(216,19, BLACK,LAVENDER, Report);

itoa(imageX,Report,10);
rectfill(screen,316,13,364,39,LAVENDER);
PutsLuna(316,19, BLACK,LAVENDER, Report);

itoa(sfm_image->w,Report,10);
rectfill(screen,416,13,464,39,LAVENDER);
PutsLuna(416,19, BLACK,LAVENDER, Report);
*/

	if(sfm_image) destroy_bitmap(sfm_image);
	return(imageX);
}

int SfmDisplayJpeg(char *filespec, int x, int y)
{
	BITMAP *sfm_image;
	PALETTE sfm_palette;
	int imageX, imageW, imageH;

	imageX=x;
	sfm_image=load_jpeg(filespec, sfm_palette);
	if (!sfm_image) {
		NormalLoadError(filespec);
		return(-1);
	}
	if(DepthFound > 8) set_palette(sfm_palette);
/*
	imageW=sfm_image->w;
	if(sfm_image->w > 790-x) imageW=790-x;
*/
	if(SfmImageX == 0) {
		if(sfm_image->w < 790-x) imageX=790-sfm_image->w;
		imageW=sfm_image->w;
		if(sfm_image->w > 790-x) imageW=790-x;
	}

if(SfmImageX != 0) goto bypass;

	if(SfmScreentype==LCARS_POPSICLE_SCREEN && x > 753 - imageW) {
		x = 753 - imageW;
		imageX = x;
	}
	if(SfmScreentype==LCARS_SPLIT_SCREEN && x > 790 - imageW) {
		x = 790 - imageW;
		imageX = x;
	}
bypass:
	imageH=sfm_image->h;
	if(sfm_image->h > 590-y) imageH=590-y;
	blit(sfm_image, screen, 0, 0, x, y, imageW,imageH);

	SfmImageX=x;
	SfmImageY=y;


	if(sfm_image) destroy_bitmap(sfm_image);
/* 	if(imageX > x) imageX=x; */
	return(x);
}
int SfmDisplayGif(char *filespec, int x, int y)
{
	BITMAP *sfm_image;
	PALETTE sfm_palette;
	int imageX, imageW, imageH;

	imageX=x;
	sfm_image=load_gif(filespec, 0);
	if (!sfm_image) {
		NormalLoadError(filespec);
		return(-1);
	}
	if(DepthFound > 8) set_palette(sfm_palette);
/*
	imageW=sfm_image->w;
	if(sfm_image->w > 790-x) imageW=790-x;
*/
	if(SfmImageX == 0) {
		if(sfm_image->w < 790-x) imageX=790-sfm_image->w;
		imageW=sfm_image->w;
		if(sfm_image->w > 790-x) imageW=790-x;
	}

	if(SfmScreentype==LCARS_POPSICLE_SCREEN && x > 753 - imageW) {
		x = 753 - imageW;
		imageX = x;
	}
	if(SfmScreentype==LCARS_SPLIT_SCREEN && x > 790 - imageW) {
		x = 790 - imageW;
		imageX = x;
	}


	imageH=sfm_image->h;
	if(sfm_image->h > 590-y) imageH=590-y;
	blit(sfm_image, screen, 0, 0, x, y, imageW,imageH);

	SfmImageX=x;
	SfmImageY=y;

	if(sfm_image) destroy_bitmap(sfm_image);
/* 	if(imageX > x) imageX=x; */
	return(x);
}

int SfmTxtRefresh(int txty)
{
	int gx,gy,i,z,numlines;

	if(SfmScreentype==LCARS_SPLIT_SCREEN) {
		gx=132;
		gy=246;
		numlines=12;
	} else {
		gx=47;
		gy=60;
		numlines=17;
	}

	for( z=0; z < numlines; ++z) {
		rectfill(screen,gx-2,gy,SfmImageX-10,gy+32,BLACK);
		if( Ln[txty+z][0]=='>' || Ln[txty+z][0]=='!') {
			for( i=0; i< strlen(Ln[txty+z]); ++i)
				Highlight[i]=Ln[txty+z][i+1];
				PutsFont21(gx,gy,SfmHeadlineColor,Highlight);
			} else PutsFont19(gx,gy,SfmTextColor,Ln[txty+z]);
		gy += 29;
	}
}
void SfmMessageBox1a(int Hue)
{
	int boxtop;

	boxtop = 10;
	rectfill(screen,10,boxtop,110,boxtop+54, Hue);
	PutsLuna(14,boxtop+36, BLACK, Hue, "CLOSE");
	PutsLuna(91,boxtop+36, BLACK, Hue, "ESC");
}
void SfmMessageBox2a(int Hue)
{
	int boxtop;

	boxtop = 68;
	rectfill(screen,10,boxtop,110,boxtop+54, Hue);
	PutsLuna(14,boxtop+36, BLACK, Hue, "EDIT");
	if(NoEdit==FALSE) PutsLuna(96,boxtop+36, BLACK, Hue, "F9");
}
int SfmSplitScreen()
{
	char Report[24];
	int NumOfButtons=0;
	int imageX, imageY;
	int title_len, caption_len, alignX;

	imageX=SfmImageX;
	imageY=SfmImageY;
	rectfill(screen,0,0,800,600, BLACK);
	Brackets1(SfmBracketColor1, SfmBracketColor2);
	SfmMessageBox1a(LILAC);
	SfmMessageBox2a(SfmBracketColor2);
	rectfill(screen,10,308,110,532,SfmBracketColor1);
	rectfill(screen,10,536,110,589,SfmBracketColor2);
	BracketArrows(1);

	title_len=StrLenMars(2, SfmTitle);
	caption_len=StrLenLuna(SfmCaption);
	if(title_len >= caption_len) alignX=790-title_len;
		else alignX=790-caption_len;
	MarsF(alignX,10,2, SfmTitleColor,BLACK,SfmTitle);
	PutsLuna(alignX,81,SfmCaptionColor,BLACK,SfmCaption);

	if(strlen(SfmButton4Label) > 0) NumOfButtons++;
	if(strlen(SfmButton3Label) > 0 && NumOfButtons==1) NumOfButtons++;
	if(strlen(SfmButton2Label) > 0 && NumOfButtons==2) NumOfButtons++;
	if(strlen(SfmButton1Label) > 0 && NumOfButtons==3) NumOfButtons++;

	if(NumOfButtons > 0) ButtonType1(682,153,SfmButton4Color,SfmButton4Label);
	if(NumOfButtons > 1) ButtonType1(562,153,SfmButton3Color,SfmButton3Label);
	if(NumOfButtons > 2) ButtonType1(682,106,SfmButton2Color,SfmButton2Label);
	if(NumOfButtons > 3) ButtonType1(562,106,SfmButton1Color,SfmButton1Label);
/*
	PutsLuna(140,58, SKYBLUE, BLACK, SfmFolder);
	PutsLuna(140,58+24, SKYBLUE, BLACK, SfmImage);
	PutsLuna(140,58+48, SKYBLUE, BLACK, SfmIndex);
*/
	if( (__file_exists(SfmImage)) ) {
		if(SfmImageX==0) imageX=508;
		if(SfmImageY==0) imageY=ly+22;
		if(stricmp( "JPG", get_extension(SfmImage))==0)
			SfmImageX=SfmDisplayJpeg(SfmImage, imageX, imageY);
		if(stricmp( "GIF", get_extension(SfmImage))==0)
			SfmImageX=SfmDisplayGif(SfmImage, imageX, imageY);
		if(stricmp( "BMP", get_extension(SfmImage))==0)
			SfmImageX=SfmDisplayBmp(SfmImage, imageX, imageY);
		if(SfmImageX== -1) SfmImageX=762;  /* image failure, full text margin */
	}
	if(SfmImageX==0) SfmImageX=762;  /* no image, full text margin */

/*
itoa(SfmImageX,Report,10);
rectfill(screen,516,13,564,39,LAVENDER);
PutsLuna(516,19, BLACK,LAVENDER, Report);
*/
}

int SfmFullScreen()
{
	int imageX, imageY, capX;

	imageX=SfmImageX;
	imageY=SfmImageY;
	rectfill(screen,0,0,800,600, BLACK);
	PopsicleSticks(SfmFrameColor);
	capX=ColorTitle(ustrupr(SfmTitle),SfmTitleColor);
	PutsLuna(capX,20, BLACK,SfmFrameColor, SfmCaption);
	PutsLuna(460,20, BLACK,SfmFrameColor, MakeDisplayName(SfmFile));
	if(NoEdit==FALSE) PutsLuna(694,20, BLACK,SfmFrameColor, "EDIT: F9");
	if(SfmControltype==TXT_CONTROL) {
		UpArrowSymbol(66,566,BLACK);
		DownArrowSymbol(91,566,BLACK);
	}
	PutsLuna(679,566, BLACK,SfmFrameColor, "CLOSE: ESC");

	if( (__file_exists(SfmImage)) ) {
		if(SfmImageX == 0) imageX=450;
		if(SfmImageY == 0) imageY=50;

		if(stricmp( "JPG", get_extension(SfmImage))==0)
			SfmImageX=SfmDisplayJpeg(SfmImage, imageX, imageY);
		if(stricmp( "GIF", get_extension(SfmImage))==0)
			SfmImageX=SfmDisplayGif(SfmImage, imageX, imageY);
		if(stricmp( "BMP", get_extension(SfmImage))==0)
			SfmImageX=SfmDisplayBmp(SfmImage, imageX, imageY);
		if(SfmImageX == -1) SfmImageX=762;  /* image failure, full text margin */
	}
	if(SfmImageX == 0) SfmImageX=762;  /* no image, full text margin */

	if(stricmp(SfmPopsicleCaption,"") != 0) {
		if((670-SfmImageX) > StrLenLuna(SfmPopsicleCaption))
			if(SfmImageX >=129) PutsLuna(SfmImageX,566, BLACK,SfmFrameColor, SfmPopsicleCaption);
				else PutsLuna(129,566, BLACK,SfmFrameColor, SfmPopsicleCaption);
	}
	if(stricmp(SfmBottomCaption,"") != 0) {
		PutsLuna(129,566, BLACK,SfmFrameColor, SfmBottomCaption);
	}

}
int SfmPanelScreen()
{
	rectfill(screen,0,0,800,600, BLACK);
}
int SfmMsdScreen()

{
	int imageX, imageY, pos;
	int BarColor;

	BarColor=TAN;
	pos=13;
	imageX=SfmImageX;
	imageY=SfmImageY;
	SfmScroll = FALSE;
	rectfill(screen,0,0,800,600, BLACK);

	NortheastElbow(200+pos,13,LILAC);
	NorthwestElbow(481,13,LILAC);

	LeftBumper26(39, 13,LILAC);
	RightBumper26(760, 13,LILAC);
	rectfill(screen, 47, 13, 199+pos, 39, LILAC);
	rectfill(screen, 542-60, 13, 752, 39, LILAC);

	rectfill(screen, 200+pos, 40, 274+pos, 64, BLACK);
	NortheastCorner(274+pos,40);

	rectfill(screen, 275+pos, 40, 325+pos, 71, LILAC);
	rectfill(screen, 356, 40, 456, 71, LILAC);

	rectfill(screen, 275+pos, 77, 325+pos, 488, BarColor);
	rectfill(screen, 356, 77, 456, 488, BarColor);
	rectfill(screen, 275+pos, 493, 325+pos, 586, BarColor);
	rectfill(screen, 356, 493, 456, 586, BarColor);


	if(NoEdit==FALSE) ButtonType1(562-47,493+47, MANGO, "EDIT: F9");
	ButtonType1(682-47,493+47, LILAC, "CLOSE: ESC");

	Title(ustrupr(SfmTitle));

	if( (__file_exists(SfmImage)) ) {
		if(SfmImageX==0) imageX=508;
		if(SfmImageY==0) imageY=ly+22;
		if(stricmp( "JPG", get_extension(SfmImage))==0)
			SfmImageX=SfmDisplayJpeg(SfmImage, imageX, imageY);
		if(stricmp( "BMP", get_extension(SfmImage))==0)
			SfmImageX=SfmDisplayBmp(SfmImage, imageX, imageY);
		if(SfmImageX== -1) SfmImageX=762;
	}
}

int SfmReadStyleSheet()
{
	char temp[80];
	int y=0;

	do {
		if(strnicmp(Ln[y],"<sfml>",6) == 0) goto cycle;
		if(strnicmp(Ln[y],"<#",2) == 0) goto cycle;
		if(strnicmp(Ln[y],"<title=",7) == 0 && ParseTagbuf(Ln[y], "title")==0) {
			strcpy(SfmTitle, ParseResult);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<caption=",9) == 0 && ParseTagbuf(Ln[y], "caption")==0) {
			strcpy(SfmCaption, ParseResult);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<photolabel=",12) == 0 && ParseTagbuf(Ln[y], "photolabel")==0) {
			strcpy(SfmPopsicleCaption, ParseResult);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<bottomcaption=",15) == 0 && ParseTagbuf(Ln[y], "bottomcaption")==0) {
			strcpy(SfmBottomCaption, ParseResult);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<titlecolor=",12) == 0 && ParseTagbuf(Ln[y], "titlecolor")==0) {
			SfmTitleColor=SfmGetNamedColor(ParseResult);
			if(SfmTitleColor == -1) SfmTitleColor=ORANGE;
			goto cycle;
		}
		if(strnicmp(Ln[y],"<captioncolor=",14) == 0 && ParseTagbuf(Ln[y], "captioncolor")==0) {
			SfmCaptionColor=SfmGetNamedColor(ParseResult);
			if(SfmCaptionColor == -1) SfmCaptionColor=SKYBLUE;
			goto cycle;
		}
		if(strnicmp(Ln[y],"<headlinecolor=",15) == 0 && ParseTagbuf(Ln[y], "headlinecolor")==0) {
			SfmHeadlineColor=SfmGetNamedColor(ParseResult);
			if(SfmHeadlineColor == -1) SfmHeadlineColor=NAPLES;
			goto cycle;
		}
		if(strnicmp(Ln[y],"<textcolor=",11) == 0 && ParseTagbuf(Ln[y], "textcolor")==0) {
			SfmTextColor=SfmGetNamedColor(ParseResult);
			if(SfmTextColor == -1) SfmTextColor=ORANGE;
			goto cycle;
		}
		if(strnicmp(Ln[y],"<bracketcolor1=",15) == 0 && ParseTagbuf(Ln[y], "bracketcolor1")==0) {
			SfmBracketColor1=SfmGetNamedColor(ParseResult);
			if(SfmBracketColor1 == -1) SfmBracketColor1=MANGO;
			goto cycle;
		}
		if(strnicmp(Ln[y],"<bracketcolor2=",15) == 0 && ParseTagbuf(Ln[y], "bracketcolor2")==0) {
			SfmBracketColor2=SfmGetNamedColor(ParseResult);
			if(SfmBracketColor2 == -1) SfmBracketColor2=BRICK;
			goto cycle;
		}
		if(strnicmp(Ln[y],"<screen=",7) == 0 && ParseTagbuf(Ln[y], "screen")==0) {
			if(stricmp(ParseResult,"full")==0) SfmScreentype = LCARS_POPSICLE_SCREEN;
			if(stricmp(ParseResult,"msd")==0) SfmScreentype = LCARS_MSD_SCREEN;
			if(stricmp(ParseResult,"panel")==0) SfmScreentype = LCARS_PANEL_SCREEN;
			if(stricmp(ParseResult,"overlay")==0) SfmScreentype = LCARS_OVERLAY_SCREEN;
			goto cycle;
		}
		if(strnicmp(Ln[y],"<scroll=",8) == 0 && ParseTagbuf(Ln[y], "scroll")==0) {
			if(stricmp(ParseResult,"yes")==0) SfmScroll = TRUE;
			goto cycle;
		}
		if(strnicmp(Ln[y],"<framecolor=",12) == 0 && ParseTagbuf(Ln[y], "framecolor")==0) {
			SfmFrameColor=SfmGetNamedColor(ParseResult);
			if(SfmFrameColor == -1) SfmFrameColor=LILAC;
			goto cycle;
		}
		if(strnicmp(Ln[y],"<button1label=",14) == 0 && ParseTagbuf(Ln[y], "button1label")==0) {
			strcpy(SfmButton1Label, ParseResult);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<button1color=",14) == 0 && ParseTagbuf(Ln[y], "button1color")==0) {
			SfmButton1Color=SfmGetNamedColor(ParseResult);
			if(SfmButton1Color == -1) SfmButton1Color=BRICK;
			goto cycle;
		}
		if(strnicmp(Ln[y],"<button2label=",14) == 0 && ParseTagbuf(Ln[y], "button2label")==0) {
			strcpy(SfmButton2Label, ParseResult);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<button2color=",14) == 0 && ParseTagbuf(Ln[y], "button2color")==0) {
			SfmButton2Color=SfmGetNamedColor(ParseResult);
			if(SfmButton2Color == -1) SfmButton2Color=BRICK;
			goto cycle;
		}
		if(strnicmp(Ln[y],"<button3label=",14) == 0 && ParseTagbuf(Ln[y], "button3label")==0) {
			strcpy(SfmButton3Label, ParseResult);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<button3color=",14) == 0 && ParseTagbuf(Ln[y], "button3color")==0) {
			SfmButton3Color=SfmGetNamedColor(ParseResult);
			if(SfmButton3Color == -1) SfmButton3Color=BRICK;
			goto cycle;
		}
		if(strnicmp(Ln[y],"<button4label=",14) == 0 && ParseTagbuf(Ln[y], "button4label")==0) {
			strcpy(SfmButton4Label, ParseResult);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<button4color=",14) == 0 && ParseTagbuf(Ln[y], "button4color")==0) {
			SfmButton4Color=SfmGetNamedColor(ParseResult);
			if(SfmButton4Color == -1) SfmButton4Color=BRICK;
			goto cycle;
		}
		if(strnicmp(Ln[y],"<folder=",8) == 0 && ParseTagbuf(Ln[y], "folder")==0) {
			strcpy(temp, ParseResult);
			strcpy(SfmFolder, "C:\\LCARS24\\");
			strcat(SfmFolder, temp);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<file=",6) == 0 && ParseTagbuf(Ln[y], "file")==0) {
			strcpy(temp, ParseResult);
			strcpy(SfmIndex, SfmFolder);
			strcat(SfmIndex, "\\");
			strcat(SfmIndex, temp);
			if( strnicmp( "TXT", get_extension(temp),3 )==0 )
				SfmControltype=TXT_CONTROL;
			goto cycle;
		}
		if(strnicmp(Ln[y],"<image=",7) == 0 && ParseTagbuf(Ln[y], "image")==0) {
			strcpy(temp, ParseResult);
			strcpy(SfmImage, SfmFolder);
			strcat(SfmImage, "\\");
			strcat(SfmImage, temp);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<imagex=",8) == 0 && ParseTagbuf(Ln[y], "imagex")==0) {
			SfmImageX=atoi(ParseResult);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<imagey=",8) == 0 && ParseTagbuf(Ln[y], "imagey")==0) {
			SfmImageY=atoi(ParseResult);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<f1link=",8) == 0 && ParseTagbuf(Ln[y], "f1link")==0) {
			strcpy(temp, ParseResult);
			strcpy(SfmLink[1], SfmFolder);
			strcat(SfmLink[1], "\\");
			strcat(SfmLink[1], temp);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<f2link=",8) == 0 && ParseTagbuf(Ln[y], "f2link")==0) {
			strcpy(temp, ParseResult);
			strcpy(SfmLink[2], SfmFolder);
			strcat(SfmLink[2], "\\");
			strcat(SfmLink[2], temp);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<f3link=",8) == 0 && ParseTagbuf(Ln[y], "f3link")==0) {
			strcpy(temp, ParseResult);
			strcpy(SfmLink[3], SfmFolder);
			strcat(SfmLink[3], "\\");
			strcat(SfmLink[3], temp);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<f4link=",8) == 0 && ParseTagbuf(Ln[y], "f4link")==0) {
			strcpy(temp, ParseResult);
			strcpy(SfmLink[4], SfmFolder);
			strcat(SfmLink[4], "\\");
			strcat(SfmLink[4], temp);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<f5link=",8) == 0 && ParseTagbuf(Ln[y], "f5link")==0) {
			strcpy(temp, ParseResult);
			strcpy(SfmLink[5], SfmFolder);
			strcat(SfmLink[5], "\\");
			strcat(SfmLink[5], temp);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<f6link=",8) == 0 && ParseTagbuf(Ln[y], "f6link")==0) {
			strcpy(temp, ParseResult);
			strcpy(SfmLink[6], SfmFolder);
			strcat(SfmLink[6], "\\");
			strcat(SfmLink[6], temp);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<f7link=",8) == 0 && ParseTagbuf(Ln[y], "f7link")==0) {
			strcpy(temp, ParseResult);
			strcpy(SfmLink[7], SfmFolder);
			strcat(SfmLink[7], "\\");
			strcat(SfmLink[7], temp);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<f8link=",8) == 0 && ParseTagbuf(Ln[y], "f8link")==0) {
			strcpy(temp, ParseResult);
			strcpy(SfmLink[8], SfmFolder);
			strcat(SfmLink[8], "\\");
			strcat(SfmLink[8], temp);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<f9link=",8) == 0 && ParseTagbuf(Ln[y], "f9link")==0) {
			strcpy(temp, ParseResult);
			strcpy(SfmLink[9], SfmFolder);
			strcat(SfmLink[9], "\\");
			strcat(SfmLink[9], temp);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<wav=",5) == 0 && ParseTagbuf(Ln[y], "wav")==0) {
			strcpy(SfmWav, ParseResult);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<animation=",11) == 0 && ParseTagbuf(Ln[y], "animation")==0) {
			strcpy(SfmGif, ParseResult);
			goto cycle;
		}
		if(strnicmp(Ln[y],"<autoclose",10) == 0) {
			AutocloseFlag=TRUE;;
			goto cycle;
		}
		if(strnicmp(Ln[y],"<drawcolor=",11) == 0 && ParseTagbuf(Ln[y], "drawcolor")==0) {
			SfmDrawColor=SfmGetNamedColor(ParseResult);
			if(SfmDrawColor == -1) SfmDrawColor=SEABLUE;
			goto cycle;
		}
		if(strnicmp(Ln[y],"<linethickness=",15) == 0 && ParseTagbuf(Ln[y], "linethickness")==0) {
			SfmLineThickness=atoi(ParseResult);
			goto cycle;
		}

cycle:		y++;
	} while(y < EndText);
}

void SfmlHighlightPointer(int i, char mode)
{
	int tx,ty,ix,iy,tc,pc;

	if( ! (__file_exists(SfmImage)) ) return;

	tx=label[i].tx;
	ty=label[i].ty;
	ix=label[i].px;
	iy=label[i].py;
	if(mode==0) tc=pc=TAN;
	if(mode==1) tc=pc=BIGBLUE;
	if(mode >1) tc=label[i].Col1;
	if(mode==2) pc=TAN;
	if(mode==3) pc=BIGBLUE;
	SchematicLabel(tx,ty,ix+SfmImageX,iy+SfmImageY,label[i].Str,tc,pc);
}
void HighlighterIndication()
{
	UpArrowSymbol(466,566,BLACK);
	DownArrowSymbol(491,566,BLACK);
}
int SfmStaticControl(char MsdZoomFlag)
{
	BITMAP *bmp1, *bmp2, *bmp3;
	PALETTE msd_palette;
	char MsdZoom=0;
	int MsdOffsetX, MsdOffsetY;
	char Focus=0;
	char ZoomDisabled=0;
	int imageX, imageY, imageW, imageH;
	int LeftMargin=47;
	int WindowWidth=718;
	char Report[16];
	int py;
	int i;

	SecondsCounter=0;
	py=0;
	if(SfmScreentype==LCARS_POPSICLE_SCREEN && MsdZoomFlag==1) {
		if( ! (__file_exists(SfmImage)) ) {
			NormalLoadError(SfmImage);
			goto zoombypass;
		}
		if(SlideshowActive==TRUE) goto zoombypass;
		bmp3=create_bitmap(800,500);
		blit(screen,bmp3,0,50,0,0,800,500);
		bmp1=load_bitmap(SfmImage, msd_palette);
		if(bmp1->h > 248) ZoomDisabled=1;
		bmp2=create_bitmap(1412,bmp1->h*2);
		clear_to_color(bmp2,BLACK);
		stretch_blit(bmp1,bmp2,0,0,bmp1->w,bmp1->h,0,0,bmp1->w*2,bmp1->h*2);
		if(SfmImageX < 47) LeftMargin=SfmImageX;
		if(SfmImageX < 47) WindowWidth += 47-SfmImageX;
		if(bmp1 && bmp2 && bmp3) {
			if(ZoomDisabled==0) PutsLuna(580,566, BLACK,SfmFrameColor, "ZOOM: F2");
			MsdZoom=1;
		}
zoombypass:
		SfmlHighlightPointer(py, 3);
		HighlighterIndication();
	}

	if(strcmp(SfmWav,"") != 0 && __file_exists(SfmWav)) LcarsPlayWav(SfmWav);
	if(strcmp(SfmGif,"") != 0 && __file_exists(SfmGif)) LcarsPlayGif(SfmImageX,SfmImageY,SfmGif);
	if(AutocloseFlag==TRUE) {
		if(MsdZoom==1) {
			if(bmp1) destroy_bitmap(bmp1);
			if(bmp2) destroy_bitmap(bmp2);
			if(bmp3) destroy_bitmap(bmp3);
		}
		return(27);
	}


loopback:
	do {
		if(AutorunTimer()==TRUE) return(32);

	} while(!kbhit());
	c = GetKey();
	switch( c )
		{
		case F2: if( ! MsdZoomFlag) goto loopback;
			if(ZoomDisabled==1) goto loopback;
			if(MsdZoom==1) {
				MsdZoom=2;
				MsdOffsetX=bmp1->w/2;
				MsdOffsetY=0;
/*				MsdOffsetY=SfmImageY-bmp1->h; */
				rectfill(screen,0,50,800,550, BLACK);
				if(Focus==1) goto prefocus;
blit(bmp2,screen,MsdOffsetX,MsdOffsetY,LeftMargin,(600-(bmp1->h*2))/2,WindowWidth,bmp1->h*2);
				rectfill(screen,450,560,568,586,SfmFrameColor);
				PutsLuna(450,566, BLACK,SfmFrameColor, "ENHANCING . . .");
				SmoothBlit2x(bmp1,bmp2,0,0,0,0,bmp1->w,bmp1->h);
				SmoothBlitY(bmp2,0,0,bmp1->w*2,bmp1->h*2);
prefocus:
				rectfill(screen,450,560,568,586,SfmFrameColor);
blit(bmp2,screen,MsdOffsetX,MsdOffsetY,LeftMargin,(600-(bmp1->h*2))/2,WindowWidth,bmp1->h*2);

/*		blit(bmp2,screen,MsdOffsetX,MsdOffsetY,47,50,718,500); */
				PutsLuna(450,566, BLACK,SfmFrameColor, "SCROLL:");
				LeftArrowSymbol(500,566,BLACK);
				RightArrowSymbol(525,566,BLACK);
				Focus=1;
			} else {
				if(MsdZoom==0) goto loopback;
				MsdZoom=1;
				blit(bmp3,screen,0,0,0,50,800,500);
				rectfill(screen,450,560,568,586,SfmFrameColor);
				HighlighterIndication();
				SfmlHighlightPointer(py, 3);
			}
		/*	PanelBeep();  */
			goto loopback;

		case UPARROW: 	if(MsdZoom !=1) goto loopback;
				SfmlHighlightPointer(py, 2);
				py--;
				if(py < 0) py=NumOfLabels-1;
				SfmlHighlightPointer(py, 3);
				goto loopback;
		case DOWNARROW: if(MsdZoom !=1) goto loopback;
				SfmlHighlightPointer(py, 2);
				py++;
				if(py > NumOfLabels-1) py=0;
				SfmlHighlightPointer(py, 3);
				goto loopback;
		case LEFTARROW: if(MsdZoom < 2) goto loopback;
				MsdOffsetX -=16;
				if(MsdOffsetX <0) {
					MsdOffsetX=0;
					goto loopback;
				}
				if(MsdOffsetX < 16) MsdOffsetX=0;
				goto refresh;
		case RIGHTARROW: if(MsdZoom < 2) goto loopback;
				MsdOffsetX +=16;
				if(MsdOffsetX > bmp1->w) {
					MsdOffsetX=bmp1->w;
					goto loopback;
				}
				if(MsdOffsetX > bmp1->w-16) MsdOffsetX=bmp1->w;
				goto erase;
		case HOMEKEY:   if(MsdZoom==1) goto loopback;
				MsdOffsetX=0;
				goto refresh;
		case ENDKEY:    if(MsdZoom==1) goto loopback;
				MsdOffsetX=bmp1->w;
				goto erase;
		case F9:        if(NoEdit==TRUE) goto loopback;
				if(OpenProgEdit(SfmFile)==1) return(9);
					else goto loopback;
		case 27: 	if( strcmp(SfmImage,"")==0 ) return(27);
				if(MsdZoom==1) {
					if(bmp1) destroy_bitmap(bmp1);
					if(bmp2) destroy_bitmap(bmp2);
					if(bmp3) destroy_bitmap(bmp3);
				}
	/* to support the briefing applet */
				return(27);
		case 32:        if(SlideshowActive==FALSE) goto loopback;
				return(32);
		case BS:	if(SlideshowActive==FALSE) goto loopback;
				return(BS);
		case F12:	if(SlideshowActive==FALSE) goto loopback;
				return(F12);
		case 49:        if(stricmp("", SfmLink[1])==0) goto loopback;
				strcpy(SfmLink[0], SfmLink[1]);
				return(1);
		case 50:        if(stricmp("", SfmLink[2])==0) goto loopback;
				strcpy(SfmLink[0], SfmLink[2]);
				return(2);
		case 51:        if(stricmp("", SfmLink[3])==0) goto loopback;
				strcpy(SfmLink[0], SfmLink[3]);
				return(3);
		case 52:        if(stricmp("", SfmLink[4])==0) goto loopback;
				strcpy(SfmLink[0], SfmLink[4]);
				return(4);
		case 53:        if(stricmp("", SfmLink[5])==0) goto loopback;
				strcpy(SfmLink[0], SfmLink[5]);
				return(5);
		case 54:        if(stricmp("", SfmLink[6])==0) goto loopback;
				strcpy(SfmLink[0], SfmLink[6]);
				return(6);
		case 55:        if(stricmp("", SfmLink[7])==0) goto loopback;
				strcpy(SfmLink[0], SfmLink[7]);
				return(7);
		case 56:        if(stricmp("", SfmLink[8])==0) goto loopback;
				strcpy(SfmLink[0], SfmLink[8]);
				return(8);
		case 57:        if(stricmp("", SfmLink[9])==0) goto loopback;
				strcpy(SfmLink[0], SfmLink[9]);
				return(9);
		case 350:	Screenshot792("Sfml8.bmp");
				PanelBeep();
				goto loopback;
		case 351:	Screenshot1024("Sfml10.bmp");
				PanelBeep();
				goto loopback;
		default:	goto loopback;

		}

erase:

if(MsdOffsetX > bmp1->w-(753-bmp1->w)) rectfill(screen,753,50,800,550,BLACK);
/*
if(MsdOffsetX > bmp1->w-(753-bmp1->w)) rectfill(screen,47+bmp1->w,50,800,550,BLACK);
*/
/*
if(MsdOffsetX > bmp1->w-(800-bmp1->w)) rectfill(screen,bmp1->w,50,800,550,BLACK);
*/
refresh:
	blit(bmp2,screen,MsdOffsetX,MsdOffsetY,LeftMargin,(600-(bmp1->h*2))/2,WindowWidth,bmp1->h*2);

/*
itoa(MsdOffsetX,Report,10);
rectfill(screen,278,560,368,586,SfmFrameColor);
PutsLuna(278,566, BLACK,SfmFrameColor, Report);
*/

	goto loopback;
}

int SfmTxtControl(int txty )
{
	SfmTxtRefresh(txty);
	SecondsCounter=0;


loopback:

	do {
		if(AutorunTimer()==TRUE) return(32);

	} while(!kbhit());

	c = GetKey();
	switch( c )
		{
		case 27: return(27);
		case UPARROW: if(txty<1) goto loopback;
				--txty;
				SfmTxtRefresh(txty);
				goto loopback;
		case DOWNARROW: if(txty>=EndText-8) goto loopback;
				if(EndText < 17) goto loopback;
				++txty;
				SfmTxtRefresh(txty);
				goto loopback;
		case PGUPKEY:	if(txty<1) goto loopback;
				txty -=10;
				if(txty<0) txty=0;
				SfmTxtRefresh(txty);
				goto loopback;
		case PGDNKEY:	if(EndText < 17) goto loopback;
				if(SfmScreentype==LCARS_SPLIT_SCREEN && txty>=EndText-5) goto loopback;
				if(SfmScreentype==LCARS_POPSICLE_SCREEN && txty>=EndText-8) goto loopback;
				txty +=10;
				if(txty>=EndText-8) {
					txty=EndText-8;
				}
				SfmTxtRefresh(txty);
				goto loopback;
		case HOMEKEY: if(txty<1) goto loopback;
				txty=0;
				SfmTxtRefresh(txty);
				goto loopback;
		case ENDKEY:
				if(SfmScreentype==LCARS_SPLIT_SCREEN && txty>=EndText-5) goto loopback;
				if(SfmScreentype==LCARS_POPSICLE_SCREEN && txty>=EndText-8) goto loopback;
				if(SfmScreentype==LCARS_SPLIT_SCREEN) txty=EndText-5;
					else txty=EndText-8;
				SfmTxtRefresh(txty);
				goto loopback;
		case F1:        if(stricmp("", SfmLink[1])==0) goto loopback;
				strcpy(SfmLink[0], SfmLink[1]);
				return(1);
		case F2:        if(stricmp("", SfmLink[2])==0) goto loopback;
				strcpy(SfmLink[0], SfmLink[2]);
				return(2);
		case F3:        if(stricmp("", SfmLink[3])==0) goto loopback;
				strcpy(SfmLink[0], SfmLink[3]);
				return(3);
		case F4:        if(stricmp("", SfmLink[4])==0) goto loopback;
				strcpy(SfmLink[0], SfmLink[4]);
				return(4);
		case F5:        if(stricmp("", SfmLink[5])==0) goto loopback;
				strcpy(SfmLink[0], SfmLink[5]);
				return(5);
		case F6:        if(stricmp("", SfmLink[6])==0) goto loopback;
				strcpy(SfmLink[0], SfmLink[6]);
				return(6);
		case F7:        if(stricmp("", SfmLink[7])==0) goto loopback;
				strcpy(SfmLink[0], SfmLink[7]);
				return(7);
		case F9:        if(NoEdit==TRUE) goto loopback;
				if(OpenProgEdit(SfmFile)==1) return(10);
				strcpy(CurrentFile, SfmIndex);
/* ##### */			if(LoadTextFile() != 0) return(86);
					else SfmIndexLoaded=TRUE;
				goto loopback;
		case 32:	if(SlideshowActive==FALSE) goto loopback;
				return(32);
		case BS:	if(SlideshowActive==FALSE) goto loopback;
				return(BS);
		case F12:	if(SlideshowActive==FALSE) goto loopback;
				return(F12);
		case 350:	Screenshot792("Sfml8.bmp");
				goto loopback;
		case 351:	Screenshot1024("Sfml10.bmp");
				goto loopback;
		default:	goto loopback;
	}
}
int LcSfml(char *filespec)
{
	int TextStart,Result;
	char Bounceback[80];
	char BouncebackFlag;
	char MsdZoomFlag;

	BouncebackFlag=0;
	NoEdit=FALSE;
	SavedAs=FALSE;

	/* if Preview mode called by Progedit, use already-loaded buffer */
	if(strcmp("*", filespec)==0) {
/*		SetDefault(); */
/*		SfmInit();    */
		strcpy(SfmImage, "");
		SfmImageX=0;
		SfmImageY=0;
		strcpy( SfmFile, "PREVIEW");
		NoEdit=TRUE;
		goto skip_load;
	}

	if(strnicmp("MSD", get_extension(filespec),3 )==0) MsdZoomFlag=1;
		else MsdZoomFlag=0;
	strcpy(Bounceback, filespec);
redo:
	SetDefault();
	SfmInit();
	if(SavedAs==FALSE) strcpy(CurrentFile, filespec);
/*???*/	if(LoadSourceCode() == 0) TextStart=0;
		else return(86);
	strcpy( SfmFile, CurrentFile); /* so user can view and edit source */
skip_load:
	SfmReadStyleSheet();
	if(SfmScreentype == LCARS_SPLIT_SCREEN) SfmSplitScreen();
	if(SfmScreentype == LCARS_POPSICLE_SCREEN) SfmFullScreen();
	if(SfmScreentype == LCARS_PANEL_SCREEN) SfmPanelScreen();
/*	if(SfmScreentype == LCARS_MSD_SCREEN) SfmMsdScreen(); */
	if(SfmControltype==STATIC_CONTROL) {

		SfmReadDiagramCode();
		SfmReadSignageCode();
		Result=SfmStaticControl(MsdZoomFlag);
		goto done;
	}
	if(SfmControltype==TXT_CONTROL) {
		SfmReadSignageCode();
		strcpy(CurrentFile, SfmIndex);
		if(LoadTextFile() == 0) {
			SfmIndexLoaded=TRUE;
			Result=SfmTxtControl(0);
		}
			else return(86);
	}

done:
	if(Result==9) goto redo; /* user edited source */

	/* avoid conflict between bouncback and Preview/Briefing */
	if(Result==27 && BouncebackFlag==1) Result=0;

	/* to support the briefing applet */

	if(Result==BS || Result==32 || Result==F12 || Result==27) return(Result);

	if(Result > 0 && Result <10) {
/*		strcpy(Bounceback, filespec); */
		strcpy(filespec, SfmLink[Result]);
		BouncebackFlag=1;
		goto redo;
	}
	if(Result==0 && BouncebackFlag==1) {
		strcpy(filespec, Bounceback);
		BouncebackFlag=0;
		goto redo;
	}

	return(Result);
}
int OpenSfml(char *filespec)
{  /* saves the screen then restores it when LcSfml closes */
	BITMAP *bmp = create_bitmap(800,600);
/*	clear_to_color(bmp,BLACK); */
	blit(screen, bmp, 0, 0, 0, 0, 800, 600);
	LcSfml(filespec);
	rectfill(screen,0,0,800,600, BLACK);
	blit(bmp, screen, 0, 0, 0, 0, 800, 600);
	if(bmp) destroy_bitmap(bmp);
	return(0);
}


