/* Standby.h, variables and some functions of the main LCARS 24 module */

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#ifndef STANDBY_H
#define STANDBY_H


#include <sys/time.h>
#include "lcars24.h"
#include "grset.h"
#include "lccolor.h"
#include "getkey.h"
#include "playwav.h"
#include "cropcirc.h"
#include "mars28.h"
#include "stardate.h"
#include "parts.h"
#include "copyfile.h"
#include "gif.h"
#include "gifview.h"
#include "jpeg.h"
#include "brack1.h"
#include "elbows.h"
#include "mapfonts.h"
#include "headline.h"
#include "errmsg.h"
#include "scrnshot.h"
#include "textio.h"
#include "lcreader.h"
#include "guide.h"
#include "convert.h"
#include "help.h"
#include "matheng.h"
#include "periodic.h"
#include "crosswrd.h"
#include "cards.h"
#include "borg.h"
#include "filemenu.h"
#include "text24.h"
#include "files24.h"
#include "blackjak.h"
#include "chess24.h"
#include "worldmap.h"
#include "wb3.h"
#include "wb5.h"
#include "warbird.h"
#include "winfont.h"
#include "bmi.h"
#include "sysinfo.h"
/* #include "timer.h" */
#include "option.h"
#include "library.h"
#include "viewscrn.h"
#include "alarm.h"
#include "calendar.h"
#include "sfml.h"
#include "phone.h"
#include "timezone.h"
#include "launcher.h"

void Box1a(int Color, char *Str1, char *Str2, char *Str3, char *Str4);
void Box2a(int Hue, char *Str);
void Box1b(int Hue, char *Str);
void EscBox1b(int Hue, char *Str);
void Box2b(int Hue);
void Box3b(int Hue);
void Box4b(int Hue);
void Box5b(int Hue);
void Box3bm(int Hue);
void Box4bm(int Hue);
void Box5bm(int Hue);
void ElbowSignage(int Hue1, int Hue2);
void Boxes();
void Screen1( int Clear);
void ColorSwitch(int x, int y, int sz);
void PutStarDate();
void ClearTextBuf();
unsigned long DoFree();
unsigned long FloppyFree();
void DirFindFilesAndInfo(char *mask, int Num);
void SortFiles();
int DirFindFiles(char *mask);
void SortFolders();
int DirFindFolders(char *mask);
void DoDir(int b);
void GetCopyPath(char *Maskspec);
int GetYNA();
int CopyOneFile(char *Dest, char *Source);
int DoCopy(int b);
int DoDel(int b);
void LineInput_DisplayInputString(int Hue);
void LineInput_Clear();
void ChangeDirectory(int i);
int MakeDir(int b);
int RemoveDir(int b);
int DoType(int b);
int Rename(int b);
int LcarsCmdCom();
int DosRefresh(int txty);
void DosTopOfFile(int txty);
void DosEndOfFile(int txty);
void LineInput_Cursor();
void LineInput_CursorLeft();
void LineInput_CursorRight();
void LineInput_Del();
void LineInput_BS();
void LineInput_DisplayChar();
int AllBlank();
void DosLineInput();
void MathLineInput();
void GlowMode();
int FindOS(void);
void FindGifFiles();
int RegisterDateSetting(int NewMonth, int NewDay, int NewYear);
void RegisterTimeSetting(int NewHr, int NewMin);
void ForcedTimeDisplay(int x, int y, int sz);
void DateSettingDisplay(int NewMonth, int NewDay);
void SettingDisplay(int NewHr, int NewMin);
void DisplaySnoozeSetting();
void TimeSettingMode();
void DateSettingMode();
void SettingsMode();
void SetLcarsPath();
void Recover();
void FindCurrentBracketColors();
int WarmRecover();
void SpecsMode();
void ChangeFolder(char PathAndFilename[80]);
void DoLaunch();
void LaunchDisplay(char *ProgramName,char *ProgramPath);
void FilesMode();
void MakeLauncherBat();
int AppsMode();
int DataMode();
int StopBreak();
void Intro();
int MathMode();
int DosMode();
void LcarsInit();


#endif

