/* textio.c, the following text-loading/saving/coping functions
	int CopyAppList() (for list of DOS programs for launching)
	int LoadAppList()
	int FileTooLong()  (These three use the character array Ln.)
	int LoadTextFile(); (First copy the filename into CurrentFile)
	int SaveTextFile()
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "lcars24.h"
#include "textio.h"


int WrapLoadText(int margin)
{
	char buf[LINELENGTH];
	int w,x,y;
	PACKFILE *Fp;
	unsigned short t;
	int skip=FALSE; /* if forcing a CR, skip the next recorded one */
	int graphical_margin;

	for(y = 0; y < LINECOUNT-1; ++y) memset(Ln[y],0,LINELENGTH);
	memset(buf,0,LINELENGTH);

	if ( ( Fp = pack_fopen(CurrentFile, "rt" )) == NULL ) {
		NormalLoadError(CurrentFile);
		return(86);
	}

	graphical_margin=358;
	if(margin == 50) graphical_margin=380;
	if(margin >= 80) graphical_margin=500;


	w=x=y=0;
	t=32;

	do {
grab:		if(pack_feof(Fp)) {
			strcat(Ln[y], buf);
			if( x !=0 ) ++y;
			break;
		}
		t = pack_getc(Fp);
		if(t>126) t=32;

intake:
		if(y >=LINECOUNT-4) break;
		if(t> 31 || t == 9) {
			buf[w]=(t); /* actual intake */
			++w;
			/* (add something for tabs here) */

		}




/* existing CR in the file */

	if(t==13 && (x==0 || w !=0 || skip==FALSE) ) {

if( StrLenFont21(Ln[y]) + StrLenFont21(buf) >= graphical_margin ) goto wrap;
		strcat(Ln[y], buf);
		memset(buf,0,LINELENGTH);
		w=0;
		x=0;
		++y;
		skip=FALSE;
		goto grab;
	}


	if( (t==13 && (Ln[y][x-1]=='.' || Ln[y][x-2]=='.'))
		|| (t==13 && Ln[y][0]=='!') ) {
			if(w==0) {
				if(skip==TRUE) {
					strcat(Ln[y], " ");
					++x;
					skip=FALSE;
					goto intake;
				} else {
					++y;
					x=0;
					skip=FALSE;
				}
			} else {
				if(x+w <= margin) {
					if(skip==TRUE) {
						strcat(Ln[y], " ");
						++x;
					} else {
if( StrLenFont21(Ln[y]) + StrLenFont21(buf) >= graphical_margin ) goto wrap;
						strcat(Ln[y], buf);
						x+=w;
						memset(buf,0,LINELENGTH);
						w=0;
						x=0;
						++y;
/* makes no difference */	/*		skip=TRUE; */
					}
				} else {
					++y;
					strcpy(Ln[y], buf);
					x=w;
					memset(buf,0,LINELENGTH);
					w=0;
					x=0;
					++y;
/* makes no difference*/	/*	skip=TRUE;   */
				}
			}
		}

/* long solid line */
			if(w >= 48) {
				if(StrLenFont21(buf) < graphical_margin) goto bypass;
				if(x==0) {
					strcpy(Ln[y], buf);
					memset(buf,0,LINELENGTH);
					w=0;
					++y;
					x=0;
				} else {
					++y;
					strcpy(Ln[y], buf);
					memset(buf,0,LINELENGTH);
					w=0;
					++y;
					x=0;
				}
			}
bypass:

/* End of word found? If so, dump it to the line. */
			if(t == 32) {
if(x+w <= margin && (StrLenFont21(Ln[y]) + StrLenFont21(buf) < graphical_margin) ) {
					strcat(Ln[y], buf);
					x+=w;
					memset(buf,0,LINELENGTH);
					w=0;
/* must be inactive */	/*		skip=FALSE; */
				} else {
					/* word wrap */
wrap:					++y;
					strcpy(Ln[y], buf);
					x=w;
					memset(buf,0,LINELENGTH);
					w=0;
					skip=TRUE;
				}
			}
	}  while(1);

	EndText = y;		/* was y-1 */
	memset(Ln[y+1],26,8);  /* was y */
	pack_fclose( Fp );
	file_too_long = FALSE;
	if(EndText >=LINECOUNT-4) {
		FileTooLong();
		file_too_long = TRUE;
	}
	return(0);
}


int CopyAppList()
{
	char Report[5];
	int z, Actual;

	for(z=0; z < MAXPROGRAMS; ++z) {
		memset(Ln[z],0,LINELENGTH);
	}
	if(NoAppList==TRUE) return(0); {
		strcpy(Ln[0],"APPSLIST.TXT not found");
	}
	Actual=0;
	for(z=0; z < EndAppList; ++z) {
		strcpy(Ln[z],AppTitle[z]);
		if(Ln[z][0] > 32) ++Actual;
	}
	EndText=EndAppList;
	NumOfFiles=NumOfApps;
	itoa( Actual, Report, 10);
	PutsLuna(14,254+60, BLACK, BracketColor1, Report);
	PutsLuna(14,254+16+60, BLACK, BracketColor1, "REGISTERED");
	PutsLuna(14,254+32+60, BLACK, BracketColor1, "DOS PROGRAMS");
}
int LoadAppList()
{
	long z;
	int i;
	unsigned char alt = 1;
	int t;
	PACKFILE *Fp;

	for(z=0; z < MAXPROGRAMS; ++z) {
		memset(AppTitle[z],0,LINELENGTH);
		memset(ProgramPath[z],0,LINELENGTH);
	}
	EndAppList=0;
	Fp = pack_fopen(CurrentFile, "rt");
	z=1;
	i=0;
	t=32;
	do {
		if(pack_feof(Fp)) break;
		t = pack_getc(Fp);
			if( t == 13 ) {
			 if( alt == 0) ++z;
			 i=0;
			 alt = !alt;
		}  else {
			if( alt == 1) AppTitle[z][i] = (t);
				else ProgramPath[z][i] = (t);
			if (t> 31) ++i;
		}
	}  while(1);
	EndAppList = z;
	EndText=EndAppList;
	NumOfApps = z-3;
	pack_fclose( Fp );
	return(0);
}

int FileTooLong()
{
	char Report[80];
	char Lines[12];

	itoa( EndText, Lines, 10);
	strcpy(Report, "ONLY ");
	strcat(Report, Lines);
	strcat(Report, " LINES LOADED.  DO NOT EDIT OR SAVE.");

	BITMAP *errbmp = create_bitmap(800,600);

	clear_bitmap(errbmp);
	blit(screen, errbmp, 0, 0, 0, 0, 800, 600);

	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(LILAC);
	Title("FILE ERROR");
	PutsScorpio(160,100,NAPLES,"FILE TOO LONG");
	PutsFont21(160,132,ORANGE,CurrentFile);
	PutsFont21(160,164,ORANGE, Report);

	ButtonType3(160, 196, LILAC, LILAC, "CANCEL");
	EscSymbol(277, 196, 2, NAPLES);

	ButtonType2(40+120, 243, LILAC, PURPLE, "VIEW");
	EnterSymbol(40+88+146+4, 243, 2, ORANGE);

	load_abort=FALSE;
loopback:
	c = GetKey();
	switch( c )
		{
		case LEFTARROW:
		case 27: blit(errbmp, screen, 0, 0, 0, 0, 800, 600);
			destroy_bitmap(errbmp);
			load_abort=TRUE;
			return(86);
		case 13: blit(errbmp, screen, 0, 0, 0, 0, 800, 600);
			destroy_bitmap(errbmp);
			return(0);
		default: goto loopback;
	}
}
int LoadTextFile()
{
	char buf[LINELENGTH];
	int w,x,y;
	PACKFILE *Fp;
	unsigned short t;
	int margin=LINELENGTH;
	int skip=FALSE; /* if forcing a CR, skip the next recorded one */

	for(y = 0; y < LINECOUNT-1; ++y) memset(Ln[y],0,LINELENGTH);
	memset(buf,0,LINELENGTH);

	if ( ( Fp = pack_fopen(CurrentFile, "rt" )) == NULL ) {
		NormalLoadError(CurrentFile);
		return(86);
	}

	w=x=y=0;
	t=32;

	do {
		if(pack_feof(Fp)) {
			strcat(Ln[y], buf);
			if( x !=0 ) ++y;
			break;
		}
		t = pack_getc(Fp);
		if(t>126) t=32;

intake:
		if(y >=LINECOUNT-4) break;
		if(t> 31 || t == 9) {
			buf[w]=(t); /* actual intake */
			++w;
			/* (add something for tabs here) */

		}


/* existing CR in the file */
		if( t == 13 ) {
			if(w==0) {
				if(skip==TRUE) {
					strcat(Ln[y], " ");
					++x;
					skip=FALSE;
					goto intake;
				} else {
					++y;
					x=0;
					skip=FALSE;
				}
			} else {
				if(x+w < margin) {
					if(skip==TRUE) {
						strcat(Ln[y], " ");
						++x;
						skip=FALSE;
					} else {
						strcat(Ln[y], buf);
						x+=w;
		  memset(buf,0,LINELENGTH);
						w=0;
						x=0;
						++y;
/*					 skip=TRUE; */
					}
				} else {
					++y;
					strcpy(Ln[y], buf);
					x=w;
			 memset(buf,0,LINELENGTH);
					w=0;
					x=0;
					++y;
/*				 skip=TRUE;			  */
				}
			}
		}

/* long solid line */
			if(w >= 50) {
				if(x==0) {
					strcpy(Ln[y], buf);
			 memset(buf,0,LINELENGTH);
					w=0;
					++y;
					x=0;
				} else {
					++y;
					strcpy(Ln[y], buf);
			 memset(buf,0,LINELENGTH);
					w=0;
					++y;
					x=0;
				}
			}

/* End of word found? If so, dump it to the line. */
			if(t == 32) {
				if(x+w < margin) {
					strcat(Ln[y], buf);
					x+=w;
			 memset(buf,0,LINELENGTH);
					w=0;
					skip=FALSE;
				} else {
					/* word wrap */
					++y;
					strcpy(Ln[y], buf);
					x=w;
			 memset(buf,0,LINELENGTH);
					w=0;
					skip=TRUE;
				}
			}
	}  while(1);

	EndText = y;		/* was y-1 */
	memset(Ln[y+1],26,8);  /* was y */
	pack_fclose( Fp );
	file_too_long = FALSE;
	if(EndText >=LINECOUNT-4) {
		FileTooLong();
		file_too_long = TRUE;
	}
	return(0);
}

int SaveTextFile()
{
	long z;
	int i;
	unsigned short cr=13;
	unsigned short lf=10;
	unsigned short t;
	PACKFILE *Fp;

	Fp = pack_fopen(CurrentFile, "w");
	z=0;
	i=0;
	t=32;
	do {
		if( z >= EndText) break;
		t = Ln[z][i];
		if(  t == (null) ) {
			pack_putc( (cr), Fp);
			pack_putc( (lf), Fp);
			++z;
			i=0;
		} else {
			pack_putc( (t), Fp);
			++i;
		}
	}  while(1);
	pack_fclose( Fp );
	if(stricmp(CurrentFile,"c:\\lcars24\\appslist.txt")==0) {
		LoadAppList();
/*	 CopyAppList(); */
	}
	return(0);
}

int LoadSourceCode()
{
	char buf[LINELENGTH];
	int z, i, t;
	PACKFILE *Fp;

	for(z = 0; z < LINECOUNT-1; ++z) memset(Ln[z],0,LINELENGTH);

	if ( ( Fp = pack_fopen(CurrentFile, "rt" )) == NULL ) {
		NormalLoadError(CurrentFile);
		return(86);
	}

	z=0;
	i=0;
	t=32;
	do {
		if(pack_feof(Fp)) break;
		t = pack_getc(Fp);
			if( t == 13 ) {
			 ++z;
			 i=0;
		}  else {
			if( i > LINELENGTH-7 ) {	/* was 60 */
				++z;
				i=0;
			}
			Ln[z][i] = (t);
			if (t> 31 || t == 9) ++i;
			if( t < 32 && t !=9 ) Ln[z][i] = (null);
		}
	}  while(1);

	EndText = z;
	memset(Ln[z+1],26,8);  /* was z */
	pack_fclose( Fp );
	file_too_long = FALSE;
	if(EndText >=LINECOUNT-4) {
		FileTooLong();
		file_too_long = TRUE;
	}
	return(0);
}



