/* Tic-tac-toe engine (3x3), adapted from a console program by
Alastair Francis, using minimax, alpha-beta pruning, and
depth-limited recursion with hueristic function
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#ifndef WB3_H
#define WB3_H


#include "lcars24.h"


#define Wb3BOARD_WIDTH 3
#define Wb3BOARD_SIZE 9

enum bool {Wb3True = -1, Wb3False};
typedef enum bool Wb3Boolean;

enum symbol {Wb3empty = 0, X, O};
typedef enum symbol Wb3GamePiece;

struct Wb3Grid  {
	Wb3GamePiece Wb3Element[Wb3BOARD_SIZE];
	int Wb3Elements_occupied;
};
typedef struct Wb3Grid Wb3BoardType;

struct Wb3Player {
	Wb3Boolean Wb3Computer;
	int Wb3SkillLevel;
};
typedef struct Wb3Player Wb3PlayerType;


Wb3GamePiece Wb3Players_piece;
int Wb3MaxDepth;

void Wb3InitBoard (Wb3BoardType* board);
void Wb3PlacePiece (Wb3BoardType* board, int position, Wb3GamePiece piece);
void Wb3RemovePiece (Wb3BoardType* board, int position);
Wb3Boolean Wb3IsWinner (Wb3BoardType board);
Wb3Boolean Wb3IsFull (Wb3BoardType board);
int Wb3Heuristic (Wb3BoardType board);
int Wb3FindBestMove (Wb3BoardType board, Wb3GamePiece piece);
void Wb3FindOpponentMove (Wb3BoardType board, Wb3GamePiece piece, int* status,
			 int alpha, int beta, int depth);

int Wb3FindPlayerMove (Wb3BoardType board, Wb3GamePiece piece, int* status,
				int alpha, int beta, int depth);

#endif

