#include "nRF.h"
#include "nwk_hw.h"

#include <avr/io.h>

//all on PORTD. we should use hardware spi, but i have no time for that. this is OK for now. we can fix it later...
#define NRF_MISO	2
#define NRF_MOSI	3
#define NRF_SCK		4
#define NRF_NCS		5
#define NRF_CE		6

void nwkHwInit(void)
{
	PORTD = (PORTD | (1 << NRF_NCS)) &~ (1 << NRF_CE);
	DDRD = (DDRD | (1 << NRF_MOSI) | (1 << NRF_SCK) | (1 << NRF_NCS) | (1 << NRF_CE)) &~ (1 << NRF_MISO);
}

void nrfCE(char active)
{
	if (active) PORTD |= 1 << NRF_CE;
	else PORTD &=~ (1 << NRF_CE);
}

void nrfCS(char active)
{
	if (active) PORTD &=~ (1 << NRF_NCS);
	else PORTD |= 1 << NRF_NCS;
}

void __attribute__((naked)) nrfDelay200us(void)	//assumes 20MHz clock, delays exactly 205.5us incl call & ret
{
	asm volatile(
			"	ldi  r30, 4		\n\t"
			"loop:				\n\t"
			"	nop			\n\t"
			"	dec  r1			\n\t"
			"	brne loop		\n\t"
			"	dec  r30		\n\t"
			"	brne loop		\n\t"
			"	ret			\n\t"
	);
}

void nrfWaitForIrq(void){
	//nothing
}

uint8_t nrfSpiByte(uint8_t byte)
{
	uint8_t i = 8;
	
	do{
		if (byte & 0x80) PORTD |= 1 << NRF_MOSI;
		else PORTD &=~ (1 << NRF_MOSI);
		PIND = 1 << NRF_SCK;
		byte <<= 1;
		if (PIND & (1 << NRF_MISO)) byte++;
		PIND = 1 << NRF_SCK;
		
	}while(--i);
	
	return byte;
}