#ifndef _PROTOCOL_H_
#define _PROTOCOL_H_

#include <stdint.h>


#define RF_CHANNEL		0
#define NUM_RETRIES		15

//main OS commands (proto v0.1.0.0)
#define PKT_PROTO_VERSION	0x00	//NODATA
#define PKT_PROTO_VER		0x01	//DATA: ver
#define PKT_GET_FW_VER		0x02	//NODATA
#define PKT_FW_VER		0x03	//DATA: ver
#define PKT_CHG_BRI		0x04	//DATA: change
#define PKT_CHG_SPEED		0x05	//DATA: change
#define PKT_CHG_PATTERN		0x06	//DATA: change
#define PKT_ENTER_BOOTLOADER	0x07	//NODATA

//bootloader commands (bootloader v0.1.0.0)
#define PKT_BL_GET_VER		0xF0	//NODATA
#define PKT_BL_FW_VER		0xF1	//DATA: ver
#define PKT_BL_ERASE		0xF2	//NODATA
#define PKT_BL_ERASE_DONE	0xF3	//DATA: state (0 = success, else error)
#define PKT_BL_WRITE		0xF4	//DATA: block
#define PKT_BL_WRITE_DONE	0xF5	//NODATA
#define PKT_BL_REBOOT		0xF6	//NODATA


struct __attribute__((packed)) rf_hdr {
	uint32_t addr;		//who sent this (needed so we can reply)
	uint8_t type;
};

struct __attribute__((packed)) rf_multipart {
	uint32_t addr;		//address of this chunk
	uint8_t pct_done;	//percent done after this packet (for UI)
	uint8_t data[16];	//the data
};

struct __attribute__((packed)) rf_packet {	//all values are little endian
	
	struct rf_hdr hdr;
	union{
		uint32_t ver;			//version info
		uint8_t state;			//for simple unsigned values
		int8_t change;			//for "change" values
		struct rf_multipart block;	//for fw update
	};
};






#endif

