#ifndef _BITFIELD_H_
#define _BITFIELD_H_

#include <stdint.h>


#define BITFIELD_NWORDS(elemSz, nElem)				((nElem * elemSz + 31) / 32)
#define BITFIELD_DECLARE(name, elemSz, nElem)		uint32_t name[BITFIELD_NWORDS(elemSz, nElem)]

uint32_t bitfieldRead(const uint32_t *bf, uint32_t elemSz, uint32_t idx);
void bitfieldWrite(uint32_t *bf, uint32_t elemSz, uint32_t idx, uint32_t val);



#endif
