#include "oscall.h"

void __attribute__((naked)) DALGetGlobalsPtr(){
	asm volatile(CALL_OSCALL(4, 0x0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) HALDbgBreak() {
	asm volatile(CALL_OSCALL(4, 0x4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDbgMessage() {
	asm volatile(CALL_OSCALL(4, 0x8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALAttnGetLEDAttributes() {
	asm volatile(CALL_OSCALL(4, 0xC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALAttnGetVibrateAttributes() {
	asm volatile(CALL_OSCALL(4, 0x10):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALAttnSetLEDAttributes() {
	asm volatile(CALL_OSCALL(4, 0x14):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALAttnSetVibrateAttributes() {
	asm volatile(CALL_OSCALL(4, 0x18):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALBatteryGetInfo() {
	asm volatile(CALL_OSCALL(4, 0x1C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALBatteryGetValidKinds() {
	asm volatile(CALL_OSCALL(4, 0x20):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALBatterySetInfo() {
	asm volatile(CALL_OSCALL(4, 0x24):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDelay() {
	asm volatile(CALL_OSCALL(4, 0x28):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDisplayGetAttributes() {
	asm volatile(CALL_OSCALL(4, 0x2C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDisplayGetPalette() {
	asm volatile(CALL_OSCALL(4, 0x30):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDisplaySetAttributes() {
	asm volatile(CALL_OSCALL(4, 0x34):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDisplaySetPalette() {
	asm volatile(CALL_OSCALL(4, 0x38):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDisplayDoze() {
	asm volatile(CALL_OSCALL(4, 0x3C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDisplayWake() {
	asm volatile(CALL_OSCALL(4, 0x40):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDisplayLock() {
	asm volatile(CALL_OSCALL(4, 0x44):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDisplayUnlock() {
	asm volatile(CALL_OSCALL(4, 0x48):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDockStatus() {
	asm volatile(CALL_OSCALL(4, 0x4C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDrawInit() {
	asm volatile(CALL_OSCALL(4, 0x50):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDrawCopyRectangle() {
	asm volatile(CALL_OSCALL(4, 0x54):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDrawFindIndexes() {
	asm volatile(CALL_OSCALL(4, 0x58):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDrawGetPixel() {
	asm volatile(CALL_OSCALL(4, 0x5C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDrawChars() {
	asm volatile(CALL_OSCALL(4, 0x60):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDrawLine() {
	asm volatile(CALL_OSCALL(4, 0x64):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDrawRectangle() {
	asm volatile(CALL_OSCALL(4, 0x68):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDrawSetPixel() {
	asm volatile(CALL_OSCALL(4, 0x6C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDrawSetPixels() {
	asm volatile(CALL_OSCALL(4, 0x70):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALErrDisplay() {
	asm volatile(CALL_OSCALL(4, 0x74):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALEventPost() {
	asm volatile(CALL_OSCALL(4, 0x78):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALEventRegisterCallBack() {
	asm volatile(CALL_OSCALL(4, 0x7C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpAddDouble() {
	asm volatile(CALL_OSCALL(4, 0x80):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpAddFloat() {
	asm volatile(CALL_OSCALL(4, 0x84):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpCompareDoubleEqual() {
	asm volatile(CALL_OSCALL(4, 0x88):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpCompareDoubleLessThan() {
	asm volatile(CALL_OSCALL(4, 0x8C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpCompareFloatEqual() {
	asm volatile(CALL_OSCALL(4, 0x90):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpCompareFloatLessThan() {
	asm volatile(CALL_OSCALL(4, 0x94):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpDivDouble() {
	asm volatile(CALL_OSCALL(4, 0x98):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpDivFloat() {
	asm volatile(CALL_OSCALL(4, 0x9C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpDoubleToFloat() {
	asm volatile(CALL_OSCALL(4, 0xA0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpDoubleToInt32() {
	asm volatile(CALL_OSCALL(4, 0xA4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpDoubleToLongDouble() {
	asm volatile(CALL_OSCALL(4, 0xA8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpDoubleToLongLong() {
	asm volatile(CALL_OSCALL(4, 0xAC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpDoubleToUInt32() {
	asm volatile(CALL_OSCALL(4, 0xB0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpDoubleToULongLong() {
	asm volatile(CALL_OSCALL(4, 0xB4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpFloatToDouble() {
	asm volatile(CALL_OSCALL(4, 0xB8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpFloatToInt32() {
	asm volatile(CALL_OSCALL(4, 0xBC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpFloatToLongDouble() {
	asm volatile(CALL_OSCALL(4, 0xC0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpFloatToLongLong() {
	asm volatile(CALL_OSCALL(4, 0xC4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpFloatToUInt32() {
	asm volatile(CALL_OSCALL(4, 0xC8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpFloatToULongLong() {
	asm volatile(CALL_OSCALL(4, 0xCC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpInt32ToDouble() {
	asm volatile(CALL_OSCALL(4, 0xD0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpInt32ToFloat() {
	asm volatile(CALL_OSCALL(4, 0xD4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpLongDoubleToDouble() {
	asm volatile(CALL_OSCALL(4, 0xD8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpLongDoubleToFloat() {
	asm volatile(CALL_OSCALL(4, 0xDC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpLongLongToDouble() {
	asm volatile(CALL_OSCALL(4, 0xE0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpLongLongToFloat() {
	asm volatile(CALL_OSCALL(4, 0xE4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpMulDouble() {
	asm volatile(CALL_OSCALL(4, 0xE8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpMulFloat() {
	asm volatile(CALL_OSCALL(4, 0xEC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpNegDouble() {
	asm volatile(CALL_OSCALL(4, 0xF0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpNegFloat() {
	asm volatile(CALL_OSCALL(4, 0xF4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpSubDouble() {
	asm volatile(CALL_OSCALL(4, 0xF8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpSubFloat() {
	asm volatile(CALL_OSCALL(4, 0xFC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpUInt32ToDouble() {
	asm volatile(CALL_OSCALL(4, 0x100):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpUInt32ToFloat() {
	asm volatile(CALL_OSCALL(4, 0x104):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpULongLongToDouble() {
	asm volatile(CALL_OSCALL(4, 0x108):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALFlpULongLongToFloat() {
	asm volatile(CALL_OSCALL(4, 0x10C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALGetHwrMiscFlags() {
	asm volatile(CALL_OSCALL(4, 0x110):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALGetHwrMiscFlagsExt() {
	asm volatile(CALL_OSCALL(4, 0x114):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALGetHwrWakeUp() {
	asm volatile(CALL_OSCALL(4, 0x118):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALInterruptAllSetStatus() {
	asm volatile(CALL_OSCALL(4, 0x11C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALInterruptAllGetStatus() {
	asm volatile(CALL_OSCALL(4, 0x120):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALInterruptGetHandler() {
	asm volatile(CALL_OSCALL(4, 0x124):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALInterruptSetHandler() {
	asm volatile(CALL_OSCALL(4, 0x128):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALInterruptSetState() {
	asm volatile(CALL_OSCALL(4, 0x12C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALKeyGetRates() {
	asm volatile(CALL_OSCALL(4, 0x130):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALKeyGetState() {
	asm volatile(CALL_OSCALL(4, 0x134):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALKeyResetDoubleTap() {
	asm volatile(CALL_OSCALL(4, 0x138):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALKeySetMask() {
	asm volatile(CALL_OSCALL(4, 0x13C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALKeySetRates() {
	asm volatile(CALL_OSCALL(4, 0x140):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALMemoryGetMemoryMap() {
	asm volatile(CALL_OSCALL(4, 0x144):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALMemoryGetStorageAreaProtectionState() {
	asm volatile(CALL_OSCALL(4, 0x148):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALMemorySetStorageAreaProtectionState() {
	asm volatile(CALL_OSCALL(4, 0x14C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALMemoryValidateArea() {
	asm volatile(CALL_OSCALL(4, 0x150):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALMemoryGetAreaSize() {
	asm volatile(CALL_OSCALL(4, 0x154):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALPenCalibrate() {
	asm volatile(CALL_OSCALL(4, 0x158):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALPenRawToScreen() {
	asm volatile(CALL_OSCALL(4, 0x15C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALPenResetCalibration() {
	asm volatile(CALL_OSCALL(4, 0x160):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALPenGetPosition() {
	asm volatile(CALL_OSCALL(4, 0x164):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALPenScreenToRaw() {
	asm volatile(CALL_OSCALL(4, 0x168):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALPowerGetAutoOffEvtTime() {
	asm volatile(CALL_OSCALL(4, 0x16C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALPowerGetAutoOffSeconds() {
	asm volatile(CALL_OSCALL(4, 0x170):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALPowerSetAutoOffEvtTime() {
	asm volatile(CALL_OSCALL(4, 0x174):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALPowerSetAutoOffSeconds() {
	asm volatile(CALL_OSCALL(4, 0x178):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALPowerSleepReady() {
	asm volatile(CALL_OSCALL(4, 0x17C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALProcessorID() {
	asm volatile(CALL_OSCALL(4, 0x180):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALRandomGetBits() {
	asm volatile(CALL_OSCALL(4, 0x184):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALRandomInitializeSeed() {
	asm volatile(CALL_OSCALL(4, 0x188):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALReset() {
	asm volatile(CALL_OSCALL(4, 0x18C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALScreenDefaultPalette() {
	asm volatile(CALL_OSCALL(4, 0x190):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALScreenDrawNotify() {
	asm volatile(CALL_OSCALL(4, 0x194):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALScreenGetColortable() {
	asm volatile(CALL_OSCALL(4, 0x198):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALScreenInit() {
	asm volatile(CALL_OSCALL(4, 0x19C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALScreenLock() {
	asm volatile(CALL_OSCALL(4, 0x1A0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALScreenPalette() {
	asm volatile(CALL_OSCALL(4, 0x1A4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALScreenSendUpdateArea() {
	asm volatile(CALL_OSCALL(4, 0x1A8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALScreenUnlock() {
	asm volatile(CALL_OSCALL(4, 0x1AC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALScreenUpdateBitmap() {
	asm volatile(CALL_OSCALL(4, 0x1B0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALSetInitStage() {
	asm volatile(CALL_OSCALL(4, 0x1B4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALSetHwrMiscFlags() {
	asm volatile(CALL_OSCALL(4, 0x1B8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALSilkscreenGetID() {
	asm volatile(CALL_OSCALL(4, 0x1BC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALSoundOff() {
	asm volatile(CALL_OSCALL(4, 0x1C0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALSoundPlay() {
	asm volatile(CALL_OSCALL(4, 0x1C4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALTimeGetAlarm() {
	asm volatile(CALL_OSCALL(4, 0x1C8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALTimeGetSeconds() {
	asm volatile(CALL_OSCALL(4, 0x1CC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALTimeGetSystemTime() {
	asm volatile(CALL_OSCALL(4, 0x1D0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALTimeGetSystemTimerInterval() {
	asm volatile(CALL_OSCALL(4, 0x1D4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALTimeSetAlarm() {
	asm volatile(CALL_OSCALL(4, 0x1D8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALTimeSetSeconds() {
	asm volatile(CALL_OSCALL(4, 0x1DC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALTraceInit() {
	asm volatile(CALL_OSCALL(4, 0x1E0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALTraceClose() {
	asm volatile(CALL_OSCALL(4, 0x1E4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALTraceOutputT() {
	asm volatile(CALL_OSCALL(4, 0x1E8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALTraceOutputTL() {
	asm volatile(CALL_OSCALL(4, 0x1EC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALTraceOutputVT() {
	asm volatile(CALL_OSCALL(4, 0x1F0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALTraceOutputVTL() {
	asm volatile(CALL_OSCALL(4, 0x1F4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALTraceOutputB() {
	asm volatile(CALL_OSCALL(4, 0x1F8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALOEMGetCompanyID() {
	asm volatile(CALL_OSCALL(4, 0x1FC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALOEMGetHALID() {
	asm volatile(CALL_OSCALL(4, 0x200):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALOEMGetDeviceID() {
	asm volatile(CALL_OSCALL(4, 0x204):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HwrCalcDynamicHeapSize() {
	asm volatile(CALL_OSCALL(4, 0x208):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HwrCalcDynamicRAMSize() {
	asm volatile(CALL_OSCALL(4, 0x20C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDisplayDrawBootScreen() {
	asm volatile(CALL_OSCALL(4, 0x210):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALGetROMToken() {
	asm volatile(CALL_OSCALL(4, 0x214):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALEventGroupClear() {
	asm volatile(CALL_OSCALL(4, 0x218):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALEventGroupCreate() {
	asm volatile(CALL_OSCALL(4, 0x21C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALEventGroupDelete() {
	asm volatile(CALL_OSCALL(4, 0x220):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALEventGroupRead() {
	asm volatile(CALL_OSCALL(4, 0x224):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALEventGroupSignal() {
	asm volatile(CALL_OSCALL(4, 0x228):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALEventGroupWait() {
	asm volatile(CALL_OSCALL(4, 0x22C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALEventGroupGetInfo() {
	asm volatile(CALL_OSCALL(4, 0x230):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALMailboxCreate() {
	asm volatile(CALL_OSCALL(4, 0x234):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALMailboxDelete() {
	asm volatile(CALL_OSCALL(4, 0x238):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALMailboxSend() {
	asm volatile(CALL_OSCALL(4, 0x23C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALMailboxWait() {
	asm volatile(CALL_OSCALL(4, 0x240):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALMailboxGetInfo() {
	asm volatile(CALL_OSCALL(4, 0x244):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALMutexCreate() {
	asm volatile(CALL_OSCALL(4, 0x248):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALMutexDelete() {
	asm volatile(CALL_OSCALL(4, 0x24C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALMutexRelease() {
	asm volatile(CALL_OSCALL(4, 0x250):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALMutexReserve() {
	asm volatile(CALL_OSCALL(4, 0x254):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALMutexGetInfo() {
	asm volatile(CALL_OSCALL(4, 0x258):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALSemaphoreCreate() {
	asm volatile(CALL_OSCALL(4, 0x25C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALSemaphoreDelete() {
	asm volatile(CALL_OSCALL(4, 0x260):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALSemaphoreSignal() {
	asm volatile(CALL_OSCALL(4, 0x264):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALSemaphoreWait() {
	asm volatile(CALL_OSCALL(4, 0x268):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALSemaphoreGetInfo() {
	asm volatile(CALL_OSCALL(4, 0x26C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTaskCreate() {
	asm volatile(CALL_OSCALL(4, 0x270):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTaskDelay() {
	asm volatile(CALL_OSCALL(4, 0x274):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTaskDelete() {
	asm volatile(CALL_OSCALL(4, 0x278):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTaskGetCurrentID() {
	asm volatile(CALL_OSCALL(4, 0x27C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTaskGetInfo() {
	asm volatile(CALL_OSCALL(4, 0x280):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTaskResume() {
	asm volatile(CALL_OSCALL(4, 0x284):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTaskSuspend() {
	asm volatile(CALL_OSCALL(4, 0x288):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTaskStart() {
	asm volatile(CALL_OSCALL(4, 0x28C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTaskSwitching() {
	asm volatile(CALL_OSCALL(4, 0x290):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTaskWait() {
	asm volatile(CALL_OSCALL(4, 0x294):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTaskWaitClr() {
	asm volatile(CALL_OSCALL(4, 0x298):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTaskWake() {
	asm volatile(CALL_OSCALL(4, 0x29C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTaskExit() {
	asm volatile(CALL_OSCALL(4, 0x2A0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTimerCreate() {
	asm volatile(CALL_OSCALL(4, 0x2A4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTimerDelete() {
	asm volatile(CALL_OSCALL(4, 0x2A8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTimerSet() {
	asm volatile(CALL_OSCALL(4, 0x2AC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KALTimerGetInfo() {
	asm volatile(CALL_OSCALL(4, 0x2B0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) RALCallWithNewStack() {
	asm volatile(CALL_OSCALL(4, 0x2B4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) RALGetEntryAddresses() {
	asm volatile(CALL_OSCALL(4, 0x2B8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) RALGetModuleInfo() {
	asm volatile(CALL_OSCALL(4, 0x2BC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) RALGetStaticBase() {
	asm volatile(CALL_OSCALL(4, 0x2C0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) RALLinkClient() {
	asm volatile(CALL_OSCALL(4, 0x2C4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) RALLoadModule() {
	asm volatile(CALL_OSCALL(4, 0x2C8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) RALPatchEntry() {
	asm volatile(CALL_OSCALL(4, 0x2CC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) RALSetA5() {
	asm volatile(CALL_OSCALL(4, 0x2D0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) RALUnloadModule() {
	asm volatile(CALL_OSCALL(4, 0x2D4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) RALUnloadNext() {
	asm volatile(CALL_OSCALL(4, 0x2D8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DALSetDbgLockout() {
	asm volatile(CALL_OSCALL(4, 0x2DC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALKeyGetDoubleTapDelay() {
	asm volatile(CALL_OSCALL(4, 0x2E0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALKeySetDoubleTapDelay() {
	asm volatile(CALL_OSCALL(4, 0x2E4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALInvalidateICache() {
	asm volatile(CALL_OSCALL(4, 0x2E8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}



void __attribute__((naked)) HALDraw_Bitmap() {
	asm volatile(CALL_OSCALL(4, 0x2F8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDraw_FindIndexes() {
	asm volatile(CALL_OSCALL(4, 0x2FC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) HALDraw_GetPixel() {
	asm volatile(CALL_OSCALL(4, 0x300):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) HALDraw_Chars() {
	asm volatile(CALL_OSCALL(4, 0x304):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDraw_Line() {
	asm volatile(CALL_OSCALL(4, 0x308):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDraw_Rectangle() {
	asm volatile(CALL_OSCALL(4, 0x30C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALDraw_Pixels() {
	asm volatile(CALL_OSCALL(4, 0x310):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HALSoundOpen() {
	asm volatile(CALL_OSCALL(4, 0x314):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) HALSoundClose() {
	asm volatile(CALL_OSCALL(4, 0x318):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) HALSoundRead() {
	asm volatile(CALL_OSCALL(4, 0x31C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) HALSoundWrite() {
	asm volatile(CALL_OSCALL(4, 0x320):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) HALSoundIoctl() {
	asm volatile(CALL_OSCALL(4, 0x324):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) HALSoundInitialize() {
	asm volatile(CALL_OSCALL(4, 0x328):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) HALSoundDispose() {
	asm volatile(CALL_OSCALL(4, 0x32C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) HALDraw_GetSupportedDensity() {
	asm volatile(CALL_OSCALL(4, 0x334):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) HALPlaySmf() {
	asm volatile(CALL_OSCALL(4, 0x338):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) HALDisplaySleep() {
	asm volatile(CALL_OSCALL(4, 0x358):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) HALRedrawInputArea() {
	asm volatile(CALL_OSCALL(4, 0x3C0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) PalmOSMain() {
	asm volatile(CALL_OSCALL(8, 0x0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PalmOSGetGlobalsPtr() {
	asm volatile(CALL_OSCALL(8, 0x4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AlmAlarmCallback() {
	asm volatile(CALL_OSCALL(8, 0x8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AlmCancelAll() {
	asm volatile(CALL_OSCALL(8, 0xC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AlmDisplayAlarm() {
	asm volatile(CALL_OSCALL(8, 0x10):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AlmEnableNotification() {
	asm volatile(CALL_OSCALL(8, 0x14):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AlmGetAlarm() {
	asm volatile(CALL_OSCALL(8, 0x18):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AlmGetAlarmV40() {
	asm volatile(CALL_OSCALL(8, 0x1C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AlmInit() {
	asm volatile(CALL_OSCALL(8, 0x20):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AlmSetAlarm() {
	asm volatile(CALL_OSCALL(8, 0x24):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AlmSetAlarmV40() {
	asm volatile(CALL_OSCALL(8, 0x28):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AlmTimeChange() {
	asm volatile(CALL_OSCALL(8, 0x2C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnGetAttentionV40() {
	asm volatile(CALL_OSCALL(8, 0x30):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnUpdateV40() {
	asm volatile(CALL_OSCALL(8, 0x34):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnForgetItV40() {
	asm volatile(CALL_OSCALL(8, 0x38):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnGetCountsV40() {
	asm volatile(CALL_OSCALL(8, 0x3C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnIterateV40() {
	asm volatile(CALL_OSCALL(8, 0x40):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpBitsSize() {
	asm volatile(CALL_OSCALL(8, 0x44):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpColortableSize() {
	asm volatile(CALL_OSCALL(8, 0x48):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpCompress() {
	asm volatile(CALL_OSCALL(8, 0x4C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpCreate() {
	asm volatile(CALL_OSCALL(8, 0x50):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpDelete() {
	asm volatile(CALL_OSCALL(8, 0x54):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpGetBitDepth() {
	asm volatile(CALL_OSCALL(8, 0x58):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpGetBits() {
	asm volatile(CALL_OSCALL(8, 0x5C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpGetColortable() {
	asm volatile(CALL_OSCALL(8, 0x60):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpGetDimensions() {
	asm volatile(CALL_OSCALL(8, 0x64):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpGetNextBitmap() {
	asm volatile(CALL_OSCALL(8, 0x68):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpGetSizes() {
	asm volatile(CALL_OSCALL(8, 0x6C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpSize() {
	asm volatile(CALL_OSCALL(8, 0x70):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CncAddProfile() {
	asm volatile(CALL_OSCALL(8, 0x74):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CncDeleteProfile() {
	asm volatile(CALL_OSCALL(8, 0x78):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CncGetProfileInfo() {
	asm volatile(CALL_OSCALL(8, 0x7C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CncGetProfileList() {
	asm volatile(CALL_OSCALL(8, 0x80):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CncProfileCloseDB() {
	asm volatile(CALL_OSCALL(8, 0x84):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CncProfileCount() {
	asm volatile(CALL_OSCALL(8, 0x88):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CncProfileCreate() {
	asm volatile(CALL_OSCALL(8, 0x8C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CncProfileDelete() {
	asm volatile(CALL_OSCALL(8, 0x90):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CncProfileGetCurrent() {
	asm volatile(CALL_OSCALL(8, 0x94):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CncProfileGetIDFromIndex() {
	asm volatile(CALL_OSCALL(8, 0x98):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CncProfileGetIDFromName() {
	asm volatile(CALL_OSCALL(8, 0x9C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CncProfileGetIndex() {
	asm volatile(CALL_OSCALL(8, 0xA0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CncProfileOpenDB() {
	asm volatile(CALL_OSCALL(8, 0xA4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CncProfileSetCurrent() {
	asm volatile(CALL_OSCALL(8, 0xA8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CncProfileSettingGet() {
	asm volatile(CALL_OSCALL(8, 0xAC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CncProfileSettingSet() {
	asm volatile(CALL_OSCALL(8, 0xB0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CnvInPlaceSwapNBytes() {
	asm volatile(CALL_OSCALL(8, 0xB4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CnvReadSwappedNBytes() {
	asm volatile(CALL_OSCALL(8, 0xB8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CnvWriteSwappedNBytes() {
	asm volatile(CALL_OSCALL(8, 0xBC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CnvReadARMStructureFrom68KFormat() {
	asm volatile(CALL_OSCALL(8, 0xC0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CnvWriteARMStructureTo68KFormat() {
	asm volatile(CALL_OSCALL(8, 0xC4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) Crc16CalcBlock() {
	asm volatile(CALL_OSCALL(8, 0xC8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DateAdjust() {
	asm volatile(CALL_OSCALL(8, 0xCC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DateDaysToDate() {
	asm volatile(CALL_OSCALL(8, 0xD0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DateSecondsToDate() {
	asm volatile(CALL_OSCALL(8, 0xD4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DateTemplateToAscii() {
	asm volatile(CALL_OSCALL(8, 0xD8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DateToAscii() {
	asm volatile(CALL_OSCALL(8, 0xDC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DateToDays() {
	asm volatile(CALL_OSCALL(8, 0xE0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DateToDOWDMFormat() {
	asm volatile(CALL_OSCALL(8, 0xE4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DayOfMonth() {
	asm volatile(CALL_OSCALL(8, 0xE8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DayOfWeek() {
	asm volatile(CALL_OSCALL(8, 0xEC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DaysInMonth() {
	asm volatile(CALL_OSCALL(8, 0xF0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DbgMessage() {
	asm volatile(CALL_OSCALL(8, 0xF4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DbgBreak() {
	asm volatile(CALL_OSCALL(8, 0xF8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DlkControl() {
	asm volatile(CALL_OSCALL(8, 0xFC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DlkDispatchRequest() {
	asm volatile(CALL_OSCALL(8, 0x100):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DlkGetSyncInfo() {
	asm volatile(CALL_OSCALL(8, 0x104):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DlkSetLogEntry() {
	asm volatile(CALL_OSCALL(8, 0x108):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DlkStartServer() {
	asm volatile(CALL_OSCALL(8, 0x10C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmArchiveRecord() {
	asm volatile(CALL_OSCALL(8, 0x110):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmAttachRecord() {
	asm volatile(CALL_OSCALL(8, 0x114):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmAttachResource() {
	asm volatile(CALL_OSCALL(8, 0x118):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmCloseDatabase() {
	asm volatile(CALL_OSCALL(8, 0x11C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmCreateDatabase() {
	asm volatile(CALL_OSCALL(8, 0x120):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmCreateDatabaseFromImage() {
	asm volatile(CALL_OSCALL(8, 0x124):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmCreateDatabaseV40() {
	asm volatile(CALL_OSCALL(8, 0x128):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmDatabaseInfo() {
	asm volatile(CALL_OSCALL(8, 0x12C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmDatabaseInfoV40() {
	asm volatile(CALL_OSCALL(8, 0x130):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmDatabaseProtect() {
	asm volatile(CALL_OSCALL(8, 0x134):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmDatabaseProtectV40() {
	asm volatile(CALL_OSCALL(8, 0x138):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmDatabaseSize() {
	asm volatile(CALL_OSCALL(8, 0x13C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmDatabaseSizeV40() {
	asm volatile(CALL_OSCALL(8, 0x140):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmDeleteCategory() {
	asm volatile(CALL_OSCALL(8, 0x144):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmDeleteDatabase() {
	asm volatile(CALL_OSCALL(8, 0x148):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmDeleteDatabaseV40() {
	asm volatile(CALL_OSCALL(8, 0x14C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmDeleteRecord() {
	asm volatile(CALL_OSCALL(8, 0x150):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmDetachRecord() {
	asm volatile(CALL_OSCALL(8, 0x154):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmDetachResource() {
	asm volatile(CALL_OSCALL(8, 0x158):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmFindDatabase() {
	asm volatile(CALL_OSCALL(8, 0x15C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmFindDatabaseV40() {
	asm volatile(CALL_OSCALL(8, 0x160):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmFindDatabaseWithTypeCreatorV40() {
	asm volatile(CALL_OSCALL(8, 0x164):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmFindDatabaseWithTypeCreator() {
	asm volatile(CALL_OSCALL(8, 0x168):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmFindRecordByID() {
	asm volatile(CALL_OSCALL(8, 0x16C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmFindResource() {
	asm volatile(CALL_OSCALL(8, 0x170):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmFindResourceType() {
	asm volatile(CALL_OSCALL(8, 0x174):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmFindSortPosition() {
	asm volatile(CALL_OSCALL(8, 0x178):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmFindSortPositionV10() {
	asm volatile(CALL_OSCALL(8, 0x17C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmGet1Resource() {
	asm volatile(CALL_OSCALL(8, 0x180):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmGetAppInfoH() {
	asm volatile(CALL_OSCALL(8, 0x184):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmGetDatabase() {
	asm volatile(CALL_OSCALL(8, 0x188):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmGetDatabaseLockState() {
	asm volatile(CALL_OSCALL(8, 0x18C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmGetDatabaseV40() {
	asm volatile(CALL_OSCALL(8, 0x190):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmGetLastErr() {
	asm volatile(CALL_OSCALL(8, 0x194):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmGetNextDatabaseByTypeCreator() {
	asm volatile(CALL_OSCALL(8, 0x198):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmGetNextDatabaseByTypeCreatorV40() {
	asm volatile(CALL_OSCALL(8, 0x19C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmGetRecord() {
	asm volatile(CALL_OSCALL(8, 0x1A0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmGetResource() {
	asm volatile(CALL_OSCALL(8, 0x1A4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmGetResourceIndex() {
	asm volatile(CALL_OSCALL(8, 0x1A8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmInit() {
	asm volatile(CALL_OSCALL(8, 0x1AC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmInsertionSort() {
	asm volatile(CALL_OSCALL(8, 0x1B0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmMoveCategory() {
	asm volatile(CALL_OSCALL(8, 0x1B4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmMoveOpenDBContext() {
	asm volatile(CALL_OSCALL(8, 0x1B8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmMoveRecord() {
	asm volatile(CALL_OSCALL(8, 0x1BC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmNewHandle() {
	asm volatile(CALL_OSCALL(8, 0x1C0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmNewRecord() {
	asm volatile(CALL_OSCALL(8, 0x1C4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmNewResource() {
	asm volatile(CALL_OSCALL(8, 0x1C8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmNextOpenDatabase() {
	asm volatile(CALL_OSCALL(8, 0x1CC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmNextOpenResDatabase() {
	asm volatile(CALL_OSCALL(8, 0x1D0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmNumDatabases() {
	asm volatile(CALL_OSCALL(8, 0x1D4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmNumDatabasesV40() {
	asm volatile(CALL_OSCALL(8, 0x1D8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmNumRecords() {
	asm volatile(CALL_OSCALL(8, 0x1DC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmNumRecordsInCategory() {
	asm volatile(CALL_OSCALL(8, 0x1E0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmNumResources() {
	asm volatile(CALL_OSCALL(8, 0x1E4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmOpenDatabase() {
	asm volatile(CALL_OSCALL(8, 0x1E8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmOpenDatabaseByTypeCreator() {
	asm volatile(CALL_OSCALL(8, 0x1EC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmOpenDatabaseInfo() {
	asm volatile(CALL_OSCALL(8, 0x1F0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmOpenDatabaseInfoV40() {
	asm volatile(CALL_OSCALL(8, 0x1F4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmOpenDatabaseV40() {
	asm volatile(CALL_OSCALL(8, 0x1F8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmOpenDBNoOverlay() {
	asm volatile(CALL_OSCALL(8, 0x1FC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmOpenDBNoOverlayV40() {
	asm volatile(CALL_OSCALL(8, 0x200):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmOpenDBWithLocale() {
	asm volatile(CALL_OSCALL(8, 0x204):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmPositionInCategory() {
	asm volatile(CALL_OSCALL(8, 0x208):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmQueryNextInCategory() {
	asm volatile(CALL_OSCALL(8, 0x20C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmQueryRecord() {
	asm volatile(CALL_OSCALL(8, 0x210):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmQuickSort() {
	asm volatile(CALL_OSCALL(8, 0x214):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmRecordInfo() {
	asm volatile(CALL_OSCALL(8, 0x218):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmReleaseRecord() {
	asm volatile(CALL_OSCALL(8, 0x21C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmReleaseResource() {
	asm volatile(CALL_OSCALL(8, 0x220):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmRemoveRecord() {
	asm volatile(CALL_OSCALL(8, 0x224):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmRemoveResource() {
	asm volatile(CALL_OSCALL(8, 0x228):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmRemoveSecretRecords() {
	asm volatile(CALL_OSCALL(8, 0x22C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmResetRecordStates() {
	asm volatile(CALL_OSCALL(8, 0x230):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmResizeRecord() {
	asm volatile(CALL_OSCALL(8, 0x234):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmResizeResource() {
	asm volatile(CALL_OSCALL(8, 0x238):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmResourceInfo() {
	asm volatile(CALL_OSCALL(8, 0x23C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmSearchRecord() {
	asm volatile(CALL_OSCALL(8, 0x240):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmSearchResource() {
	asm volatile(CALL_OSCALL(8, 0x244):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmSeekRecordInCategory() {
	asm volatile(CALL_OSCALL(8, 0x248):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmSet() {
	asm volatile(CALL_OSCALL(8, 0x24C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmSetDatabaseInfo() {
	asm volatile(CALL_OSCALL(8, 0x250):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmSetDatabaseInfoV40() {
	asm volatile(CALL_OSCALL(8, 0x254):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmSetRecordInfo() {
	asm volatile(CALL_OSCALL(8, 0x258):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmSetResourceInfo() {
	asm volatile(CALL_OSCALL(8, 0x25C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmStrCopy() {
	asm volatile(CALL_OSCALL(8, 0x260):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmWrite() {
	asm volatile(CALL_OSCALL(8, 0x264):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmWriteCheck() {
	asm volatile(CALL_OSCALL(8, 0x268):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EncDES() {
	asm volatile(CALL_OSCALL(8, 0x26C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EncDigestMD4() {
	asm volatile(CALL_OSCALL(8, 0x270):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EncDigestMD5() {
	asm volatile(CALL_OSCALL(8, 0x274):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ErrAlertCustom() {
	asm volatile(CALL_OSCALL(8, 0x278):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ErrDisplayFileLineMsg() {
	asm volatile(CALL_OSCALL(8, 0x27C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ErrExceptionList() {
	asm volatile(CALL_OSCALL(8, 0x280):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ErrThrow() {
	asm volatile(CALL_OSCALL(8, 0x284):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtDequeueKeyEvent() {
	asm volatile(CALL_OSCALL(8, 0x288):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtDequeuePenPoint() {
	asm volatile(CALL_OSCALL(8, 0x28C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtDequeuePenStrokeInfo() {
	asm volatile(CALL_OSCALL(8, 0x290):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtEnableGraffiti() {
	asm volatile(CALL_OSCALL(8, 0x294):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtEnqueueKey() {
	asm volatile(CALL_OSCALL(8, 0x298):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtEnqueuePenPoint() {
	asm volatile(CALL_OSCALL(8, 0x29C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtFlushKeyQueue() {
	asm volatile(CALL_OSCALL(8, 0x2A0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtFlushNextPenStroke() {
	asm volatile(CALL_OSCALL(8, 0x2A4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtFlushPenQueue() {
	asm volatile(CALL_OSCALL(8, 0x2A8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtGetPen() {
	asm volatile(CALL_OSCALL(8, 0x2AC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtGetPenBtnList() {
	asm volatile(CALL_OSCALL(8, 0x2B0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtGetSilkscreenAreaList() {
	asm volatile(CALL_OSCALL(8, 0x2B4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtGetSysEvent() {
	asm volatile(CALL_OSCALL(8, 0x2B8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtKeyQueueEmpty() {
	asm volatile(CALL_OSCALL(8, 0x2BC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtKeyQueueSize() {
	asm volatile(CALL_OSCALL(8, 0x2C0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtPenQueueSize() {
	asm volatile(CALL_OSCALL(8, 0x2C4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtProcessSoftKeyStroke() {
	asm volatile(CALL_OSCALL(8, 0x2C8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtResetAutoOffTimer() {
	asm volatile(CALL_OSCALL(8, 0x2CC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtSetAutoOffTimer() {
	asm volatile(CALL_OSCALL(8, 0x2D0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtSetKeyQueuePtr() {
	asm volatile(CALL_OSCALL(8, 0x2D4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtSetNullEventTick() {
	asm volatile(CALL_OSCALL(8, 0x2D8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtSetPenQueuePtr() {
	asm volatile(CALL_OSCALL(8, 0x2DC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtSysEventAvail() {
	asm volatile(CALL_OSCALL(8, 0x2E0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtSysInit() {
	asm volatile(CALL_OSCALL(8, 0x2E4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtWakeup() {
	asm volatile(CALL_OSCALL(8, 0x2E8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtWakeupWithoutNilEvent() {
	asm volatile(CALL_OSCALL(8, 0x2EC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgAccept() {
	asm volatile(CALL_OSCALL(8, 0x2F0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgConnect() {
	asm volatile(CALL_OSCALL(8, 0x2F4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgControl() {
	asm volatile(CALL_OSCALL(8, 0x2F8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgDBRead() {
	asm volatile(CALL_OSCALL(8, 0x2FC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgDBReadV40() {
	asm volatile(CALL_OSCALL(8, 0x300):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgDBWrite() {
	asm volatile(CALL_OSCALL(8, 0x304):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgDBWriteV40() {
	asm volatile(CALL_OSCALL(8, 0x308):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgDisconnect() {
	asm volatile(CALL_OSCALL(8, 0x30C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgDoDialog() {
	asm volatile(CALL_OSCALL(8, 0x310):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgGet() {
	asm volatile(CALL_OSCALL(8, 0x314):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgGetDefaultApplication() {
	asm volatile(CALL_OSCALL(8, 0x318):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgGetRegisteredApplications() {
	asm volatile(CALL_OSCALL(8, 0x31C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgGetRegisteredTypes() {
	asm volatile(CALL_OSCALL(8, 0x320):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgGetTargetApplication() {
	asm volatile(CALL_OSCALL(8, 0x324):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgInit() {
	asm volatile(CALL_OSCALL(8, 0x328):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgNotifyGoto() {
	asm volatile(CALL_OSCALL(8, 0x32C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgNotifyPreview() {
	asm volatile(CALL_OSCALL(8, 0x330):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgNotifyReceive() {
	asm volatile(CALL_OSCALL(8, 0x334):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgNotifyReceiveV35() {
	asm volatile(CALL_OSCALL(8, 0x338):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgPut() {
	asm volatile(CALL_OSCALL(8, 0x33C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgReceive() {
	asm volatile(CALL_OSCALL(8, 0x340):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgRegisterData() {
	asm volatile(CALL_OSCALL(8, 0x344):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgRegisterDatatype() {
	asm volatile(CALL_OSCALL(8, 0x348):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgRequest() {
	asm volatile(CALL_OSCALL(8, 0x34C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgSend() {
	asm volatile(CALL_OSCALL(8, 0x350):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgSetDefaultApplication() {
	asm volatile(CALL_OSCALL(8, 0x354):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgLibControl() {
	asm volatile(CALL_OSCALL(8, 0x358):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgLibGetLibraryRef() {
	asm volatile(CALL_OSCALL(8, 0x35C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExgLibHandleEvent() {
	asm volatile(CALL_OSCALL(8, 0x360):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExpCardGetSerialPort() {
	asm volatile(CALL_OSCALL(8, 0x364):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExpCardInfo() {
	asm volatile(CALL_OSCALL(8, 0x368):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExpCardInserted() {
	asm volatile(CALL_OSCALL(8, 0x36C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExpCardPresent() {
	asm volatile(CALL_OSCALL(8, 0x370):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExpCardRemoved() {
	asm volatile(CALL_OSCALL(8, 0x374):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExpInit() {
	asm volatile(CALL_OSCALL(8, 0x378):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExpSlotDriverInstall() {
	asm volatile(CALL_OSCALL(8, 0x37C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExpSlotDriverRemove() {
	asm volatile(CALL_OSCALL(8, 0x380):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExpSlotEnumerate() {
	asm volatile(CALL_OSCALL(8, 0x384):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExpSlotLibFind() {
	asm volatile(CALL_OSCALL(8, 0x388):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExpSlotRegister() {
	asm volatile(CALL_OSCALL(8, 0x38C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ExpSlotUnregister() {
	asm volatile(CALL_OSCALL(8, 0x390):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FileClose() {
	asm volatile(CALL_OSCALL(8, 0x394):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FileControl() {
	asm volatile(CALL_OSCALL(8, 0x398):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FileDelete() {
	asm volatile(CALL_OSCALL(8, 0x39C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FileDeleteV40() {
	asm volatile(CALL_OSCALL(8, 0x3A0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FileOpen() {
	asm volatile(CALL_OSCALL(8, 0x3A4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FileOpenV40() {
	asm volatile(CALL_OSCALL(8, 0x3A8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FileReadLow() {
	asm volatile(CALL_OSCALL(8, 0x3AC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FileSeek() {
	asm volatile(CALL_OSCALL(8, 0x3B0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FileTell() {
	asm volatile(CALL_OSCALL(8, 0x3B4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FileTruncate() {
	asm volatile(CALL_OSCALL(8, 0x3B8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FileWrite() {
	asm volatile(CALL_OSCALL(8, 0x3BC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FindSaveMatchV40() {
	asm volatile(CALL_OSCALL(8, 0x3C0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FlpAToF() {
	asm volatile(CALL_OSCALL(8, 0x3C4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FlpBase10Info() {
	asm volatile(CALL_OSCALL(8, 0x3C8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FlpCorrectedAdd() {
	asm volatile(CALL_OSCALL(8, 0x3CC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FlpCorrectedSub() {
	asm volatile(CALL_OSCALL(8, 0x3D0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FlpFToA() {
	asm volatile(CALL_OSCALL(8, 0x3D4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FlpVersion() {
	asm volatile(CALL_OSCALL(8, 0x3D8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntAverageCharWidth() {
	asm volatile(CALL_OSCALL(8, 0x3DC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntBaseLine() {
	asm volatile(CALL_OSCALL(8, 0x3E0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntCharHeight() {
	asm volatile(CALL_OSCALL(8, 0x3E4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntCharsInWidth() {
	asm volatile(CALL_OSCALL(8, 0x3E8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntCharsWidth() {
	asm volatile(CALL_OSCALL(8, 0x3EC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntCharWidth() {
	asm volatile(CALL_OSCALL(8, 0x3F0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntDefineFont() {
	asm volatile(CALL_OSCALL(8, 0x3F4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntDescenderHeight() {
	asm volatile(CALL_OSCALL(8, 0x3F8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntGetFont() {
	asm volatile(CALL_OSCALL(8, 0x3FC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntGetFontPtr() {
	asm volatile(CALL_OSCALL(8, 0x400):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntGetScrollValues() {
	asm volatile(CALL_OSCALL(8, 0x404):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntLineHeight() {
	asm volatile(CALL_OSCALL(8, 0x408):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntLineWidth() {
	asm volatile(CALL_OSCALL(8, 0x40C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntSetFont() {
	asm volatile(CALL_OSCALL(8, 0x410):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntWCharWidth() {
	asm volatile(CALL_OSCALL(8, 0x414):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntWidthToOffset() {
	asm volatile(CALL_OSCALL(8, 0x418):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntWordWrap() {
	asm volatile(CALL_OSCALL(8, 0x41C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FntWordWrapReverseNLines() {
	asm volatile(CALL_OSCALL(8, 0x420):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FtrGet() {
	asm volatile(CALL_OSCALL(8, 0x424):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FtrGetByIndex() {
	asm volatile(CALL_OSCALL(8, 0x428):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FtrInit() {
	asm volatile(CALL_OSCALL(8, 0x42C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FtrPtrFree() {
	asm volatile(CALL_OSCALL(8, 0x430):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FtrPtrNew() {
	asm volatile(CALL_OSCALL(8, 0x434):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FtrPtrResize() {
	asm volatile(CALL_OSCALL(8, 0x438):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FtrSet() {
	asm volatile(CALL_OSCALL(8, 0x43C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FtrUnregister() {
	asm volatile(CALL_OSCALL(8, 0x440):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) GetCharAttr() {
	asm volatile(CALL_OSCALL(8, 0x444):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) GetCharCaselessValue() {
	asm volatile(CALL_OSCALL(8, 0x448):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) GetCharSortValue() {
	asm volatile(CALL_OSCALL(8, 0x44C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TmOutputB() {
	asm volatile(CALL_OSCALL(8, 0x450):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TmOutputT() {
	asm volatile(CALL_OSCALL(8, 0x454):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TmOutputTL() {
	asm volatile(CALL_OSCALL(8, 0x458):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TmOutputVT() {
	asm volatile(CALL_OSCALL(8, 0x45C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TmOutputVTL() {
	asm volatile(CALL_OSCALL(8, 0x460):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HSUtilReverseDWord() {
	asm volatile(CALL_OSCALL(8, 0x464):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) HSUtilReverseWord() {
	asm volatile(CALL_OSCALL(8, 0x468):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ImcReadFieldNoSemicolon() {
	asm volatile(CALL_OSCALL(8, 0x46C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ImcReadFieldQuotablePrintable() {
	asm volatile(CALL_OSCALL(8, 0x470):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ImcReadPropertyParameter() {
	asm volatile(CALL_OSCALL(8, 0x474):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ImcReadWhiteSpace() {
	asm volatile(CALL_OSCALL(8, 0x478):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ImcSkipAllPropertyParameters() {
	asm volatile(CALL_OSCALL(8, 0x47C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ImcStringIsAscii() {
	asm volatile(CALL_OSCALL(8, 0x480):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ImcWriteNoSemicolon() {
	asm volatile(CALL_OSCALL(8, 0x484):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ImcWriteQuotedPrintable() {
	asm volatile(CALL_OSCALL(8, 0x488):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KeyCurrentState() {
	asm volatile(CALL_OSCALL(8, 0x48C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KeyRates() {
	asm volatile(CALL_OSCALL(8, 0x490):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KeySetMask() {
	asm volatile(CALL_OSCALL(8, 0x494):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LmGetLocaleSetting() {
	asm volatile(CALL_OSCALL(8, 0x498):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LmGetNumLocales() {
	asm volatile(CALL_OSCALL(8, 0x49C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LmLocaleToIndex() {
	asm volatile(CALL_OSCALL(8, 0x4A0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LocGetNumberSeparators() {
	asm volatile(CALL_OSCALL(8, 0x4A4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstSetDrawFunctionV40() {
	asm volatile(CALL_OSCALL(8, 0x4A8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MdmDial() {
	asm volatile(CALL_OSCALL(8, 0x4AC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MdmHangUp() {
	asm volatile(CALL_OSCALL(8, 0x4B0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemCardInfoV40() {
	asm volatile(CALL_OSCALL(8, 0x4B4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemChunkFree() {
	asm volatile(CALL_OSCALL(8, 0x4B8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemChunkNew() {
	asm volatile(CALL_OSCALL(8, 0x4BC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemCmp() {
	asm volatile(CALL_OSCALL(8, 0x4C0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemDebugMode() {
	asm volatile(CALL_OSCALL(8, 0x4C4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemFormat() {
	asm volatile(CALL_OSCALL(8, 0x4C8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemGetRomNVParams() {
	asm volatile(CALL_OSCALL(8, 0x4CC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHandleCardNoV40() {
	asm volatile(CALL_OSCALL(8, 0x4D0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHandleDataStorage() {
	asm volatile(CALL_OSCALL(8, 0x4D4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHandleFlags() {
	asm volatile(CALL_OSCALL(8, 0x4D8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHandleFree() {
	asm volatile(CALL_OSCALL(8, 0x4DC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHandleHeapID() {
	asm volatile(CALL_OSCALL(8, 0x4E0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHandleLock() {
	asm volatile(CALL_OSCALL(8, 0x4E4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHandleLockCount() {
	asm volatile(CALL_OSCALL(8, 0x4E8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHandleNew() {
	asm volatile(CALL_OSCALL(8, 0x4EC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHandleOwner() {
	asm volatile(CALL_OSCALL(8, 0x4F0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHandleResetLock() {
	asm volatile(CALL_OSCALL(8, 0x4F4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHandleResize() {
	asm volatile(CALL_OSCALL(8, 0x4F8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHandleSetOwner() {
	asm volatile(CALL_OSCALL(8, 0x4FC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHandleSize() {
	asm volatile(CALL_OSCALL(8, 0x500):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHandleToLocalIDV40() {
	asm volatile(CALL_OSCALL(8, 0x504):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHandleUnlock() {
	asm volatile(CALL_OSCALL(8, 0x508):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHeapCheck() {
	asm volatile(CALL_OSCALL(8, 0x50C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHeapCompact() {
	asm volatile(CALL_OSCALL(8, 0x510):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHeapDynamic() {
	asm volatile(CALL_OSCALL(8, 0x514):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHeapFlags() {
	asm volatile(CALL_OSCALL(8, 0x518):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHeapFreeByOwnerID() {
	asm volatile(CALL_OSCALL(8, 0x51C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHeapFreeBytes() {
	asm volatile(CALL_OSCALL(8, 0x520):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHeapID() {
	asm volatile(CALL_OSCALL(8, 0x524):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHeapIDV40() {
	asm volatile(CALL_OSCALL(8, 0x528):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHeapInit() {
	asm volatile(CALL_OSCALL(8, 0x52C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHeapPtr() {
	asm volatile(CALL_OSCALL(8, 0x530):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHeapScramble() {
	asm volatile(CALL_OSCALL(8, 0x534):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemHeapSize() {
	asm volatile(CALL_OSCALL(8, 0x538):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemInfo() {
	asm volatile(CALL_OSCALL(8, 0x53C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemInit() {
	asm volatile(CALL_OSCALL(8, 0x540):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemKernelInit() {
	asm volatile(CALL_OSCALL(8, 0x544):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemLocalIDKindV40() {
	asm volatile(CALL_OSCALL(8, 0x548):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemLocalIDToGlobalV40() {
	asm volatile(CALL_OSCALL(8, 0x54C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemLocalIDToLockedPtrV40() {
	asm volatile(CALL_OSCALL(8, 0x550):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemLocalIDToPtrV40() {
	asm volatile(CALL_OSCALL(8, 0x554):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemMove() {
	asm volatile(CALL_OSCALL(8, 0x558):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemNumCardsV40() {
	asm volatile(CALL_OSCALL(8, 0x55C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemNumHeaps() {
	asm volatile(CALL_OSCALL(8, 0x560):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemNumHeapsV40() {
	asm volatile(CALL_OSCALL(8, 0x564):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemNumRAMHeaps() {
	asm volatile(CALL_OSCALL(8, 0x568):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemNumRAMHeapsV40() {
	asm volatile(CALL_OSCALL(8, 0x56C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemNVParams() {
	asm volatile(CALL_OSCALL(8, 0x570):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemPtrCardNoV40() {
	asm volatile(CALL_OSCALL(8, 0x574):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemPtrDataStorage() {
	asm volatile(CALL_OSCALL(8, 0x578):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemPtrFlags() {
	asm volatile(CALL_OSCALL(8, 0x57C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemPtrHeapID() {
	asm volatile(CALL_OSCALL(8, 0x580):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemPtrNew() {
	asm volatile(CALL_OSCALL(8, 0x584):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemPtrOwner() {
	asm volatile(CALL_OSCALL(8, 0x588):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemPtrRecoverHandle() {
	asm volatile(CALL_OSCALL(8, 0x58C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemPtrResetLock() {
	asm volatile(CALL_OSCALL(8, 0x590):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemPtrResize() {
	asm volatile(CALL_OSCALL(8, 0x594):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemPtrSetOwner() {
	asm volatile(CALL_OSCALL(8, 0x598):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemPtrSize() {
	asm volatile(CALL_OSCALL(8, 0x59C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemPtrToLocalIDV40() {
	asm volatile(CALL_OSCALL(8, 0x5A0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemPtrUnlock() {
	asm volatile(CALL_OSCALL(8, 0x5A4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemSemaphoreRelease() {
	asm volatile(CALL_OSCALL(8, 0x5A8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemSemaphoreReserve() {
	asm volatile(CALL_OSCALL(8, 0x5AC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemSet() {
	asm volatile(CALL_OSCALL(8, 0x5B0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemSetDebugMode() {
	asm volatile(CALL_OSCALL(8, 0x5B4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemStoreInfo() {
	asm volatile(CALL_OSCALL(8, 0x5B8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemStoreInfoV40() {
	asm volatile(CALL_OSCALL(8, 0x5BC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemStoreSearch() {
	asm volatile(CALL_OSCALL(8, 0x5C0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemStoreSetInfo() {
	asm volatile(CALL_OSCALL(8, 0x5C4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MemStoreSetInfoV40() {
	asm volatile(CALL_OSCALL(8, 0x5C8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) OmGetCurrentLocale() {
	asm volatile(CALL_OSCALL(8, 0x5CC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) OmGetIndexedLocale() {
	asm volatile(CALL_OSCALL(8, 0x5D0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) OmGetNextSystemLocale() {
	asm volatile(CALL_OSCALL(8, 0x5D4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) OmGetSystemLocale() {
	asm volatile(CALL_OSCALL(8, 0x5D8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) OmLocaleToOverlayDBName() {
	asm volatile(CALL_OSCALL(8, 0x5DC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) OmOverlayDBNameToLocale() {
	asm volatile(CALL_OSCALL(8, 0x5E0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) OmSetSystemLocale() {
	asm volatile(CALL_OSCALL(8, 0x5E4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PenCalibrate() {
	asm volatile(CALL_OSCALL(8, 0x5E8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PenResetCalibration() {
	asm volatile(CALL_OSCALL(8, 0x5EC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrefGetAppPreferences() {
	asm volatile(CALL_OSCALL(8, 0x5F0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrefGetAppPreferencesV10() {
	asm volatile(CALL_OSCALL(8, 0x5F4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrefGetPreference() {
	asm volatile(CALL_OSCALL(8, 0x5F8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrefGetPreferences() {
	asm volatile(CALL_OSCALL(8, 0x5FC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrefOpenPreferenceDB() {
	asm volatile(CALL_OSCALL(8, 0x600):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrefOpenPreferenceDBV10() {
	asm volatile(CALL_OSCALL(8, 0x604):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrefSetAppPreferences() {
	asm volatile(CALL_OSCALL(8, 0x608):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrefSetAppPreferencesV10() {
	asm volatile(CALL_OSCALL(8, 0x60C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrefSetPreference() {
	asm volatile(CALL_OSCALL(8, 0x610):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrefSetPreferences() {
	asm volatile(CALL_OSCALL(8, 0x614):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrvCncCreateDatabaseFromDefault() {
	asm volatile(CALL_OSCALL(8, 0x618):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrvCncMgrInit() {
	asm volatile(CALL_OSCALL(8, 0x61C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrvCncPostHotSyncDBCleanup() {
	asm volatile(CALL_OSCALL(8, 0x620):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrvCncProfileBuildUniqueName() {
	asm volatile(CALL_OSCALL(8, 0x624):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrvCncProfileDuplicate() {
	asm volatile(CALL_OSCALL(8, 0x628):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PwdExists() {
	asm volatile(CALL_OSCALL(8, 0x62C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PwdRemove() {
	asm volatile(CALL_OSCALL(8, 0x630):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PwdSet() {
	asm volatile(CALL_OSCALL(8, 0x634):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PwdVerify() {
	asm volatile(CALL_OSCALL(8, 0x638):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) RctCopyRectangle() {
	asm volatile(CALL_OSCALL(8, 0x63C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) RctGetIntersection() {
	asm volatile(CALL_OSCALL(8, 0x640):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) RctInsetRectangle() {
	asm volatile(CALL_OSCALL(8, 0x644):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) RctOffsetRectangle() {
	asm volatile(CALL_OSCALL(8, 0x648):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) RctPtInRectangle() {
	asm volatile(CALL_OSCALL(8, 0x64C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) RctSetRectangle() {
	asm volatile(CALL_OSCALL(8, 0x650):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ScrCompress() {
	asm volatile(CALL_OSCALL(8, 0x654):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ScrCompressScanLine() {
	asm volatile(CALL_OSCALL(8, 0x658):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ScrDecompress() {
	asm volatile(CALL_OSCALL(8, 0x65C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ScrDeCompressScanLine() {
	asm volatile(CALL_OSCALL(8, 0x660):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SecGetPwdHint() {
	asm volatile(CALL_OSCALL(8, 0x664):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SecSetPwdHint() {
	asm volatile(CALL_OSCALL(8, 0x668):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SerialMgrInstall() {
	asm volatile(CALL_OSCALL(8, 0x66C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlkClose() {
	asm volatile(CALL_OSCALL(8, 0x670):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlkCloseSocket() {
	asm volatile(CALL_OSCALL(8, 0x674):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlkFlushSocket() {
	asm volatile(CALL_OSCALL(8, 0x678):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlkOpen() {
	asm volatile(CALL_OSCALL(8, 0x67C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlkOpenSocket() {
	asm volatile(CALL_OSCALL(8, 0x680):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlkProcessRPC() {
	asm volatile(CALL_OSCALL(8, 0x684):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlkReceivePacket() {
	asm volatile(CALL_OSCALL(8, 0x688):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlkSendPacket() {
	asm volatile(CALL_OSCALL(8, 0x68C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlkSetSocketListener() {
	asm volatile(CALL_OSCALL(8, 0x690):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlkSocketPortID() {
	asm volatile(CALL_OSCALL(8, 0x694):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlkSocketSetTimeout() {
	asm volatile(CALL_OSCALL(8, 0x698):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlkSysPktDefaultResponse() {
	asm volatile(CALL_OSCALL(8, 0x69C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotCardGetSerialPort() {
	asm volatile(CALL_OSCALL(8, 0x6A0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotCardInfo() {
	asm volatile(CALL_OSCALL(8, 0x6A4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotCardIsFilesystemSupported() {
	asm volatile(CALL_OSCALL(8, 0x6A8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotCardLowLevelFormat() {
	asm volatile(CALL_OSCALL(8, 0x6AC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotCardMediaType() {
	asm volatile(CALL_OSCALL(8, 0x6B0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotCardMetrics() {
	asm volatile(CALL_OSCALL(8, 0x6B4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotCardPresent() {
	asm volatile(CALL_OSCALL(8, 0x6B8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotCardRelease() {
	asm volatile(CALL_OSCALL(8, 0x6BC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotCardReserve() {
	asm volatile(CALL_OSCALL(8, 0x6C0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotCardSectorRead() {
	asm volatile(CALL_OSCALL(8, 0x6C4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotCardSectorWrite() {
	asm volatile(CALL_OSCALL(8, 0x6C8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotClose() {
	asm volatile(CALL_OSCALL(8, 0x6CC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotCustomControl() {
	asm volatile(CALL_OSCALL(8, 0x6D0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotOpen() {
	asm volatile(CALL_OSCALL(8, 0x6D4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotLibAPIVersion() {
	asm volatile(CALL_OSCALL(8, 0x6D8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotPowerCheck() {
	asm volatile(CALL_OSCALL(8, 0x6DC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotSleep() {
	asm volatile(CALL_OSCALL(8, 0x6E0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotWake() {
	asm volatile(CALL_OSCALL(8, 0x6E4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndCreateMidiList() {
	asm volatile(CALL_OSCALL(8, 0x6E8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndDoCmd() {
	asm volatile(CALL_OSCALL(8, 0x6EC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndGetDefaultVolume() {
	asm volatile(CALL_OSCALL(8, 0x6F0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndInit() {
	asm volatile(CALL_OSCALL(8, 0x6F4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndPlaySmf() {
	asm volatile(CALL_OSCALL(8, 0x6F8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndPlaySmfResource() {
	asm volatile(CALL_OSCALL(8, 0x6FC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndPlaySystemSound() {
	asm volatile(CALL_OSCALL(8, 0x700):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndSetDefaultVolume() {
	asm volatile(CALL_OSCALL(8, 0x704):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmClearErr() {
	asm volatile(CALL_OSCALL(8, 0x708):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmClose() {
	asm volatile(CALL_OSCALL(8, 0x70C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmControl() {
	asm volatile(CALL_OSCALL(8, 0x710):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmCustomControl() {
	asm volatile(CALL_OSCALL(8, 0x714):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmExtOpen() {
	asm volatile(CALL_OSCALL(8, 0x718):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmExtOpenBackground() {
	asm volatile(CALL_OSCALL(8, 0x71C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmGetDeviceCount() {
	asm volatile(CALL_OSCALL(8, 0x720):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmGetDeviceInfo() {
	asm volatile(CALL_OSCALL(8, 0x724):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmGetStatus() {
	asm volatile(CALL_OSCALL(8, 0x728):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmOpen() {
	asm volatile(CALL_OSCALL(8, 0x72C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmOpenBackground() {
	asm volatile(CALL_OSCALL(8, 0x730):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmPrimeWakeupHandler() {
	asm volatile(CALL_OSCALL(8, 0x734):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmReceive() {
	asm volatile(CALL_OSCALL(8, 0x738):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmReceiveCheck() {
	asm volatile(CALL_OSCALL(8, 0x73C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmReceiveFlush() {
	asm volatile(CALL_OSCALL(8, 0x740):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmReceiveWait() {
	asm volatile(CALL_OSCALL(8, 0x744):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmReceiveWindowClose() {
	asm volatile(CALL_OSCALL(8, 0x748):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmReceiveWindowOpen() {
	asm volatile(CALL_OSCALL(8, 0x74C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmSend() {
	asm volatile(CALL_OSCALL(8, 0x750):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmSendCheck() {
	asm volatile(CALL_OSCALL(8, 0x754):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmSendFlush() {
	asm volatile(CALL_OSCALL(8, 0x758):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmSendWait() {
	asm volatile(CALL_OSCALL(8, 0x75C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmSetReceiveBuffer() {
	asm volatile(CALL_OSCALL(8, 0x760):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmSetWakeupHandler() {
	asm volatile(CALL_OSCALL(8, 0x764):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmSleep() {
	asm volatile(CALL_OSCALL(8, 0x768):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SrmWake() {
	asm volatile(CALL_OSCALL(8, 0x76C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrAToI() {
	asm volatile(CALL_OSCALL(8, 0x770):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrCaselessCompare() {
	asm volatile(CALL_OSCALL(8, 0x774):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrCat() {
	asm volatile(CALL_OSCALL(8, 0x778):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrChr() {
	asm volatile(CALL_OSCALL(8, 0x77C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrCompare() {
	asm volatile(CALL_OSCALL(8, 0x780):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrCompareAscii() {
	asm volatile(CALL_OSCALL(8, 0x784):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrCopy() {
	asm volatile(CALL_OSCALL(8, 0x788):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrDelocalizeNumber() {
	asm volatile(CALL_OSCALL(8, 0x78C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrIToA() {
	asm volatile(CALL_OSCALL(8, 0x790):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrIToH() {
	asm volatile(CALL_OSCALL(8, 0x794):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrLen() {
	asm volatile(CALL_OSCALL(8, 0x798):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrLocalizeNumber() {
	asm volatile(CALL_OSCALL(8, 0x79C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrNCaselessCompare() {
	asm volatile(CALL_OSCALL(8, 0x7A0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrNCat() {
	asm volatile(CALL_OSCALL(8, 0x7A4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrNCompare() {
	asm volatile(CALL_OSCALL(8, 0x7A8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrNCompareAscii() {
	asm volatile(CALL_OSCALL(8, 0x7AC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrNCopy() {
	asm volatile(CALL_OSCALL(8, 0x7B0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrPrintF() {
	asm volatile(CALL_OSCALL(8, 0x7B4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrStr() {
	asm volatile(CALL_OSCALL(8, 0x7B8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrToLower() {
	asm volatile(CALL_OSCALL(8, 0x7BC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) StrVPrintF() {
	asm volatile(CALL_OSCALL(8, 0x7C0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysAppExit() {
	asm volatile(CALL_OSCALL(8, 0x7C4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysAppLaunch() {
	asm volatile(CALL_OSCALL(8, 0x7C8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysAppLaunchV40() {
	asm volatile(CALL_OSCALL(8, 0x7CC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysAppStartup() {
	asm volatile(CALL_OSCALL(8, 0x7D0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysAreWeUIThread() {
	asm volatile(CALL_OSCALL(8, 0x7D4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysBatteryInfo() {
	asm volatile(CALL_OSCALL(8, 0x7D8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysBatteryInfoV20() {
	asm volatile(CALL_OSCALL(8, 0x7DC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysBatteryInfoV40() {
	asm volatile(CALL_OSCALL(8, 0x7E0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysBinarySearch() {
	asm volatile(CALL_OSCALL(8, 0x7E4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysBroadcastActionCode() {
	asm volatile(CALL_OSCALL(8, 0x7E8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysCheckPwdTimeout() {
	asm volatile(CALL_OSCALL(8, 0x7EC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysColdBoot() {
	asm volatile(CALL_OSCALL(8, 0x7F0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysCopyStringResource() {
	asm volatile(CALL_OSCALL(8, 0x7F4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysCreateDataBaseList() {
	asm volatile(CALL_OSCALL(8, 0x7F8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysCreatePanelList() {
	asm volatile(CALL_OSCALL(8, 0x7FC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysCurAppDatabase() {
	asm volatile(CALL_OSCALL(8, 0x800):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysCurAppDatabaseV40() {
	asm volatile(CALL_OSCALL(8, 0x804):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysCurAppInfoPV20() {
	asm volatile(CALL_OSCALL(8, 0x808):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysDisableInts() {
	asm volatile(CALL_OSCALL(8, 0x80C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysErrString() {
	asm volatile(CALL_OSCALL(8, 0x810):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) EvtAddEventToQueue() {
	asm volatile(CALL_OSCALL(8, 0x814):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysEventAddToQueue() {
	asm volatile(CALL_OSCALL(8, 0x814):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtAddUniqueEventToQueue() {
	asm volatile(CALL_OSCALL(8, 0x818):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysEventAddUniqueToQueue() {
	asm volatile(CALL_OSCALL(8, 0x818):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtEventAvail() {
	asm volatile(CALL_OSCALL(8, 0x81C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysEventAvail() {
	asm volatile(CALL_OSCALL(8, 0x81C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtCopyEvent() {
	asm volatile(CALL_OSCALL(8, 0x820):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysEventCopy() {
	asm volatile(CALL_OSCALL(8, 0x820):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtGetEvent() {
	asm volatile(CALL_OSCALL(8, 0x824):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysEventGet() {
	asm volatile(CALL_OSCALL(8, 0x824):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtInitialize() {
	asm volatile(CALL_OSCALL(8, 0x828):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysEventInitialize() {
	asm volatile(CALL_OSCALL(8, 0x828):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysFindModule() {
	asm volatile(CALL_OSCALL(8, 0x82C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysFormPointerArrayToStrings() {
	asm volatile(CALL_OSCALL(8, 0x830):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysGetAppInfo() {
	asm volatile(CALL_OSCALL(8, 0x834):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysGetEntryAddresses() {
	asm volatile(CALL_OSCALL(8, 0x838):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysGetOSVersionString() {
	asm volatile(CALL_OSCALL(8, 0x83C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysGetROMToken() {
	asm volatile(CALL_OSCALL(8, 0x840):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysGetROMTokenV40() {
	asm volatile(CALL_OSCALL(8, 0x844):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysGetStackInfo() {
	asm volatile(CALL_OSCALL(8, 0x848):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysHandleEvent() {
	asm volatile(CALL_OSCALL(8, 0x84C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysInit() {
	asm volatile(CALL_OSCALL(8, 0x850):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysInsertionSort() {
	asm volatile(CALL_OSCALL(8, 0x854):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysLCDBrightness() {
	asm volatile(CALL_OSCALL(8, 0x858):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysLCDContrast() {
	asm volatile(CALL_OSCALL(8, 0x85C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysLibLoad() {
	asm volatile(CALL_OSCALL(8, 0x860):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysLibRemove() {
	asm volatile(CALL_OSCALL(8, 0x864):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysLibFindV40() {
	asm volatile(CALL_OSCALL(8, 0x868):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysLibInstallV40() {
	asm volatile(CALL_OSCALL(8, 0x86C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysLibLoadV40() {
	asm volatile(CALL_OSCALL(8, 0x870):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysLibRemoveV40() {
	asm volatile(CALL_OSCALL(8, 0x874):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysLibTblEntry() {
	asm volatile(CALL_OSCALL(8, 0x878):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysLinkerStub() {
	asm volatile(CALL_OSCALL(8, 0x87C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysLoadModule() {
	asm volatile(CALL_OSCALL(8, 0x880):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysNewOwnerID() {
	asm volatile(CALL_OSCALL(8, 0x884):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysNotifyBroadcast() {
	asm volatile(CALL_OSCALL(8, 0x888):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysNotifyBroadcastDeferred() {
	asm volatile(CALL_OSCALL(8, 0x88C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysNotifyDatabaseAdded() {
	asm volatile(CALL_OSCALL(8, 0x890):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysNotifyDatabaseRemoved() {
	asm volatile(CALL_OSCALL(8, 0x894):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysNotifyInit() {
	asm volatile(CALL_OSCALL(8, 0x898):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysNotifyRegister() {
	asm volatile(CALL_OSCALL(8, 0x89C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysNotifyRegisterV40() {
	asm volatile(CALL_OSCALL(8, 0x8A0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysNotifyUnregister() {
	asm volatile(CALL_OSCALL(8, 0x8A4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysNotifyUnregisterV40() {
	asm volatile(CALL_OSCALL(8, 0x8A8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysNotifyBroadcastFromInterrupt() {
	asm volatile(CALL_OSCALL(8, 0x8AC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysPatchEntry() {
	asm volatile(CALL_OSCALL(8, 0x8B0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysQSort() {
	asm volatile(CALL_OSCALL(8, 0x8B4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysRandom() {
	asm volatile(CALL_OSCALL(8, 0x8B8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysReset() {
	asm volatile(CALL_OSCALL(8, 0x8BC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysRestoreStatus() {
	asm volatile(CALL_OSCALL(8, 0x8C0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysSetA5() {
	asm volatile(CALL_OSCALL(8, 0x8C4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysSetAutoOffTime() {
	asm volatile(CALL_OSCALL(8, 0x8C8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysSetDbgLockout() {
	asm volatile(CALL_OSCALL(8, 0x8CC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysSetDevAutoLockTime() {
	asm volatile(CALL_OSCALL(8, 0x8D0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysSetPwdTimeout() {
	asm volatile(CALL_OSCALL(8, 0x8D4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysSleep() {
	asm volatile(CALL_OSCALL(8, 0x8D8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysSleepV40() {
	asm volatile(CALL_OSCALL(8, 0x8DC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysStringByIndex() {
	asm volatile(CALL_OSCALL(8, 0x8E0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysTaskCreate() {
	asm volatile(CALL_OSCALL(8, 0x8E4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysTaskDelay() {
	asm volatile(CALL_OSCALL(8, 0x8E8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysTaskDelayV40() {
	asm volatile(CALL_OSCALL(8, 0x8EC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysTaskDelete() {
	asm volatile(CALL_OSCALL(8, 0x8F0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysTicksPerSecond() {
	asm volatile(CALL_OSCALL(8, 0x8F4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysUIAppSwitch() {
	asm volatile(CALL_OSCALL(8, 0x8F8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysUIAppSwitchV40() {
	asm volatile(CALL_OSCALL(8, 0x8FC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysUIBusy() {
	asm volatile(CALL_OSCALL(8, 0x900):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysUILaunch() {
	asm volatile(CALL_OSCALL(8, 0x904):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysUnloadModule() {
	asm volatile(CALL_OSCALL(8, 0x908):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) SysWantEvent() {
	asm volatile(CALL_OSCALL(8, 0x910):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TimAdjust() {
	asm volatile(CALL_OSCALL(8, 0x914):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TimDateTimeToSeconds() {
	asm volatile(CALL_OSCALL(8, 0x918):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TimeToAscii() {
	asm volatile(CALL_OSCALL(8, 0x91C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TimGetAlarm() {
	asm volatile(CALL_OSCALL(8, 0x920):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TimGetSeconds() {
	asm volatile(CALL_OSCALL(8, 0x924):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TimGetTicks() {
	asm volatile(CALL_OSCALL(8, 0x928):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TimSecondsToDateTime() {
	asm volatile(CALL_OSCALL(8, 0x92C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TimSetAlarm() {
	asm volatile(CALL_OSCALL(8, 0x930):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TimSetSeconds() {
	asm volatile(CALL_OSCALL(8, 0x934):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TimTimeZoneToUTC() {
	asm volatile(CALL_OSCALL(8, 0x938):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TimUTCToTimeZone() {
	asm volatile(CALL_OSCALL(8, 0x93C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TlsSetSystemData() {
	asm volatile(CALL_OSCALL(8, 0x940):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TsmDrawMode() {
	asm volatile(CALL_OSCALL(8, 0x944):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TsmFepCommitAction() {
	asm volatile(CALL_OSCALL(8, 0x948):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TsmFepHandleEvent() {
	asm volatile(CALL_OSCALL(8, 0x94C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TsmFepMapEvent() {
	asm volatile(CALL_OSCALL(8, 0x950):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TsmFepReset() {
	asm volatile(CALL_OSCALL(8, 0x954):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TsmFepTerminate() {
	asm volatile(CALL_OSCALL(8, 0x958):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TsmGetCurrentFepCreator() {
	asm volatile(CALL_OSCALL(8, 0x95C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TsmGetFepMode() {
	asm volatile(CALL_OSCALL(8, 0x960):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TsmGetSystemFepCreator() {
	asm volatile(CALL_OSCALL(8, 0x964):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TsmHandleEvent() {
	asm volatile(CALL_OSCALL(8, 0x968):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TsmInit() {
	asm volatile(CALL_OSCALL(8, 0x96C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TsmSetCurrentFepCreator() {
	asm volatile(CALL_OSCALL(8, 0x970):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TsmSetFepMode() {
	asm volatile(CALL_OSCALL(8, 0x974):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TsmSetSystemFepCreator() {
	asm volatile(CALL_OSCALL(8, 0x978):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtByteAttr() {
	asm volatile(CALL_OSCALL(8, 0x97C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtCaselessCompare() {
	asm volatile(CALL_OSCALL(8, 0x980):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtCharAttr() {
	asm volatile(CALL_OSCALL(8, 0x984):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtCharEncoding() {
	asm volatile(CALL_OSCALL(8, 0x988):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtCharIsValid() {
	asm volatile(CALL_OSCALL(8, 0x98C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtCharWidth() {
	asm volatile(CALL_OSCALL(8, 0x990):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtCharXAttr() {
	asm volatile(CALL_OSCALL(8, 0x994):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtCharBounds() {
	asm volatile(CALL_OSCALL(8, 0x998):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtCharSize() {
	asm volatile(CALL_OSCALL(8, 0x99C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtCompare() {
	asm volatile(CALL_OSCALL(8, 0x9A0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtConvertEncoding() {
	asm volatile(CALL_OSCALL(8, 0x9A4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtEncodingName() {
	asm volatile(CALL_OSCALL(8, 0x9A8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtFindString() {
	asm volatile(CALL_OSCALL(8, 0x9AC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtGetChar() {
	asm volatile(CALL_OSCALL(8, 0x9B0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtGetNextChar() {
	asm volatile(CALL_OSCALL(8, 0x9B4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtGetPreviousChar() {
	asm volatile(CALL_OSCALL(8, 0x9B8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtGetTruncationOffset() {
	asm volatile(CALL_OSCALL(8, 0x9BC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtGetWordWrapOffset() {
	asm volatile(CALL_OSCALL(8, 0x9C0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtMaxEncoding() {
	asm volatile(CALL_OSCALL(8, 0x9C4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtNameToEncoding() {
	asm volatile(CALL_OSCALL(8, 0x9C8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtParamString() {
	asm volatile(CALL_OSCALL(8, 0x9CC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtPrepFindString() {
	asm volatile(CALL_OSCALL(8, 0x9D0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtReplaceStr() {
	asm volatile(CALL_OSCALL(8, 0x9D4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtSetNextChar() {
	asm volatile(CALL_OSCALL(8, 0x9D8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtStrEncoding() {
	asm volatile(CALL_OSCALL(8, 0x9DC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtTransliterate() {
	asm volatile(CALL_OSCALL(8, 0x9E0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TxtWordBounds() {
	asm volatile(CALL_OSCALL(8, 0x9E4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAControl() {
	asm volatile(CALL_OSCALL(8, 0x9E8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAExchangeReaderNew() {
	asm volatile(CALL_OSCALL(8, 0x9EC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAExchangeWriterNew() {
	asm volatile(CALL_OSCALL(8, 0x9F0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAMemoryReaderNew() {
	asm volatile(CALL_OSCALL(8, 0x9F4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAFoldFilterNew() {
	asm volatile(CALL_OSCALL(8, 0x9F8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAUnfoldFilterNew() {
	asm volatile(CALL_OSCALL(8, 0x9FC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAQPEncoderFilterNew() {
	asm volatile(CALL_OSCALL(8, 0xA00):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAQPDecoderFilterNew() {
	asm volatile(CALL_OSCALL(8, 0xA04):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAB64DecoderFilterNew() {
	asm volatile(CALL_OSCALL(8, 0xA08):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAB64EncoderFilterNew() {
	asm volatile(CALL_OSCALL(8, 0xA0C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAEscapeFilterNew() {
	asm volatile(CALL_OSCALL(8, 0xA10):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAUnEscapeFilterNew() {
	asm volatile(CALL_OSCALL(8, 0xA14):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAPartFilterNew() {
	asm volatile(CALL_OSCALL(8, 0xA18):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAMemoryReaderNewTo68K() {
	asm volatile(CALL_OSCALL(8, 0xA1C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAExchangeReaderNewTo68K() {
	asm volatile(CALL_OSCALL(8, 0xA20):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAExchangeWriterNewTo68K() {
	asm volatile(CALL_OSCALL(8, 0xA24):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAReaderToARM() {
	asm volatile(CALL_OSCALL(8, 0xA28):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAReaderTo68K() {
	asm volatile(CALL_OSCALL(8, 0xA2C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAWriterToARM() {
	asm volatile(CALL_OSCALL(8, 0xA30):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UDAWriterTo68K() {
	asm volatile(CALL_OSCALL(8, 0xA34):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSCustomControl() {
	asm volatile(CALL_OSCALL(8, 0xA38):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSDirCreate() {
	asm volatile(CALL_OSCALL(8, 0xA3C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSDirEntryEnumerate() {
	asm volatile(CALL_OSCALL(8, 0xA40):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSExportDatabaseToFile() {
	asm volatile(CALL_OSCALL(8, 0xA44):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSExportDatabaseToFileV40() {
	asm volatile(CALL_OSCALL(8, 0xA48):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSExportDatabaseToFileCustom() {
	asm volatile(CALL_OSCALL(8, 0xA4C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSExportDatabaseToFileCustomV40() {
	asm volatile(CALL_OSCALL(8, 0xA50):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileClose() {
	asm volatile(CALL_OSCALL(8, 0xA54):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileCreate() {
	asm volatile(CALL_OSCALL(8, 0xA58):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileDBGetRecord() {
	asm volatile(CALL_OSCALL(8, 0xA5C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileDBGetResource() {
	asm volatile(CALL_OSCALL(8, 0xA60):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileDBInfo() {
	asm volatile(CALL_OSCALL(8, 0xA64):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileDelete() {
	asm volatile(CALL_OSCALL(8, 0xA68):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileEOF() {
	asm volatile(CALL_OSCALL(8, 0xA6C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileGetAttributes() {
	asm volatile(CALL_OSCALL(8, 0xA70):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileGetDate() {
	asm volatile(CALL_OSCALL(8, 0xA74):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileOpen() {
	asm volatile(CALL_OSCALL(8, 0xA78):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileRead() {
	asm volatile(CALL_OSCALL(8, 0xA7C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileReadData() {
	asm volatile(CALL_OSCALL(8, 0xA80):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileRename() {
	asm volatile(CALL_OSCALL(8, 0xA84):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileResize() {
	asm volatile(CALL_OSCALL(8, 0xA88):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileSeek() {
	asm volatile(CALL_OSCALL(8, 0xA8C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileSetAttributes() {
	asm volatile(CALL_OSCALL(8, 0xA90):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileSetDate() {
	asm volatile(CALL_OSCALL(8, 0xA94):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileSize() {
	asm volatile(CALL_OSCALL(8, 0xA98):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileTell() {
	asm volatile(CALL_OSCALL(8, 0xA9C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSFileWrite() {
	asm volatile(CALL_OSCALL(8, 0xAA0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSGetDefaultDirectory() {
	asm volatile(CALL_OSCALL(8, 0xAA4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSImportDatabaseFromFile() {
	asm volatile(CALL_OSCALL(8, 0xAA8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSImportDatabaseFromFileV40() {
	asm volatile(CALL_OSCALL(8, 0xAAC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSImportDatabaseFromFileCustom() {
	asm volatile(CALL_OSCALL(8, 0xAB0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSImportDatabaseFromFileCustomV40() {
	asm volatile(CALL_OSCALL(8, 0xAB4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSInit() {
	asm volatile(CALL_OSCALL(8, 0xAB8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSInstallFSLib() {
	asm volatile(CALL_OSCALL(8, 0xABC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSRegisterDefaultDirectory() {
	asm volatile(CALL_OSCALL(8, 0xAC0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSRemoveFSLib() {
	asm volatile(CALL_OSCALL(8, 0xAC4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSUnregisterDefaultDirectory() {
	asm volatile(CALL_OSCALL(8, 0xAC8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSVolumeEnumerate() {
	asm volatile(CALL_OSCALL(8, 0xACC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSVolumeFormat() {
	asm volatile(CALL_OSCALL(8, 0xAD0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSVolumeGetLabel() {
	asm volatile(CALL_OSCALL(8, 0xAD4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSVolumeInfo() {
	asm volatile(CALL_OSCALL(8, 0xAD8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSVolumeMount() {
	asm volatile(CALL_OSCALL(8, 0xADC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSVolumeSetLabel() {
	asm volatile(CALL_OSCALL(8, 0xAE0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSVolumeSize() {
	asm volatile(CALL_OSCALL(8, 0xAE4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSVolumeUnmount() {
	asm volatile(CALL_OSCALL(8, 0xAE8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinAddWindow() {
	asm volatile(CALL_OSCALL(8, 0xAEC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinClipRectangle() {
	asm volatile(CALL_OSCALL(8, 0xAF0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinCopyRectangle() {
	asm volatile(CALL_OSCALL(8, 0xAF4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinCreateBitmapWindow() {
	asm volatile(CALL_OSCALL(8, 0xAF8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinCreateOffscreenWindow() {
	asm volatile(CALL_OSCALL(8, 0xAFC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinCreateWindow() {
	asm volatile(CALL_OSCALL(8, 0xB00):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinDeleteWindow() {
	asm volatile(CALL_OSCALL(8, 0xB04):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinDisableWindow() {
	asm volatile(CALL_OSCALL(8, 0xB08):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinDisplayToWindowPt() {
	asm volatile(CALL_OSCALL(8, 0xB0C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinDrawBitmap() {
	asm volatile(CALL_OSCALL(8, 0xB10):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinDrawChar() {
	asm volatile(CALL_OSCALL(8, 0xB14):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinDrawChars() {
	asm volatile(CALL_OSCALL(8, 0xB18):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinDrawGrayLine() {
	asm volatile(CALL_OSCALL(8, 0xB1C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinDrawGrayRectangleFrame() {
	asm volatile(CALL_OSCALL(8, 0xB20):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinDrawInvertedChars() {
	asm volatile(CALL_OSCALL(8, 0xB24):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinDrawLine() {
	asm volatile(CALL_OSCALL(8, 0xB28):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinDrawPixel() {
	asm volatile(CALL_OSCALL(8, 0xB2C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinDrawRectangle() {
	asm volatile(CALL_OSCALL(8, 0xB30):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinDrawRectangleFrame() {
	asm volatile(CALL_OSCALL(8, 0xB34):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinDrawTruncChars() {
	asm volatile(CALL_OSCALL(8, 0xB38):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinDrawWindowFrame() {
	asm volatile(CALL_OSCALL(8, 0xB3C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinEnableWindow() {
	asm volatile(CALL_OSCALL(8, 0xB40):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinEraseChars() {
	asm volatile(CALL_OSCALL(8, 0xB44):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinEraseLine() {
	asm volatile(CALL_OSCALL(8, 0xB48):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinErasePixel() {
	asm volatile(CALL_OSCALL(8, 0xB4C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinEraseRectangle() {
	asm volatile(CALL_OSCALL(8, 0xB50):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinEraseRectangleFrame() {
	asm volatile(CALL_OSCALL(8, 0xB54):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinEraseWindow() {
	asm volatile(CALL_OSCALL(8, 0xB58):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinFillLine() {
	asm volatile(CALL_OSCALL(8, 0xB5C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinFillRectangle() {
	asm volatile(CALL_OSCALL(8, 0xB60):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetActiveWindow() {
	asm volatile(CALL_OSCALL(8, 0xB64):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetBitmap() {
	asm volatile(CALL_OSCALL(8, 0xB68):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetClip() {
	asm volatile(CALL_OSCALL(8, 0xB6C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetDisplayExtent() {
	asm volatile(CALL_OSCALL(8, 0xB70):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetDisplayWindow() {
	asm volatile(CALL_OSCALL(8, 0xB74):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetDrawWindow() {
	asm volatile(CALL_OSCALL(8, 0xB78):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetDrawWindowBounds() {
	asm volatile(CALL_OSCALL(8, 0xB7C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetFirstWindow() {
	asm volatile(CALL_OSCALL(8, 0xB80):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetFramesRectangle() {
	asm volatile(CALL_OSCALL(8, 0xB84):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetPattern() {
	asm volatile(CALL_OSCALL(8, 0xB88):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetPatternType() {
	asm volatile(CALL_OSCALL(8, 0xB8C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetPixel() {
	asm volatile(CALL_OSCALL(8, 0xB90):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetPixelRGB() {
	asm volatile(CALL_OSCALL(8, 0xB94):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetBounds() {
	asm volatile(CALL_OSCALL(8, 0xB98):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetWindowExtent() {
	asm volatile(CALL_OSCALL(8, 0xB9C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetWindowFrameRect() {
	asm volatile(CALL_OSCALL(8, 0xBA0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinIndexToRGB() {
	asm volatile(CALL_OSCALL(8, 0xBA4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinInitializeWindow() {
	asm volatile(CALL_OSCALL(8, 0xBA8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinInvertChars() {
	asm volatile(CALL_OSCALL(8, 0xBAC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinInvertLine() {
	asm volatile(CALL_OSCALL(8, 0xBB0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinInvertPixel() {
	asm volatile(CALL_OSCALL(8, 0xBB4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinInvertRectangle() {
	asm volatile(CALL_OSCALL(8, 0xBB8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinInvertRectangleFrame() {
	asm volatile(CALL_OSCALL(8, 0xBBC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinModal() {
	asm volatile(CALL_OSCALL(8, 0xBC0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinMoveWindowAddr() {
	asm volatile(CALL_OSCALL(8, 0xBC4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPaintBitmap() {
	asm volatile(CALL_OSCALL(8, 0xBC8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPaintChar() {
	asm volatile(CALL_OSCALL(8, 0xBCC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPaintChars() {
	asm volatile(CALL_OSCALL(8, 0xBD0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPaintLine() {
	asm volatile(CALL_OSCALL(8, 0xBD4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPaintLines() {
	asm volatile(CALL_OSCALL(8, 0xBD8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPaintPixel() {
	asm volatile(CALL_OSCALL(8, 0xBDC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPaintPixels() {
	asm volatile(CALL_OSCALL(8, 0xBE0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPaintRectangle() {
	asm volatile(CALL_OSCALL(8, 0xBE4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPaintRectangleFrame() {
	asm volatile(CALL_OSCALL(8, 0xBE8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPalette() {
	asm volatile(CALL_OSCALL(8, 0xBEC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPopDrawState() {
	asm volatile(CALL_OSCALL(8, 0xBF0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPushDrawState() {
	asm volatile(CALL_OSCALL(8, 0xBF4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinRemoveWindow() {
	asm volatile(CALL_OSCALL(8, 0xBF8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinResetClip() {
	asm volatile(CALL_OSCALL(8, 0xBFC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinRestoreBits() {
	asm volatile(CALL_OSCALL(8, 0xC00):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinRGBToIndex() {
	asm volatile(CALL_OSCALL(8, 0xC04):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSaveBits() {
	asm volatile(CALL_OSCALL(8, 0xC08):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinScreenInit() {
	asm volatile(CALL_OSCALL(8, 0xC0C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinScreenLock() {
	asm volatile(CALL_OSCALL(8, 0xC10):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinScreenMode() {
	asm volatile(CALL_OSCALL(8, 0xC14):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinScreenUnlock() {
	asm volatile(CALL_OSCALL(8, 0xC18):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinScrollRectangle() {
	asm volatile(CALL_OSCALL(8, 0xC1C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetActiveWindow() {
	asm volatile(CALL_OSCALL(8, 0xC20):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetBackColor() {
	asm volatile(CALL_OSCALL(8, 0xC24):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetBackColorRGB() {
	asm volatile(CALL_OSCALL(8, 0xC28):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetClip() {
	asm volatile(CALL_OSCALL(8, 0xC2C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetColors() {
	asm volatile(CALL_OSCALL(8, 0xC30):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetDrawMode() {
	asm volatile(CALL_OSCALL(8, 0xC34):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetDrawWindow() {
	asm volatile(CALL_OSCALL(8, 0xC38):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetForeColor() {
	asm volatile(CALL_OSCALL(8, 0xC3C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetForeColorRGB() {
	asm volatile(CALL_OSCALL(8, 0xC40):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetPattern() {
	asm volatile(CALL_OSCALL(8, 0xC44):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetPatternType() {
	asm volatile(CALL_OSCALL(8, 0xC48):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetTextColor() {
	asm volatile(CALL_OSCALL(8, 0xC4C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetTextColorRGB() {
	asm volatile(CALL_OSCALL(8, 0xC50):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetUnderlineMode() {
	asm volatile(CALL_OSCALL(8, 0xC54):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetBounds() {
	asm volatile(CALL_OSCALL(8, 0xC58):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinValidateHandle() {
	asm volatile(CALL_OSCALL(8, 0xC5C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinWindowToDisplayPt() {
	asm volatile(CALL_OSCALL(8, 0xC60):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) IntlSetStrictChecks() {
	asm volatile(CALL_OSCALL(8, 0xC64):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpCreateBitmapV3() {
	asm volatile(CALL_OSCALL(8, 0xC68):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpGetCompressionType() {
	asm volatile(CALL_OSCALL(8, 0xC6C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpGetDensity() {
	asm volatile(CALL_OSCALL(8, 0xC70):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpGetNextBitmapAnyDensity() {
	asm volatile(CALL_OSCALL(8, 0xC74):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpGetTransparentValue() {
	asm volatile(CALL_OSCALL(8, 0xC78):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpGetVersion() {
	asm volatile(CALL_OSCALL(8, 0xC7C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpSetDensity() {
	asm volatile(CALL_OSCALL(8, 0xC80):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpSetTransparentValue() {
	asm volatile(CALL_OSCALL(8, 0xC84):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) EvtGetPenNative() {
	asm volatile(CALL_OSCALL(8, 0xC88):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetCoordinateSystem() {
	asm volatile(CALL_OSCALL(8, 0xC8C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetSupportedDensity() {
	asm volatile(CALL_OSCALL(8, 0xC90):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPaintTiledBitmap() {
	asm volatile(CALL_OSCALL(8, 0xC94):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetCoordinateSystem() {
	asm volatile(CALL_OSCALL(8, 0xC98):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinScalePoint() {
	asm volatile(CALL_OSCALL(8, 0xC9C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinScaleRectangle() {
	asm volatile(CALL_OSCALL(8, 0xCA0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinScreenGetAttribute() {
	asm volatile(CALL_OSCALL(8, 0xCA4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinUnscalePoint() {
	asm volatile(CALL_OSCALL(8, 0xCA8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinUnscaleRectangle() {
	asm volatile(CALL_OSCALL(8, 0xCAC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysSleepWakeNotificationCallback() {
	asm volatile(CALL_OSCALL(8, 0xCB0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinScaleCoord() {
	asm volatile(CALL_OSCALL(8, 0xCB4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinUnscaleCoord() {
	asm volatile(CALL_OSCALL(8, 0xCB8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPaintRoundedRectangleFrame() {
	asm volatile(CALL_OSCALL(8, 0xCBC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndPlaySmfIrregardless() {
	asm volatile(CALL_OSCALL(8, 0xCC0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndPlaySmfResourceIrregardless() {
	asm volatile(CALL_OSCALL(8, 0xCC4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndInterruptSmfIrregardless() {
	asm volatile(CALL_OSCALL(8, 0xCC8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) Crc16CalcBigBlock() {
	asm volatile(CALL_OSCALL(8, 0xCCC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SlotMediaType() {
	asm volatile(CALL_OSCALL(8, 0xCD0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) IntlInit() {
	asm volatile(CALL_OSCALL(8, 0xCD4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) IntlHandleEvent() {
	asm volatile(CALL_OSCALL(8, 0xCD8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) IntlGetRoutineAddress() {
	asm volatile(CALL_OSCALL(8, 0xCDC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) OmGetRoutineAddress() {
	asm volatile(CALL_OSCALL(8, 0xCE0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) OmInit() {
	asm volatile(CALL_OSCALL(8, 0xCE4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) OmOpenOverlayDatabase() {
	asm volatile(CALL_OSCALL(8, 0xCE8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PenRestoreSavedCalibration() {
	asm volatile(CALL_OSCALL(8, 0xCEC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ScrCompressRLE() {
	asm volatile(CALL_OSCALL(8, 0xCF0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ScrDecompressRLE() {
	asm volatile(CALL_OSCALL(8, 0xCF4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ScrCompressPackBits() {
	asm volatile(CALL_OSCALL(8, 0xCF8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ScrCompressPackBits16() {
	asm volatile(CALL_OSCALL(8, 0xCFC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ScrDecompressPackBits() {
	asm volatile(CALL_OSCALL(8, 0xD00):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ScrDecompressPackBits16() {
	asm volatile(CALL_OSCALL(8, 0xD04):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) VFSPrvCleanupFiles() {
	asm volatile(CALL_OSCALL(8, 0xD08):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndStreamCreate() {
	asm volatile(CALL_OSCALL(8, 0xD0C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndStreamDelete() {
	asm volatile(CALL_OSCALL(8, 0xD10):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndStreamStart() {
	asm volatile(CALL_OSCALL(8, 0xD14):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndStreamPause() {
	asm volatile(CALL_OSCALL(8, 0xD18):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndStreamStop() {
	asm volatile(CALL_OSCALL(8, 0xD1C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndStreamSetVolume() {
	asm volatile(CALL_OSCALL(8, 0xD20):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndStreamGetVolume() {
	asm volatile(CALL_OSCALL(8, 0xD24):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndStreamSetPan() {
	asm volatile(CALL_OSCALL(8, 0xD28):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndStreamGetPan() {
	asm volatile(CALL_OSCALL(8, 0xD2C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndPlayResource() {
	asm volatile(CALL_OSCALL(8, 0xD30):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPrvInitCanvas() {
	asm volatile(CALL_OSCALL(8, 0xD34):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPrvInitCanvasWithBitmap() {
	asm volatile(CALL_OSCALL(8, 0xD38):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinPrvInitDrawState() {
	asm volatile(CALL_OSCALL(8, 0xD3C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpPrvConvertBitmap() {
	asm volatile(CALL_OSCALL(8, 0xD40):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpGetPixelFormat() {
	asm volatile(CALL_OSCALL(8, 0xD44):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) BmpCreateVersion3() {
	asm volatile(CALL_OSCALL(8, 0xD48):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetBitmapDimensions() {
	asm volatile(CALL_OSCALL(8, 0xD4C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndStreamCreateExtended() {
	asm volatile(CALL_OSCALL(8, 0xD50):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SndStreamDeviceControl() {
	asm volatile(CALL_OSCALL(8, 0xD54):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinSetScalingMode() {
	asm volatile(CALL_OSCALL(8, 0xD58):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) WinGetScalingMode() {
	asm volatile(CALL_OSCALL(8, 0xD5C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}

void __attribute__((naked)) DmSync() {
	asm volatile(CALL_OSCALL(8, 0xE3C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DmSyncDatabase() {
	asm volatile(CALL_OSCALL(8, 0xE40):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AbtShowAbout() {
	asm volatile(CALL_OSCALL(12, 0x0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnAllowClose() {
	asm volatile(CALL_OSCALL(12, 0x4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnDoEmergencySpecialEffects() {
	asm volatile(CALL_OSCALL(12, 0x8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnDoSpecialEffects() {
	asm volatile(CALL_OSCALL(12, 0xC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnEffectOfEvent() {
	asm volatile(CALL_OSCALL(12, 0x10):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnEnableNotification() {
	asm volatile(CALL_OSCALL(12, 0x14):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnForgetIt() {
	asm volatile(CALL_OSCALL(12, 0x18):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnGetAttention() {
	asm volatile(CALL_OSCALL(12, 0x1C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnGetCounts() {
	asm volatile(CALL_OSCALL(12, 0x20):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnHandleEvent() {
	asm volatile(CALL_OSCALL(12, 0x24):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnIterate() {
	asm volatile(CALL_OSCALL(12, 0x28):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnListOpen() {
	asm volatile(CALL_OSCALL(12, 0x2C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnIndicatorAllow() {
	asm volatile(CALL_OSCALL(12, 0x30):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnIndicatorAllowed() {
	asm volatile(CALL_OSCALL(12, 0x34):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnIndicatorCheckBlink() {
	asm volatile(CALL_OSCALL(12, 0x38):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnIndicatorEnable() {
	asm volatile(CALL_OSCALL(12, 0x3C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnIndicatorEnabled() {
	asm volatile(CALL_OSCALL(12, 0x40):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnIndicatorGetBlinkPattern() {
	asm volatile(CALL_OSCALL(12, 0x44):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnIndicatorSetBlinkPattern() {
	asm volatile(CALL_OSCALL(12, 0x48):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnIndicatorTicksTillNextBlink() {
	asm volatile(CALL_OSCALL(12, 0x4C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnReopen() {
	asm volatile(CALL_OSCALL(12, 0x50):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnUpdate() {
	asm volatile(CALL_OSCALL(12, 0x54):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CategoryCreateList() {
	asm volatile(CALL_OSCALL(12, 0x58):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CategoryCreateListV10() {
	asm volatile(CALL_OSCALL(12, 0x5C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CategoryEdit() {
	asm volatile(CALL_OSCALL(12, 0x60):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CategoryEditV10() {
	asm volatile(CALL_OSCALL(12, 0x64):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CategoryEditV20() {
	asm volatile(CALL_OSCALL(12, 0x68):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CategoryFind() {
	asm volatile(CALL_OSCALL(12, 0x6C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CategoryFreeList() {
	asm volatile(CALL_OSCALL(12, 0x70):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CategoryFreeListV10() {
	asm volatile(CALL_OSCALL(12, 0x74):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CategoryGetName() {
	asm volatile(CALL_OSCALL(12, 0x78):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CategoryGetNext() {
	asm volatile(CALL_OSCALL(12, 0x7C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CategoryInitialize() {
	asm volatile(CALL_OSCALL(12, 0x80):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CategorySelect() {
	asm volatile(CALL_OSCALL(12, 0x84):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CategorySelectV10() {
	asm volatile(CALL_OSCALL(12, 0x88):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CategorySetName() {
	asm volatile(CALL_OSCALL(12, 0x8C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CategorySetTriggerLabel() {
	asm volatile(CALL_OSCALL(12, 0x90):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CategoryTruncateName() {
	asm volatile(CALL_OSCALL(12, 0x94):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ClipboardAddItem() {
	asm volatile(CALL_OSCALL(12, 0x98):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ClipboardAppendItem() {
	asm volatile(CALL_OSCALL(12, 0x9C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ClipboardGetItem() {
	asm volatile(CALL_OSCALL(12, 0xA0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlDrawControl() {
	asm volatile(CALL_OSCALL(12, 0xA4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlEnabled() {
	asm volatile(CALL_OSCALL(12, 0xA8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlEraseControl() {
	asm volatile(CALL_OSCALL(12, 0xAC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlGetLabel() {
	asm volatile(CALL_OSCALL(12, 0xB0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlGetSliderValues() {
	asm volatile(CALL_OSCALL(12, 0xB4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlGetValue() {
	asm volatile(CALL_OSCALL(12, 0xB8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlHandleEvent() {
	asm volatile(CALL_OSCALL(12, 0xBC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlHideControl() {
	asm volatile(CALL_OSCALL(12, 0xC0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlHitControl() {
	asm volatile(CALL_OSCALL(12, 0xC4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlNewControl() {
	asm volatile(CALL_OSCALL(12, 0xC8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlNewGraphicControl() {
	asm volatile(CALL_OSCALL(12, 0xCC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlNewSliderControl() {
	asm volatile(CALL_OSCALL(12, 0xD0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlSetEnabled() {
	asm volatile(CALL_OSCALL(12, 0xD4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlSetGraphics() {
	asm volatile(CALL_OSCALL(12, 0xD8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlSetLabel() {
	asm volatile(CALL_OSCALL(12, 0xDC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlSetSliderValues() {
	asm volatile(CALL_OSCALL(12, 0xE0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlSetUsable() {
	asm volatile(CALL_OSCALL(12, 0xE4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlSetValue() {
	asm volatile(CALL_OSCALL(12, 0xE8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlShowControl() {
	asm volatile(CALL_OSCALL(12, 0xEC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) CtlValidatePointer() {
	asm volatile(CALL_OSCALL(12, 0xF0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DayDrawDays() {
	asm volatile(CALL_OSCALL(12, 0xF4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DayDrawDaySelector() {
	asm volatile(CALL_OSCALL(12, 0xF8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) DayHandleEvent() {
	asm volatile(CALL_OSCALL(12, 0xFC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) Find() {
	asm volatile(CALL_OSCALL(12, 0x100):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FindDrawHeader() {
	asm volatile(CALL_OSCALL(12, 0x104):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FindGetLineBounds() {
	asm volatile(CALL_OSCALL(12, 0x108):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FindSaveMatch() {
	asm volatile(CALL_OSCALL(12, 0x10C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FindStrInStr() {
	asm volatile(CALL_OSCALL(12, 0x110):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldCalcFieldHeight() {
	asm volatile(CALL_OSCALL(12, 0x114):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldCompactText() {
	asm volatile(CALL_OSCALL(12, 0x118):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldCopy() {
	asm volatile(CALL_OSCALL(12, 0x11C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldCut() {
	asm volatile(CALL_OSCALL(12, 0x120):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldDelete() {
	asm volatile(CALL_OSCALL(12, 0x124):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldDirty() {
	asm volatile(CALL_OSCALL(12, 0x128):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldDrawField() {
	asm volatile(CALL_OSCALL(12, 0x12C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldEraseField() {
	asm volatile(CALL_OSCALL(12, 0x130):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldFreeMemory() {
	asm volatile(CALL_OSCALL(12, 0x134):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldGetAttributes() {
	asm volatile(CALL_OSCALL(12, 0x138):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldGetBounds() {
	asm volatile(CALL_OSCALL(12, 0x13C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldGetFont() {
	asm volatile(CALL_OSCALL(12, 0x140):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldGetInsPtPosition() {
	asm volatile(CALL_OSCALL(12, 0x144):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldGetMaxChars() {
	asm volatile(CALL_OSCALL(12, 0x148):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldGetNumberOfBlankLines() {
	asm volatile(CALL_OSCALL(12, 0x14C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldGetScrollPosition() {
	asm volatile(CALL_OSCALL(12, 0x150):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldGetScrollValues() {
	asm volatile(CALL_OSCALL(12, 0x154):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldGetSelection() {
	asm volatile(CALL_OSCALL(12, 0x158):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldGetTextAllocatedSize() {
	asm volatile(CALL_OSCALL(12, 0x15C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldGetTextHandle() {
	asm volatile(CALL_OSCALL(12, 0x160):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldGetTextHeight() {
	asm volatile(CALL_OSCALL(12, 0x164):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldGetTextLength() {
	asm volatile(CALL_OSCALL(12, 0x168):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldGetTextPtr() {
	asm volatile(CALL_OSCALL(12, 0x16C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldGetVisibleLines() {
	asm volatile(CALL_OSCALL(12, 0x170):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldGrabFocus() {
	asm volatile(CALL_OSCALL(12, 0x174):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldHandleEvent() {
	asm volatile(CALL_OSCALL(12, 0x178):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldInsert() {
	asm volatile(CALL_OSCALL(12, 0x17C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldMakeFullyVisible() {
	asm volatile(CALL_OSCALL(12, 0x180):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldNewField() {
	asm volatile(CALL_OSCALL(12, 0x184):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldPaste() {
	asm volatile(CALL_OSCALL(12, 0x188):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldRecalculateField() {
	asm volatile(CALL_OSCALL(12, 0x18C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldReleaseFocus() {
	asm volatile(CALL_OSCALL(12, 0x190):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldScrollable() {
	asm volatile(CALL_OSCALL(12, 0x194):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldScrollField() {
	asm volatile(CALL_OSCALL(12, 0x198):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSendChangeNotification() {
	asm volatile(CALL_OSCALL(12, 0x19C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSendHeightChangeNotification() {
	asm volatile(CALL_OSCALL(12, 0x1A0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSetAttributes() {
	asm volatile(CALL_OSCALL(12, 0x1A4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSetBounds() {
	asm volatile(CALL_OSCALL(12, 0x1A8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSetDirty() {
	asm volatile(CALL_OSCALL(12, 0x1AC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSetFont() {
	asm volatile(CALL_OSCALL(12, 0x1B0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSetInsertionPoint() {
	asm volatile(CALL_OSCALL(12, 0x1B4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSetInsPtPosition() {
	asm volatile(CALL_OSCALL(12, 0x1B8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSetMaxChars() {
	asm volatile(CALL_OSCALL(12, 0x1BC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSetMaxVisibleLines() {
	asm volatile(CALL_OSCALL(12, 0x1C0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSetScrollPosition() {
	asm volatile(CALL_OSCALL(12, 0x1C4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSetSelection() {
	asm volatile(CALL_OSCALL(12, 0x1C8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSetText() {
	asm volatile(CALL_OSCALL(12, 0x1CC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSetTextAllocatedSize() {
	asm volatile(CALL_OSCALL(12, 0x1D0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSetTextHandle() {
	asm volatile(CALL_OSCALL(12, 0x1D4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSetTextPtr() {
	asm volatile(CALL_OSCALL(12, 0x1D8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldSetUsable() {
	asm volatile(CALL_OSCALL(12, 0x1DC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldUndo() {
	asm volatile(CALL_OSCALL(12, 0x1E0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FldWordWrap() {
	asm volatile(CALL_OSCALL(12, 0x1E4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FontSelect() {
	asm volatile(CALL_OSCALL(12, 0x1E8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmActiveState() {
	asm volatile(CALL_OSCALL(12, 0x1EC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmAddSpaceForObject() {
	asm volatile(CALL_OSCALL(12, 0x1F0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmAlert() {
	asm volatile(CALL_OSCALL(12, 0x1F4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmCloseAllForms() {
	asm volatile(CALL_OSCALL(12, 0x1F8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmCopyLabel() {
	asm volatile(CALL_OSCALL(12, 0x1FC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmCopyTitle() {
	asm volatile(CALL_OSCALL(12, 0x200):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmCustomAlert() {
	asm volatile(CALL_OSCALL(12, 0x204):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmCustomResponseAlert() {
	asm volatile(CALL_OSCALL(12, 0x208):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmDeleteForm() {
	asm volatile(CALL_OSCALL(12, 0x20C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmDispatchEvent() {
	asm volatile(CALL_OSCALL(12, 0x210):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmDoDialog() {
	asm volatile(CALL_OSCALL(12, 0x214):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmDrawForm() {
	asm volatile(CALL_OSCALL(12, 0x218):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmEraseForm() {
	asm volatile(CALL_OSCALL(12, 0x21C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetActiveField() {
	asm volatile(CALL_OSCALL(12, 0x220):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetActiveForm() {
	asm volatile(CALL_OSCALL(12, 0x224):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetActiveFormID() {
	asm volatile(CALL_OSCALL(12, 0x228):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetControlGroupSelection() {
	asm volatile(CALL_OSCALL(12, 0x22C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetControlValue() {
	asm volatile(CALL_OSCALL(12, 0x230):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetFirstForm() {
	asm volatile(CALL_OSCALL(12, 0x234):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetFocus() {
	asm volatile(CALL_OSCALL(12, 0x238):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetFormBounds() {
	asm volatile(CALL_OSCALL(12, 0x23C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetFormId() {
	asm volatile(CALL_OSCALL(12, 0x240):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetFormPtr() {
	asm volatile(CALL_OSCALL(12, 0x244):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetGadgetData() {
	asm volatile(CALL_OSCALL(12, 0x248):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetLabel() {
	asm volatile(CALL_OSCALL(12, 0x24C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetNumberOfObjects() {
	asm volatile(CALL_OSCALL(12, 0x250):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetObjectBounds() {
	asm volatile(CALL_OSCALL(12, 0x254):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetObjectId() {
	asm volatile(CALL_OSCALL(12, 0x258):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetObjectIndex() {
	asm volatile(CALL_OSCALL(12, 0x25C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetObjectIndexFromPtr() {
	asm volatile(CALL_OSCALL(12, 0x260):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetObjectPosition() {
	asm volatile(CALL_OSCALL(12, 0x264):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetObjectPtr() {
	asm volatile(CALL_OSCALL(12, 0x268):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetObjectType() {
	asm volatile(CALL_OSCALL(12, 0x26C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetTitle() {
	asm volatile(CALL_OSCALL(12, 0x270):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetUserModifiedState() {
	asm volatile(CALL_OSCALL(12, 0x274):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGetWindowHandle() {
	asm volatile(CALL_OSCALL(12, 0x278):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmGotoForm() {
	asm volatile(CALL_OSCALL(12, 0x27C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmHandleEvent() {
	asm volatile(CALL_OSCALL(12, 0x280):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmHelp() {
	asm volatile(CALL_OSCALL(12, 0x284):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmHideObject() {
	asm volatile(CALL_OSCALL(12, 0x288):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmInitForm() {
	asm volatile(CALL_OSCALL(12, 0x28C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmNewBitmap() {
	asm volatile(CALL_OSCALL(12, 0x290):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmNewForm() {
	asm volatile(CALL_OSCALL(12, 0x294):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmNewGadget() {
	asm volatile(CALL_OSCALL(12, 0x298):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmNewGsi() {
	asm volatile(CALL_OSCALL(12, 0x29C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmNewLabel() {
	asm volatile(CALL_OSCALL(12, 0x2A0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmPointInTitle() {
	asm volatile(CALL_OSCALL(12, 0x2A4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmPopupForm() {
	asm volatile(CALL_OSCALL(12, 0x2A8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmRemoveObject() {
	asm volatile(CALL_OSCALL(12, 0x2AC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmReturnToForm() {
	asm volatile(CALL_OSCALL(12, 0x2B0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmSaveAllForms() {
	asm volatile(CALL_OSCALL(12, 0x2B4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmSetActiveForm() {
	asm volatile(CALL_OSCALL(12, 0x2B8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmSetCategoryLabel() {
	asm volatile(CALL_OSCALL(12, 0x2BC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmSetControlGroupSelection() {
	asm volatile(CALL_OSCALL(12, 0x2C0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmSetControlValue() {
	asm volatile(CALL_OSCALL(12, 0x2C4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmSetEventHandler() {
	asm volatile(CALL_OSCALL(12, 0x2C8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmSetFocus() {
	asm volatile(CALL_OSCALL(12, 0x2CC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmSetGadgetData() {
	asm volatile(CALL_OSCALL(12, 0x2D0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmSetGadgetHandler() {
	asm volatile(CALL_OSCALL(12, 0x2D4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmSetMenu() {
	asm volatile(CALL_OSCALL(12, 0x2D8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmSetNotUserModified() {
	asm volatile(CALL_OSCALL(12, 0x2DC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmSetObjectBounds() {
	asm volatile(CALL_OSCALL(12, 0x2E0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmSetObjectPosition() {
	asm volatile(CALL_OSCALL(12, 0x2E4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmSetTitle() {
	asm volatile(CALL_OSCALL(12, 0x2E8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmShowObject() {
	asm volatile(CALL_OSCALL(12, 0x2EC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmUpdateForm() {
	asm volatile(CALL_OSCALL(12, 0x2F0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmUpdateScrollers() {
	asm volatile(CALL_OSCALL(12, 0x2F4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmValidatePtr() {
	asm volatile(CALL_OSCALL(12, 0x2F8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) FrmVisible() {
	asm volatile(CALL_OSCALL(12, 0x2FC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) GsiEnable() {
	asm volatile(CALL_OSCALL(12, 0x300):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) GsiEnabled() {
	asm volatile(CALL_OSCALL(12, 0x304):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) GsiInitialize() {
	asm volatile(CALL_OSCALL(12, 0x308):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) GsiSetLocation() {
	asm volatile(CALL_OSCALL(12, 0x30C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) GsiSetShiftState() {
	asm volatile(CALL_OSCALL(12, 0x310):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) InsPtCheckBlink() {
	asm volatile(CALL_OSCALL(12, 0x314):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) InsPtEnable() {
	asm volatile(CALL_OSCALL(12, 0x318):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) InsPtEnabled() {
	asm volatile(CALL_OSCALL(12, 0x31C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) InsPtGetHeight() {
	asm volatile(CALL_OSCALL(12, 0x320):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) InsPtGetLocation() {
	asm volatile(CALL_OSCALL(12, 0x324):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) InsPtInitialize() {
	asm volatile(CALL_OSCALL(12, 0x328):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) InsPtSetHeight() {
	asm volatile(CALL_OSCALL(12, 0x32C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) InsPtSetLocation() {
	asm volatile(CALL_OSCALL(12, 0x330):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KbdDraw() {
	asm volatile(CALL_OSCALL(12, 0x334):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KbdErase() {
	asm volatile(CALL_OSCALL(12, 0x338):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KbdGetLayout() {
	asm volatile(CALL_OSCALL(12, 0x33C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KbdGetPosition() {
	asm volatile(CALL_OSCALL(12, 0x340):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KbdGetShiftState() {
	asm volatile(CALL_OSCALL(12, 0x344):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KbdHandleEvent() {
	asm volatile(CALL_OSCALL(12, 0x348):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KbdSetLayout() {
	asm volatile(CALL_OSCALL(12, 0x34C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KbdSetPosition() {
	asm volatile(CALL_OSCALL(12, 0x350):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KbdSetShiftState() {
	asm volatile(CALL_OSCALL(12, 0x354):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KeyboardStatusFree() {
	asm volatile(CALL_OSCALL(12, 0x358):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) KeyboardStatusNew() {
	asm volatile(CALL_OSCALL(12, 0x35C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstDrawList() {
	asm volatile(CALL_OSCALL(12, 0x360):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstEraseList() {
	asm volatile(CALL_OSCALL(12, 0x364):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstGetNumberOfItems() {
	asm volatile(CALL_OSCALL(12, 0x368):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstGetSelection() {
	asm volatile(CALL_OSCALL(12, 0x36C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstGetSelectionText() {
	asm volatile(CALL_OSCALL(12, 0x370):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstGetTopItem() {
	asm volatile(CALL_OSCALL(12, 0x374):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstGetVisibleItems() {
	asm volatile(CALL_OSCALL(12, 0x378):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstHandleEvent() {
	asm volatile(CALL_OSCALL(12, 0x37C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstMakeItemVisible() {
	asm volatile(CALL_OSCALL(12, 0x380):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstNewList() {
	asm volatile(CALL_OSCALL(12, 0x384):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstPopupList() {
	asm volatile(CALL_OSCALL(12, 0x388):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstScrollList() {
	asm volatile(CALL_OSCALL(12, 0x38C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstSetDrawFunction() {
	asm volatile(CALL_OSCALL(12, 0x390):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstSetHeight() {
	asm volatile(CALL_OSCALL(12, 0x394):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstSetListChoices() {
	asm volatile(CALL_OSCALL(12, 0x398):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstSetPosition() {
	asm volatile(CALL_OSCALL(12, 0x39C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstSetSelection() {
	asm volatile(CALL_OSCALL(12, 0x3A0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) LstSetTopItem() {
	asm volatile(CALL_OSCALL(12, 0x3A4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MenuAddItem() {
	asm volatile(CALL_OSCALL(12, 0x3A8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MenuCmdBarAddButton() {
	asm volatile(CALL_OSCALL(12, 0x3AC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MenuCmdBarDisplay() {
	asm volatile(CALL_OSCALL(12, 0x3B0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MenuCmdBarGetButtonData() {
	asm volatile(CALL_OSCALL(12, 0x3B4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MenuDispose() {
	asm volatile(CALL_OSCALL(12, 0x3B8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MenuDrawMenu() {
	asm volatile(CALL_OSCALL(12, 0x3BC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MenuEraseMenu() {
	asm volatile(CALL_OSCALL(12, 0x3C0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MenuEraseStatus() {
	asm volatile(CALL_OSCALL(12, 0x3C4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MenuGetActiveMenu() {
	asm volatile(CALL_OSCALL(12, 0x3C8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MenuHandleEvent() {
	asm volatile(CALL_OSCALL(12, 0x3CC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MenuHideItem() {
	asm volatile(CALL_OSCALL(12, 0x3D0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MenuInit() {
	asm volatile(CALL_OSCALL(12, 0x3D4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MenuSetActiveMenu() {
	asm volatile(CALL_OSCALL(12, 0x3D8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MenuSetActiveMenuRscID() {
	asm volatile(CALL_OSCALL(12, 0x3DC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) MenuShowItem() {
	asm volatile(CALL_OSCALL(12, 0x3E0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PhoneNumberLookup() {
	asm volatile(CALL_OSCALL(12, 0x3E4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PhoneNumberLookupCustom() {
	asm volatile(CALL_OSCALL(12, 0x3E8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrgHandleEvent() {
	asm volatile(CALL_OSCALL(12, 0x3EC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrgStartDialog() {
	asm volatile(CALL_OSCALL(12, 0x3F0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrgStartDialogV31() {
	asm volatile(CALL_OSCALL(12, 0x3F4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrgStopDialog() {
	asm volatile(CALL_OSCALL(12, 0x3F8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) PrgUpdateDialog() {
	asm volatile(CALL_OSCALL(12, 0x3FC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ResLoadConstant() {
	asm volatile(CALL_OSCALL(12, 0x400):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ResLoadForm() {
	asm volatile(CALL_OSCALL(12, 0x404):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) ResLoadMenu() {
	asm volatile(CALL_OSCALL(12, 0x408):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SclDrawScrollBar() {
	asm volatile(CALL_OSCALL(12, 0x40C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SclGetScrollBar() {
	asm volatile(CALL_OSCALL(12, 0x410):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SclHandleEvent() {
	asm volatile(CALL_OSCALL(12, 0x414):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SclSetScrollBar() {
	asm volatile(CALL_OSCALL(12, 0x418):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SecSelectViewStatus() {
	asm volatile(CALL_OSCALL(12, 0x41C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SecVerifyPW() {
	asm volatile(CALL_OSCALL(12, 0x420):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SelectDay() {
	asm volatile(CALL_OSCALL(12, 0x424):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SelectDayV10() {
	asm volatile(CALL_OSCALL(12, 0x428):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SelectOneTime() {
	asm volatile(CALL_OSCALL(12, 0x42C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SelectTime() {
	asm volatile(CALL_OSCALL(12, 0x430):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SelectTimeV33() {
	asm volatile(CALL_OSCALL(12, 0x434):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SelectTimeZone() {
	asm volatile(CALL_OSCALL(12, 0x438):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysAppLauncherDialog() {
	asm volatile(CALL_OSCALL(12, 0x43C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysBatteryDialog() {
	asm volatile(CALL_OSCALL(12, 0x440):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysFatalAlert() {
	asm volatile(CALL_OSCALL(12, 0x444):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysFatalAlertInit() {
	asm volatile(CALL_OSCALL(12, 0x448):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysKeyboardDialog() {
	asm volatile(CALL_OSCALL(12, 0x44C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) SysKeyboardDialogV10() {
	asm volatile(CALL_OSCALL(12, 0x450):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblDrawTable() {
	asm volatile(CALL_OSCALL(12, 0x454):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblEditing() {
	asm volatile(CALL_OSCALL(12, 0x458):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblEraseTable() {
	asm volatile(CALL_OSCALL(12, 0x45C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblFindRowData() {
	asm volatile(CALL_OSCALL(12, 0x460):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblFindRowID() {
	asm volatile(CALL_OSCALL(12, 0x464):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGetBounds() {
	asm volatile(CALL_OSCALL(12, 0x468):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGetColumnSpacing() {
	asm volatile(CALL_OSCALL(12, 0x46C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGetColumnWidth() {
	asm volatile(CALL_OSCALL(12, 0x470):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGetCurrentField() {
	asm volatile(CALL_OSCALL(12, 0x474):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGetItemBounds() {
	asm volatile(CALL_OSCALL(12, 0x478):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGetItemFont() {
	asm volatile(CALL_OSCALL(12, 0x47C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGetItemInt() {
	asm volatile(CALL_OSCALL(12, 0x480):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGetItemPtr() {
	asm volatile(CALL_OSCALL(12, 0x484):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGetLastUsableRow() {
	asm volatile(CALL_OSCALL(12, 0x488):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGetNumberOfRows() {
	asm volatile(CALL_OSCALL(12, 0x48C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGetNumberOfColumns() {
	asm volatile(CALL_OSCALL(12, 0x490):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGetRowData() {
	asm volatile(CALL_OSCALL(12, 0x494):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGetRowHeight() {
	asm volatile(CALL_OSCALL(12, 0x498):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGetRowID() {
	asm volatile(CALL_OSCALL(12, 0x49C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGetSelection() {
	asm volatile(CALL_OSCALL(12, 0x4A0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGetTopRow() {
	asm volatile(CALL_OSCALL(12, 0x4A4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblGrabFocus() {
	asm volatile(CALL_OSCALL(12, 0x4A8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblHandleEvent() {
	asm volatile(CALL_OSCALL(12, 0x4AC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblHasScrollBar() {
	asm volatile(CALL_OSCALL(12, 0x4B0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblInsertRow() {
	asm volatile(CALL_OSCALL(12, 0x4B4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblMarkRowInvalid() {
	asm volatile(CALL_OSCALL(12, 0x4B8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblMarkTableInvalid() {
	asm volatile(CALL_OSCALL(12, 0x4BC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblRedrawTable() {
	asm volatile(CALL_OSCALL(12, 0x4C0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblReleaseFocus() {
	asm volatile(CALL_OSCALL(12, 0x4C4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblRemoveRow() {
	asm volatile(CALL_OSCALL(12, 0x4C8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblRowInvalid() {
	asm volatile(CALL_OSCALL(12, 0x4CC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblRowMasked() {
	asm volatile(CALL_OSCALL(12, 0x4D0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblRowSelectable() {
	asm volatile(CALL_OSCALL(12, 0x4D4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblRowUsable() {
	asm volatile(CALL_OSCALL(12, 0x4D8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSelectItem() {
	asm volatile(CALL_OSCALL(12, 0x4DC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetBounds() {
	asm volatile(CALL_OSCALL(12, 0x4E0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetColumnEditIndicator() {
	asm volatile(CALL_OSCALL(12, 0x4E4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetColumnMasked() {
	asm volatile(CALL_OSCALL(12, 0x4E8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetColumnSpacing() {
	asm volatile(CALL_OSCALL(12, 0x4EC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetColumnUsable() {
	asm volatile(CALL_OSCALL(12, 0x4F0):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetColumnWidth() {
	asm volatile(CALL_OSCALL(12, 0x4F4):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetCustomDrawProcedure() {
	asm volatile(CALL_OSCALL(12, 0x4F8):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetItemFont() {
	asm volatile(CALL_OSCALL(12, 0x4FC):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetItemInt() {
	asm volatile(CALL_OSCALL(12, 0x500):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetItemPtr() {
	asm volatile(CALL_OSCALL(12, 0x504):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetItemStyle() {
	asm volatile(CALL_OSCALL(12, 0x508):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetLoadDataProcedure() {
	asm volatile(CALL_OSCALL(12, 0x50C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetRowData() {
	asm volatile(CALL_OSCALL(12, 0x510):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetRowHeight() {
	asm volatile(CALL_OSCALL(12, 0x514):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetRowID() {
	asm volatile(CALL_OSCALL(12, 0x518):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetRowMasked() {
	asm volatile(CALL_OSCALL(12, 0x51C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetRowSelectable() {
	asm volatile(CALL_OSCALL(12, 0x520):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetRowStaticHeight() {
	asm volatile(CALL_OSCALL(12, 0x524):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetRowUsable() {
	asm volatile(CALL_OSCALL(12, 0x528):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetSaveDataProcedure() {
	asm volatile(CALL_OSCALL(12, 0x52C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblSetSelection() {
	asm volatile(CALL_OSCALL(12, 0x530):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TblUnhighlightSelection() {
	asm volatile(CALL_OSCALL(12, 0x534):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) TimeZoneToAscii() {
	asm volatile(CALL_OSCALL(12, 0x538):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UIBrightnessAdjust() {
	asm volatile(CALL_OSCALL(12, 0x53C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UIColorGetTableEntryIndex() {
	asm volatile(CALL_OSCALL(12, 0x540):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UIColorGetTableEntryRGB() {
	asm volatile(CALL_OSCALL(12, 0x544):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UIColorInit() {
	asm volatile(CALL_OSCALL(12, 0x548):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UIColorPopTable() {
	asm volatile(CALL_OSCALL(12, 0x54C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UIColorPushTable() {
	asm volatile(CALL_OSCALL(12, 0x550):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UIColorSetTableEntry() {
	asm volatile(CALL_OSCALL(12, 0x554):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UIContrastAdjust() {
	asm volatile(CALL_OSCALL(12, 0x558):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UIInitialize() {
	asm volatile(CALL_OSCALL(12, 0x55C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UIPickColor() {
	asm volatile(CALL_OSCALL(12, 0x560):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UIGetGlobalsPtr() {
	asm volatile(CALL_OSCALL(12, 0x564):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) UIReset() {
	asm volatile(CALL_OSCALL(12, 0x568):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


void __attribute__((naked)) AttnInitialize() {
	asm volatile(CALL_OSCALL(12, 0x56C):::"r0","r1","r2","r3","r12","lr","cc","memory");
}


