#ifndef _SONY_MSIO_H_
#define _SONY_MSIO_H_

#define SONY_MSIO_API_CREATOR				'SoNy'

#define SONY_MSIO_API_VER_1					0x00000001	//seen in OS4 and OS5 Clie DEVICES


#define sonyMsioErrorClass					0x8000

#define sonyMsioErrBadSlotRef				(sonyMsioErrorClass | 1)
#define sonyMsioErrNoCardPresent			(sonyMsioErrorClass | 2)
#define sonyMsioErrSelectedFuncNotEnabled	(sonyMsioErrorClass | 4)	//you need to enable the function before doing what you did
#define sonyMsioErrFuncHasNoAttributes		(sonyMsioErrorClass | 5)	//card attribute length register reports zero
#define sonyMsioErrAttributeLenInvalid		(sonyMsioErrorClass | 6)	//some attribute returne dby the card had an invalid length
#define sonyMsioErrNoFuncNotEnabled			(sonyMsioErrorClass | 7)	//you need to enable a function before doing what you did
#define sonyMsioErrAFuncIsEnabled			(sonyMsioErrorClass | 8)	//you cannot do what you just did while a function is enabled
#define sonyMsioErrCannotSupplyCurrent		(sonyMsioErrorClass | 12)	//this stick function requires more current than this handheld can supply
#define sonyMsioErrOutOfMemory				(sonyMsioErrorClass | 13)	//ran out of memory while doing what you asked for
#define sonyMsioErrIntWaitTimedOut			(sonyMsioErrorClass | 14)	//an interrupt did not arrive within the time you specified


struct MsioAttrs {
	char manufacturer[33];
	char product[33];
	char version[17];
};


#define SONY_MSIO_OP_API_VERSION			0x2100
struct SonyMsioApiVersion {
	UInt32 ver;							//OUT: ver
};

#define SONY_MSIO_OP_FUNCTION_ENABLE		0x2101
struct SonyMsioFunctionEnable {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
	void (*irqHandler)(void* userata);	//IN
	void *irqHandlerData;				//IN
};

#define SONY_MSIO_OP_FUNCTION_DISABLE		0x2102
struct SonyMsioFunctionDisable {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
};

#define SONY_MSIO_OP_FUNCTION_CHECK			0x2103
struct SonyMsioFunctionCheck {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
	UInt8 *reg7valOutP;					//ptr IN, val OUT
};

#define SONY_MSIO_OP_GET_ATTRIBUTES			0x2104		//ARM, 0x2029 is similar
struct SonyMsioGetAttributes {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
	struct MsioAttrs *attrs;			//ptr IN, val OUT
};

#define SONY_MSIO_OP_INT_CONTROL			0x2105
struct SonyMsioIntControl {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
	Boolean irqOn;						//IN
};

#define SONY_MSIO_OP_POWER_SAVE			0x2106
struct SonyMsioPowerSave {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
	Boolean goSleep;					//IN
	UInt8 sbz;
	UInt32 maxWait;						//IN
};

#define SONY_MSIO_OP_SET_DEFAULT_TIMEOUTS	0x2107
struct SonyMsioSetDefaultTimeouts {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
	UInt32 readTimeoutUsec;				//IN
	UInt32 writeTimeoutUsec;			//IN
};

#define SONY_MSIO_OP_CHECK_FUNCTION_POWER	0x2108
struct SonyMsioCheckFunctionPower {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
	Boolean *poweredOutP;				//ptr IN, val OUT
};

#define SONY_MSIO_OP_CHECK_STICK_TYPE		0x2109
struct SonyMsioCheckStickType {
	UInt16 slotRef;						//IN
	Boolean *isMsioStickOutP;			//ptr IN, val OUT
};

#define SONY_MSIO_OP_FUNCTION_ENABLE_NO_CURRENT_CHECK	0x210A		//not always implemented, param is SonyMsioFunctionEnable

#define SONY_MSIO_OP_IO_GET_REG				0x2110
struct SonyMsioIoGetReg {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
	UInt8 *regValsOutP;					//ptr IN, val OUT
	UInt8 firstRegIdx;					//IN
	UInt8 numRegs;						//IN
	UInt32 readTimeout;					//IN
};

#define SONY_MSIO_OP_IO_GET_INT				0x2111
struct SonyMsioIoGetInt {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
	UInt8 *intRegValOutP;				//ptr IN, val OUT
	UInt8 numBytesToRead;				//IN. should always be 1. anything over 2 WILL overflow the stack in the Slot driver!
	UInt32 readTimeout;					//IN
};

#define SONY_MSIO_OP_IO_SET_REG				0x2112
struct SonyMsioIoSetReg {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
	const UInt8 *regValsToSet;			//ptr IN, val IN
	UInt8 firstRegIdx;					//IN
	UInt8 numRegs;						//IN
	UInt32 writeTimeout;				//IN
};

#define SONY_MSIO_OP_IO_READ_DATA			0x2113	//issues a READ_LDATA TPC
struct SonyMsioIoReadData {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
	UInt8 *dataOutP;					//ptr IN, val OUT
	UInt16 dataLen;						//IN
	UInt32 readTimeout;					//IN
};


#define SONY_MSIO_OP_IO_WRITE_DATA			0x2114	//issues a WRITE_LDATA TPC
struct SonyMsioIoWriteData {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
	const UInt8 *dataInP;				//ptr IN, val IN
	UInt16 dataLen;						//IN
	UInt32 readTimeout;					//IN
};

#define SONY_MSIO_OP_IO_SET_CMD				0x2115	//Only sends. Does not wait for INT. some commands are limited (0x55, 0x33, 0x99)
struct SonyMsioIoSetCmd {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
	UInt8 cmd;							//IN
	UInt32 tpcTimeout;					//IN
};

#define SONY_MSIO_OP_IO_WAIT_INT			0x2116
struct SonyMsioIoWaitInt {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
	UInt32 waitTimeout;					//IN
};

#define SONY_MSIO_OP_IO_TPC_W				0x2117
struct SonyMsioIoTpcW {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
	UInt8 tpc;							//IN
	UInt8 rfu;							//UNUSED
	const UInt8* dataToSendP;			//ptr IN, val IN
	UInt16 dataLen;						//IN
	UInt32 writeTimeout;				//IN
};

//on ACER devices this is hopelessly broken. controller is told to write tpc + dataLen bytes, and use TPC if 0
#define SONY_MSIO_OP_IO_TPC_R				0x2118
struct SonyMsioIoTpcR {
	UInt16 slotRef;						//IN
	UInt8 slotIdx;						//IN, always zero
	UInt8 functionID;					//IN
	UInt8 tpc;							//IN
	UInt8 rfu;							//UNUSED
	UInt8* dataOutP;					//ptr IN, val OUT
	UInt16 dataLen;						//IN
	UInt32 readTimeout;					//IN
};














#endif
