#ifndef _DRIVERLESS_H_
#define _DRIVERLESS_H_

struct Globals;

typedef Err (*FuncSlotCustomControl)(void *driverData, UInt16 selector, void *apiData);
typedef Err (*FuncPowerControl)(void **driverDataP, Boolean on);

enum DriverlessResult {
	DriverlessDeviceUnknown,
	DriverlessDeviceKnownAndSupported,
	DriverlessDeviceKnownAndError,
};

struct DriverlessSupportRecord {
	UInt32 dev;
	FuncSlotCustomControl fCustomControl;
	FuncPowerControl fPowerControl;
};

#define DRIVERLESS_DEFINE(_dev, _powerControlF, _customControllF)		\
	const struct DriverlessSupportRecord DRIVERLESS_ ## _dev 	\
		__attribute__((used, section(".driverless_descr")))  = {		\
		.dev = _dev,													\
		.fCustomControl = _customControllF,								\
		.fPowerControl = _powerControlF,								\
	} 
		

enum DriverlessResult driverlessCheck(struct Globals *g, UInt32 devID);



#endif
