#ifndef _GLOBALS_H_
#define _GLOBALS_H_

#include <PalmTypes.h>
#include "msioCommsProto.h"
#include "driverless.h"
#include "SonyMSIO.h"

#define MIN_RX_BUF_SZ		(MSIO_MAX_PACKET_LEN * 2 + 1024)

#define DEVICE_MSIO_FLAG_RAW_TPCS_BROKEN		0x01


struct Globals {
	
	//LL state
	UInt16 slotRef, libRef;
	union {
		volatile UInt8 lastSta;	//lastSta MUST be 2 byte aligned, 2 bytes are always written to it
		UInt16 spacerAndAligner;
	};
	UInt8 *rxBuf;
	void *dispBuffer;
	UInt16 hrLibRef, silkLibRef;
	UInt8 deviceMsioFlags;
	
	//ui state
	Boolean alarmTriggered;
	UInt32 prevRtcReported;
	Int16 prevPenX, prevPenY;
	UInt32 prevKeyState;
	
	//serial state
	UInt16 serPort;
	void *serRxBuf;
	Boolean serRxPending;
	
	//MSIO
	FuncSlotCustomControl fSlotCustomControl;
	void *customControlData;
	
	//pre-filled requests
	struct SonyMsioIoTpcR getIntReqRawTpc;		//you might think that SonyMsioIoGetInt makes sense, but on DSP devices it is much slower!
	struct SonyMsioIoGetInt getIntReqManaged;
	
	struct SonyMsioIoSetCmd irqAckCmd;
	
	struct SonyMsioIoWriteData wdPen;
	struct MsioPktPen pkPen;
	
	struct SonyMsioIoReadData rdMisc;		//MSIO_SHORT_PKT_SZ
	struct SonyMsioIoReadData rdMiscBig;	//MSIO_MAX_PACKET_LEN
};



#endif
