#include "halMemory.h"
#include "printf.h"
#include "kernel.h"
#include "memmap.h"
#include "dal.h"


static bool mStorageIsWriteable = false;	//starts ro

#ifndef CUSTOM_MEMORY_MAP

	const struct HalMemMap* DALEXPORT impl_HALMemoryGetMemoryMap(void)
	{
		logvst("%s\n", __func__);
	
		static const struct HalMemMapPiece mMapPieces[] = {
			{
				.memType = HAL_MEM_PIECE_TYPE_ROM,
				.base = CPU_ROM_BASE,
				.size = CPU_ROM_SIZE,
			},
			{
				.memType = HAL_MEM_PIECE_TYPE_DYNAMIC_RAM,
				.base = CPU_DYN_RAM_BASE,
				.size = CPU_DYN_RAM_SIZE,
			},
			{
				.memType = HAL_MEM_PIECE_TYPE_STORAGE_RAM,
				.base = CPU_STORAGE_RAM_BASE,
				.size = CPU_STORAGE_RAM_SIZE,
			},
		};
		static const struct HalMemMap mMap = {
			.numPieces = sizeof(mMapPieces) / sizeof(*mMapPieces),
			.pieces = mMapPieces,
		};
			
		return &mMap;
	}

#endif

bool DALEXPORT impl_HALMemoryGetStorageAreaProtectionState(void)		//not same as set sets
{
	logt("%s -> %s (meaning: isWriteable)\n", __func__, mStorageIsWriteable ? "true"  :"false");
	return mStorageIsWriteable;
}

void DALEXPORT impl_HALMemorySetStorageAreaProtectionState(bool allowWrites)
{
	logvst("%s(%s (meaning: makeWriteable) )\n", __func__, allowWrites ? "true" : "false");
	
	if (KERN_STATUS_OK != KSetStorageRamWriteable(allowWrites))
		fatal("Cannot set storage memory ptotection state\n");
	mStorageIsWriteable = allowWrites;
	
	
	#ifdef STORAGE_WRITEABLE_NOTIF
	extern void STORAGE_WRITEABLE_NOTIF(bool);
	STORAGE_WRITEABLE_NOTIF(allowWrites);
	#endif
}

uint32_t DALEXPORT impl_HALMemoryGetAreaSize(void* addr, bool isReadAccess)	//return length of writeable/readable memory at given address. does not need to hanel any heaps palmos knows
{
	if (kheapIsInOurHeaps(addr))
		return 1024;	//why not, all known callers just check for nonzero
	
	return 0;
}