#ifndef _HAL_MEMORY_H_
#define _HAL_MEMORY_H_

#include <stdbool.h>
#include <stdint.h>

#define HAL_MEM_PIECE_TYPE_ROM				0
#define HAL_MEM_PIECE_TYPE_DYNAMIC_RAM		1
#define HAL_MEM_PIECE_TYPE_STORAGE_RAM		2


struct HalMemMapPiece {
	uint8_t memType;
	uint32_t base;
	uint32_t size;
};

struct HalMemMap {
	uint8_t numPieces;
	const struct HalMemMapPiece* pieces;
};


const struct HalMemMap* HALMemoryGetMemoryMap(void);


bool HALMemoryGetStorageAreaProtectionState(void);
void HALMemorySetStorageAreaProtectionState(bool readonly);


#endif
