#include "halTrace.h"
#include "printf.h"
#include "kal.h"
#include "dal.h"
#include <string.h>
#include <stdio.h>

static uint32_t mMutex;

static void halTrace(uint16_t *errModuleP, const char *formatStringP, va_list vl, bool withNewline)
{
	if (!HAL_TRACE_ENABLED)
		return;
	
	KALTaskSwitching(false);
	if (!mMutex) {
		if (KALMutexCreate(&mMutex, CREATE_4CC('_','t','r','c')))
			fatal("Failed to create Trace module mutex\n");
	}
	KALTaskSwitching(true);
	
	(void)KALMutexReserve(mMutex, -1);
	
	if (errModuleP)
		pr("ERR(0x%04x) ", *errModuleP);
		
	vpr(formatStringP, vl);
	
	if (withNewline)
		pr("\n");
	
	(void)KALMutexRelease(mMutex);
}

static void halTraceLL(bool withNewline, const char *formatStringP, ...)
{
	va_list vl;
	
	va_start(vl, formatStringP);
	halTrace(NULL, formatStringP, vl, withNewline);
	va_end(vl);
}

void DALEXPORT impl_HALTraceInit(void)
{
	logt("%s\n", __func__);
}

void DALEXPORT impl_HALTraceClose(void)
{
	logt("%s\n", __func__);
}

void DALEXPORT impl_HALTraceOutputVT(uint16_t errModule, const char *formatStringP, va_list vl)
{
	halTrace(errModule ? &errModule : NULL, formatStringP, vl, false);
}

void DALEXPORT impl_HALTraceOutputVTL(uint16_t errModule, const char *formatStringP, va_list vl)
{
	halTrace(errModule ? &errModule : NULL, formatStringP, vl, true);
}

void DALEXPORT impl_HALTraceOutputT(uint16_t errModule, const char *formatStringP, ...)
{
	va_list vl;
	
	va_start(vl, formatStringP);
	halTrace(errModule ? &errModule : NULL, formatStringP, vl, false);
	va_end(vl);
}

void DALEXPORT impl_HALTraceOutputTL(uint16_t errModule, const char *formatStringP, ...)
{
	va_list vl;
	
	va_start(vl, formatStringP);
	halTrace(errModule ? &errModule : NULL, formatStringP, vl, true);
	va_end(vl);
}

void DALEXPORT impl_HALTraceOutputB(uint16_t errModule, const uint8_t *bufferP, uint32_t bufferLen)
{
	uint32_t i;
	
	HALTraceOutputTL(errModule, "Buffer %u bytes:", bufferLen);
	
	for (i = 0; i < bufferLen; i++) {
		
		if (!(i & 0x0F))
			halTraceLL(false, " %08x:", i);
		halTraceLL(false, " %02x", *bufferP++);
		if ((i & 0x0F) == 0x0F)
			halTraceLL(true, "");
	}
	if (i & 0x0f)
		halTraceLL(true, "");
}

void DALEXPORT impl_HALDbgMessage(const char* str)
{
	loge("HALDbgMessage('%s')\n", str);
}