#include "dockAndBattery.h"
#include "platform.h"
#include "audiohw.h"
#include "xscale.h"
#include "dal.h"

static bool dockPrvIsCharging(void)
{
	return !platGpioGetVal(24);
}

static void dockPrvUpdateDockStatus(void)
{
	halDockStatusChanged(dockPrvIsCharging() ? HAL_DOCK_STATUS_DOCK_ATTACHED | HAL_DOCK_STATUS_EXTRNAL_PWR | HAL_DOCK_STATUS_CHARGING | HAL_DOCK_STATUS_USB_CRADLE : 0);
}

static void dockPrvDockIrqHandler(void *data)
{
	dockPrvUpdateDockStatus();
}

void dockHwrInit(void)
{
	HALInterruptSetHandler(REPALM_IRQ_NO_MANGLE(XSCALE_IRQ_NO_GPIO(24)), dockPrvDockIrqHandler, NULL);
	
	platGpioSetDir(24, false);
	platGpioSetFunc(24, 0);
	platGpioClearEdgeDetected(24);
	platGpioSetEdgeDetect(24, true, true);
	
	dockPrvUpdateDockStatus();
}

void batteryInfo(SysBatteryKind *kindP, bool *haveMainsP, uint8_t *percentP)
{
	if (kindP)
		*kindP = sysBatteryKindLiIon1400;
	
	if (haveMainsP)
		*haveMainsP = dockPrvIsCharging();
	
	if (percentP) {
		
		int32_t val = adcGetValue(AdcValBattery);
		static uint8_t prevPerc = 88;
		
		if (val != DAL_ADC_VAL_INVALID) {
			
			static const uint16_t curve[] = {3300, 3700, 3730, 3761, 3791, 3822, 3853, 3884, 3985, 4009, 4050};
			uint32_t i;
			
			if (val <= curve[0])
				prevPerc = 0;
			else if (val >= curve[sizeof(curve) / sizeof(*curve) - 1])
				prevPerc = 100;
			else {
				
				for (i = 0; i < sizeof(curve) / sizeof(*curve) && curve[i] < val; i++);
				prevPerc = (i - 1) * 10 + (val - curve[i - 1]) * 10 / (curve[i] - curve[i - 1]);
			}
		}
		*percentP = prevPerc;
	}
}