#ifndef _MSIO_H_
#define _MSIO_H_

#include <stdbool.h>
#include <stdint.h>
#include "cpu.h"


#define MSIO_IRQn		(DMA2_Stream4_IRQn + 1)

//TPCs
#define MS_RD_LDATA					0x02
#define MS_RD_SDATA					0x03		//might not work on non-PRO MSs
#define MS_RD_REG					0x04
#define MS_GET_INT					0x07
#define MS_SET_RW_REG_ADRS			0x08
#define MS_EX_SET_CMD				0x09		//might not work on non-PRO MSs
#define MS_WR_REG					0x0b
#define MS_WR_SDATA					0x0c		//might not work on non-PRO MSs
#define MS_WR_LDATA					0x0d
#define MS_SET_CMD					0x0e

//registers
#define MS_REG_NO_INT				0x01
#define MS_REG_NO_STA0				0x02
#define MS_REG_NO_STA1				0x03
#define MS_REG_NO_TYPE				0x04
#define MS_REG_NO_TYPE2				0x05
#define MS_REG_NO_CATEGORY			0x06
#define MS_REG_NO_CLASS				0x07

#define MSIO_REG_NO_POWER			0x08
#define MSIO_REG_ATTRLEN_HI			0x09
#define MSIO_REG_ATTRLEN_LO			0x0a

#define MS_REG_NO_SYSCFG			0x10
#define MS_REG_NO_BLK_HI			0x11
#define MS_REG_NO_BLK_MID			0x12
#define MS_REG_NO_BLK_LO			0x13
#define MS_REG_NO_ACCESSTYP			0x14
#define MS_REG_NO_PAGE				0x15
#define MS_REG_NO_OOB(x)			(0x16 + (x))		//9 of them
#define MS_REG_NO_OVERWRI_FLG		MS_REG_NO_OOB(0)
#define MS_REG_NO_MANAGE_FLG		MS_REG_NO_OOB(1)
#define MS_REG_NO_LA_HI				MS_REG_NO_OOB(2)
#define MS_REG_NO_LA_LO				MS_REG_NO_OOB(3)

#define MS_NUM_REGS					0x30		//can be expanded, but why. MUST be a multiple of 4

//device categories we care about
#define MS_CATEGORY_STORAGE			0xff
#define MS_CATEGORY_REPALM			0x64

//int vals
#define INT_VAL_INVAL_CMD		0x01
#define INT_VAL_DATA_AVAIL		0x20
#define INT_VAL_ERROR			0x40
#define INT_VAL_CMD_DONE		0x80

void msioInit(void);				//assumes DMA1, SPI1, SPI2, SPI3, CRC are on, PLLQ is set to give SPI units clocks

void msioEnable(void);				//just once

void msioSignalIrq(bool requestingInt);
volatile uint8_t* msioGetRegs(void);
bool msioPoll(uint8_t *tpcP, const void **dataP, uint16_t *lenP);
void msioReleaseBuf(void);

//data passed to these must be cleaned from d-cache since DMA will be used to read it
//do keep in mind that DTCM is not readable by DMA so do not put things there...
#define MSIO_OUT_BUFER_SZ		512
#define MSIO_OUT_BUFFER_CT		2
void* msioGetOutBuffer(uint_fast8_t i);	//MSIO_OUT_BUFER_SZ bytes in size. guaranteed DMA-safe. example: fill it and pass to msioProvideLongReadData()
bool msioProvideLongReadData(const void *data, uint_fast16_t len);		//true if this did NOT overwrite previous data
bool msioProvideShortReadData(const void *data, uint_fast16_t len);
bool msioHaveLongDataToTx(void);
bool msioHaveShortDataToTx(void);



//provided externally
bool msioCategoryChanged(uint_fast8_t newCat);	//return true if allowed



//debug
void dtx(uint_fast8_t);


#endif