#include "msioMemoryBacking.h"
#include "msioSimpleMemory.h"
#include <stdio.h>
#include "printf.h"
#include "msio.h"


#define MS_CMD_READ				0xAA
#define MS_CMD_STOP				0x33

#define IRQ_TILL_DATA_READ		0x01
#define IRQ_TILL_STATUS_READ	0x02




static uint16_t mCurBlock = 0, mCurPage = 0;
static bool mContinuous = false, mWantData = false, mStopped = false, mEnabled = false;
static uint8_t mIrqCause = 0;
	
void msioSimpleMemoryInit(void)
{
	//nothing
}

static void msioSimpleMemoryPrvIrqSet(void)
{
	msioSignalIrq(mEnabled && mIrqCause);
}

void __attribute__((noinline)) msioSimpleMemoryCommand(uint_fast8_t cmd)
{
	volatile uint8_t *regs = msioGetRegs();

	if (!mEnabled)
		return;
	
	if (cmd == MS_CMD_READ) {
		
		uint_fast16_t blockNo;
		void *dataOutP;
		
		blockNo = (((uint_fast16_t)regs[MS_REG_NO_BLK_MID]) << 8) + regs[MS_REG_NO_BLK_LO];
		
		mCurBlock = blockNo;
		mCurPage = regs[MS_REG_NO_PAGE];
		mWantData = !(regs[MS_REG_NO_ACCESSTYP] & 0x40);
		mContinuous = mWantData && (mCurPage != BACKING_PAGES_PER_BLOCK) && !(regs[MS_REG_NO_ACCESSTYP] & 0x20);
		mStopped = false;
		
		if (!msMemoryBackingRead(mCurBlock, mCurPage, mWantData ? &dataOutP : NULL, (uint8_t*)(regs + MS_REG_NO_OOB(0)))) {
			
			regs[MS_REG_NO_INT] = INT_VAL_ERROR;	//error
			mIrqCause |= IRQ_TILL_STATUS_READ;
		}
		else {
			
			mIrqCause |= mWantData ? IRQ_TILL_DATA_READ : IRQ_TILL_STATUS_READ;
			regs[MS_REG_NO_INT] = (mWantData ? INT_VAL_DATA_AVAIL : 0x00) | (mContinuous ? 0x00 : INT_VAL_CMD_DONE);	//data avail. done if not continuous
			
			(void)msioProvideLongReadData(dataOutP, BACKING_PAGE_SIZE);
		}
		msioSimpleMemoryPrvIrqSet();
	}
	else if (cmd == MS_CMD_STOP) {
		
		mStopped = true;
		regs[MS_REG_NO_INT] |= INT_VAL_CMD_DONE;	//command completed
	}
	else {
		
		mContinuous = false;
		regs[MS_REG_NO_INT] = INT_VAL_CMD_DONE;	//command completed
	}
}

void __attribute__((noinline)) msioSimpleMemoryLongReadCompleted(void)
{
	volatile uint8_t *regs = msioGetRegs();
	
	if (!mEnabled)
		return;
	
	regs[MS_REG_NO_INT] &=~ INT_VAL_DATA_AVAIL;
	mIrqCause &=~ IRQ_TILL_DATA_READ;
	
	if (!mContinuous) {
				
		(void)msioProvideLongReadData(NULL, 0);
	}
	else if (mStopped) {
		
		mIrqCause |= IRQ_TILL_STATUS_READ;
		mStopped = false;			//expected to irq
	}
	else {
		
		mCurPage++;
		
		if (mCurPage != BACKING_PAGES_PER_BLOCK) {			//not done with block
			
			void *dataOutP;
			
			if (mCurPage == BACKING_PAGES_PER_BLOCK - 1)		//we're about to provide the last page - the command is done
				regs[MS_REG_NO_INT] |= 0x80;
			
			if (!msMemoryBackingRead(mCurBlock, mCurPage, mWantData ? &dataOutP : NULL, (uint8_t*)(regs + MS_REG_NO_OOB(0)))) {
				
				regs[MS_REG_NO_INT] = 0x40;	//error
				mIrqCause |= IRQ_TILL_STATUS_READ;
			}
			else if (mWantData){
				
				regs[MS_REG_NO_INT] |= 0x20;	//data avail, cmd over
				mIrqCause |= IRQ_TILL_DATA_READ;
				
				(void)msioProvideLongReadData(dataOutP, BACKING_PAGE_SIZE);
			}
		}
	}
	msioSimpleMemoryPrvIrqSet();
}

void __attribute__((noinline)) msioSimpleMemoryRegsReadCompleted(void)
{
	if (!mEnabled)
		return;
	
	mIrqCause &=~ IRQ_TILL_STATUS_READ;
	msioSimpleMemoryPrvIrqSet();
}

void __attribute__((noinline)) msioSimpleMemoryEnable(bool on)
{
	mEnabled = on;
	msioSimpleMemoryPrvIrqSet();
}







