#ifndef _LK_PLATFORM_H_
#define _LK_PLATFORM_H_

#include <stdbool.h>
#include <stdint.h>


//normal use
struct CortexExcFrame;
void kernelDispatchIrq(void);
void kernelHandleSwi(struct CortexExcFrame *exc);
void* __attribute__((const)) platPeriphP2V(uintptr_t pa);
bool platSetStackGuard(uint32_t addr);
bool platDmaBufAlloc(uint32_t sz, uintptr_t *paP, void **vaP);
void platDmaBufFree(void *va);
void platInstrCacheClearDataCacheClean(uintptr_t addr, int32_t sz);

//time
void platDelay(uint32_t usec);

void platEnablePeriphClock(uint32_t periph, bool clocked);	//periph types as per platform
bool platIsPeriphClockEnabled(uint32_t periph);


//gpio (abilities are plat-specific)
void platGpioSetDir(uint32_t gpio, bool out);
void platGpioSetVal(uint32_t gpio, bool hi);
bool platGpioGetVal(uint32_t gpio);
void platGpioSetFunc(uint32_t gpio, uint32_t func);	//values as per platform (eg: PXA26x 86..89 are weird)
void platGpioSetEdgeDetect(uint32_t gpio, bool rising, bool falling);
bool platGpioGetEdgeDetected(uint32_t gpio);
void platGpioClearEdgeDetected(uint32_t gpio);

//for init
void platInitCaches(void);			//among other things, must turn on the d-cache
void platInitPowerAndClocks(void);	//very very early. nothing much available
void platInitIrqs(void);
void platMapPeriphs(void);
void platExportFuncs(void);



//exports to the outside world
void* repalmPlatPeriphP2V(uintptr_t pa);
bool repalmPlatDmaBufAlloc(uint32_t sz, uintptr_t *paP, void **vaP);
bool repalmPlatDmaBufFree(void *va);


#endif
