#include <stdbool.h>
#include <stdint.h>
#include <string.h>
#include <stdio.h>
#include "platform.h"
#include "xscale.h"
#include "memmap.h"
#include "printf.h"
#include "timers.h"
#include "xscale.h"
#include "entry.h"
#include "misc.h"
#include "heap.h"
#include "irqs.h"
#include "mpu.h"

#define NON_PORTABLE
#include <HwrMiscFlags.h>
#undef NON_PORTABLE




static void debugUartInit(void)
{
	struct PxaUart *uart = platPeriphP2V(PXA_BASE_HWUART);
	uint32_t i;
	
	//setup gpios
	platGpioSetDir(35, true);	//SP3203 "nSHUTDOWN" pin
	platGpioSetDir(48, true);	//TX
	platGpioSetDir(49, false);	//RX
	platGpioSetDir(50, false);	//CTS
	platGpioSetDir(51, true);	//RTS
	for (i = 0; i < 4; i++) {
		platGpioSetEdgeDetect(48 + i, false, false);
		platGpioSetFunc(48 + i, 1);
	}
	platGpioSetVal(35, true);	//power up the SP3203
	
	
	platEnablePeriphClock(XSCALE_CLOCK_ID_HWUART, true);
	
	uart->IER = 0x00;	//uart off while we config it
	uart->FCR = 0x07;	//reset fifos, enable them
	uart->LCR = 0x80;	//access DLAB
	uart->DLL = 0x08;	//divisor of 8 gives us 115,200
	uart->DLH = 0x00;
	uart->LCR = 0x03;	//DLAB off, 8n1 selected
	uart->MCR = 0x00;	//no loopback or weird modem shit
	
	//as this is a HWUART, we need to config a few more things
	uart->ABR = 0x00;	//autobaud off
	
	uart->IER = 0x40;	//unit on, no irqs
}

void __attribute__((used)) machInit(uint32_t stage, const void* data)
{
	if (stage == STAGE_INIT_EARLY) {
		
		platMapPeriphs();
		mmuMapIoSeg((void*)0x89000000, 0x08000000);	//sd controller
		platInitPowerAndClocks();
		
		//get debug uart up as early as possible
		debugUartInit();
	}
	else if (stage == STAGE_SETUP_HEAPS) {
		
		static uint32_t heap[65536];
		
		kheapRegisterHeap((uintptr_t)heap, sizeof(heap), MEM_USABLE_AS_STACK | MEM_USABLE_FOR_DMA | MEM_USABLE_FOR_EXEC | MEM_FAST);
	}
	else if (stage == STAGE_INIT_INTERRUPTS) {
		
		platInitIrqs();
	}
	else if (stage == STAGE_CRASH_LOCKS_BREAK) {
		
		
	}
}

bool hwMaybeGetRomToken(uint32_t name, const void **dataP, uint16_t *szP)
{
	return false;
}

void hwGetMiscFlags(uint16_t *miscFlagsP, uint16_t *extMiscFlagsP)
{
	if (miscFlagsP)
		*miscFlagsP = hwrMiscFlagHasMiscFlagExt | hwrMiscFlagHasCradleDetect | hwrMiscFlagNoRTCBug | hwrMiscFlagHasMbdIrDA | hwrMiscFlagHasBacklight;
	
	if (extMiscFlagsP)
		*extMiscFlagsP = hwrMiscFlagExtHasSWBright | hwrMiscFlagExt115KIrOK | hwrMiscFlagExtHasLiIon;
}

int32_t cpuGetClockRate(enum ClockRateDevice dev)
{
	switch (dev) {
		case CpuClockRate:
		case TimerClockRate:
			return CPU_CLOCK_RATE;
		
		default:
			return-1;
	}
}

bool hwPwrCtl(uint32_t selector, const uint32_t *newValP, uint32_t *oldValP)
{
	return false;
}


#ifdef BUILDING_FOR_BIG_ARM
	#pragma GCC push_options
	#pragma GCC target ("arm")
#endif

void __attribute__((noinline)) machIdle(void)	//noinline will stop this form being inlined into thumb and them failing to link
{
	asm volatile("mcr p14, 0, %0, c7, c0, 4"::"r"(1):"memory");
}

#ifdef BUILDING_FOR_BIG_ARM
	#pragma GCC pop_options
#endif


Err machinePaceDispatch(EmulStateRef ref, uint16_t call, Err *ret68kP)
{
	return sysErrNotAllowed;
}
