#include <HostControl.h>
#include "hostCtl.h"
#include "printf.h"

//new ones in OS5
#define hostSelectorCanAllowAppSwitch	0xc00		//param is LocalID

#define hostSelectorEnableGremlins		0xc01
#define hostSelectorDisableGremlins		0xc02
#define hostSelectorAppStart			0xc03		//param is const char*
#define hostSelectorAppQuit				0xc04		//param: const char* dbName, u32 return value


void hostCtl(struct CortexExcFrame *exc)
{
	uint32_t ret;
	
	switch (exc->r0) {
		case hostSelectorGetHostID:
			ret = hostIDPalmOS;
			break;
		
		case hostSelectorGetHostPlatform:
			ret = hostPlatformPalmOS;
			break;
		
		case hostSelectorIsSelectorImplemented:
			ret =	exc->r1 == hostSelectorGetHostID ||
					exc->r1 == hostSelectorGetHostPlatform ||
					exc->r1 == hostSelectorIsSelectorImplemented ||
					exc->r1 == hostSelectorCanAllowAppSwitch ||
					exc->r1 == hostSelectorAppStart ||
					exc->r1 == hostSelectorAppQuit ||
					exc->r1 == hostSelectorGremlinIsRunning;
			break;
		
		case hostSelectorCanAllowAppSwitch:
			ret = true;
			break;
		
		case hostSelectorAppStart:
			logt("APP start '%s'\n", (exc->r1 >= 0x08000000) ? (const char*)exc->r1 : "(null)");
			ret = 0;
			break;
		
		case hostSelectorAppQuit:
			logt("APP quit '%s' -> %u\n", (exc->r1 >= 0x08000000) ? (const char*)exc->r1 : "(null)", exc->r2);
			ret = 0;
			break;
		
		case hostSelectorGremlinIsRunning:	//always no
			ret = 0;
			break;
		
		default:
			logw("Unexpected HostControl backend call 0x%04x from 0x%08x\n", exc->r0, exc->pc);
			//fallthrough
			
		case hostSelectorEnableGremlins:
		case hostSelectorDisableGremlins:
			ret = 0xffff;
			break;
	}
	
	exc->r0 = ret;
}