#ifndef _PALMCARD_PROTO_H_
#define _PALMCARD_PROTO_H_

#include <stdint.h>

#define PCC_REQ_MAGIC				0xA005
#define PCC_WRAP_REQ(val)			(PCC_REQ_MAGIC + (((val) & 0xff) << 4))
#define PCC_UNWRAP_REQ(req)			(((req) >> 4) & 0xff)
#define PCC_ISVALID_REQ(req)		(((req) & 0xf00f) == PCC_REQ_MAGIC)

#define PCC_REQ_DOWNLOAD_CODE		0x00	//	() -> (code)
#define PCC_REQ_PUTCHAR				0x01	//	(u16 chr) -> ()
#define PCC_REQ_IRQ_STA				0x02	//	(u16 clrBits) -> (u16 setBits, u16 devState)
#define PCC_REQ_BATT_REPORT			0x03	//	(u16 sample, uint16_t vrefInMillivolots) -> ()
#define PCC_REQ_TOUCH_REPORT		0x04	//	(u16 x, u16 y) -> ()	//all 0xffff if penup
#define PCC_REQ_BTN_REPORT			0x05	//	(u16 btnMask) -> ()
#define PCC_REQ_WANT_UART_CFG		0x06	//	() -> (uart config, struct PalmcardCommsUartConfig)
#define PCC_REQ_UART_BAUDRATE		0x07	//	(u32be) -> ()
#define PCC_REQ_UART_DATA			0x08	//	(u16 wordsCanAccept, u16 data[]) -> (u16 data[])	//not packed, PCC_MAX_UART_WORDS_AT_ONCE words at once at most
#define PCC_REQ_AUDIO_DATA			0x09	//	() -> (256 samples of data, packed into 128 words)
#define PCC_REQ_SIMPLE_AUDIO_REQ	0x0a	//	() -> (u16 freq, u16 amp)
#define PCC_REQ_DEV_ATTRS			0x0b	//	(u16 devAttrs) -> ()
#define PCC_REQ_DEVICE_HWR_FLAGS	0x0c	//	(u16 hwrFlags} -> ()


#define PCC_MAX_UART_WORDS_AT_ONCE				64

#define PCC_IRQ_BIT_HAVE_NEW_DEVICE_CONFIG		0x0001
#define PCC_IRQ_BIT_HAVE_NEW_UART_CONFIG		0x0002
#define PCC_IRQ_BIT_HAVE_NEW_UART_DATA			0x0004
#define PCC_IRQ_BIT_HAVE_NEW_SIMPLE_SOUND_REQ	0x0008
#define PCC_IRQ_BIT_REQUEST_POWER_OFF			0x0010

#define PCC_DEVSTATE_MASK_SCREEN				0x0003
#define PCC_DEVSTATE_SHIFT_SCREEN				0
#define PCC_DEVSTATE_MASK_SERIAL				0x000c
#define PCC_DEVSTATE_SHIFT_SERIAL				2
#define PCC_DEVSTATE_BIT_BACKLIGHT_ON			0x0010
#define PCC_DEVSTATE_BIT_AUDIO_ON				0x0020

#define PCC_DEVATTR_BIT_HAVE_BACKLIGHT			0x0001
#define PCC_DEVATTR_BIT_HAVE_IR					0x0002

#define PCC_DEVSTATE_VAL_SCREEN_OFF				0x0000
#define PCC_DEVSTATE_VAL_SCREEN_1_BPP			0x0001
#define PCC_DEVSTATE_VAL_SCREEN_2_BPP			0x0002
#define PCC_DEVSTATE_VAL_SCREEN_4_BPP			0x0003

#define PCC_DEVSTATE_VAL_SERIAL_XCVR_OFF		0x0000
#define PCC_DEVSTATE_VAL_SERIAL_XCVR_CRADLE		0x0001
#define PCC_DEVSTATE_VAL_SERIAL_XCVR_IRDA		0x0002

//hwrFlags
#define PCC_HW_IDENTIFIED						0x0001
#define PCC_HW_HAS_IR							0x0002
#define PCC_HW_HAS_BACKLIGHT					0x0004
#define PCC_HW_HAS_BBADS						0x0008
#define PCC_HW_INVALID_RESERVED_BIT				0x8000	//no valid "hw flags" field wil have this set

//defined bits match UARTCR in 68k
#define UART_CFG_TX_FLOW_CONTROL				0x8000	//NOT bit 11 in UARTTR
#define UART_CFG_MASK_RX_EN						0x4000	//matches UARTCR
#define UART_CFG_MASK_TX_EN						0x2000	//matches UARTCR
#define UART_CFG_TX_BREAK						0x1000	//bit 12 in UARTTR
#define UART_CFG_MASK_PAR_ENA					0x0800	//matches UARTCR
#define UART_CFG_MASK_PAR_ODD					0x0400	//matches UARTCR
#define UART_CFG_MASK_STOP_BITS_2				0x0200	//matches UARTCR
#define UART_CFG_MASK_BYTE_LEN_8				0x0100	//matches UARTCR

struct PalmcardCommsUartConfig {
	union {
		uint32_t baudrateBE;	//for 68k only
		struct {
			uint16_t baudrateHi;
			uint16_t baudrateLo;
		};
	};
	uint16_t cfg;				//see above
} __attribute__((packed));

/*

When the UART is first enabled after cold reset, before enabling interrupts,
set the UART ENABLE and RX ENABLE bits and per- form a word-read operation
on the receiver register to initialize the FIFO and character-status bits.
*/


#endif


/*

requests are sent to CSA0 one word at a time
when done, a single write access to CSA2 triggers processing
reply can be read from CSA0, but that might take time

while it has nothing to say, CSA0 outputs <SOMETHING that is not 0xFACE> (likely zero)
a reply begins with a magic of 0xFACE, then u16 indicating the number of u16s that follow, followed by data


a request can only be made once the previosu reply has been read, the only exception is the FIRST request
reqests begin with a word encoding the request type thusly: (0xA005 + (reqType << 4))
then a u16 indicating number of u16s that are data that follows



*/