#ifndef _HW_CPU_H_
#define _HW_CPU_H_

#include "stm32h7a3xx.h"





#define SYSTICK_CLOCKS_PER_TIMER_TICK					2								//better be a constant power of 2 or else bad bad bad slow int64 division

#define CPU_CLOCK_RATE									320000000

#define TIMER_TICKS_PER_MSEC							((CPU_CLOCK_RATE + 500) / 1000)

#define CPU_NUM_IRQS									160

static inline void cpuPutchar(char ch)
{
	#if 1	//ZWT
	
		volatile uint32_t *addr = (volatile uint32_t*)0x2001FFFC;
		uint32_t timeout = 0;
				
		while(addr[0] & 0x80000000ul) {
			asm volatile("dsb sy");
			
			if (++timeout == 0x100000)
				break;
		}
		addr[0] = 0x80000000ul | (uint8_t)ch;
	#endif
	
	#if 0	//UART
	
		while (!(UART4->ISR & USART_ISR_TXFT));
		UART4->TDR = ch;
	
	#endif
}

#endif
