//should match what entry.c for this machine actually configures

//memories we have:
// FLASH		2M   @ 0x08000000
// QSPI:		8M   @ 0x70000000
// AXI RAM:		1M   @ 0x24000000	(framebuffer and end of dynamic heap)
// AHB RAM:		128K @ 0x30000000	(hal static mem)
// ITCM:		64K  @ 0x00000000	(UI thread TC and MSIO funcs)
// DTCM:		128K @ 0x20000000	(heap for stacks and kernel .data and .bss)
// SRD RAM:		32K  @ 0x38000000	(unused)
//
//how we use them:
// flash is OS image, precisely as it is
// use GFXMMU to map end of QSPI memory and AXI ram togethrer into a chunk to use for dyn heap
// framebuffer needs 624K (max), places in AXI RAM end, used directly at its address
// dynamic ram ~ 1.4M (together with VRAM adds up to 2MB) at end of
// storage ram is the rest (6M)
//
//it should be remembered that QSPI doesnt work well directly, ever, it needs to be remapped via GFXMMU because fuck me
//
//thus GFXMMU mappings:
// 0x25000000 -> 0x70000000 (QSPI first 4MB)
// 0x25400000 -> 0x70400000 (QSPI last 4MB)
// 0x25800000 -> 0x70400000 (QSPI last 4MB) again to make mpu config easier
// 0x25c00000 -> 0x24000000 (AXI ram)
//
//thus address ranges:
// ROM:		0x08000000 + 0x00200000
// STORAGE:	0x25000000 + 0x00700000
// DYNAMIC: 0x25B00000 + 0x0015FE00
// VRAM2:	0x2405FE00 + 0x00050200	(temp for compression/swapping, must fit: screen * 1025 / 1024 + 1)
// VRAM1:	0x240B0000 + 0x00050000 (actual vram enough to fit 320x480x2. rounded up for mmu to be able to limit access for change detection)
//ITCM use:
// first 1K - unmapped for NULL (yes, sorry)
// next 4K - fastcode (code from DAL that needs to be super fast)
// the rest - ui thread TC

#define CPU_HARDWIRED_UI_THREAD_JIT_TC_BASE		0x00001400	//ITCM is TC for UI thread (almost all 64K of it)
#define CPU_HARDWIRED_UI_THREAD_JIT_TC_SIZE		0x0000ec00	//we save some bytes for "fastcode"

#define CPU_ROM_BASE							0x08000000	//1MB of ROM
#define CPU_ROM_SIZE							0x00200000

#define CPU_STORAGE_RAM_BASE					0x25000000	//6M of storage heap
#define CPU_STORAGE_RAM_SIZE					0x00700000

#define CPU_DYN_RAM_BASE						0x25B00000	//1.37MB of dyn heap
#define CPU_DYN_RAM_SIZE						0x0015FE00

//total VRAM use: 0x9C000 = 624K  
//for vram tracking, the actual buffer must be self-aligned 
#define CPU_HARDWIRED_VTMP1_SPACE				0x2405FE00	//for screen compression/swapping, must fit: screen * 1025 / 1024 + 1
#define CPU_HARDWIRED_VTMP1_SIZE				0x00050200
#define CPU_HARDWIRED_VRAM_ADDR					0x240B0000	//enough to fit 320x480x2. rounded up for mmu to be able to limit access for change detection
#define CPU_HARDWIRED_VRAM_SIZE					0x00050000

#define HAL_UNCACHED_RAM_BASE					0x30000000
#define HAL_UNCACHED_RAM_SIZE					0x00000c00

#define HAL_STATIC_MEM_BASE						0x30000c00	//executable, stack usable
#define HAL_STATIC_MEM_SIZE						0x0001f400	//126K

#define HAL_CCM_MEM_BASE						0x20007000	//nonexecutable, stack usable
#define HAL_CCM_MEM_SIZE						0x00018FFC	//100K - 4 byte ZWT buffer

//DAL's .data and .bss live in SRAM2:			0x20027D00 and are 16K+768b (in sram 1 for fast callouts)


//for disp
#define DISP_MPU_REG							14
void mpuRegCfg(uint32_t idx, uint32_t addr, uint32_t cfg);
void mpuRegCfgPermOnly(uint32_t idx, uint32_t cfg);
