#ifndef _MSIO_REPALM_PROTO_H_
#define _MSIO_REPALM_PROTO_H_

#include <stdbool.h>
#include <stdint.h>

/*
	worst case LZ-compress hi-res screen is 205600 bytes (402 messages)
	HiRes+ is 308400 bytes (603 messages)
	LoRes is 25700 bytes (lo res sony is 8bpp only) - 51 messages
	
	8Kbps ADPCM data with 50ms latency is 200 bytes per second
	
	card signals interrupt when it has something to say
	we read status to see what it has
	screen xfers are least prio and use read short tpc
	all other things use read long tpc of 64 byte lengths (unless more is needed, like CLUTs)
	
	to send data to card, we simply issue a long write
	if we have a CRC error on write to card, we'll not get ack and we'll know
	but what if we get a crc error on read from card?
	//let's hope not :D
	writes to card can be of any length
	all endiannesses on all multi-byte values are big-endian. structures shall be arranged such that ARM and 68k align them they same
	
	
	it is assumed that every data read will be preceded by "read status"
*/

#define MSIO_MAX_PACKET_LEN						512		//as per MSIO drivers
#define MSIO_SHORT_PKT_SZ						64		//most packets we READ are this big, except CLUT pieces

//for status reg
#define MSIO_STA_HAVE_DATA						0x01


struct MsioPktHeader {
	uint8_t pktTyp;
};


#define MSIO_PKT_NOP							0x00
struct MsioPktNop {
	struct MsioPktHeader hdr;
};

#define MSIO_PKT_SET_BOOT_PARAMS				0x01
struct MsioPktBootParams {
	struct MsioPktHeader hdr;
	uint16_t dispW;
	uint16_t dispH;
	uint16_t supportedDepths;
	uint16_t hwrMiscFlags;
	uint16_t hwrMiscExtFlags;
	uint8_t curDepth;
	uint8_t miscBits;
	
	uint16_t voltageInCv;
	uint8_t percent, kind, isPluggedIn;
	
	uint32_t curRtc;
	
	#define MISC_BIT_LED_SUPPORTED		0x0001
	#define MISC_BIT_VIB_SUPPORTED		0x0002
	#define MISC_BIT_AUDIO_SUPPORTED	0x0004
	#define MISC_BIT_HIGH_DENSITY		0x0008
	#define MISC_BIT_BACKLIGHT_ON		0x0010
};

#define MSIO_PKT_PEN							0x02
struct MsioPktPen {
	struct MsioPktHeader hdr;
	int16_t x, y;
};

#define MSK_PKT_BUTTONS							0x03
struct MsioPktButtons {
	struct MsioPktHeader hdr;
	uint16_t keyboardBits[3];	//NR series
	uint32_t palmOsBitMask;
};

#define MSIO_PKT_BATT_INFO						0x04
struct MsioPktBattInfo {
	struct MsioPktHeader hdr;
	uint16_t voltageInCv;
	uint8_t percent, kind, isPluggedIn;
};

#define MSIO_PKT_SER_OP_REQUEST					0x05
#define MSIO_PKT_SER_OP_REPLY					0x06
struct MsioPktSerOp {
	struct MsioPktHeader hdr;
	uint8_t op;		//enum MsioSerOpType
	union {
		struct {
			uint16_t padding;
			uint32_t port;				//eg:  serPortLocalHotSync or serPortDefault
			uint32_t baud;
		} open;
		struct {
			uint16_t flags;				//bitfield of serSettingsFlag*
			uint32_t baud;
			uint32_t ctsTimeout;
			
			#define SER_FLAG_IR_MODE		0x8000	//only on "SET"
			#define SER_FLAG_IR_RX_ON		0x4000
		} settings;
		struct {
			uint16_t errors;			//errors as is form SerGetStatus()
			uint8_t ctsOn;				//bool
			uint8_t dsrOn;				//bool
		} state;
		struct {
			uint16_t err;
			uint32_t val;				//uint32, in/out as needed
			uint8_t selector;
		} control;
	} data;
};

enum MsioSerOpType {
	//requests
	SerOpOpen,			//"open" => SerOpSuccess / SerOpFailure
	SerOpClose,			//no params
	SerOpSetSettings,	//"settings"
	SerOpGetSettings,	//no params
	SerOpGetState,		//no params
	SerOpControl,		//"control"
	SerOpSendWait,		//no params
	
	
	//replies
	SerOpSuccess,		//no params
	SerOpFailure,		//no params
	SerOpCurSettings,	//"settings"
	SerOpCurState,		//"state"
	SerOpControlReply	//"control"
};

#define MSIO_PKT_SER_DATA					0x07
struct MsioSerialData {
	struct MsioPktHeader hdr;
	uint16_t bytesAndFlags;		//nBytes in top 9 bits, bitmask of serLineError* in bottom 7
	uint8_t data[];				//high byte is first byte to send, low byte is second byte to send
	
	#define MSG_BYTES_AND_FLAGS_BYTES_MASK	0xFF80
	#define MSG_BYTES_AND_FLAGS_BYTES_SHIFT	7
	
	#define MSG_BYTES_AND_FLAGS_FLAGS_MASK	0x007F	//serLineError* for RX, 
	#define MSG_BYTES_AND_FLAGS_FLAGS_SHIFT	0	
};

#define MSIO_PKT_SER_TX_REPLY				0x14
struct MsioSerialDataTxReply {
	struct MsioPktHeader hdr;
	uint16_t err;
	uint32_t numSent;
};

#define MSIO_PKT_SET_BACKLIGHT				0x08
#define MSIO_PKT_SET_BRI					0x09
#define MSIO_PKT_SET_CONTRAST				0x0a
#define MSIO_PKT_SET_DEPTH					0x0b
struct MsioShortMessage {
	struct MsioPktHeader hdr;
	uint8_t value;
};

#define MSIO_PKT_LED_CONTROL				0x0c
#define MSIO_PKT_VIB_CONTROL				0x0d
struct MsioVibLedControl {
	struct MsioPktHeader hdr;
	uint16_t numTimes;				//zero for off
	uint32_t pattern;
	uint16_t csecPerPiece;			//centisecs
	uint16_t csecBetween;			//centisecs
};

#define MSIO_PKT_CLUT_HDR					0x0e
struct MsioClutHdr {
	struct MsioPktHeader hdr;
	uint16_t numEntries;
};

//up to two full packets of data follow
//a read of any length may be attempted for either of them
//but if more than 512 bytes of data is expected, the first must be for 512 bytes
//each entry is 4 bytes, so amax of two 512 byte reads are expected

#define MSIO_PKT_DISPLAY_HDR				0x0f
struct MsioScreenImgHdr {
	struct MsioPktHeader hdr;
	uint8_t totalSzHi;			//this order allows reading them as a U32 on 68k side
	uint16_t totalSzLo;
	uint8_t data[MSIO_SHORT_PKT_SZ - 4];	//must be word-sized
};

//packets of data follow
//a read of any length may be attempted for either of them
//but if more than 512 bytes of data is expected, the first must be for 512 bytes

#define MSIO_PKT_AUDIO_DATA					0x10
struct MsioAudioData {
	struct MsioPktHeader hdr;
	uint16_t dataSz;
	uint8_t data[MSIO_SHORT_PKT_SZ - 4];
};

#define MSIO_PKT_SET_ALARM					0x11
#define MSIO_PKT_SET_RTC					0x12
struct MsioRtcSetData {
	struct MsioPktHeader hdr;
	uint8_t pad[3];
	uint32_t value;
};

#define MSIO_PKT_RTC_REPORT					0x13
struct MsioRtcData {
	struct MsioPktHeader hdr;
	uint8_t pad[2];
	bool alarmTriggered;
	uint32_t curTime;
};

//0x14 is taken

#endif
