#ifndef _M0_FAULT_DISPATCH_
#define _M0_FAULT_DISPATCH_

/*

	comes in a few pieces so you can insert your own things in the middle
	do not include more than once or shit will not link...duh

	define three things to include more processing
	
	CODE_TO_GO_TO_ARM
	
		code to jump to your own way to do arm
		 * r0 contains exc frame
		 * r2 contains the ARM pc
		 * r1, r3, r12 are all yours
		 * LR is whatever you need to return from this exception
		 * numeric labels 5 andlater are yours
	
	CODE_GOTO_ARM_PC_IN_EXC_VALID
		same as the above, except exc->pc already has the arm PC
		 * BUT, r2 does not!!!
	
	CODE_FOR_UNDEF_32BIT_INSTR
		
		code to run in case of an undefined 32-bit instr
		 * r0 contains exc frame
		 * r1 has first halfword
		 * r2 has second halfword
		 * r3, r12 are all yours
		 * LR is whatever you need to return from this exception
		 * numeric labels 5 and later are yours
	
	CODE_FOR_POSSIBLY_UNDEF_16BIT_INSTR
		 * r0 contains exc frame
		 * r1 has the instr (do not clobber it)
		 * r2 has pc
		 * r2, r3, r12 are all yours
		 * LR is whatever you need to return from this exception
		 * numeric labels 5 and later are yours

	EXTRA_ASM_INPUTS
		if you want to use asm inputs, start at 8 and use this variable to define them, START WITH A COMMA

*/

//XXX: rememeber that C-M0 will not execute a "BX PC" and will treat it as invalid instr instead. 


#define STR2(x)			#x
#define STR(x)			STR2(x)


void __attribute__((used,naked)) HardFault_Handler(void)
{
	asm volatile(
		".syntax unified									\n\t"
		"	mov   r0, lr									\n\t"
		"	lsrs  r0, #3									\n\t"
		"	bcs   1f										\n\t"
		"	mov   r0, sp									\n\t"	//grab the appropriate SP
		"	b     2f										\n\t"
		"1:													\n\t"
		"	mrs   r0, psp									\n\t"
		"2:													\n\t"

		"check_for_arm_mode:								\n\t"
		"	ldr   r1, [r0, #4 * 7]							\n\t"	//load pushed flags
		"	lsrs  r2, r1, #25								\n\t"	//shift out the T bit
		"	bcc   in_arm_mode								\n\t"	//arm mode?
		
		"in_thumb_mode:										\n\t"
		"	ldr   r2, [r0, #4 * 6]							\n\t"	//grab PC
		"	ldrh  r1, [r2]									\n\t"	//try to get instr (THIS CAN FAULT)
		"	lsrs  r3, r1, #11								\n\t"
		"	cmp   r3, #0x1E									\n\t"
		"	bne   instr_not_blx								\n\t"
		"	ldrh  r2, [r2, #2]								\n\t"	//try to get instr part 2(THIS CAN FAULT)
		"	lsrs  r3, r2, #11								\n\t"
		"	cmp   r3, #0x1D									\n\t"
		"	bne   instr32_not_blx							\n\t"
		
		"instr32_is_blx:									\n\t"
		"	lsls  r1, #21									\n\t"
		"	asrs  r1, #9									\n\t"
		"	lsls  r2, #21									\n\t"
		"	lsrs  r2, #20									\n\t"
		"	adds  r2, r1									\n\t"
		"	ldr   r1, [r0, #0x18]							\n\t"	//grab PC
		"	adds  r1, #5									\n\t"	//adjust for where offset is from, and also calculate LR
		"	str   r1, [r0, #0x14]							\n\t"	//set lr
		"	adds  r2, r1									\n\t"	//final address (but need to clear bottom 2 bits)
		"	lsrs  r2, #2									\n\t"
		"	lsls  r2, #2									\n\t"	//target address of the BLX
		
		//check if this is an OsCall (a speed optimization)
		"blx_check_for_oscall:								\n\t"
		"	ldr   r1, [r2]									\n\t"	//load first target instr (THIS CAN FAULT)
		"	movs  r3, #0x0c									\n\t"
		"	ands  r3, r1									\n\t"
		"	beq   go_to_raw_arm_addr						\n\t"	//not oscall
		"	negs  r3, r3									\n\t"
		"	mov   r12, r3									\n\t"	//table offset
		"	adds  r1, r3									\n\t"
		"	ldr   r3, =0xe519c000							\n\t"
		"	cmp   r1, r3									\n\t"
		"	bne   go_to_raw_arm_addr						\n\t"	//not oscall
		"	ldr   r1, [r2, #4]								\n\t"	//load second target instr (THIS CAN FAULT)
		"	add   r12, r9									\n\t"
		"	mov   r3, r12									\n\t"
		"	ldr   r3, [r3]									\n\t"
		"	mov   r12, r3									\n\t"
		
		#ifdef HAVE_v8M_BASE
			"	movw  r3, #0x00000FFC						\n\t"
		#else	
			"	movs  r3, #0x0f								\n\t"
			"	lsls  r3, #8								\n\t"
			"	adds  r3, #0xfc								\n\t"
		#endif
		"	ands  r3, r1									\n\t"
		"	subs  r1, r3									\n\t"
		"	add   r12, r3									\n\t"
		"	ldr   r3, =0xe59cf000							\n\t"
		"	cmp   r1, r3									\n\t"
		"	bne   go_to_raw_arm_addr						\n\t"	//not oscall
		
		"is_oscall:											\n\t"
		"	mov   r2, r12									\n\t"
		"	ldr   r2, [r2]									\n\t"	//load final target jump address for the OsCall
		
		"check_if_oscall_to_thumb:							\n\t"
		"	lsrs  r3, r2, #1								\n\t"
		"	bcc   go_to_raw_arm_addr						\n\t"	//just continue interpreting there :)
		
		"oscall_was_to_thumb:								\n\t"
		"	lsls  r3, #1									\n\t"	//clear bottom bit
		"	str   r3, [r0, #0x18]							\n\t"	//store addr in exc frame so we can jump to it
		"	bx    lr										\n\t"	//and bail
		
		"instr_not_blx:										\n\t"
		"	cmp   r3, #0x1C									\n\t"
		"	bls   instr_16bit_long							\n\t"
		"	ldrh  r2, [r2, #2]								\n\t"	//try to get instr part 2(THIS CAN FAULT)
		"	b     instr32_not_blx							\n\t"
		
		
		"instr32_not_blx:									\n\t"	//there are no other long instrs we care for so treat as an undefined instr
		
		CODE_FOR_UNDEF_32BIT_INSTR
		
		"	b     goto_undefinstr_fault_handler				\n\t"
		
		"instr_16bit_long:									\n\t"	//short instrs might fault for other reasons, but dispatching that in asm is a pain. just check for udf

		"	movs  r3, #0x47									\n\t"
		"	lsls  r3, #8									\n\t"
		"	adds  r3, #0x78									\n\t"
		"   cmp   r3, r1									\n\t"
		"	bne   instr16_is_not_bx_pc						\n\t"
		"	lsrs  r2, #2									\n\t"
		"	adds  r2, #1									\n\t"
		"	lsls  r2, #2									\n\t"
		"go_to_raw_arm_addr:								\n\t"	// BLX.T to an adm address
		CODE_TO_GO_TO_ARM
		
		"instr16_is_not_bx_pc:								\n\t"
		CODE_FOR_POSSIBLY_UNDEF_16BIT_INSTR
		
		"goto_undefinstr_fault_handler:						\n\t"
		"	movs  r1, # " STR(EXC_m0_CAUSE_UNDEFINSTR) "	\n\t"
		"	ldr   r2, =faultHandlerWithExcFrame				\n\t"	//go to generic fault handler
		"	bx    r2										\n\t"
		
		"in_arm_mode:										\n\t"
		"	movs  r2, #0x01									\n\t"	//set the T bit
		"	lsls  r2, #24									\n\t"
		"	orrs  r1, r2									\n\t"
		"	str   r1, [r0, #0x1c]							\n\t"	//store into pushed flags
		
		CODE_GOTO_ARM_PC_IN_EXC_VALID

		CODE_AT_END_EXTRA
		
		".ltorg												\n\t"
		:
		:EXTRA_ASM_INPUTS
		: "cc", "memory", "r0", "r1", "r2", "r3", "r12" //yes gcc needs this list...
	);
}



#endif
