#include "zodiac.h"
#include "printf.h"
#include "audio.h"
#include "boot.h"

enum TwSoundIfaceSelector {
	TwSoundIfaceGetMasterVolume,
	TwSoundIfaceSetMasterVolume,
	TwSoundIfaceGetMute,
	TwSoundIfaceSetMute,
	TwSoundIfaceGetBassBoost,
	TwSoundIfaceSetBassBoost,
	TwSoundIfaceGetAlarmPlaying,
	TwSoundIfaceSetAlarmPlaying,
	TwSoundIfaceGetVal_0x712,
	TwSoundIfaceSetVal_0x712,
	TwSoundIfaceGetVal_0x714,
	TwSoundIfaceSetVal_0x714,
	TwSoundIfaceGetVal_0x706,
};


///xxx: read about TW_VD_AUDIOAMP_MUTE_SPKRS TW_VD_AUDIOAMP_MUTE_ALL in tw doc. might help figur eout remainin gsound mysteries

static Err twPrvIfaceSound(enum TwSoundIfaceSelector sel, void* data, uint32_t *szP)
{
	/*globals adds are as per sim
		selector 0 param is 2 bytes. get master volume. basically guts for TwSndGetVolume()
		selector 1 param is 2 bytes. set master volume. basically guts for TwSndSetVolume()
		selector 2 param is 1 byte. basically TwSndGetMute() except returns actual state, no tmie related shit
		selector 3 param is 1 byte. basically TwSndSetMute()
		selector 4 param is 1 byte. get bass boost. basically TwSndGetBassBoost()
		selector 5 param is 1 byte. set bass boost. basically TwSndSetBassBoost()
		selector 6 param is 1 byte.basically TwSndGetAlarmPlaying(), if such a thing existed
		selector 7 param is 1 byte. basically TwSndSetAlarmPlaying()
		selector 8 param is 2 bytes, getter. volume related. globals+712h. at boot is 64
		selector 9 param is 2 bytes. setter. volume related. globals+712h
		selector 10 param is 2 bytes, getter. globals+714h. at boot is 25
		selector 11 param is 2 bytes, setter. globals+714h. clipped to 0...100
		selector 12 param is 1 bytes (as per api) 2 as witten, getter. globals+706h
	*/
	static uint16_t mMasterVolume = 64, val_0x712 = 64, val_0x714 = 25;
	static bool mBassBoost = false, mAlarmPlaying = false;
	static uint32_t mMuteCount = 0;
	
	logi("%s(%u, ...)\n", __func__, sel);
	
	if (!data || !data)
		return sysErrParamErr;
	
	switch (sel) {
		case TwSoundIfaceGetMasterVolume:
			if (*szP < sizeof(mMasterVolume))
				return sysErrParamErr;
			*(uint16_t*)data = mMasterVolume;
			break;
		
		case TwSoundIfaceSetMasterVolume:
			if (*szP < sizeof(mMasterVolume))
				return sysErrParamErr;
			mMasterVolume = *(const uint16_t*)data;
			break;
		
		case TwSoundIfaceGetMute:
			if (*szP < sizeof(uint8_t))
				return sysErrParamErr;
			*(uint8_t*)data = !!mMuteCount;
			break;
		
		case TwSoundIfaceSetMute:
			if (*szP < sizeof(uint8_t))
				return sysErrParamErr;
			if (*(const uint8_t*)data)
				mMuteCount++;
			else
				mMuteCount--;
			break;
		
		case TwSoundIfaceGetBassBoost:
			if (*szP < sizeof(uint8_t))
				return sysErrParamErr;
			*(uint8_t*)data = mBassBoost;
			break;
		
		case TwSoundIfaceSetBassBoost:
			if (*szP < sizeof(uint8_t))
				return sysErrParamErr;
			mBassBoost = !!*(const uint8_t*)data;
			break;
		
		case TwSoundIfaceGetAlarmPlaying:
			if (*szP < sizeof(uint8_t))
				return sysErrParamErr;
			*(uint8_t*)data = mAlarmPlaying;
			break;
		
		case TwSoundIfaceSetAlarmPlaying:
			if (*szP < sizeof(uint8_t))
				return sysErrParamErr;
			mAlarmPlaying = !!*(const uint8_t*)data;
			break;
		
		case TwSoundIfaceGetVal_0x712:
			if (*szP < sizeof(val_0x712))
				return sysErrParamErr;
			*(uint16_t*)data = val_0x712;
			break;
		
		case TwSoundIfaceSetVal_0x712:
			if (*szP < sizeof(val_0x712))
				return sysErrParamErr;
			val_0x712 = *(const uint16_t*)data;
			break;
		
		case TwSoundIfaceGetVal_0x714:
			if (*szP < sizeof(val_0x714))
				return sysErrParamErr;
			*(uint16_t*)data = val_0x714;
			break;
		
		case TwSoundIfaceSetVal_0x714:
			if (*szP < sizeof(val_0x714))
				return sysErrParamErr;
			val_0x714 = *(const uint16_t*)data;
			break;
		
		case TwSoundIfaceGetVal_0x706:
			if (*szP < sizeof(uint8_t))	//this iscorrect as per existing DALs. yes, check for 1 byte but write 2
				return sysErrParamErr;
			*(uint16_t*)data = 1;
			break;
		
		default:
			fatal("%s: Unknown selector %u\n", __func__, sel);
			return sysErrParamErr;
	}
	return errNone;
}

uint32_t DALEXPORT impl_TwHALSoundNumActiveStreams(void)
{
	return audioGetNumOutStreams();
}

void* zodPrvGetSoundIface(void)
{
	return &twPrvIfaceSound;
}