#define _ASSEMBLY
#include "common.h"
#define LIB_SLOT_IN_GLOBALS 0x18
.syntax unified
.globl SysLinkerStub  //required to exist
.type LinkerStubCall_v7m, %function
.globl LinkerStubCall_v7m
.weak LinkerStubCall_v7m
.section .text.LinkerStubCall_v7m
.balign 4 //life is easier when aligned to a 4-byte-boundary :)
.func
LinkerStubCall_v7m:
	//stack has [descr] [callfunc | 1]
	push  {r0-r3, lr}
	ldr   r0, [sp, #0x18]  //get stub func addr
	ldrh  r1, [r0, #0x05]  //load (self_module_id * 4)
	ldrh  r2, [r0, #0x09]  //load lib slot in globals
	bic   r1, #0xf000      //isolate (self_module_id * 4)
	bic   r2, #0xf000      //isolate lib slot in globals
	ldr   r3, [r9]         //get pointer to where table shall go into r3
	ldr   r3, [r3, r1]
	adds  r2, r3
	ldr   r0, [sp, #0x14]  //param #1: lib descriptor
	lsrs  r1, #2           //param #2: module ID
	adds  r2, #1           //param #3: table write loc (lower bit tells linker stub that we cna handle thumb addrs directly (rePalm special)
	bl    SysLinkerStub
	pop   {r0-r3, lr}
	add   sp, #4
	pop   {pc}
.endfunc
.type Llib_load_stub, %function
.section .text.Llib_load_stub
.balign 4 //life is easier when aligned to a 4-byte-boundary :)
.func
Llib_load_stub:
	adr r12, 1f
	push {r12}
	b.w LinkerStubCall_v7m
	.balign 4 // the data needs to be word-aligned
1:
	.word 0x6c696272 // type (libr)
	.word 0x6746544c // creator (gFTL)
	.word 1
	.word 10
	.word 0x616d6464 // res type for data (amdd)
	.word 0x616d6469 // res type for info (amdi)
	.word 0x616d6463 // res type for code (amdc)
	.hword 0 // res id for data
	.hword 0 // res id for info
	.hword 0 // res id for code
	.hword 0 // reserved
.endfunc
.macro libentry name idx
	.type \name, %function
	.globl \name
	.section .text.\name
	.balign 4 //life is easier when aligned to a 4-byte-boundary :)
	.func
	\name:
	1:
		ldr   r12, [r9]
		ldr   r12, [r12, #0 + MY_LIB_ID]           // .W to force format T3
		ldr   r12, [r12, #0 + LIB_SLOT_IN_GLOBALS] // .W to force format T3
		cmp   r12, #0
		it    ne
		ldrne pc,  [r12, #4 * \idx]
		adr   r12, 1b + 1
		push  {r12}
		b     Llib_load_stub
	.endfunc
.endm
libentry ftlInit 0
libentry ftlFree 1
libentry ftlMount 2
libentry ftlUnmount 3
libentry ftlSleepNotify 4
libentry ftlLowLevelFormat 5
libentry ftlGetInfo 6
libentry ftlRead 7
libentry ftlWrite 8
libentry ftlTrim 9
