#ifndef _VDRV_MY_PORT_H_
#define _VDRV_MY_PORT_H_

#include <stdint.h>
#include "vdrvV5.h"

#define NUM_PORTS			2

Err portOpen(void **drvrDataP /* OUT */, const struct VdrvConfig *cfg, const struct VdrvRecvQueue* recvQ);
Err portClose(void *drvrData);
Err portControl(void *drvrData, uint32_t controlOp /* VDRV_CTL_OP_* */, void* data, uint16_t *controlDataLenP /* never used */);
Err portGetStatus(void *drvrData, uint16_t* statusP /* VDRV_STA_* bitfield */ );
uint32_t portWrite(void *drvrData, const void *buf, uint32_t size, Err *errP);
Err portCustomControl(void *drvrData, ...);



Err portGetInfo(struct VdrvPortInfo* info);

#endif