#ifndef _UTIL_H_
#define _UTIL_H_

#include <stdint.h>

#define MAKE_4CC(a,b,c,d)			((((uint32_t)(a)) << 24) | (((uint32_t)(b)) << 16) | (((uint32_t)(c)) << 8) | (((uint32_t)(d)) << 0))
#define F4CC					"%c%c%c%c"
#define C4CC(v)					((v) >> 24) & 0xff, ((v) >> 16) & 0xff, ((v) >> 8) & 0xff, ((v) >> 0) & 0xff

//litle-endian
void writeLE32(uint32_t *dst, uint32_t val);
void writeLE24(uint8_t *dst, uint32_t val);
void writeLE16(uint16_t *dst, uint16_t val);
uint32_t readLE32(const uint32_t *p);
uint32_t readLE24(const uint8_t *p);
uint16_t readLE16(const uint16_t *p);

//big-endian
void writeBE32(uint32_t *dst, uint32_t val);
void writeBE24(uint8_t *dst, uint32_t val);
void writeBE16(uint16_t *dst, uint16_t val);
uint32_t readBE32(const uint32_t *p);
uint32_t readBE24(const uint8_t *p);
uint16_t readBE16(const uint16_t *p);

//switchable-endian
void seSetLittleEndian(bool little);		//else big
void writeSE32(uint32_t *dst, uint32_t val);
void writeSE24(uint8_t *dst, uint32_t val);
void writeSE16(uint16_t *dst, uint16_t val);
uint32_t readSE32(const uint32_t *p);
uint32_t readSE24(const uint8_t *p);
uint16_t readSE16(const uint16_t *p);



#define PALMOS_TIME_OFFSET			2082844800UL

#endif

