#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <stdio.h>
#include "decompress_bin.h"
#include "lz.h"

int main(int argc, char** argv)
{
	uint32_t i, romInRamBase, decompressorBase, inSz = 0, inUsed = 0, outSz;
	uint8_t *in = NULL, *out;
	int c;
	
	if (argc != 3 || argv[1][0] != '0' || argv[1][1] != 'x' || strlen(argv[1]) != 10 || argv[2][0] != '0' || argv[2][1] != 'x' || strlen(argv[2]) != 10) {
		fprintf(stderr, "USAGE: %s 0xABCDEF00 0x22334455 < rom.bin > newrom.bin\n"
							"\t# 0xABCDEF00 is address to decompress to\n"
							"\t# 0x22334455 is address where this code will live\n", argv[0]);
		return -1;
	}
	
	romInRamBase = strtol(argv[1] + 2, NULL, 16);
	decompressorBase = strtol(argv[2] + 2, NULL, 16);
	fprintf(stderr, "ROMinRAM base 0x%08x\n", romInRamBase);
	fprintf(stderr, "Decompressor base 0x%08x\n", decompressorBase);
	
	while ((c = getchar()) != EOF) {
		
		if (inSz == inUsed) {
			
			inSz = (inSz * 9 / 8) + 1;
			in = realloc(in, inSz);
			if (!in)
				abort();
		}
		in[inUsed++] = c;
	}
	
	fprintf(stderr, "READ %u (0x%08x) bytes of ROM\n", inUsed, inUsed);
	out = malloc((uint64_t)inUsed * 257 / 256 + 1);
	if (!out)
		abort();
	
	outSz = lzCompress(in, out, inUsed, 32768, 8);
	fprintf(stderr, "\nPRODUCED %u(0x%08x) compressed bytes\n", outSz, outSz);
	fprintf(stderr, "\nTOTAL SIZE %u(0x%08x)\n", outSz + decompress_bin_len, outSz + decompress_bin_len);
	
	//place values into compressed binary array (assumes LE machine)
	*(uint32_t*)(decompress_bin + 4) += decompressorBase;
	*(uint32_t*)(decompress_bin + 8) = romInRamBase;
	*(uint32_t*)(decompress_bin + 12) = outSz;
	*(uint32_t*)(decompress_bin + 16) = decompress_bin_len;
	
	//write out decompressor
	for (i = 0; i < decompress_bin_len; i++)
		putchar(decompress_bin[i]);
	
	//write out compressed data
	for (i = 0; i < outSz; i++)
		putchar(out[i]);
	
	free(out);
	free(in);
	
	return 0;
}