#ifndef _MAPLE_COMMS_H_
#define _MAPLE_COMMS_H_

#include <stdint.h>



#define MAPLE_CMD_REQ_DEV_NFO				0x01
#define MAPLE_CMD_REX_ETD_NFO				0x02
#define MAPLE_CMD_RST_DEV					0x03
#define MAPLE_CMD_SHTDWN_DEV				0x04
#define MAPLE_RSP_DEV_NFO					0x05
#define MAPLE_RSP_EXTD_NFO					0x06
#define MAPLE_RSP_MAPLE_CMD_ACK				0x07
#define MAPLE_RSP_DATA_XFER					0x08
#define MAPLE_CMD_GET_COND					0x09
#define MAPLE_CMD_GET_MEM_NFO				0x0A
#define MAPLE_CMD_BLK_RD					0x0B
#define MAPLE_CMD_BLK_WR					0x0C
#define MAPLE_CMD_BLK_WR_FINISH				0x0D	//called after each block write to complete it (else next writes will fail)
#define MAPLE_CMD_SET_COND					0x0E
#define MAPLE_CMD_ERROR_CODE				0xFA	//includes word of data: the error
#define MAPLE_CMD_ERROR_ADDR_ERR			0xFB	//flash address error (includes word of data: the err bits)
#define MAPLE_CMD_ERROR_PLZ_RESEND_PACKET	0xFC	//no data
#define MAPLE_CMD_ERROR_MAPLE_CMD_UNKNOWN	0xFD	//no data
#define MAPLE_CMD_ERROR_FUNC_UNKNOWN		0xFE	//no data

#define MAPLE_COMMS_FUNC_CONROLLER			0x01
#define MAPLE_COMMS_FUNC_MEMORY				0x02
#define MAPLE_COMMS_FUNC_DISPLAY			0x04
#define MAPLE_COMMS_FUNC_CLOCK				0x08
#define MAPLE_COMMS_FUNC_MEMORY				0x02

#define MAPLE_COMMS_ERR_WRONG_REPLY_LEN		1
#define MAPLE_COMMS_ERR_CRC_FAIL			2
#define MAPLE_COMMS_ERR_NAK					3

//higher level (returns MAPLE_COMMS_ERR_*)
uint8_t mapleCommsWriteBlock(uint8_t toAddr, uint8_t partition, uint16_t block, const void *data);	//512 bytes
uint8_t mapleCommsReadBlock(uint8_t toAddr, uint8_t partition, uint16_t block, const void** dataP);	//returns pointer to data in our mem. safe to use till u call another api here
uint8_t mapleCommsWriteScreen(uint8_t toAddr, const void *data);	//192 bytes. first byte top bit shows up first
uint8_t mapleCommsReadButtons(uint8_t toAddr, uint8_t *buttonsP); 
uint8_t mapleCommsSetBuzzer(uint8_t toAddr, uint8_t period, uint8_t dutyCy);	//clock to the PWM is always is 1MHz
//month & day is 1-based
uint8_t mapleCommsGetClock(uint8_t toAddr, uint16_t *yearP, uint8_t *monthP, uint8_t *dayP, uint8_t *hrP, uint8_t *minP, uint8_t *secP);
uint8_t mapleCommsSetClock(uint8_t toAddr, uint16_t year, uint8_t month, uint8_t day, uint8_t hr, uint8_t min, uint8_t sec);

//lowest level
void mapleCommsStart(uint8_t cmd, uint8_t from, uint8_t to, uint8_t numExtraWords);
void mapleCommsSendWord(uint32_t word);
void mapleCommsFinish(void);


#endif
