/****************************************************************************
*                                                                           *
*   simulaton program for the evolutionary optimizer:                       *
*   target function is to be included in this source                        *
*   Version 0.2                                                             *
*   1.4.94            (C) Petra Roosen                                      *
*                                                                           *
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define  forever  for(;;)
#define  bool     int
#define  TRUE     1
#define  FALSE    0
#define  max(A,B) (A)<(B)?(B):(A)
#define  min(A,B) (A)<(B)?(A):(B)

typedef  struct
  { double  koeff[5];    /* Koeffizientenmatrix */
    double  dkoeff[5];   /* ... und deren Variationsbandbreite */
    int     Kennzahl;     /* Kennzahl des Datensatzes  */
    int     Mama;         /* Zur Kontrolle, wie Indi geschaffen wurde */
    int     Papa;
    int     Alter;        /* Zum Einbau einer Altersbeschraenkung */
    double  Ergebnis;     /* Zielfunktionswert */
  }
  Paraset;

typedef struct            /* Im Simulator eigentlich ohne Bedeutung */
  {
    char    Name[50];    /* Variablenname */
    double  Wert;         /* Anfangswert, spielt hier keine Rolle */
    double  Ulimit;       /* Untere und obere Definitionsbereichsgrenzen */
    double  Olimit;
  }
  Iniset;


/**** global variables: ****/

Paraset Indi;
int     Parazahl, Runde;
Iniset  Limits[5];
FILE    *infile, *outfile, *flagfile;
char    Transdir[250];
int     sleeptime=1;


/**** function prototypes: ****/

void    main(void);
void    init(void);
bool    empfange(void);
void    rechne(void);
bool    verschicke(void);


/**************************************************************************/
/**************************************************************************/
/******************* Begin of target function determination ***************/

void rechne()  /* Example: Minimal fct. value of a hyper-paraboloid */
{
  double  Ergebnis;
  int     i;


  Ergebnis = 0;
  for (i=0; i<Parazahl; i++)
  {
    Ergebnis += Indi.koeff[i] * Indi.koeff[i];
  }

  Indi.Ergebnis = Ergebnis;
}

/******************** End of target function determination *****************/
/***************************************************************************/
/***************************************************************************/

void main()
{
  bool klappt;

  init();               /* for transfer directory determination only */

  forever
  {
    Runde++;
    klappt = empfange();
    rechne();
    printf("%d. simulator result: %G,          sleep time: %d\n",
           Runde, Indi.Ergebnis, sleeptime);
    klappt = verschicke();
  }
}


void init()
{
  FILE    *fp;
  char    dummy[250];

  printf("\n\n");
  printf("  **************************************************\n");
  printf("  * Simulator module for co-operation with the     *\n");
  printf("  * evolutionary parameter optimizer               *\n");
  printf("  * for general optimization problems              *\n");
  printf("  *                                                *\n");
  printf("  * Shareware version 0.2    (C)3/94  Petra Roosen *\n");
  printf("  **************************************************\n\n");


  /******* Einlesen des Transfer-Directories ******/
  if ( (fp=fopen("strateg.dat","r")) )
    {
      fscanf(fp, "%s", dummy);
      if ( strcmp(dummy, "EPO-0.2") )
      {
        printf("\007Wrong initialization file at the identification header!\n");
        sleep(5);
        exit(0);
      }
      fscanf(fp, "%*s");
      fscanf(fp, "%*s %*s");
      fscanf(fp, "%*s %*d");
      fscanf(fp, "%*s %*d");
      fscanf(fp, "%*s %*d");
      fscanf(fp, "%*s %*d");
      fscanf(fp, "%*s %*d");
      fscanf(fp, "%*s %*s");
      fscanf(fp, "%*s %*s");
      fscanf(fp, "%s %s", dummy, Transdir);
      if ( strcmp(dummy, "transfer_dir") )
      {
        printf("\007Faulty initialization file at \"transfer_dir\"!\n");
        sleep(5);
        exit(0);
      }
      fclose(fp);
    }
}


bool empfange()
{
  int i, gelesen;
  char aktFile[250];


  sprintf(aktFile, "%so2s.msg", Transdir);

  do    /** auf die Existenz des Message-Files warten **/
  {
#ifdef UNIX
    sleep(1);
#else
    _sleep2(400);
#endif
    flagfile = fopen(aktFile, "r");
  }
    while (flagfile == NULL);
  fclose(flagfile);
  remove(aktFile);

  sprintf(aktFile, "%so2s.dat", Transdir);

lies_Daten:
#ifdef UNIX
    sleep(sleeptime);
#else
    _sleep2(sleeptime);
#endif
  infile = fopen(aktFile, "r");

  if (infile == NULL)
    {
      printf("Kein Datenfile vorhanden, obwohl das Message-File gefunden wurde\n");
      printf("Da scheint noch ein anderes Programm in die Fileuebergabe\n");
      printf("zwischen Optimierer und Simulator einzugreifen!!\n");
      printf("Programm endet wegen Fehlerbedingung!\n");
      sleep(5);
      exit(0);
    }

  fscanf(infile, "%*s %*s %d %*s", &Parazahl);
  if (Parazahl == 0)
    {
      printf("Abbruchnachricht vom Optimierer erhalten: Simulator verendet.\n");
      fclose(infile);
      sleep(5);
      remove(aktFile);
      exit(0);
    }

  for (i=0; i<Parazahl; i++)
  {
    gelesen = fscanf(infile, "%s %lf %lf",
                     Limits[i].Name, &(Indi.koeff[i]), &(Indi.dkoeff[i]) );
    if (gelesen != 3)
      {
        fclose(infile);
        sleeptime += 2;
        goto lies_Daten;
      }
    sleeptime--;
    sleeptime = max(sleeptime, 0);
  }
  fscanf(infile, "%*s %d %*s %d %*s %d %*s %d",
         &(Indi.Kennzahl), &(Indi.Mama), &(Indi.Papa), &(Indi.Alter) );
  fclose(infile);

  remove("o2s.dat");
  remove("o2s.msg");

  return TRUE;
}


bool verschicke()
{
  int  i;
  char aktFile[250];


  sprintf(aktFile, "%ss2o.dat", Transdir);
  outfile = fopen(aktFile, "w");

  if (outfile != NULL)
    {
      fprintf(outfile, "Ergebnis zu Kennzahl %d mit %d Parametern\n\n",
              Indi.Kennzahl, Parazahl);
      for (i=0; i<Parazahl; i++)
      {
        fprintf(outfile, "%s %G %G\n",
                Limits[i].Name, Indi.koeff[i], Indi.dkoeff[i]);
      }
      fprintf(outfile, "Mama     %d\n", Indi.Mama);
      fprintf(outfile, "Papa     %d\n", Indi.Papa);
      fprintf(outfile, "Alter    %d\n", Indi.Alter);
      fprintf(outfile, "Ergebnis %G\n", Indi.Ergebnis);
      fclose(outfile);
      sprintf(aktFile, "%ss2o.msg", Transdir);
      flagfile = fopen(aktFile, "w");
      fclose(flagfile);

      return TRUE;
		}
		else
			return FALSE;
}

