// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#define  STRICT
#define  D3D_OVERLOADS


#define __WIN32__

#include <math.h>
#include <float.h>

#include <time.h>
#include <stdio.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>

#include <ddraw.h>
#include <d3d.h>



#include "xgldefines.h"
#include "xglstructs.h"
#include "xgl.h"


#include "colorconv.h"




// Timing utilities
extern __int64 prof_temp;
extern __int64 func_time;

#define prof_start(v) \
	v = 0;

#define prof_enter(v) \
	__asm { _emit 0x0f } \
	__asm { _emit 0x31 } \
	__asm { mov dword ptr prof_temp, eax } \
	__asm { mov dword ptr prof_temp+4, edx } \
	v -= prof_temp;

#define prof_exit(v) \
	__asm { _emit 0x0f } \
	__asm { _emit 0x31 } \
	__asm { mov dword ptr prof_temp, eax } \
	__asm { mov dword ptr prof_temp+4, edx } \
	v += prof_temp;


#define SetVconv() vconv = vconv_lut[depthbuf_lut[Voodoo.dbmode]][Voodoo.origin][Voodoo.texture]

// Logging utilities

#define LOG
//#define VERBOSE_LOG
//#define VERY_VERBOSE_LOG

#ifdef LOG
#define log(text) { if (Settings.logging) { of.open("glide.log", ios::app); of << text << "\n"; of.close(); } }
#else
#define log(test) {}
#endif

#ifdef VERBOSE_LOG
#define vlog(text) { if (Settings.logging) { of.open("glide.log", ios::app); of << text << "\n"; of.close(); } }
#else
#define vlog(test) {}
#endif

#ifdef VERY_VERBOSE_LOG
#define vvlog(text) { if (Settings.logging) { of.open("glide.log", ios::app); of << text << "\n"; of.close(); } }
#else
#define vvlog(test) {}
#endif






extern ofstream of;

extern HRESULT hr;
extern HINSTANCE _hInstance;


extern uint32					_color_format;

extern float					*smul;
extern float					*tmul;
extern uint32					*src_blend_lut;
extern uint32					*blend_caps_lut;
extern uint32					*dst_blend_lut;
extern uint32					*atest_lut;
extern uint32					*atest_caps_lut;

extern sVoodoo					Voodoo;
extern sDX						DX;
extern sSettings				Settings;


#include "Tex.h"
#include "TexList.h"
#include "ExeBuffer.h"


extern TexList					*_texlist;

extern ExeBuffer				*_exebuffer;


#define DEPTH_D     0
#define DEPTH_W		1
#define DEPTH_W_Z16 2
#define DEPTH_W_Z24 3
#define DEPTH_W_Z32 4
#define DEPTH_Z		5
#define DEPTH_MAX	6

extern int depthbuf_lut[5];
extern uint16 yiq_lut[256];

#define TEXTURE				0
#define NO_TEXTURE			1
#define TEXTURE_MODE_MAX	2

extern void (*(vconv_lut[DEPTH_MAX][2][TEXTURE_MODE_MAX]))(const XGLVertex &, D3DTLVERTEX &);

extern XGLCCState colorcombine_lut[XGLCOMBINEFUNC_MAX][XGLCOMBINEFACTOR_MAX][XGLLOCAL_MAX][XGLOTHER_MAX];

extern HFONT fontInUse;
