/* 2004.06.05
****************************************
**  Copyright  (C)  W.ch  1999-2004   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB Host File Module      @CH375  **
**  TC2.0@PC, KC7.0@MCS51             **
****************************************
*/
/* Uļдģ, ӷʽ: ģSPIʱ+ѯ */
/* MCS-51ƬCʾ */
/* ΪʹUļдģʹUļӳ,ռýٵĵƬԴ,ʹ89C51Ƭ */
/* ֽΪλUļд,ƬRAMֻҪʮֽ,ҪⲿRAM */

#include <reg51.h>
#include <absacc.h>
#include <string.h>
#include <stdio.h>

#define MAX_PATH_LEN			32		/* ·,бָܷСԼ·00H,CH375ģֵֵ֧62,Сֵ13 */
#include "..\CH375HM.H"

/* ·ӷʽ,4SPI,SCSɹSPI
   Ƭ    ģ
    P1.0  =  SDI
    P1.1  =  SDO
    P1.2  =  SCK
    P1.3  =  SCS
      =  INT#  ͨSPIѯģINT#״̬
*/
sbit	P10					=	P1^0;
sbit	P11					=	P1^1;
sbit	P12					=	P1^2;
sbit	P13					=	P1^3;
#define	CH375HM_SPI_SDI			P10		/* ٶCH375ģSDIӵƬP10 */
#define	CH375HM_SPI_SDO			P11		/* ٶCH375ģSDOӵƬP11 */
#define	CH375HM_SPI_SCK			P12		/* ٶCH375ģSCKӵƬP12 */
#define	CH375HM_SPI_SCS			P13		/* ٶCH375ģSCSӵƬP13 */

CMD_PARAM	idata	mCmdParam;			/* Ĭ¸ýṹռ60ֽڵRAM,޸MAX_PATH_LEN,޸Ϊ32ʱ,ֻռ32ֽڵRAM */
unsigned char		TempLength;			/* ʱеݳ,ԭļеڶζֽ */
unsigned char idata	TempBuffer[20];		/* ʱ,Ŵԭļж */

sbit	LED_OUT		=	P1^4;			/* P1.4 ͵ƽLEDʾ,ڼʾĽ */

/* ԺΪλʱ,24MHzʱ */
void	mDelaymS( unsigned char delay )
{
	unsigned char	i, j, c;
	for ( i = delay; i != 0; i -- ) {
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
	}
}

/* һֽݸCH375ģ,ͬʱһֽ,SPIģʽ0ʽ(SPI_SCKĬΪ0) */
unsigned char	mSpiExchange( unsigned char c )
{
	unsigned char	i, d;
	d = 0;
	CH375HM_SPI_SCK = 0;
	for ( i = 8; i != 0; i -- ) {  /* 8λ */
		if ( c & 0x80 ) CH375HM_SPI_SDI = 1;  /* ģSDI */
		else CH375HM_SPI_SDI = 0;
		d <<= 1;
		if ( CH375HM_SPI_SDO ) d ++;  /* ģSDOΪߵƽλ1 */
		CH375HM_SPI_SCK = 1;  /* SPIʱأģݲ */
		c <<= 1;
		CH375HM_SPI_SCK = 0;
	}
/* ƬϿʹmSpiExchangeӳִʱ10uSǴ1MHzӲSPIӿڣô˴Ӧüʱȷӳڴ10uS */
/* ģ鵥ƬΪ18.432MHzģ鵥ƬƵʼӱôʱҪӦüһ */
/* ͨMCS51ƬģSPIӿڽκʱ */
	return( d );
}

#if 0
/* һֽݸCH375ģ,ͬʱһֽ,SPIģʽ3ʽ(SPI_SCKĬΪ1) */
unsigned char	mSpiExchange3( unsigned char c )
{
	unsigned char	i, d;
	d = 0;
	for ( i = 8; i != 0; i -- ) {   /* 8λ */
		CH375HM_SPI_SCK = 0;
		if ( c & 0x80 ) CH375HM_SPI_SDI = 1;  /* ģSDI */
		else CH375HM_SPI_SDI = 0;
		d <<= 1;
		if ( CH375HM_SPI_SDO ) d ++;  /* ģSDOΪߵƽλ1 */
		CH375HM_SPI_SCK = 1;  /* SPIʱأģݲ */
		c <<= 1;
	}
/* ʱҪͬmSpiExchangeӳSPIģʽ0 */
	return( d );
}
#endif

/* ִ */
unsigned char	ExecCommand( unsigned char cmd, unsigned char len )
/* ,ز״̬,ͷزCMD_PARAMṹ */
{
	unsigned char		i, j, status;
	CH375HM_SPI_SCS = 0;  /* SPIƬѡ */
	mSpiExchange( cmd );  /* д */
	mSpiExchange( len );  /* дĳ */
	if ( len ) {  /* в */
		for ( i = 0; i != len; i ++ ) mSpiExchange( mCmdParam.Other.mBuffer[ i ] );  /* д */
	}
	CH375HM_SPI_SCS = 1;  /* SPIƬѡ */
	mDelaymS( 1 );  /* ʱС5uS */
	while ( 1 ) {  /* ݴ,ֱɲ˳ */
//		while ( CH375HM_INT_WIRE );  /* ȴģɲ͵ƽж,ѼⷽʽǶģINT#źŽ½رؼ */
		CH375HM_SPI_SCS = 0;  /* SPIƬѡ */
		status = mSpiExchange( 0xFF );  /* д0xFFΪЧ(Ӧдֵ),ģ״̬ */
		if ( status == 0xFF ) {  /* ģδ,ҲINT#ûжϲ */
			CH375HM_SPI_SCS = 1;  /* SPIƬѡ */
			mDelaymS( 1 );
			continue;  /* ȴģɲ */
		}
		if ( status == ERR_SUCCESS ) {  /* ɹ */
			i = mSpiExchange( 0 );  /* ؽݵĳ,д0û,κֵ */
			if ( i ) {  /* н */
				j = 0;
				do {  /* ʹdo+whileṹΪЧʸfor */
					mCmdParam.Other.mBuffer[ j ] = mSpiExchange( 0 );  /* սݲ浽ṹ,д0û */
					j ++;
				} while ( -- i );
			}
			CH375HM_SPI_SCS = 1;  /* SPIƬѡ */
			break;  /* ɹ */
		}
#if 0
/* ҪΪλдļͱ봦USB_INT_DISK_READ/USB_INT_DISK_WRITEɲοSPI5дExecCommandӳ */
		else if ( status == USB_INT_DISK_READ ) {  /* ڴU̶ݿ,ݶ */
			i = 64;
			do {
				*buffer = mSpiExchange( 0 );  /* ν64ֽڵ */
				buffer ++;  /* յݱ浽ⲿ */
			} while ( -- i );
		}
		else if ( status == USB_INT_DISK_WRITE ) {  /* Uдݿ,д */
			i = 64;
			do {
				mSpiExchange( *buffer );  /* η64ֽڵ */
				buffer ++;  /* ͵ⲿ */
			} while ( -- i );
		}
		else if ( status == USB_INT_DISK_RETRY ) {  /* дݿʧ,Ӧ޸Ļָ */
			i = mSpiExchange( 0 );  /* ģʽΪظָֽĸ8λ,Сģʽôյǻظָֽĵ8λ */
			status = mSpiExchange( 0 );  /* ģʽΪظָֽĵ8λ,Сģʽôյǻظָֽĸ8λ */
			buffer -= ( (unsigned short)i << 8 ) + status;  /* ǴģʽµĻظָ,Сģʽ,Ӧ( (unsigned short)status << 8 ) + i */
		}
#endif
		else {  /* ʧ */
			CH375HM_SPI_SCS = 1;  /* SPIƬѡ */
			if ( status == ERR_DISK_DISCON || status == ERR_USB_CONNECT ) mDelaymS( 100 );  /* U̸ոӻ߶Ͽ,Ӧʱʮٲ */
			break;  /* ʧܷ */
		}
		CH375HM_SPI_SCS = 1;  /* SPIƬѡ */
	}
	return( status );
}

/* ״̬,ʾ벢ͣ */
void	mStopIfError( unsigned char iError )
{
	unsigned char	led;
	if ( iError == ERR_SUCCESS ) return;  /* ɹ */
	printf( "Error: %02X\n", (unsigned short)iError );  /* ʾ */
	led=0;
	while ( 1 ) {
		LED_OUT = led&1;  /* LED˸ */
		mDelaymS( 100 );
		led^=1;
	}
}

/* Ϊprintfgetkeyʼ */
void	mInitSTDIO( )
{
	SCON = 0x50;
	PCON = 0x80;
	TMOD = 0x20;
	TH1 = 0xf3;  /* 24MHz, 9600bps */
	TR1 = 1;
	TI = 1;
}

main( ) {
	unsigned char	i;
	unsigned short	count;
	unsigned char	*pStr;
	LED_OUT = 0;  /* LEDһʾ */
	mDelaymS( 250 );  /* ʱ500,CH375ģϵҪ500ҵĸλʱ */
	mDelaymS( 250 );
	LED_OUT = 1;
	mInitSTDIO( );
	printf( "Start\n" );
	while ( 1 ) {  /* ѭ */
		printf( "Wait\n" );
		while ( 1 ) {  /* ʹòѯʽUǷ */
			i = ExecCommand( CMD_QueryStatus, 0 );  /* ѯǰģ״̬ */
			mStopIfError( i );
			if ( mCmdParam.Status.mDiskStatus >= DISK_CONNECT ) break;  /* UѾ */
			mDelaymS( 100 );  /* ڴдUʱٲѯ,ûбҪһֱͣزѯ,õƬ,û¿ʱȴһٲѯ */
		}
		mDelaymS( 200 );  /* ʱ,ѡ,еUSB洢Ҫʮʱ */
		LED_OUT = 0;  /* LED */
/* UǷ׼,U̲Ҫһ,ĳЩU̱Ҫִһܹ */
		for ( i = 0; i < 5; i ++ ) {
			mDelaymS( 100 );
			printf( "Ready ?\n" );
			if ( ExecCommand( CMD_DiskReady, 0 ) == ERR_SUCCESS ) break;  /* ѯǷ׼ */
		}
/* ȡԭļ */
		printf( "Open\n" );
		strcpy( mCmdParam.Open.mPathName, "\\C51\\CH375HFT.C" );  /* ļ,ļC51Ŀ¼ */
		i = ExecCommand( CMD_FileOpen, MAX_PATH_LEN );  /* ļ,Ϊֵ,ʡټ */
		TempLength = 0;
		if ( i == ERR_MISS_DIR || i == ERR_MISS_FILE ) {  /* ERR_MISS_DIR˵ûҵC51Ŀ¼,ERR_MISS_FILE˵ûҵļ */
			printf( "Ҳԭļ/C51/CH375HFT.C\n" );
		}
		else {  /* ҵļ\C51\CH375HFT.C߳ */
			mStopIfError( i );
			mCmdParam.ByteRead.mByteCount = 6;  /* 6ֽ, ζдĳȲܳ sizeof( mCmdParam.ByteWrite.mByteBuffer ) */
			i = ExecCommand( CMD_ByteRead, 1 );  /* ֽΪλȡ */
			mStopIfError( i );
			printf( "ļжǰ6ַ[" );
			for ( i=0; i!=mCmdParam.ByteRead.mByteCount; i++ ) printf( "%C", mCmdParam.ByteRead.mByteBuffer[i] );
			printf( "]\n" );
			if ( mCmdParam.ByteRead.mByteCount<6 ) printf( "Ѿļĩβ\n" );
			if ( mCmdParam.ByteRead.mByteCount==6 ) {  /* δļĩβ */
				mCmdParam.ByteRead.mByteCount = 20;  /* ٶ20ֽ, ζдĳȲܳ sizeof( mCmdParam.ByteWrite.mByteBuffer ) */
				i = ExecCommand( CMD_ByteRead, 1 );  /* ֽΪλȡ,Ÿղŵ */
				mStopIfError( i );
				TempLength = mCmdParam.ByteRead.mByteCount;  /* ڶζֽ */
				memcpy( TempBuffer, mCmdParam.ByteRead.mByteBuffer, TempLength );  /* ݴڶζԱдļ */
				printf( "ļжĵ6ַʼ[" );
				for ( i=0; i!=mCmdParam.ByteRead.mByteCount; i++ ) printf( "%C", mCmdParam.ByteRead.mByteBuffer[i] );
				printf( "]\n" );
				if ( mCmdParam.ByteRead.mByteCount<20 ) printf( "Ѿļĩβ\n" );
			}
			printf( "Close\n" );
			mCmdParam.Close.mUpdateLen = 0;
			i = ExecCommand( CMD_FileClose, 1 );  /* رļ */
			mStopIfError( i );
		}
/* ļ */
		printf( "Create\n" );
/*		strcpy( mCmdParam.Create.mPathName, "\\NEWFILE.TXT" );*/
		strcpy( mCmdParam.Create.mPathName, "\\˫Ұ.TXT" );  /* ļ,ڸĿ¼ */
		i = ExecCommand( CMD_FileCreate, MAX_PATH_LEN );  /* ½ļ,ļѾɾ½ */
		mStopIfError( i );
		printf( "ByteLocate\n" );
//		mCmdParam.ByteLocate.mByteOffset = 0;  /* ƶļͷ,»صļͷ,Աдݸԭ */
//		ExecCommand( CMD_ByteLocate, 4 );  /* ֽΪλƶļָ */
//		mCmdParam.ByteLocate.mByteOffset = 0xFFFFFFFF;  /* ƶļβ,CMD_FileOpenļ,׷ݵѴļĩβ */
//		ExecCommand( CMD_ByteLocate, 4 );  /* ֽΪλƶļָ */
		printf( "Write\n" );
		pStr = "Note: \xd\xaֽΪλUļд,ƬֻҪмʮֽڵRAM,ҪⲿRAM,\xd\xaȴ/C51/CH375HFT.Cļжǰ20ַ,Ȼд˵һ\xd\xa";
		count = strlen( pStr );  /* ׼дݵܳ */
		while ( count ) {  /* ϴ,ֶд */
			if ( count < sizeof( mCmdParam.ByteWrite.mByteBuffer ) ) i = count;  /* ֻʣһЩҪд */
			else i = sizeof( mCmdParam.ByteWrite.mByteBuffer );  /* ݽ϶,ֶд */
			count -= i;  /*  */
			memcpy( mCmdParam.ByteWrite.mByteBuffer, pStr, i );  /* ׼дݵṹ,ԴݿADC,Գռ˵Ϣ */
			pStr += i;
			mCmdParam.ByteWrite.mByteCount = i;  /* ָдֽ */
			i = ExecCommand( CMD_ByteWrite, 1+i );  /* ֽΪλļд */
			mStopIfError( i );
		}
//		mCmdParam.ByteWrite.mByteCount = 0;  /* ָд0ֽ,ˢļĳ,עֽΪ0ôCMD_ByteWriteֻдݶ޸ļ */
//		ExecCommand( CMD_ByteWrite, 1 );  /* ֽΪλļд,Ϊ0ֽд,ֻڸļĳ,׶дݺ,ְ취ļ */
		memcpy( mCmdParam.ByteWrite.mByteBuffer, TempBuffer, TempLength );
		mCmdParam.ByteWrite.mByteCount = TempLength;  /* ԭļе20ֽڵӵļĩβ */
		i = ExecCommand( CMD_ByteWrite, 1+TempLength );  /* ֽΪλļд */
		mStopIfError( i );
		printf( "Close\n" );
		mCmdParam.Close.mUpdateLen = 1;  /* Զļ,ֽΪλļдݺ,û0ȵCMD_ByteWriteļ,ôڹرļʱģԶļ */
		i = ExecCommand( CMD_FileClose, 1 );  /* رļ,ֽΪλļд(׷)ݺ,ļرļ */
		mStopIfError( i );

/* ȴU̶Ͽ */
		printf( "Take_out\n" );
		while ( 1 ) {  /* ʹòѯʽUǷϿ */
			i = ExecCommand( CMD_QueryStatus, 0 );  /* ѯǰģ״̬ */
			mStopIfError( i );
			if ( mCmdParam.Status.mDiskStatus <= DISK_DISCONNECT ) break;  /* UѾϿ */
			mDelaymS( 100 );  /* ûбҪһֱͣزѯ,õƬ,û¿ʱȴһٲѯ */
		}
		LED_OUT = 1;  /* LED */
	}
}
