// DMAGETI.C
// This program installs the DMA sub-system and calls
// the function dmaGetIRQNumber to determine the IRQ
// setting of the Voice Master or Sound Master II.

#include <stdio.h>
#include "cvxdigi.h"

extern _dmaDevice;

VOID main ( VOID )
{
   WORD dmaIRQNumber;
   WORD initError;
   WORD portAddress;

   // Initialize DMA. Setting each parameter to _AUTODETECT
   // causes dmaInit to perform a search for the Port,
   // DMA channel, and IRQ setting respectively.
   initError = dmaInit( _AUTODETECT, _AUTODETECT, _AUTODETECT,
                        &portAddress );

   // If the variable _dmaDevice equals 0 then the DMA
   // sub-system was not initialized correctly.
   if( _dmaDevice == 0 )
      printf( "ERROR = %d : dmaInit failed\n", initError );
   else
   {
      // Call function to to get the DMA IRQ setting 
      // of the Voice Master or Sound Master II.
      dmaGetIRQNumber( &dmaIRQNumber );

      // Display DMA IRQ number to the screen.
      printf("DMA using IRQ %x\n", dmaIRQNumber );

      // Unitialize the DMA sub-system.
      if( dmaUninit() )
      {
         printf("DMA uninit failure.\n");
      }
   }
}


