
{===========================================================================}
{ Konzept        : DATA BECKERs Sound Blaster Superbuch                     }
{ Programm Scope : Ein Echtzeit-Oszilloskop fr die Sound-Blaster-Karte.    }
{                  Die vom DSP (Digital Sound Processor) gelesenen Werte    }
{                  werden in grafische Darstellung umgesetzt.               }
{===========================================================================}
{ Autor          : Arthur Burda                                             }
{ Dateiname      : SCOPE.PAS                                                }
{ entwickelt am  : 29.08.1993                                               }
{ letztes Update : 01.09.1993                                               }
{ Version        : 1.01                                                     }
{ Compiler       : Turbo bzw. Borland Pascal 7.0 (wegen Megagraphics        }
{                  Toolbox)                                                 }
{===========================================================================}

PROGRAM Scope;

{---------------------------------------------------------------------------}
{ Compiler-Schalter                                                         }
{---------------------------------------------------------------------------}

{$B-}                         { Kurzschluverfahren fr boolesche Ausdrcke }
{$D-}                                        { keine Debugger-Informationen }
{$F+}                                                { FAR-Aufrufe erlauben }
{$G+}                                                   { 286-Code erzeugen }
{$I-}                                                   { keine I/O-Prfung }
{$R-}                                               { keine Bereichsprfung }
{$S-}                                                  { keine Stackprfung }
{$X+}                    { Behandlung von Funktionen wie Prozeduren mglich }

USES GRAPH, MGDrv, MGEvents, MGSystem, SBDrv, SBDSP;

CONST
  Max = 16;                             { max. Anzahl der Schwingungsbalken }

  Thickness : Byte = 12;                      { Dicke der Schwingungsbalken }

VAR
  GrSystem  : PMGSystem;               { Zeiger auf das Grafiksystem-Objekt }
  EvHandler : PMGEventHandler;               { Zeiger auf den Event-Handler }
  Event     : TEvent;                                   { Ereignis-Variable }
  Count     : Word;                                                { Zhler }
  DSPValues : ARRAY[1..Max] OF Byte;                   { aktuelle DSP-Werte }

{===========================================================================}
{ Prozedur Read_DSP: Liest die DSP-Werte in das Current-Array ein.          }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE Read_DSP;

BEGIN
  FOR Count := 1 TO Max DO
    BEGIN
      WriteDSP(dsp_ReadDirectUnpack);
      DSPValues[Count] := Abs(ReadDSP-128);
    END;
END;

{===========================================================================}
{ Prozedur Draw_Scope: Zeichnet das Echtzeit-Oszilloskop.                   }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE Draw_Scope;

BEGIN
  FOR Count := 1 TO Max DO
    BEGIN
      IF Count <= 8 THEN
        GrSystem^.SetFillStyle(SolidFill, Count)
      ELSE
        GrSystem^.SetFillStyle(SolidFill, 17-Count);
      GrSystem^.Bar(10, 80+((Count-1)*20), 10+(DSPValues[Count]*4),
        60+Thickness+(Count*20));
      GrSystem^.SetFillStyle(SolidFill, 0);
      GrSystem^.Bar(10+(DSPValues[Count]*4), 80+((Count-1)*20),
        GrSystem^.GetMaxX-100, 60+Thickness+(Count*20));
    END;
END;

{---------------------------------------------------------------------------}
{ Hauptprogramm                                                             }
{---------------------------------------------------------------------------}

BEGIN
  GrSystem := New(PMGSystem, Init(gm_VGA_640x480x16, ''));
  EvHandler := New(PMGEventHandler, Init(TRUE));
  IF MouseEvents THEN
    EvHandler^.HideMouse;
  FOR Count := 1 TO MaxColors DO
    GrSystem^.SetPalette(Count, Count);
  FOR Count := 1 TO 8 DO
    GrSystem^.SetRGBPalette(Count, 0, 10+((Count-1)*7), 0);
  GrSystem^.SetRGBPalette(9, 50, 50, 50);
  GrSystem^.SetColor(9);
  GrSystem^.Rectangle(0, 0, GrSystem^.GetMaxX, GrSystem^.GetMaxY);
  GrSystem^.Line(0, 20, GrSystem^.GetMaxX, 20);
  GrSystem^.Line(0, GrSystem^.GetMaxY-20, GrSystem^.GetMaxX,
    GrSystem^.GetMaxY-20);
  GrSystem^.OutTextXY(16, 7, 'DATA BECKERs Sound Blaster Superbuch * '+
    'Realtime Scope * (c) 1993 by A. Burda');
  GrSystem^.OutTextXY(16, GrSystem^.GetMaxY-14, 'ESC = Realtime Scope '+
    'beenden  '#24#25' = Balkendicke ndern  R/G/B = Farbe ndern');
  REPEAT
    Read_DSP;
    Draw_Scope;
    EvHandler^.GetKeyEvent(Event);
    IF Event.KeyCode = kbUp THEN
      IF Thickness < 19 THEN
        Inc(Thickness);
    IF Event.KeyCode = kbDown THEN
      IF Thickness > 1 THEN
        BEGIN
          GrSystem^.SetFillStyle(SolidFill, 0);
          FOR Count := 1 TO Max DO
            GrSystem^.Bar(10, 60+Thickness+((Count-1)*20),
              GrSystem^.GetMaxX-100, 60+Thickness+(Count*20));
          Dec(Thickness);
        END;
    IF UpCase(Event.CharCode) = 'R' THEN
      FOR Count := 1 TO 8 DO
        GrSystem^.SetRGBPalette(Count, 10+((Count-1)*7), 0, 0);
    IF UpCase(Event.CharCode) = 'G' THEN
      FOR Count := 1 TO 8 DO
        GrSystem^.SetRGBPalette(Count, 0, 10+((Count-1)*7), 0);
    IF UpCase(Event.CharCode) = 'B' THEN
      FOR Count := 1 TO 8 DO
        GrSystem^.SetRGBPalette(Count, 0, 0, 10+((Count-1)*7));
  UNTIL Event.KeyCode = kbEsc;
  Dispose(EvHandler, Done);
  Dispose(GrSystem, Done);
END.
