;----------------------------------------
;	EQUATES USED BY POST AND BIOS	:
;----------------------------------------

MODEL_BYTE	EQU	0FCH		; SYSTEM MODEL BYTE
SUB_MODEL_BYTE	EQU	002H		; SYSTEM SUB-MODEL TYPE
BIOS_LEVEL	EQU	000H		; BIOS REVISION LEVEL
RATE_UPPER	EQU	0F780H		; UPPER LIMIT + 13%
RATE_LOWER	EQU	0F9FDH		; LOWER LIMIT - 20%

;--------- 8042 KEYBOARD INTERFACE AND DIAGNOSTIC CONTROL REGISTERS ------------
PORT_A		EQU	060H		; 8042 KEYBOARD SCAN CODE/CONTROL PORT
PORT_B		EQU	061H		; PORT B READ/WRITE DIAGNOSTIC REGISTER
RAM_PAR_ON	EQU	11110011B	; AND MASK FOR PARITY CHECKING ENABLE ON
RAM_PAR_OFF	EQU	00001100B	; OR MASK FOR PARITY CHECKING ENABLE OFF
PARITY_ERR	EQU	11000000B	; R/W MEMORY - I/O CHANNEL PARITY ERROR
GATE2		EQU	00000001B	; TIMER 2 INPUT GATE CLOCK BIT
SPK2		EQU	00000010B	; SPEAKER OUTPUT DATA ENABLE BIT
REFRESH_BIT	EQU	00010000B	; REFRESH TEST BIT
OUT2		EQU	00100000B	; SPEAKER TIMER OUT2 INPUT BIT
IO_CHECK	EQU	01000000B	; I/O (MEMORY) CHECK OCCURRED BIT MASK
PARITY_CHECK	EQU	10000000B	; MEMORY PARITY CHECK OCCURRED BIT MASK
STATUS_PORT	EQU	064H		; 8042 STATUS PORT
OUT_BUF_FULL	EQU	00000001B	;   0 = +OUTPUT BUFFER FULL
INPT_BUF_FULL	EQU	00000010B	;   1 = +INPUT BUFFER FULL
SYS_FLAG	EQU	00000100B	;   2 = -SYSTEM FLAG -POST/-SELF TEST
CMD_DATA	EQU	00001000B	;   3 = -COMMAND/+DATA
KYBD_INH	EQU	00010000B	;   4 = +KEYBOARD INHIBITED
TRANS_TMOUT	EQU	00100000B	;   5 = +TRANSMIT TIMEOUT
RCV_TMOUT	EQU	01000000B	;   6 = +RECEIVE TIME OUT
PARITY_EVEN	EQU	10000000B	;   7 = +PARITY IS EVEN

;--------- 8042 INPUT PORT BIT DEFINITION SAVED IN @MFG_TST --------------------
BASE_MEM8	EQU	00001000B	; BASE PLANAR R/W MEMORY EXTENSION 640/X
BASE_MEM	EQU	00010000B	; BASE PLANAR R/W MEMORY SIZE 256/512
MFG_LOOP	EQU	00100000B	; LOOP POST JUMPER BIT FOP MANUFACTURING
DSP_JMP 	EQU	01000000B	; DISPLAY TYPE SWITCH JUMPER BIT
KEY_BD_INHIB	EQU	10000000B	; KEYBOARD INHIBIT SWITCH BIT

;--------- 8042 COMMANDS -------------------------------------------------------
WRITE_8042_LOC	EQU	060H		; WRITE 8042 COMMAND BYTE
SELF_TEST	EQU	0AAH		; 8042 SELF TEST
INTR_FACE_CK	EQU	0ABH		; CHECK 8042 INTERFACE COMMAND
DIS_KBD 	EQU	0ADH		; DISABLE KEYBOARD COMMAND
ENA_KBD 	EQU	0AEH		; ENABLE KEYBOARD COMMAND
READ_8042_INPUT EQU	0C0H		; READ 8042 INPUT PORT
DISABLE_BIT20	EQU	0DDH		; DISABLE ADDRESS LINE BIT 20
ENABLE_BIT20	EQU	0DFH		; ENABLE ADDRESS LINE BIT 20
KYBD_CLK_DATA	EQU	0E0H		; GET KEYBOARD CLOCK AND DATA COMMAND
SHUT_CMD	EQU	0FEH		; CAUSE A SHUTDOWN COMMAND
KYBD_CLK	EQU	001H		; KEYBOARD CLOCK BIT 0

;---------- KEYBOARD/LED COMMANDS ----------------------------------------------
KB_RESET	EQU	0FFH		; SELF DIAGNOSTIC COMMAND
KB_RESEND	EQU	0FEH		; RESEND COMMAND
KB_MAKE_BREAK	EQU	0FAH		; TYPAMATIC COMMAND
KB_ENABLE	EQU	0F4H		; KEYBOARD ENABLE
KB_TYPA_RD	EQU	0F3H		; TYPAMATIC RATE/DELAY COMMAND
KB_READ_ID	EQU	0F2H		; READ KEYBOARD ID COMMAND
KB_ECHO 	EQU	0EEH		; ECHO COMMAND
LED_CMD 	EQU	0EDH		; LED WRITE COMMAND

;---------- 8042 KEYBOARD RESPONSE ---------------------------------------------
KB_OVER_RUN	EQU	0FFH		; OVER RUN SCAN CODE
KB_RESEND	EQU	0FEH		; RESEND REQUEST
KB_ACK		EQU	0FAH		; ACKNOWLEDGE FROM TRANSMISSION
KB_BREAK	EQU	0F0H		; KEYBOARD BREAK CODE
KB_OK		EQU	0AAH		; RESPONSE FROM SELF DIAGNOSTIC

;---------- KEYBOARD SCAN CODES ------------------------------------------------
NUM_KEY 	EQU	69		; SCAN CODE FOR  NUMBER LOCK KEY
SCROLL_KEY	EQU	70		; SCAN CODE FOR  SCROLL LOCK KEY
ALT_KEY 	EQU	56		; SCAN CODE FOR  ALTERNATE SHIFT KEY
CTL_KEY 	EQU	29		; SCAN CODE FOR  CONTROL KEY
CAPS_KEY	EQU	58		; SCAN CODE FOR  SHIFT LOCK KEY
DEL_KEY 	EQU	83		; SCAN CODE FOR  DELETE KEY
INS_KEY 	EQU	82		; SCAN CODE FOR  INSERT KEY
LEFT_KEY	EQU	42		; SCAN CODE FOR  LEFT SHIFT
RIGHT_KEY	EQU	54		; SCAN CODE FOR  RIGHT SHIFT
SYS_KEY 	EQU	84		; SCAN CODE FOR  SYSTEM KEY

;---------- ENHANCED KEYBOARD SCAN CODES ---------------------------------------
ID_1		EQU	0ABH		; 1ST ID CHARACTER FOR KBX
ID_2		EQU	041H		; 2ND ID CHARACTER FOR KBX
ID_2A		EQU	054H		; ALTERNATE 2ND ID CHAR FOR KBX
F11_M		EQU	87		; F11 KEY MAKE
F12_M		EQU	88		; F12 KEY MAKE
MC_E0		EQU	224		; GENERAL MARKER CODE
MC_E1		EQU	225		; PAUSE KEY MARKER CODE
PAGE
;---------- FLAG EQUATES WITHIN  @KB_FLAG --------------------------------------
RIGHT_SHIFT	EQU	00000001B	; RIGHT SHIFT KEY DEPRESSED
LEFT_SHIFT	EQU	00000010B	; LEFT SHIFT KEY DEPRESSED
CTL_SHIFT	EQU	00000100B	; CONTROL SHIFT KEY DEPRESSED
ALT_SHIFT	EQU	00001000B	; ALTERNATE SHIFT KEY DEPRESSED
SCROLL_STATE	EQU	00010000B	; SCROLL LOCK STATE HAS BEEN TOGGLED
NUM_STATE	EQU	00100000B	; NUM LOCK STATE HAS BEEN TOGGLED
CAPS_STATE	EQU	01000000B	; CAPS LOCK STATE HAS BEEN TOGGLED
INS_STATE	EQU	10000000B	; INSERT STATE IS ACTIVE

;---------- FLAG EQUATES WITHIN  @KB_FLAG_1 ------------------------------------
L_CTL_SHIFT	EQU	00000001B	; LEFT CTL KEY DOWN
L_ALT_SHIFT	EQU	00000010B	; LEFT ALT KEY DOWN
SYS_SHIFT	EQU	00000100B	; SYSTEM KEY DEPRESSED AND HELD
HOLD_STATE	EQU	00001000B	; SUSPEND KEY HAS BEEN TOGGLED
SCROLL_SHIFT	EQU	00010000B	; SCROLL LOCK KEY IS DEPRESSED
NUM_SHIFT	EQU	00100000B	; NUM LOCK KEY IS DEPRESSED
CAPS_SHIFT	EQU	01000000B	; CAPS LOCK KEY IS DEPRESSED
INS_SHIFT	EQU	10000000B	; INSERT KEY IS DEPRESSED

;---------- FLAGS EQUATES WITHIN  @KB_FLAG_2 -----------------------------------
KB_LEDS 	EQU	00000111B	; KEYBOARD LED STATE BITS
;		EQU	00000001B	; SCROLL LOCK INDICATOR
;		EQU	00000010B	; NUM LOCK INDICATOR
;		EQU	00000100B	; CAPS LOCK INDICATOR
;		EQU	00001000B	; RESERVED (MUST BE ZERO)
KB_FA		EQU	00010000B	; ACKNOWLEDGMENT RECEIVED
KB_FE		EQU	00100000B	; RESEND RECEIVED FLAG
KB_PR_LED	EQU	01000000B	; MODE INDICATOR UPDATE
KB_ERR		EQU	10000000B	; REYBOARD TRANSMIT ERROR FLAG

;---------- FLAGS EQUATES WITHIN  @KB_FLAG_3 -----------------------------------
LC_E1		EQU	00000001B	; LAST CODE WAS THE E1 HIDDEN CODE
LC_E0		EQU	00000010B	; LAST CODE WAS THE E0 HIDDEN CODE
R_CTL_SHIFT	EQU	00000100B	; RIGHT CTL KEY DOWN
R_ALT_SHIFT	EQU	00001000B	; RIGHT ALT KEY DOWN
GRAPH_ON	EQU	00001000B	; ALT GRAPHICS KEY DOWN (WT ONLY)
KBX		EQU	00010000B	; ENHANCED KEYBOARD INSTALLED
SET_NUM_LK	EQU	00100000B	; FORCE NUM LOCK IF READ ID AND KBX
LC_AB		EQU	01000000B	; LAST CHARACTER WAS FIRST ID CHARACTER
RD_ID		EQU	10000000B	; DOING A READ ID (MUST BE BIT0)
PAGE
;----------------------------------------
;	CMOS EQUATES FOR THIS SYSTEM	:
;-------------------------------------------------------------------------------
CMOS_PORT	EQU	070H		; I/O ADDRESS OF CMOS ADDRESS PORT
CMOS_DATA	EQU	071H		; I/O ADDRESS OF CMOS DATA PORT
NMI		EQU	10000000B	; DISABLE NMI INTERRUPTS MASK -
					;  HIGH BIT OF CMOS LOCATION ADDRESS

;---------- CMOS TABLE LOCATION ADDRESS'S ## -----------------------------------
CMOS_SECONDS	EQU	000H		; SECONDS
CMOS_SEC_ALARM	EQU	001H		; SECONDS ALARM  ## NOTE:  ALL LOCATIONS
CMOS_MINUTES	EQU	002H		; MINUTES	      | IN THE CMOS AREA
CMOS_MIN_ALARM	EQU	003H		; MINUTES ALARM       | ARE IBM USE ONLY
CMOS_HOURS	EQU	004H		; HOURS 	      | AND  SUBJECT  TO
CMOS_HR_ALARM	EQU	005H		; HOURS ALARM	      | CHANGE. ONLY THE
CMOS_DAY_WEEK	EQU	006H		; DAY OF THE WEEK     | POST & BIOS CODE
CMOS_DAY_MONTH	EQU	007H		; DAY OF THE MONTH    | SHOULD	DIRECTLY
CMOS_MONTH	EQU	008H		; MONTH 	      | ACCESS LOCATIONS
CMOS_YEAR	EQU	009H		; YEAR (TWO DIGITS)   | IN CMOS STORAGE.
CMOS_REG_A	EQU	00AH		; STATUS REGISTER A   '-----------------
CMOS_REG_B	EQU	00BH		; STATUS REGISTER B  ALARM
CMOS_REG_C	EQU	00CH		; STATUS REGISTER C  FLAGS
CMOS_REG_D	EQU	00DH		; STATUS REGISTER D  BATTERY
CMOS_DIAG	EQU	00EH		; POST DIAGNOSTIC STATUS RESULTS BYTE
CMOS_SHUT_DOWN	EQU	00FH		; SHUTDOWN STATUS COMMAND BYTE
CMOS_DISKETTE	EQU	010H		; DISKETTE DRIVE TYPE BYTE	      ;
;		EQU	011H		; - RESERVED			      ;C
CMOS_DISK	EQU	012H		; FIXED DISK TYPE BYTE		      ;H
;		EQU	013H		; - RESERVED			      ;E
CMOS_EQUIP	EQU	014H		; EQUIPMENT WORD LOW BYTE	      ;C
CMOS_B_M_S_LO	EQU	015H		; BASE MEMORY SIZE - LOW BYTE (X1024) ;K
CMOS_B_M_S_HI	EQU	016H		; BASE MEMORY SIZE - HIGH BYTE	      ;S
CMOS_E_M_S_LO	EQU	017H		; EXPANSION MEMORY SIZE - LOW BYTE    ;U
CMOS_E_M_S_HI	EQU	018H		; EXPANSION MEMORY SIZE - HIGH BYTE   ;M
CMOS_DISK_1	EQU	019H		; FIXED DISK TYPE - DRIVE C EXTENSION ;E
CMOS_DISK_2	EQU	01AH		; FIXED DISK TYPE - DRIVE D EXTENSION ;D
;		EQU	01BH		; - 1BH THROUGH 2DH - RESERVED	      ;
CMOS_CKSUM_HI	EQU	02EH		; CMOS CHECKSUM - HIGH BYTE	      ;*
CMOS_CKSUM_LO	EQU	02FH		; CMOS CHECKSUM - LOW BYTE	      ;*
CMOS_U_M_S_LO	EQU	030H		; USABLE MEMORY ABOVE 1 MEG - LOW BYTE
CMOS_U_M_S_HI	EQU	031H		; USABLE MEMORY ABOVE 1 MEG - HIGH BYTE
CMOS_CENTURY	EQU	032H		; DATE CENTURY BYTE (BCD)
CMOS_INFO128	EQU	033H		; 128KB INFORMATION STATUS FLAG BYTE
;		EQU	034H		; - 34H THROUGH 3FH - RESERVED

;---------- CMOS DIAGNOSTIC STATUS ERROR FLAGS WITHIN CMOS DIAG ----------------
CMOS_CLK_FAIL	EQU	00000100B	; CMOS CLOCK NOT UPDATING OR NOT VALID
HF_FAIL 	EQU	00001000B	; FIXED DISK FAILURE ON INITIALIZATION
W_MEM_SIZE	EQU	00010000B	; MEMORY SIZE NOT EQUAL TO CONFIGURATION
BAD_CONFIG	EQU	00100000B	; MINIMUM CONFIG USED INSTEAD OF CMOS
BAD_CKSUM	EQU	01000000B	; CHECKSUM ERROR
BAD_BAT 	EQU	10000000B	; DEAD BATTERY - CMOS LOST POWER

;---------- CMOS INFORMATION FLAGS ---------------------------------------------
M640K		EQU	10000000B	; 512K -> 640K OPTION INSTALLED  (128K)
;		EQU	01000000B	; FLAG USED BY CMOS SETUP UTILITY


;---------- DISKETTE EQUATES ---------------------------------------------------
DUAL		EQU	00000001B	; MASK FOR COMBO/DSP ADAPTER
INT_FLAG	EQU	10000000B	; INTERRUPT OCCURRENCE FLAG
DSK_CHG 	EQU	10000000B	; DISKETTE CHANGE FLAG MASK BIT
DETERMINED	EQU	00010000B	; SET STATE DETERMINED IN STATE BITS
HOME		EQU	00010000B	; TRACK 0 MASK
SENSE_DRV_ST	EQU	00000100B	; SENSE DRIVE STATUS COMMAND
TRK_SLAP	EQU	030H		; CRASH STOP (48 TPI DRIVES)
QUIET_SEEK	EQU	00AH		; SEEK TO TRACK 10
MAX_DRV 	EQU	2		; MAX NUMBER OF DRIVES
HD12_SETTLE	EQU	15		; 1.2 M HEAD SETTLE TIME
HD320_SETTLE	EQU	20		; 320 K HEAD SETTLE TIME
MOTOR_WAIT	EQU	37		; 2 SECONDS OF COUNTS FOR MOTOR TURN OFF

;---------- DISKETTE ERRORS ----------------------------------------------------
TIME_OUT	EQU	080H		; ATTACHMENT FAILED TO RESPOND
BAD_SEEK	EQU	040H		; SEEK OPERATION FAILED
BAD_NEC 	EQU	020H		; DISKETTE CONTROLLER HAS FAILED
BAD_CRC 	EQU	010H		; BAD CRC ON DISKETTE READ
MED_NOT_FND	EQU	00CH		; MEDIA TYPE NOT FOUND
DMA_BOUNDARY	EQU	009H		; ATTEMPT TO DMA ACROSS 64K BOUNDARY
BAD_DMA 	EQU	008H		; DMA OVERRUN ON OPERATION
MEDIA_CHANGE	EQU	006H		; MEDIA REMOVED ON DUAL ATTACH CARD
RECORD_NOT_FND	EQU	004H		; REQUESTED SECTOR NOT FOUND
WRITE_PROTECT	EQU	003H		; WRITE ATTEMPTED ON WRITE PROTECT DISK
BAD_ADDR_MARK	EQU	002H		; ADDRESS MARK NOT FOUND
BAD_CMD 	EQU	001H		; BAD COMMAND PASSED TO DISKETTE I/O

;---------- DISK CHANGE LINE EQUATES -------------------------------------------
NOCHGLN 	EQU	001H		; NO DISK CHANGE LINE AVAILABLE
CHGLN		EQU	002H		; DISK CHANGE LINE AVAILABLE

;---------- MEDIA/DRIVE STATE INDICATORS ---------------------------------------
TRK_CAPA	EQU	00000001B	; 80 TRACK CAPABILITY
FMT_CAPA	EQU	00000010B	; MULTIPLE FORMAT CAPABILITY (1.2M)
DRV_DET 	EQU	00000100B	; DRIVE DETERMINED
MED_DET 	EQU	00010000B	; MEDIA DETERMINED BIT
DBL_STEP	EQU	00100000B	; DOUBLE STEP BIT
RATE_MSK	EQU	11000000B	; MASK FOR CLEARING ALL BUT RATE
RATE_500	EQU	00000000B	; 500 KBS DATA RATE
RATE_300	EQU	01000000B	; 300 KBS DATA RATE
RATE_250	EQU	10000000B	; 250 KBS DATA RATE
STRT_MSK	EQU	00001100B	; OPERATION START RATE MASK
SEND_MSK	EQU	11000000B	; MASK FOR SEND RATE BITS

;---------- MEDIA/DRIVE STATE INDICATORS COMPATIBILITY -------------------------
M3D3U		EQU	00000000B	; 360 MEDIA/DRIVE NOT ESTABLISHED
M3D1U		EQU	00000001B	; 360 MEDIA,1.2DRIVE NOT ESTABLISHED
M1D1U		EQU	00000010B	; 1.2 MEDIA/DRIVE NOT ESTABLISHED
MED_UNK 	EQU	00000111B	; NONE OF THE ABOVE
PAGE
;---------- INTERRUPT EQUATES --------------------------------------------------
EOI		EQU	020H		; END OF INTERRUPT COMMAND TO 8259
INTA00		EQU	020H		; 8259 PORT
INTA01		EQU	021H		; 8259 PORT
INTB00		EQU	0A0H		; 2ND 8259
INTB01		EQU	0A1H		;
INT_TYPE	EQU	070H		; START OF 8259 INTERRUPT TABLE LOCATION
INT_VIDEO	EQU	010H		; VIDEO VECTOR
;-------------------------------------------------------------------------------
DMA08		EQU	008H		; DMA STATUS REGISTER PORT ADDRESS
DMA		EQU	000H		; DMA CH.0 ADDRESS REGISTER PORT ADDRESS
DMA18		EQU	0D0H		; 2ND DMA STATUS PORT ADDRESS
DMA1		EQU	0C0H		; 2ND DMA CH.0 ADDRESS REGISTER ADDRESS
;-------------------------------------------------------------------------------
TIMER		EQU	040H		; 8254 TIMER - BASE ADDRESS

;--------- MANUFACTURING PORT --------------------------------------------------
MFG_PORT	EQU	80H		; MANUFACTURING AND POST CHECKPOINT PORT
					;  DMA CHANNEL 0 PAGE REGISTER ADDRESS

;--------- MANUFACTURING BIT DEFINITION FOR @MFG_ERR_FLAG+1 --------------------
MEM_FAIL	EQU	00000001B	; STORAGE TEST FAILED	     (ERROR 20X)
PRO_FAIL	EQU	00000010B	; VIRTUAL MODE TEST FAILED   (ERROR 104)
LMCS_FAIL	EQU	00000100B	; LOW MEG CHIP SELECT FAILED (ERROR 109)
KYCLK_FAIL	EQU	00001000B	; KEYBOARD CLOCK TEST FAILED (ERROR 304)
KY_SYS_FAIL	EQU	00010000B	; KEYBOARD OR SYSTEM FAILED  (ERROR 303)
KYBD_FAIL	EQU	00100000B	; KEYBOARD FAILED	     (ERROR 301)
DSK_FAIL	EQU	01000000B	; DISKETTE TEST FAILED	     (ERROR 601)
KEY_FAIL	EQU	10000000B	; KEYBOARD LOCKED	     (ERROR 302)

;-------------------------------------------------------------------------------
DMA_PAGE	EQU	081H		; START OF DMA PAGE REGISTERS
LAST_DMA_PAGE	EQU	08FH		; LAST DMA PAGE REGISTER

;-------------------------------------------------------------------------------
X287		EQU	0F0H		; MATH COPROCESSOR CONTROL PORT

;-------------------------------------------------------------------------------
POST_SS 	EQU	00000H		; POST STACK SEGMENT
POST_SP 	EQU	08000H		; POST STACK POINTER

;-------------------------------------------------------------------------------
CR		EQU	000DH		; CARRIAGE RETURN CHARACTER
LF		EQU	000AH		; LINE FEED CHARACTER
RVRT		EQU	00001000B	; VIDEO VERTICAL RETRACE BIT
RHRZ		EQU	00000001B	; VIDEO HORIZONTAL RETRACE BIT
H		EQU	256		; HIGH BYTE FACTOR (X 100H)
X		EQU	H+1		; HIGH AND LOW BYTE FACTOR (X 101H)
