TITLE 09-26-83 TEST3	POST UTILITIES
.XLIST
INCLUDE DSEG.SRC
INCLUDE POSTEQU.SRC
INCLUDE SYSDATA.INC
.LIST
PUBLIC	POST3
PUBLIC	ROS_CHECKSUM
PUBLIC	BLINK_INT
PUBLIC	ROM_CHECK
PUBLIC	XPC_BYTE
PUBLIC	PRT_HEX
PUBLIC	XLAT_PR
PUBLIC	PROT_PRT_HEX
PUBLIC	PROC_SHUTDOWN

INCLUDE SEGMENT.SRC

EXTRN	ROM_ERR:NEAR
;----------------------------------------
;	ROS CHECKSUM SUBROUTINE 	:
;----------------------------------------
	ASSUME	CS:CODE, DS:ABS0
POST3:
ROS_CHECKSUM	PROC	NEAR		; NEXT_ROS_MODULE
	SUB	CX,CX			; NUMBER OF BYTES TO ADD IS 64K
ROS_CHECKSUM_CNT:			; ENTRY FOR OPTIONAL ROS TEST
	XOR	AL,AL
C26:
	ADD	AL,DS:[BX]
	INC	BX			; POINT TO NEXT BYTE
	LOOP	C26			; ADD ALL BYTES IN ROS MODULE
	OR	AL,AL			; SUM = 0?
	RET
ROS_CHECKSUM	ENDP
;---------------------------------------------------------------------------
;	BLINK LED PROCEDURE FOR MFG RUN-IN TESTS
;	 IF LED IS ON, TURN IT OFF. IF OFF, TURN ON.
;---------------------------------------------------------------------------
	ASSUME	DS:DATA
BLINK_INT	PROC	NEAR
	STI
	PUSH	AX				; SAVE AX REG CONTENTS
	IN	AL,MFG_PORT			; READ CURRENT VAL OF MFG_PORT
	MOV	AH,AL				;
	NOT	AL				; FLIP ALL BITS
	AND	AL,01000000B			; ISOLATE CONTROL BIT
	AND	AH,10111111B			; MASK OUT OF ORIGINAL VAL
	OR	AL,AH				; OR NEW CONTROL BIT IN
	OUT	MFG_PORT,AL
	MOV	AL,EOI
	OUT	INTA00,AL
	POP	AX				; RESTORE AX REG
	IRET
BLINK_INT	ENDP
;--------------------------------------------------
; THIS ROUTINE CHECKSUMS OPTIONAL ROM MODULES AND
; IF CHECKSUM IS OK, CALLS INIT/TEST CODE IN MODULE
;--------------------------------------------------
ROM_CHECK	PROC	NEAR
	MOV	AX,DATA 		; POINT ES TO DATA AREA
	MOV	ES,AX			;
	SUB	AH,AH			; ZERO OUT AH
	MOV	AL,[BX+2]		; GET LENGTH INDICATOR
	MOV	CL,09H			; MULTIPLY BY 512
	SHL	AX,CL			;
	MOV	CX,AX			; SET COUNT
	PUSH	CX			; SAVE COUNT
	MOV	CX,4			; ADJUST
	SHR	AX,CL
	ADD	DX,AX			; SET POINTER TO NEXT MODULE
	POP	CX			; RETRIEVE COUNT
	CALL	ROS_CHECKSUM_CNT	; DO CHECKSUM
	JZ	ROM_CHECK_1		;
	CALL	ROM_ERR 		; POST CHECKSUM ERROR
	JMP	ROM_CHECK_END		; AND EXIT
ROM_CHECK_1:
	PUSH	DX			; SAVE POINTER
	MOV	ES:IO_ROM_INIT,0003H		; LOAD OFFSET
	MOV	ES:IO_ROM_SEG,DS		; LOAD SEGMENT
	CALL	DWORD PTR ES:IO_ROM_INIT	; CALL INIT./TEST ROUTINE
	POP	DX				;
ROM_CHECK_END:
	RET					; RETURN TO CALLER
ROM_CHECK	ENDP
;-------------------------------------------------------------------------
;	CONVERT AND PRINT ASCII CODE
;
;	AL MUST CONTAIN NUMBER TO BE CONVERTED.
;	AX AND BX DESTROYED.
;-------------------------------------------------------------------------
XPC_BYTE	PROC	NEAR
	PUSH	AX			; SAVE FOR LOW NIBBLE DISPLAY
	MOV	CL,4			; SHIFT COUNT
	SHR	AL,CL			; NIBBLE SWAP
	CALL	XLAT_PR 		; DO THE HIGH NIBBLE DISPLAY
	POP	AX			; RECOVER THE NIBBLE
	AND	AL,0FH			; ISOLATE TO LOW NIBBLE
					; FALL INTO LOW NIBBLE CONVERSION
XLAT_PR PROC	NEAR			;	CONVERT 00-0F TO ASCII CHARACTER
	ADD	AL,090H 		; ADD FIRST CONVERSION FACTOR
	DAA				; ADJUST FOR NUMERIC AND ALPHA RANGE
	ADC	AL,040H 		; ADD CONVERSION AND ADJUST LOW NIBBLE
	DAA				; ADJUST HIGH NIBBLE TO ASCII RANGE
PRT_HEX PROC	NEAR
	MOV	AH,14			; DISPLAY CHARACTER IN AL
	MOV	BH,0
	INT	10H			; CALL VIDEO_IO
	RET
PRT_HEX ENDP
XLAT_PR ENDP
XPC_BYTE	ENDP

;--------------------------------------------------
; PUT CHARACTER TO THE CRT FOR TEST.11 IN
;  PROTECTED MODE
;
; AL=ASCII CHARACTER DI=CRT BUFFER POSITION
;--------------------------------------------------
PROT_PRT_HEX	PROC	NEAR
	PUSH	DS			; SAVE CURRENT SEGMENT REGS
	PUSH	BX

;------- B/W VIDEO CARD

	MOV	BX,C_BWCRT_PTR		;
	MOV	DS,BX			; SET DS TO B/W CRT BUFFER
	CALL	PROT_PRT		; GO PRINT CHARACTER

;-------- COMPATIBLE COLOR

	MOV	BX,C_CCRT_PTR		; SET DS TO COMPATIBLE COLOR RAM
	MOV	DS,BX			;
	CALL	PROT_PRT		;

;-------- ENHANCED COLOR

	MOV	BX,E_CCRT_PTR		; ENHANCED COLOR
	MOV	DS,BX			;
	CALL	PROT_PRT		;
	MOV	BX,E_CCRT_PTR2		; ENHANCED COLOR PTR HI 64K
	MOV	DS,BX			;
	CALL	PROT_PRT		;
	POP	BX			;
	POP	DS			;
	RET
PROT_PRT:
	PUSH	DI			; SAVE DISPLACEMENT
	ROL	DI,1			; MULT *2
	MOV	DS:[DI],AL		; WRITE TO CRT BUFFER
	POP	DI			; RESTORE DISPLACEMENT
	RET
PROT_PRT_HEX	ENDP

PROC_SHUTDOWN	PROC
	MOV	AL,SHUT_CMD		; SHUTDOWN COMMAND
	OUT	STATUS_PORT,AL		;
PROC_S: HLT				;
	JMP	PROC_S			; INSURE HALT
PROC_SHUTDOWN	ENDP
CODE	ENDS
	END
