
#define  NUM_MODES   42
int   num_modes = NUM_MODES;

/* mode table entry definitions */
#define  AVC_VOICE       1
#define  AVC_MUSIC       2
#define  AVC_STEREO      3
#define  AVC_HQ          4
#define  PCM8k8b         5
#define  PCM11k8b        6
#define  PCM22k8b        7
#define  PCM44k8b        8
#define  PCM8k16b        9
#define  PCM11k16b       10
#define  PCM22k16b       11
#define  PCM44k16b       12
#define  MULAW8K         13
#define  MULAW11K        14
#define  MULAW22K        15
#define  MULAW44K        16
#define  ALAW8K          17
#define  ALAW11K         18
#define  ALAW22K         19
#define  ALAW44K         20
#define  SOURCE_MIX_MODE 21
#define  CLAIM_HDWR_MODE 22
#define  ADPCMXAC        23
#define  ADPCMXAB        24
/* 25 - 27 reserved for SPV2 modes */
#define  PCM78k8b        28
#define  PCM315k8b       29
#define  PCM48k8b        30
#define  PCM78k16b       31
#define  PCM315k16b      32
#define  PCM48k16b       33
#define  MULAW78K        34
#define  MULAW315K       35
#define  MULAW48K        36
#define  ALAW78K         37
#define  ALAW315K        38
#define  ALAW48K         39
#define  OTHER8bPCM      40
#define  OTHER16bPCM     41
#define  UNKNOWN_MODE    NUM_MODES

struct mode_data mode_table[NUM_MODES] = {
   MIDI,0,0,8,8,0,0,0,0,1,DATAFLAGS+BPS+SRATE+CHANNELS+BSIZE,/* MIDI_MODE    */
   ADPCM,FIXED,FIXED,16,16,11025,11025,1,1,576,BPS+BSIZE,   /* AVC_VOICE     */
   ADPCM,FIXED,FIXED,16,16,22050,22050,1,1,1128,BPS+BSIZE,  /* AVC_MUSIC     */
   ADPCM,FIXED,FIXED,16,16,22050,22050,2,2,2256,BPS+BSIZE,  /* AVC_STEREO    */
   ADPCM,FIXED,FIXED,16,16,44100,44100,1,1,1128,BPS+BSIZE,  /* AVC_HQ        */
   PCM,0x3e,0,8,8,8000,8000,1,2,0,BSIZE+DATAFLAGS,          /* 8k 8b PCM     */
   PCM,0x3e,0,8,8,11025,11025,1,2,0,BSIZE+DATAFLAGS,        /* 11k 8b PCM    */
   PCM,0x3e,0,8,8,22050,22050,1,2,0,BSIZE+DATAFLAGS,        /* 22k 8b PCM    */
   PCM,0x3e,0,8,8,44100,44100,1,2,0,BSIZE+DATAFLAGS,        /* 44k 8b PCM    */
   PCM,0x3e,0,16,16,8000,8000,1,2,0,BSIZE+DATAFLAGS,        /* 8k 16b PCM    */
   PCM,0x3e,0,16,16,11025,11025,1,2,0,BSIZE+DATAFLAGS,      /* 11k 16b PCM   */
   PCM,0x3e,0,16,16,22050,22050,1,2,0,BSIZE+DATAFLAGS,      /* 22k 16b PCM   */
   PCM,0x3e,0,16,16,44100,44100,1,2,0,BSIZE+DATAFLAGS,      /* 44k 16b PCM   */
   MU_LAW,0x3e,0,8,8,8000,8000,1,2,0,BSIZE+DATAFLAGS,       /* 8k 8b Mu-Law  */
   MU_LAW,0x3e,0,8,8,11025,11025,1,2,0,BSIZE+DATAFLAGS,     /* 11k 8b Mu-Law */
   MU_LAW,0x3e,0,8,8,22050,22050,1,2,0,BSIZE+DATAFLAGS,     /* 22k 8b Mu-Law */
   MU_LAW,0x3e,0,8,8,44100,44100,1,1,0,BSIZE+DATAFLAGS,     /* 44k 8b Mu-Law */
   A_LAW,0x3e,0,8,8,8000,8000,1,2,0,BSIZE+DATAFLAGS,        /* 8k 8b Mu-Law  */
   A_LAW,0x3e,0,8,8,11025,11025,1,2,0,BSIZE+DATAFLAGS,      /* 11k 8b Mu-Law */
   A_LAW,0x3e,0,8,8,22050,22050,1,2,0,BSIZE+DATAFLAGS,      /* 22k 8b Mu-Law */
   A_LAW,0x3e,0,8,8,44100,44100,1,1,0,BSIZE+DATAFLAGS,      /* 44k 8b Mu-Law */
   SOURCE_MIX,0,0,8,8,8000,8000,1,1,0,DATAFLAGS+BPS+BSIZE+SRATE+CHANNELS,
   CLAIM_HDWR,0,0,0,0,0,0,0,0,0,DATAFLAGS+BPS+BSIZE+SRATE+CHANNELS,/* Get hdwr*/
   ADPCMXA,0x3e,0,16,16,18900,18900,1,2,0,BSIZE,            /* CDROM XA Lvl C*/
   ADPCMXA,0x3e,0,16,16,37800,37800,1,2,0,BSIZE,            /* CDROM XA Lvl B*/
   SPV2BCPCM,0x3e,0,16,16,14700,14700,1,1,0,BSIZE,          /* SPV/2 BCPCM   */
   SPV2PCM,0x3e,0,16,16,14700,14700,1,1,0,BSIZE,            /* SPV/2 16b PCM */
   SPV2NONE,0x3e,0,0,0,0,0,1,1,0,BSIZE+BPS+SRATE,           /* SPV/2 NONE    */
   PCM,0x3e,0,8,8,7875,7875,1,2,0,BSIZE+DATAFLAGS,          /* 7.875K 8b PCM */
   PCM,0x3e,0,8,8,31500,31500,1,2,0,BSIZE+DATAFLAGS,        /* 31.5k 8b PCM  */
   PCM,0x3e,0,8,8,48000,48000,1,2,0,BSIZE+DATAFLAGS,        /* 48k 8b PCM    */
   PCM,0x3e,0,16,16,7875,7875,1,2,0,BSIZE+DATAFLAGS,        /* 7.875K 8b PCM */
   PCM,0x3e,0,16,16,31500,31500,1,2,0,BSIZE+DATAFLAGS,      /* 31.5k 8b PCM  */
   PCM,0x3e,0,16,16,48000,48000,1,2,0,BSIZE+DATAFLAGS,      /* 48k 8b PCM    */
   MU_LAW,0x3e,0,8,8,7875,7875,1,2,0,BSIZE+DATAFLAGS,       /* 7.875k 8b Mu-L*/
   MU_LAW,0x3e,0,8,8,31500,31500,1,1,0,BSIZE+DATAFLAGS,     /* 31.5k 8b Mu-La*/
   MU_LAW,0x3e,0,8,8,48000,48000,1,1,0,BSIZE+DATAFLAGS,     /* 48k 8b Mu-Law */
   A_LAW,0x3e,0,8,8,7875,7875,1,2,0,BSIZE+DATAFLAGS,        /* 7.875k 8b A-La*/
   A_LAW,0x3e,0,8,8,31500,31500,1,1,0,BSIZE+DATAFLAGS,      /* 31.5k 8b A-Law*/
   A_LAW,0x3e,0,8,8,48000,48000,1,1,0,BSIZE+DATAFLAGS,      /* 48k 8b A-Law  */
   PCM,0x3e,0,8,8,0,44100,1,1,0,BSIZE+SRATE,                /* other 8b PCM  */
   PCM,0x3e,0,16,16,0,44100,1,1,0,BSIZE+SRATE               /* other 16b PCM */
};

/* Defines for dsp_loaded and dsp_to_load variables                          */
#define PASSTHRU_DSP 0x00
#define IBMAUDP_DSP  0x01
#define IBMAUDR_DSP  0x02
#define IBMAUDF_DSP  0x03
#define IBMAUDG_DSP  0x04
#define IBMPCMR_DSP  0x05
#define IBMPCMP_DSP  0x06
#define IBMSPV2_DSP  0x07
#define IBMXA_DSP    0x08
#define IBMMPC_DSP   0x09
#define IBMPMM48_DSP 0x0A
#define IBMPCMR8_DSP 0x0B
#define IBMAUDS_DSP  0x0C

#define NUM_DSP 13
/* DSP module names */
char  dsp_string[NUM_DSP][13] = {"PASSTHRU    ",   /* Internal Passthru DSP  */
                                 "IBMAUDP.DSP ",   /* AVC ADPCM Playback     */
                                 "IBMAUDR.DSP ",   /* AVC ADPCM Record       */
                                 "IBMAUDF.DSP ",   /* AVC ADPCM HQ Playback  */
                                 "IBMAUDG.DSP ",   /* AVC ADPCM HQ Record    */
                                 "IBMPCMR.DSP ",   /* PCM Record             */
                                 "IBMPCMP.DSP ",   /* PCM Playback           */
                                 "IBMSPV2.DSP ",   /* Speech Viewer/2        */
                                 "IBMXA.DSP   ",   /* XA - CD ROM            */
                                 "IBMMPC.DSP  ",   /* MPC - MIDI/PCM         */
                                 "IBMPMM48.DSP",   /* M-Motion               */
                                 "IBMPCMR8.DSP",   /* PCM 8K Record          */
                                 "IBMAUDS.DSP "};  /* Synth + MIDI           */

#define MIDI_INDEX       0
#define VOICE_INDEX      1
#define MUSIC_INDEX      2
#define PCM_INDEX        3
#define PCM11K22K_INDEX  4
#define MMOTION_INDEX    5
#define SOURCE_MIX_INDEX 6
#define NUM_INDEXES      7

#if NUM_TRACKS > 1
   char mode_compat_array[NUM_INDEXES][NUM_MODES-2] =
      /* MIDI                     */
      {0,             /*MIDI      */
       IBMAUDS_DSP,   /*AVC_VOICE */
       0,             /*AVC_MUSIC */
       0,             /*AVC_STEREO*/
       0,             /*AVC_HQ    */
       0,             /*PCM8k8b   */
       IBMMPC_DSP,    /*PCM11k8b  */
       IBMMPC_DSP,    /*PCM22k8b  */
       0,             /*PCM44k8b  */
       0,             /*PCM8k16b  */
       0,             /*PCM11k16b */
       0,             /*PCM22k16b */
       0,             /*PCM44k16b */
       0,             /*MULAW8K   */
       0,             /*MULAW11K  */
       0,             /*MULAW22K  */
       0,             /*MULAW44K  */
       0,             /*ALAW8K    */
       0,             /*ALAW11K   */
       0,             /*ALAW22K   */
       0,             /*ALAW44K   */
       IBMMPC_DSP,    /*SOURCE_MIX*/
       0,             /*CLAIM_HDWR*/
       0,             /*ADPCMXAC  */
       0,             /*ADPCMXAB  */
       0,             /*SPV/2     */
       0,             /*SPV/2     */
       0,             /*SPV/2     */
       0,             /*PCM78k8b  */
       0,             /*PCM315k8b */
       0,             /*PCM48k8b  */
       0,             /*PCM78k16b */
       0,             /*PCM315k16b*/
       0,             /*PCM48k16b */
       0,             /*MULAW78K  */
       0,             /*MULAW315K */
       0,             /*MULAW48K  */
       0,             /*ALAW78K   */
       0,             /*ALAW315K  */
       0,             /*ALAW48K   */

       /* Voice                   */
       IBMAUDS_DSP,   /*MIDI      */
       IBMAUDP_DSP,   /*AVC_VOICE */
       IBMAUDP_DSP,   /*AVC_MUSIC */
       0,             /*AVC_STEREO*/
       0,             /*AVC_HQ    */
       0,             /*PCM8k8b   */
       0,             /*PCM11k8b  */
       0,             /*PCM22k8b  */
       0,             /*PCM44k8b  */
       0,             /*PCM8k16b  */
       0,             /*PCM11k16b */
       0,             /*PCM22k16b */
       0,             /*PCM44k16b */
       0,             /*MULAW8K   */
       0,             /*MULAW11K  */
       0,             /*MULAW22K  */
       0,             /*MULAW44K  */
       0,             /*ALAW8K    */
       0,             /*ALAW11K   */
       0,             /*ALAW22K   */
       0,             /*ALAW44K   */
       0,             /*SOURCE_MIX*/
       0,             /*CLAIM_HDWR*/
       0,             /*ADPCMXAC  */
       0,             /*ADPCMXAB  */
       0,             /*SPV/2     */
       0,             /*SPV/2     */
       0,             /*SPV/2     */
       0,             /*PCM78k8b  */
       0,             /*PCM315k8b */
       0,             /*PCM48k8b  */
       0,             /*PCM78k16b */
       0,             /*PCM315k16b*/
       0,             /*PCM48k16b */
       0,             /*MULAW78K  */
       0,             /*MULAW315K */
       0,             /*MULAW48K  */
       0,             /*ALAW78K   */
       0,             /*ALAW315K  */
       0,             /*ALAW48K   */


       /* Music                   */
       0,             /*MIDI      */
       IBMAUDP_DSP,   /*AVC_VOICE */
       IBMAUDP_DSP,   /*AVC_MUSIC */
       0,             /*AVC_STEREO*/
       0,             /*AVC_HQ    */
       0,             /*PCM8k8b   */
       0,             /*PCM11k8b  */
       0,             /*PCM22k8b  */
       0,             /*PCM44k8b  */
       0,             /*PCM8k16b  */
       0,             /*PCM11k16b */
       0,             /*PCM22k16b */
       0,             /*PCM44k16b */
       0,             /*MULAW8K   */
       0,             /*MULAW11K  */
       0,             /*MULAW22K  */
       0,             /*MULAW44K  */
       0,             /*ALAW8K    */
       0,             /*ALAW11K   */
       0,             /*ALAW22K   */
       0,             /*ALAW44K   */
       0,             /*SOURCE_MIX*/
       0,             /*CLAIM_HDWR*/
       0,             /*ADPCMXAC  */
       0,             /*ADPCMXAB  */
       0,             /*SPV/2     */
       0,             /*SPV/2     */
       0,             /*SPV/2     */
       0,             /*PCM78k8b  */
       0,             /*PCM315k8b */
       0,             /*PCM48k8b  */
       0,             /*PCM78k16b */
       0,             /*PCM315k16b*/
       0,             /*PCM48k16b */
       0,             /*MULAW78K  */
       0,             /*MULAW315K */
       0,             /*MULAW48K  */
       0,             /*ALAW78K   */
       0,             /*ALAW315K  */
       0,             /*ALAW48K   */

       /*  All IBM PCM,           */
       /*  A_LAW,MU_LAW,          */
       /*  but 11/22K 8Bit PCM    */
       0,             /*MIDI      */
       0,             /*AVC_VOICE */
       0,             /*AVC_MUSIC */
       0,             /*AVC_STEREO*/
       0,             /*AVC_HQ    */
       IBMPCMP_DSP,   /*PCM8k8b   */
       IBMPCMP_DSP,   /*PCM11k8b  */
       IBMPCMP_DSP,   /*PCM22k8b  */
       IBMPCMP_DSP,   /*PCM44k8b  */
       IBMPCMP_DSP,   /*PCM8k16b  */
       IBMPCMP_DSP,   /*PCM11k16b */
       IBMPCMP_DSP,   /*PCM22k16b */
       IBMPCMP_DSP,   /*PCM44k16b */
       IBMPCMP_DSP,   /*MULAW8K   */
       IBMPCMP_DSP,   /*MULAW11K  */
       IBMPCMP_DSP,   /*MULAW22K  */
       IBMPCMP_DSP,   /*MULAW44K  */
       IBMPCMP_DSP,   /*ALAW8K    */
       IBMPCMP_DSP,   /*ALAW11K   */
       IBMPCMP_DSP,   /*ALAW22K   */
       IBMPCMP_DSP,   /*ALAW44K   */
       IBMPCMP_DSP,   /*SOURCE_MIX*/
       0,             /*CLAIM_HDWR*/
       0,             /*ADPCMXAC  */
       0,             /*ADPCMXAB  */
       0,             /*SPV/2     */
       0,             /*SPV/2     */
       0,             /*SPV/2     */
       0,             /*PCM78k8b  */
       0,             /*PCM315k8b */
       0,             /*PCM48k8b  */
       0,             /*PCM78k16b */
       0,             /*PCM315k16b*/
       0,             /*PCM48k16b */
       0,             /*MULAW78K  */
       0,             /*MULAW315K */
       0,             /*MULAW48K  */
       0,             /*ALAW78K   */
       0,             /*ALAW315K  */
       0,             /*ALAW48K   */

       /* 11K 22K 8bit            */
       /* 11K 22K 8bit            */
       /* PCM only                */
       IBMMPC_DSP,    /*MIDI      */
       0,             /*AVC_VOICE */
       0,             /*AVC_MUSIC */
       0,             /*AVC_STEREO*/
       0,             /*AVC_HQ    */
       IBMPCMP_DSP,   /*PCM8k8b   */
       IBMPCMP_DSP,   /*PCM11k8b  */
       IBMPCMP_DSP,   /*PCM22k8b  */
       IBMPCMP_DSP,   /*PCM44k8b  */
       IBMPCMP_DSP,   /*PCM8k16b  */
       IBMPCMP_DSP,   /*PCM11k16b */
       IBMPCMP_DSP,   /*PCM22k16b */
       IBMPCMP_DSP,   /*PCM44k16b */
       IBMPCMP_DSP,   /*MULAW8K   */
       IBMPCMP_DSP,   /*MULAW11K  */
       IBMPCMP_DSP,   /*MULAW22K  */
       IBMPCMP_DSP,   /*MULAW44K  */
       IBMPCMP_DSP,   /*ALAW8K    */
       IBMPCMP_DSP,   /*ALAW11K   */
       IBMPCMP_DSP,   /*ALAW22K   */
       IBMPCMP_DSP,   /*ALAW44K   */
       IBMPCMP_DSP,   /*SOURCE_MIX*/
       0,             /*CLAIM_HDWR*/
       0,             /*ADPCMXAC  */
       0,             /*ADPCMXAB  */
       0,             /*SPV/2     */
       0,             /*SPV/2     */
       0,             /*SPV/2     */
       0,             /*PCM78k8b  */
       0,             /*PCM315k8b */
       0,             /*PCM48k8b  */
       0,             /*PCM78k16b */
       0,             /*PCM315k16b*/
       0,             /*PCM48k16b */
       0,             /*MULAW78K  */
       0,             /*MULAW315K */
       0,             /*MULAW48K  */
       0,             /*ALAW78K   */
       0,             /*ALAW315K  */
       0,             /*ALAW48K   */


       /* M-Motion Rates         */
       0,            /*MIDI      */
       0,            /*AVC_VOICE */
       0,            /*AVC_MUSIC */
       0,            /*AVC_STEREO*/
       0,            /*AVC_HQ    */
       0,            /*PCM8k8b   */
       0,            /*PCM11k8b  */
       0,            /*PCM22k8b  */
       0,            /*PCM44k8b  */
       0,            /*PCM8k16b  */
       0,            /*PCM11k16b */
       0,            /*PCM22k16b */
       0,            /*PCM44k16b */
       0,            /*MULAW8K   */
       0,            /*MULAW11K  */
       0,            /*MULAW22K  */
       0,            /*MULAW44K  */
       0,            /*ALAW8K    */
       0,            /*ALAW11K   */
       0,            /*ALAW22K   */
       0,            /*ALAW44K   */
       IBMPMM48_DSP, /*SOURCE_MIX*/
       0,            /*CLAIM_HDWR*/
       0,            /*ADPCMXAC  */
       0,            /*ADPCMXAB  */
       0,            /*SPV/2     */
       0,            /*SPV/2     */
       0,            /*SPV/2     */
       IBMPMM48_DSP, /*PCM78k8b  */
       IBMPMM48_DSP, /*PCM315k8b */
       IBMPMM48_DSP, /*PCM48k8b  */
       IBMPMM48_DSP, /*PCM78k16b */
       IBMPMM48_DSP, /*PCM315k16b*/
       IBMPMM48_DSP, /*PCM48k16b */
       IBMPMM48_DSP, /*MULAW78K  */
       IBMPMM48_DSP, /*MULAW315K */
       IBMPMM48_DSP, /*MULAW48K  */
       IBMPMM48_DSP, /*ALAW78K   */
       IBMPMM48_DSP, /*ALAW315K  */
       IBMPMM48_DSP, /*ALAW48K   */


      /* Source Mix              */
      IBMMPC_DSP,    /*MIDI      */
      0,             /*AVC_VOICE */
      0,             /*AVC_MUSIC */
      0,             /*AVC_STEREO*/
      0,             /*AVC_HQ    */
      IBMPCMP_DSP,   /*PCM8k8b   */
      IBMPCMP_DSP,   /*PCM11k8b  */
      IBMPCMP_DSP,   /*PCM22k8b  */
      IBMPCMP_DSP,   /*PCM44k8b  */
      IBMPCMP_DSP,   /*PCM8k16b  */
      IBMPCMP_DSP,   /*PCM11k16b */
      IBMPCMP_DSP,   /*PCM22k16b */
      IBMPCMP_DSP,   /*PCM44k16b */
      IBMPCMP_DSP,   /*MULAW8K   */
      IBMPCMP_DSP,   /*MULAW11K  */
      IBMPCMP_DSP,   /*MULAW22K  */
      IBMPCMP_DSP,   /*MULAW44K  */
      IBMPCMP_DSP,   /*ALAW8K    */
      IBMPCMP_DSP,   /*ALAW11K   */
      IBMPCMP_DSP,   /*ALAW22K   */
      IBMPCMP_DSP,   /*ALAW44K   */
      IBMPCMP_DSP,   /*SOURCE_MIX*/
      0,             /*CLAIM_HDWR*/
      0,             /*ADPCMXAC  */
      0,             /*ADPCMXAB  */
      0,             /*SPV/2     */
      0,             /*SPV/2     */
      0,             /*SPV/2     */
      IBMPMM48_DSP,  /*PCM78k8b  */
      IBMPMM48_DSP,  /*PCM315k8b */
      IBMPMM48_DSP,  /*PCM48k8b  */
      IBMPMM48_DSP,  /*PCM78k16b */
      IBMPMM48_DSP,  /*PCM315k16b*/
      IBMPMM48_DSP,  /*PCM48k16b */
      IBMPMM48_DSP,  /*MULAW78K  */
      IBMPMM48_DSP,  /*MULAW315K */
      IBMPMM48_DSP,  /*MULAW48K  */
      IBMPMM48_DSP,  /*ALAW78K   */
      IBMPMM48_DSP,  /*ALAW315K  */
      IBMPMM48_DSP}; /*ALAW48K   */

struct cbs {
   int trk;
   int trackcb[8];
   int mastercb[8];
   int mailbox[8];
};

#endif

