;                               PASSTHRU.ASM
;
; This module will load a passthru module onto the M-ACPA and start it.

;***********************************************
; Equates
;***********************************************
ADDREGLOW       EQU     4
ADDREGHI        EQU     5
DATAREGLOW      EQU     0
DATAREGHI       EQU     1
HOSTCOMREG      EQU     6
HOSTSTATUSREG   EQU     6
CLEARACCESSERR  EQU     7

; Command Reg equates
CTRRES          EQU     080H
INTHOST         EQU     040H
PSPINTACK       EQU     020H
SPBINTACK       EQU     010H
INPSEL          EQU     008H
ADCEN           EQU     004H
DAC2EN          EQU     002H
DAC1EN          EQU     001H

; Status Reg equates
HOSTINT         EQU     8
ADCINT          EQU     4
DAC2INT         EQU     2
DAC1INT         EQU     1

; PSP Sample Memory equates
ADCBLOCK0       EQU     4000H
ADCBLOCK1       EQU     4100H
DAC2BLOCK0      EQU     4200H
DAC2BLOCK1      EQU     4300H
SCRBLOCK0       EQU     4400H
SCRBLOCK1       EQU     4500H
DAC1BLOCK0      EQU     4600H
DAC1BLOCK1      EQU     4700H

;***********************************************
; Segment layout
;***********************************************

_TEXT SEGMENT BYTE PUBLIC 'CODE'
_TEXT ENDS

NULL    SEGMENT PARA PUBLIC 'BEGDATA'
NULL    ENDS

_DATA   SEGMENT WORD PUBLIC 'DATA'
_DATA   ENDS

CONST SEGMENT WORD PUBLIC 'CONST'
CONST ENDS

_BSS SEGMENT WORD PUBLIC 'BSS'
_BSS ENDS

DGROUP GROUP NULL, _DATA,CONST,_BSS

_DATA   SEGMENT

        EXTRN   _HOSTBASE:WORD
        EXTRN   PSPCODE1:WORD,PSPCODE1_END:WORD

_DATA   ENDS

_TEXT SEGMENT BYTE PUBLIC 'CODE'
        ASSUME  CS:_TEXT,DS:DGROUP,ES:DGROUP,SS:DGROUP

_PASSTHRU PROC  NEAR    ; passthru(inpsel);
        PUBLIC  _PASSTHRU
        PUSH    BP
        MOV     BP,SP
        PUSH    SI
        CLD
;
; Enable ARPA
;
        MOV     DX,_HOSTBASE
        ADD     DX,HOSTCOMREG
        MOV     AL,08H                  ; Reset DSP, disable ints
        OUT     DX,AL
        JMP     $+2
        INC     DX                      ; Clear ACC ERR (?)
        OUT     DX,AL
;
; Zero out entire 8k memory, and verify each word == 0
;
        MOV     AX,0
        CALL    PSPMTEST
        OR      AX,AX
        JZ      TESTL1OK
        MOV     AX,1                    ; RC=1 memory test failed
        JMP     PTEND

TESTL1OK:

;*********************************
; Load code at 0000-0FFF (4k max)
;*********************************
        SUB     AX,AX                   ; Set ARPA address = Code (0)
        MOV     DX,_HOSTBASE
        ADD     DX,ADDREGLOW
        OUT     DX,AX
        JMP     $+2

        MOV     SI,OFFSET DGROUP:PSPCODE1       ; Set DS:SI = PSP code
        MOV     CX,OFFSET DGROUP:PSPCODE1_END
        SUB     CX,SI                   ; CX = length of PSP code
        SHR     CX,1                    ; divide by 2 for words
        SUB     DX,ADDREGLOW-DATAREGLOW
LOAD10:
        LODSW                           ; Copy data
        OUT     DX,AX
        LOOP    LOAD10
        JMP     $+2
;
; Write INPSEL to 1FFC
;
        ADD     DX,ADDREGLOW
        MOV     AX,1FFCH
        OUT     DX,AX
        JMP     $+2
        SUB     DX,ADDREGLOW-DATAREGLOW
        MOV     AX,+4[BP]
        OUT     DX,AX
        JMP     $+2
;
; Enable ARPA
;
        ADD     DX,HOSTCOMREG
        MOV     AL,09H                  ; Remove Reset bit 0, leave int disabled
        OUT     DX,AL
        JMP     $+2
        INC     DX
        OUT     DX,AL                   ; Clear ACC ERR (if any)
;
; Wait for PSP to respond by writing to address 1FFFH
;
        MOV     CX,-1                   ; Wait loop count
LOAD1WAIT:
        MOV     AX,1FFFH
        MOV     DX,_HOSTBASE
        ADD     DX,ADDREGLOW
        OUT     DX,AX
        JMP     $+2
        SUB     DX,ADDREGLOW-DATAREGLOW
        IN      AX,DX
        CMP     AX,55AAH                ; Is
        JE      HAVEFLAG1
        LOOP    LOAD1WAIT
        MOV     AX,2                    ; Return error RC=2 (55AA not set)
        JMP     PTEND

HAVEFLAG1:

; Verify that DSP responds to a Host Interrupt by changing flag to 5A5A
        ADD     DX,HOSTCOMREG
        MOV     AL,03H
        OUT     DX,AL
        JMP     $+2
        MOV     CX,-1
TESTLOOPL1:
        MOV     AX,1FFFH
        MOV     DX,_HOSTBASE
        ADD     DX,ADDREGLOW
        OUT     DX,AX
        JMP     $+2
        SUB     DX,ADDREGLOW-DATAREGLOW
        IN      AX,DX
        CMP     AX,5A5AH                ; Is it 5A5A?
        JE      HAVEACK1
        LOOP    TESTLOOPL1
        MOV     AX,3                    ; Return error RC=3 (No DSP int ack)
        JMP     PTEND

HAVEACK1:
        SUB     AX,AX           ; Return 0 (ok)
PTEND:
        POP     SI
        POP     BP
        RET
_PASSTHRU ENDP

PSPMTEST PROC NEAR      ; AX = Value read/verify
        MOV     BX,AX
        SUB     AX,AX                   ; Set ARPA address = Code (0)
        SUB     AX,AX
        MOV     DX,_HOSTBASE
        ADD     DX,ADDREGLOW
        OUT     DX,AX
        JMP     $+2
        MOV     CX,8192
        SUB     DX,ADDREGLOW-DATAREGLOW
        MOV     AX,BX
MTEST1:                                 ; Write pattern to memory
        OUT     DX,AX
        LOOP    MTEST1
        JMP     $+2
                                        ; Now verify that pattern is there
        SUB     AX,AX                   ; Set ARPA address = Code (0)
        ADD     DX,ADDREGLOW
        OUT     DX,AX
        JMP     $+2
        MOV     CX,8192
        SUB     DX,ADDREGLOW-DATAREGLOW
MTEST2:
        IN      AX,DX
        CMP     AX,BX
        JNE     MTESTERR
        LOOP    MTEST2
MTESTERR:
        MOV     AX,CX
        RET
PSPMTEST ENDP

_TEXT   ENDS
        END
