;                               WFSUB.ASM
; This module contains the WFGEN subroutines.  These subroutines are
; dynamically loaded and fixed-up during voice selection/assignment.
; Fixups are required for branches, and data references.
; Each TMS instruction word is prefixed with a byte defining the type
; of fixing up needed: 0=none, 1=data address, 2=code address.
;
; WFSUBTBL contains the starting addresses of each subroutine.
;
; AR0 = 64 loop counter
; AR1 = *DAC1 pointer
; AR2 = *DAC2 pointer
; AR3 = temporary buffer pointer
; AR4 = NSEED1,2
; AR5 =
; AR6 =
; AR7 =
;
; ARP = 3


; PSP OPCODES FOR TMS3202x (These must be reversed by the loading routine)
; Last update 6/8/90

AR            EQU         80H        ; Data pointed to by current aux register
ARPLUS        EQU        0A0H        ; " ", then inc AR
ARMINUS       EQU         90H        ; " ", then dec AR
ARSET0        EQU         88H        ; " ", then set ARP = 0
ARSET1        EQU         89H        ; " ", then set ARP = 1
ARSET2        EQU         8AH
ARSET3        EQU         8BH
ARSET4        EQU         8CH
ARSET5        EQU         8DH
ARSET6        EQU         8EH
ARSET7        EQU         8FH
ARSET         EQU         88H        ; " ", then set ARP = "+n"
ARPLUS0       EQU        0A8H
ARPLUS1       EQU        0A9H
ARPLUS2       EQU        0AAH
ARPLUS3       EQU        0ABH
ARPLUS4       EQU        0ACH
ARPLUS5       EQU        0ADH
ARPLUS6       EQU        0AEH
ARPLUS7       EQU        0AFH
ARPLUSSET     EQU        0A8H
ARMINUS0      EQU         98H
ARMINUS1      EQU         99H
ARMINUS2      EQU         9AH
ARMINUS3      EQU         9BH
ARMINUS4      EQU         9CH
ARMINUS5      EQU         9DH
ARMINUS6      EQU         9EH
ARMINUS7      EQU         9FH
ARMINUSSET    EQU         98H
ARMINUSAR0    EQU        0D0H
ARMINUSAR0SET EQU        0D8H
ARPLUSAR0     EQU        0E0H
ARPLUSAR0SET  EQU        0E8H

; * indicates 320C25 extensions, 2 = 2 word instructions
PSPABS        EQU      0CE1BH
ADD0          EQU       0000H
ADD1          EQU       0100H
ADD2          EQU       0200H
ADD3          EQU       0300H
ADD4          EQU       0400H
ADD5          EQU       0500H
ADD6          EQU       0600H
ADD7          EQU       0700H
ADD8          EQU       0800H
ADD9          EQU       0900H
ADD10         EQU       0A00H
ADD11         EQU       0B00H
ADD12         EQU       0C00H
ADD13         EQU       0D00H
ADD14         EQU       0E00H
ADD15         EQU       0F00H
ADDC          EQU       4300H  ;*
ADDH          EQU       4800H
ADDK          EQU      0CC00H  ;*
ADDS          EQU       4900H
ADDT          EQU       4A00H  ;*
ADLK0         EQU      0D002H  ;*2
ADLK1         EQU      0D102H  ;*2
ADLK2         EQU      0D202H  ;*2
ADLK3         EQU      0D302H  ;*2
ADLK4         EQU      0D402H  ;*2
ADLK5         EQU      0D502H  ;*2
ADLK6         EQU      0D602H  ;*2
ADLK7         EQU      0D702H  ;*2
ADLK8         EQU      0D802H  ;*2
ADLK9         EQU      0D902H  ;*2
ADLK10        EQU      0DA02H  ;*2
ADLK11        EQU      0DB02H  ;*2
ADLK12        EQU      0DC02H  ;*2
ADLK13        EQU      0DD02H  ;*2
ADLK14        EQU      0DE02H  ;*2
ADLK15        EQU      0DF02H  ;*2
ADRK          EQU       7E00H  ;*
PSPAND        EQU       4E00H
ANDK0         EQU      0D004H  ;*2
ANDK1         EQU      0D104H  ;*2
ANDK2         EQU      0D204H  ;*2
ANDK3         EQU      0D304H  ;*2
ANDK4         EQU      0D404H  ;*2
ANDK5         EQU      0D504H  ;*2
ANDK6         EQU      0D604H  ;*2
ANDK7         EQU      0D704H  ;*2
ANDK8         EQU      0D804H  ;*2
ANDK9         EQU      0D904H  ;*2
ANDK10        EQU      0DA04H  ;*2
ANDK11        EQU      0DB04H  ;*2
ANDK12        EQU      0DC04H  ;*2
ANDK13        EQU      0DD04H  ;*2
ANDK14        EQU      0DE04H  ;*2
ANDK15        EQU      0DF04H  ;*2
APAC          EQU      0CE15H
B             EQU      0FF80H
BACC          EQU      0CE25H  ;*
BANZ          EQU      0FB80H
BBNZ          EQU      0F980H  ;*2
BBZ           EQU      0F880H  ;*2
BC            EQU       5E80H  ;*2
BGEZ          EQU      0F480H
BGZ           EQU      0F180H
BIOZ          EQU      0FA80H
BIT0          EQU       9000H  ;*
BIT1          EQU       9100H  ;*
BIT2          EQU       9200H  ;*
BIT3          EQU       9300H  ;*
BIT4          EQU       9400H  ;*
BIT5          EQU       9500H  ;*
BIT6          EQU       9600H  ;*
BIT7          EQU       9700H  ;*
BIT8          EQU       9800H  ;*
BIT9          EQU       9900H  ;*
BIT10         EQU       9A00H  ;*
BIT11         EQU       9B00H  ;*
BIT12         EQU       9C00H  ;*
BIT13         EQU       9D00H  ;*
BIT14         EQU       9E00H  ;*
BIT15         EQU       9F00H  ;*
BITT          EQU       5700H  ;*
BLEZ          EQU      0F280H
BLKD          EQU      0FD00H  ;*2
BLKP          EQU      0FC00H  ;*2
BLZ           EQU      0F380H
BNC           EQU       5F80H  ;*2
BNV           EQU      0F780H  ;*2
BNZ           EQU      0F580H
BV            EQU      0F080H
BZ            EQU      0F680H
CALA          EQU      0CE24H
PSPCALL       EQU      0FE80H
CMPL          EQU      0CE27H  ;*
CMPREQ        EQU      0CE50H  ;*
CMPRLT        EQU      0CE51H  ;*
CMPRGT        EQU      0CE52H  ;*
CMPRNE        EQU      0CE53H  ;*
CNFD          EQU      0CE04H  ;*
CNFP          EQU      0CE05H  ;*
DINT          EQU      0CE01H
DMOV          EQU       5600H
EINT          EQU      0CE00H
FORT16        EQU      0CE0EH  ;*
FORT8         EQU      0CE0FH  ;*
IDLE          EQU      0CE1FH  ;*
IN0           EQU       8000H
IN1           EQU       8100H
IN2           EQU       8200H
IN3           EQU       8300H
IN4           EQU       8400H
IN5           EQU       8500H
IN6           EQU       8600H
IN7           EQU       8700H
LAC0          EQU       2000H
LAC1          EQU       2100H
LAC2          EQU       2200H
LAC3          EQU       2300H
LAC4          EQU       2400H
LAC5          EQU       2500H
LAC6          EQU       2600H
LAC7          EQU       2700H
LAC8          EQU       2800H
LAC9          EQU       2900H
LAC10         EQU       2A00H
LAC11         EQU       2B00H
LAC12         EQU       2C00H
LAC13         EQU       2D00H
LAC14         EQU       2E00H
LAC15         EQU       2F00H
LACK          EQU      0CA00H
LACT          EQU       4200H  ;*
LALK0         EQU      0D001H  ;*2
LALK1         EQU      0D101H  ;*2
LALK2         EQU      0D201H  ;*2
LALK3         EQU      0D301H  ;*2
LALK4         EQU      0D401H  ;*2
LALK5         EQU      0D501H  ;*2
LALK6         EQU      0D601H  ;*2
LALK7         EQU      0D701H  ;*2
LALK8         EQU      0D801H  ;*2
LALK9         EQU      0D901H  ;*2
LALK10        EQU      0DA01H  ;*2
LALK11        EQU      0DB01H  ;*2
LALK12        EQU      0DC01H  ;*2
LALK13        EQU      0DD01H  ;*2
LALK14        EQU      0DE01H  ;*2
LALK15        EQU      0DF01H  ;*2
LAR0          EQU       3000H
LAR1          EQU       3100H
LAR2          EQU       3200H
LAR3          EQU       3300H
LAR4          EQU       3400H
LAR5          EQU       3500H
LAR6          EQU       3600H
LAR7          EQU       3700H
LARK0         EQU      0C000H
LARK1         EQU      0C100H
LARK2         EQU      0C200H
LARK3         EQU      0C300H
LARK4         EQU      0C400H
LARK5         EQU      0C500H
LARK6         EQU      0C600H
LARK7         EQU      0C700H
LARP0         EQU       5588H
LARP1         EQU       5589H
LARP2         EQU       558AH
LARP3         EQU       558BH
LARP4         EQU       558CH
LARP5         EQU       558DH
LARP6         EQU       558EH
LARP7         EQU       558FH
LDP           EQU       5200H
LDPK          EQU      0C800H
LDP0          EQU      0C800H
LDP1          EQU      0C801H
LPH           EQU       5300H  ;*
LRLK0         EQU      0D000H  ;*2
LRLK1         EQU      0D100H  ;*2
LRLK2         EQU      0D200H  ;*2
LRLK3         EQU      0D300H  ;*2
LRLK4         EQU      0D400H  ;*2
LRLK5         EQU      0D500H  ;*2
LRLK6         EQU      0D600H  ;*2
LRLK7         EQU      0D700H  ;*2
LST           EQU       5000H
LST1          EQU       5100H  ;*
PSPLT         EQU       3C00H
LTA           EQU       3D00H
LTD           EQU       3F00H
LTP           EQU       3E00H  ;*
LTS           EQU       5B00H  ;*
MAC           EQU       5D00H  ;*2
MACD          EQU       5C00H  ;*2
MAR           EQU       5500H
MPY           EQU       3800H
MPYA          EQU       3A00H  ;*
MPYK          EQU      0A000H
MPYS          EQU       3B00H  ;*
MPYU          EQU      0CF00H  ;*
PSPNEG        EQU      0CE23H  ;*
PSPNOP        EQU       5500H
NORM          EQU      0CEA2H  ;*
PSPOR         EQU       4D00H
ORK0          EQU      0D005H  ;*2
ORK1          EQU      0D105H  ;*2
ORK2          EQU      0D205H  ;*2
ORK3          EQU      0D305H  ;*2
ORK4          EQU      0D405H  ;*2
ORK5          EQU      0D505H  ;*2
ORK6          EQU      0D605H  ;*2
ORK7          EQU      0D705H  ;*2
ORK8          EQU      0D805H  ;*2
ORK9          EQU      0D905H  ;*2
ORK10         EQU      0DA05H  ;*2
ORK11         EQU      0DB05H  ;*2
ORK12         EQU      0DC05H  ;*2
ORK13         EQU      0DD05H  ;*2
ORK14         EQU      0DE05H  ;*2
ORK15         EQU      0DF05H  ;*2
OUT0          EQU      0E000H
OUT1          EQU      0E100H
OUT2          EQU      0E200H
OUT3          EQU      0E300H
OUT4          EQU      0E400H
OUT5          EQU      0E500H
OUT6          EQU      0E600H
OUT7          EQU      0E700H
OUT8          EQU      0E800H
OUT9          EQU      0E900H
OUT10         EQU      0EA00H
OUT11         EQU      0EB00H
OUT12         EQU      0EC00H
OUT13         EQU      0ED00H
OUT14         EQU      0EE00H
OUT15         EQU      0EF00H
PAC           EQU      0CE14H
PSPPOP        EQU      0CE1DH
POPD          EQU       7A00H  ;*
PSPPUSH       EQU      0CE1CH
PSHD          EQU       5400H  ;*
PSPRET        EQU      0CE26H
PSPROL        EQU      0CE34H  ;*
PSPROR        EQU      0CE35H  ;*
RC            EQU      0CE30H  ;*
RHM           EQU      0CE38H  ;*
RFSM          EQU      0CE36H  ;*
RPT           EQU       4B00H  ;*
RPTK          EQU      0CB00H  ;*
RSXM          EQU      0CE06H  ;*
RTC           EQU      0CE32H  ;*
RTXM          EQU      0CE20H  ;*
RXF           EQU      0CE0CH  ;*
ROVM          EQU      0CE02H
SACH0         EQU       6800H
SACH1         EQU       6900H
SACH2         EQU       6A00H
SACH3         EQU       6B00H
SACH4         EQU       6C00H
SACH5         EQU       6D00H
SACH6         EQU       6E00H
SACH7         EQU       6F00H
SACL          EQU       6000H
SACL0         EQU       6000H
SACL1         EQU       6100H
SACL2         EQU       6200H
SACL3         EQU       6300H
SACL4         EQU       6400H
SACL5         EQU       6500H
SACL6         EQU       6600H
SACL7         EQU       6700H
SAR0          EQU       7000H
SAR1          EQU       7100H
SAR2          EQU       7200H
SAR3          EQU       7300H
SAR4          EQU       7400H
SAR5          EQU       7500H
SAR6          EQU       7600H
SAR7          EQU       7700H
SBLK0         EQU      0D003H  ;*2
SBLK1         EQU      0D103H  ;*2
SBLK2         EQU      0D203H  ;*2
SBLK3         EQU      0D303H  ;*2
SBLK4         EQU      0D403H  ;*2
SBLK5         EQU      0D503H  ;*2
SBLK6         EQU      0D603H  ;*2
SBLK7         EQU      0D703H  ;*2
SBLK8         EQU      0D803H  ;*2
SBLK9         EQU      0D903H  ;*2
SBLK10        EQU      0DA03H  ;*2
SBLK11        EQU      0DB03H  ;*2
SBLK12        EQU      0DC03H  ;*2
SBLK13        EQU      0DD03H  ;*2
SBLK14        EQU      0DE03H  ;*2
SBLK15        EQU      0DF03H  ;*2
SBRK          EQU       7F00H  ;*
SC            EQU      0CE31H  ;*
SFL           EQU      0CE18H  ;*
SFR           EQU      0CE19H  ;*
SFSM          EQU      0CE37H  ;*
SHM           EQU      0CE39H  ;*
SOVM          EQU      0CE03H
SPAC          EQU      0CE16H
SPH           EQU       7D00H  ;*
SPL           EQU       7C00H  ;*
SPM0          EQU      0CE08H  ;*
SPML1         EQU      0CE09H  ;*
SPML4         EQU      0CE0AH  ;*
SPMR6         EQU      0CE0BH  ;*
SQRA          EQU       3900H  ;*
SQRS          EQU       5A00H  ;*
SST           EQU       7800H
SST1          EQU       7900H  ;*
SSXM          EQU      0CE07H  ;*
PSPSTC        EQU      0CE33H  ;*
STXM          EQU      0CE21H  ;*
SUB0          EQU       1000H
SUB1          EQU       1100H
SUB2          EQU       1200H
SUB3          EQU       1300H
SUB4          EQU       1400H
SUB5          EQU       1500H
SUB6          EQU       1600H
SUB7          EQU       1700H
SUB8          EQU       1800H
SUB9          EQU       1900H
SUB10         EQU       1A00H
SUB11         EQU       1B00H
SUB12         EQU       1C00H
SUB13         EQU       1D00H
SUB14         EQU       1E00H
SUB15         EQU       1F00H
SUBB          EQU       4F00H  ;*
SUBC          EQU       4700H
SUBH          EQU       4400H
SUBK          EQU      0CD00H  ;*
SUBS          EQU       4500H
SUBT          EQU      04600H  ;*
SXF           EQU      0CE0DH  ;*
TBLR          EQU       5800H
TBLW          EQU       5900H
TRAP          EQU      0CE1EH  ;*
PSPXOR        EQU       4C00H
XORK0         EQU      0D006H  ;*2
XORK1         EQU      0D106H  ;*2
XORK2         EQU      0D206H  ;*2
XORK3         EQU      0D306H  ;*2
XORK4         EQU      0D406H  ;*2
XORK5         EQU      0D506H  ;*2
XORK6         EQU      0D606H  ;*2
XORK7         EQU      0D706H  ;*2
XORK8         EQU      0D806H  ;*2
XORK9         EQU      0D906H  ;*2
XORK10        EQU      0DA06H  ;*2
XORK11        EQU      0DB06H  ;*2
XORK12        EQU      0DC06H  ;*2
XORK13        EQU      0DD06H  ;*2
XORK14        EQU      0DE06H  ;*2
XORK15        EQU      0DF06H  ;*2
ZAC           EQU      0CA00H
ZALH          EQU       4000H
ZALR          EQU       7B00H  ;*
ZALS          EQU       4100H

;*************************
; Data Page 4 (B0 200-27F)
PAGE4         EQU        200H
PAGE5         EQU        280H
PAGE6         EQU        300H
PAGE7         EQU        380H


RAMP1A        EQU          0   ; Instrument 1 vars
RAMP1B        EQU          1
RAMP1C        EQU          2
YN1           EQU          3
YN2           EQU          4
FOINC1A       EQU          5   ; Instrument 1 inputs
FOINC1B       EQU          6
FOINC1C       EQU          7
PW1           EQU          8
B11           EQU          9
B21           EQU         0AH
;LP1          EQU         0BH  ;????
A01           EQU         0CH
ENV1          EQU         0DH

M7FFF         EQU         0EH  ;????
ONE           EQU         0FH

; Inst 2 10H - 1DH
PRVSAMPL      EQU         1EH
PRVSAMPR      EQU         1FH

; Inst 3 20H - 2DH
TEMP5         EQU         2EH
NOTETBL       EQU         2FH  ;????  Used temporarily during MISC.PSP

; Inst 4 30H - 3DH
HIGHBIT       EQU         3EH
NOISE         EQU         3FH

; Inst 5 40H - 4DH
;GATES        EQU         4EH  ;????
GATESXOR      EQU         4FH  ; mask of changed gates

; Inst 6 50H - 5DH
CURCHAN       EQU         5EH  ; Current channel bitmask
CHANPAGE      EQU         5FH  ; Current channel page (40-4x)

; Inst 7 60H - 6DH
CHANVPTR      EQU         6EH  ; -> current channel variables (RAMP1A)
TEMP4         EQU         6FH

TEST0         EQU        112   ; Page 63, Address 1FF0
;*****************************

FIXNONE       EQU          0
FIXDATA       EQU          1
FIXCODE       EQU          2

;****************
; Segment layout
;****************
dgroup  group   NULL,_DATA,CONST,_BSS,far_BSS

NULL    segment word public 'BEGDATA'
NULL    ends

_DATA   segment word public 'DATA'      ; All code and data segments must be
                                        ; named and declared public
_DATA   ends

CONST   segment word public 'CONST'
CONST   ends

FAR_BSS segment word public 'FAR_BSS'
FAR_BSS ends

_BSS    segment word public 'BSS'
_BSS    ends

_TEXT   segment  byte public 'CODE'     ;Define code segment
_TEXT   ends

;**************************************************************************
_DATA SEGMENT
;**************************************************************************
 PUBLIC _WFSUBTBL
_WFSUBTBL DW    OFFSET RAMPTRI          ; Ramp/tri
        DW      OFFSET RAMPSBP          ; 3 Ramps
        DW      OFFSET PULSEBP          ; Pulse
        DW      OFFSET TRINOISE         ; Triangle + Noise
        DW      OFFSET TRITRI           ; 2 Triangles
        DW      OFFSET NOISEBP          ; Noise
        DW      OFFSET RING             ; Tri + (Tri * Tri) (no filter)
        DW      OFFSET RAMPSUB          ; Ramp+Suboctave Ramp
        DW      OFFSET RAMPRING         ; Ramp + (Ramp * Tri) + filter
        DW      OFFSET RAMPRINGNC       ; Ramp * Tri + filter
        DW      OFFSET OFF              ; Off
        DW      OFFSET OFF              ; Off
        DW      OFFSET OFF              ; Off
        DW      OFFSET OFF              ; Off
        DW      OFFSET OFF              ; Off
        DW      OFFSET OFF              ; Off

      PUBLIC _SUBEND
_SUBEND DW      MAR+ARPLUS              ;1 Inc buffer pointer 2 & set AR0 for banz
        DW      MAR+ARPLUS0             ;2
        DW      BANZ+(ARMINUS3-AR)      ;3 Loop, dec AR, and set AR=3
SUBENDE EQU     THIS WORD

;******************************
; RAMPS 3 Ramps + Bandpass (53)
;******************************
RAMPSBP DB      53
 DB     FIXDATA
        DW      LAC0+RAMP1A     ;1
 DB     FIXDATA
        DW      ADD0+FOINC1A    ;2
 DB     FIXDATA
        DW      SACL0+RAMP1A    ;3
 DB     FIXDATA
        DW      LAC0+RAMP1B     ;4
 DB     FIXDATA
        DW      ADD0+FOINC1B    ;5
 DB     FIXDATA
        DW      SACL0+RAMP1B    ;6
 DB     FIXDATA
        DW      LAC0+RAMP1C     ;7
 DB     FIXDATA
        DW      ADD0+FOINC1C    ;8
 DB     FIXDATA
        DW      SACL0+RAMP1C    ;9
 DB     FIXDATA
        DW      LAC14+RAMP1C    ;10
 DB     FIXDATA
        DW      ADD14+RAMP1B    ;11
 DB     FIXDATA
        DW      ADD14+RAMP1A    ;12
 DB     FIXNONE
        DW      SACH0+TEMP4     ;13
; Envelope Shaper
 DB FIXDATA
        DW      PSPLT+ENV1      ;14
 DB FIXNONE
        DW      MPY+TEMP4       ;15     P = Waveform * ENVn
 DB FIXDATA
        DW      LTP+A01         ;16     Into ACC           (s31b)
 DB FIXNONE
        DW      SACH0+TEMP4     ;17      and back into buffer (s15b)
;  Bandpass Filter
 DB FIXNONE
        DW      MPY+TEMP4       ;18     times input
 DB FIXDATA
        DW      LTP+YN2         ;19     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;20
 DB FIXDATA
        DW      LTD+YN1         ;21
 DB FIXDATA
        DW      MPY+B11         ;22
 DB FIXDATA
        DW      LTA+ENV1        ;23
 DB FIXNONE
        DW      APAC            ;24
 DB FIXDATA
        DW      SACH0+YN1       ;25
; Sum output
 DB FIXNONE
        DW      ADDH+AR         ;26
 DB FIXNONE
        DW      SACH0+ARPLUS    ;27      and back into buffer (s15b)
;*** 2nd sample ***
 DB     FIXDATA
        DW      LAC0+RAMP1A     ;28
 DB     FIXDATA
        DW      ADD0+FOINC1A    ;29
 DB     FIXDATA
        DW      SACL0+RAMP1A    ;30
 DB     FIXDATA
        DW      LAC0+RAMP1B     ;31
 DB     FIXDATA
        DW      ADD0+FOINC1B    ;32
 DB     FIXDATA
        DW      SACL0+RAMP1B    ;33
 DB     FIXDATA
        DW      LAC0+RAMP1C     ;34
 DB     FIXDATA
        DW      ADD0+FOINC1C    ;35
 DB     FIXDATA
        DW      SACL0+RAMP1C    ;36
 DB     FIXDATA
        DW      LAC14+RAMP1C    ;37
 DB     FIXDATA
        DW      ADD14+RAMP1B    ;38
 DB     FIXDATA
        DW      ADD14+RAMP1A    ;39
 DB     FIXNONE
        DW      SACH0+TEMP4     ;40
; Envelope Shaper
 DB FIXNONE
        DW      MPY+TEMP4       ;41     P = Waveform * ENVn
 DB FIXDATA
        DW      LTP+A01         ;42     Into ACC           (s31b)
 DB FIXNONE
        DW      SACH0+TEMP4     ;43      and back into buffer (s15b)
;  Bandpass Filter
 DB FIXNONE
        DW      MPY+TEMP4       ;44     Input times gain (already in T)
 DB FIXDATA
        DW      LTP+YN2         ;45     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;46
 DB FIXDATA
        DW      LTD+YN1         ;47
 DB FIXDATA
        DW      MPY+B11         ;48
 DB FIXNONE
        DW      APAC            ;49
 DB FIXNONE
        DW      APAC            ;50
 DB FIXDATA
        DW      SACH0+YN1       ;51
; Sum output
 DB FIXNONE
        DW      ADDH+AR         ;52
 DB FIXNONE
        DW      SACH0+ARMINUS   ;53      and back into buffer (s15b)

;*********
; OFF (0)
;*********
OFF     DB      0

;***********************************
; TRITRI  2 triangles + Bandpass (53)
;***********************************
TRITRI  DB      53
 DB FIXDATA
        DW      LAC0+RAMP1B     ;1      Update ramp B
 DB FIXDATA
        DW      ADD0+FOINC1B    ;2
 DB FIXDATA
        DW      SACL0+RAMP1B    ;3
 DB FIXNONE
        DW      PSPABS          ;4      Convert to triangle
 DB FIXNONE
        DW      SUB13+ONE       ;5
 DB FIXNONE
        DW      SACL+TEMP4      ;6
 DB FIXDATA
        DW      LAC0+RAMP1C     ;7      Update ramp C
 DB FIXDATA
        DW      ADD0+FOINC1C    ;8
 DB FIXDATA
        DW      SACL+RAMP1C     ;9
 DB FIXNONE
        DW      PSPABS          ;10     Convert to triangle
 DB FIXNONE
        DW      SUB13+ONE       ;11
 DB FIXNONE
        DW      ADD0+TEMP4      ;12
 DB FIXNONE
        DW      SACL0+TEMP4     ;13
; Envelope Shaper               ;       u31 * u31 = u30
 DB FIXDATA
        DW      PSPLT+ENV1      ;14
 DB FIXNONE
        DW      MPY+TEMP4       ;15     P = Waveform * ENVn
 DB FIXDATA
        DW      LTP+A01         ;16
 DB FIXNONE
        DW      SACH0+TEMP4     ;17
;  Bandpass Filter
 DB FIXNONE
        DW      MPY+TEMP4       ;18     times input
 DB FIXDATA
        DW      LTP+YN2         ;19     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;20
 DB FIXDATA
        DW      LTD+YN1         ;21
 DB FIXDATA
        DW      MPY+B11         ;22
 DB FIXDATA
        DW      LTA+ENV1        ;23
 DB FIXNONE
        DW      APAC            ;24
 DB FIXDATA
        DW      SACH0+YN1       ;25
; Output summer
 DB     FIXNONE
        DW      ADDH+AR         ;26     Add it to buffer
 DB     FIXNONE
        DW      SACH0+ARPLUS    ;27
;*** 2nd Sample ***
 DB     FIXDATA
        DW      LAC0+RAMP1B     ;28     Update ramp B
 DB     FIXDATA
        DW      ADD0+FOINC1B    ;29
 DB     FIXDATA
        DW      SACL0+RAMP1B    ;30
 DB     FIXNONE
        DW      PSPABS          ;31     Convert to triangle
 DB     FIXNONE
        DW      SUB13+ONE       ;32
 DB     FIXNONE
        DW      SACL+TEMP4      ;33
 DB     FIXDATA
        DW      LAC0+RAMP1C     ;34     Update ramp C
 DB     FIXDATA
        DW      ADD1+FOINC1C    ;35
 DB     FIXDATA
        DW      SACL+RAMP1C     ;36
 DB     FIXNONE
        DW      PSPABS          ;37     Convert to triangle
 DB     FIXNONE
        DW      SUB13+ONE       ;38
 DB     FIXNONE
        DW      ADD0+TEMP4      ;39
 DB     FIXNONE
        DW      SACL0+TEMP4     ;40
; Envelope Shaper               ;       u31 * u31 = u30
 DB FIXNONE
        DW      MPY+TEMP4       ;41     P = Waveform * ENVn
 DB FIXDATA
        DW      LTP+A01         ;42
 DB FIXNONE
        DW      SACH0+TEMP4     ;43
; Bandpass filter
 DB FIXNONE
        DW      MPY+TEMP4       ;44     times input
 DB FIXDATA
        DW      LTP+YN2         ;45     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;46
 DB FIXDATA
        DW      LTD+YN1         ;47
 DB FIXDATA
        DW      MPY+B11         ;48
 DB FIXNONE
        DW      APAC            ;49
 DB FIXNONE
        DW      APAC            ;50
 DB FIXDATA
        DW      SACH0+YN1       ;51
; Output summer
 DB     FIXNONE
        DW      ADDH+AR         ;52     Add it to buffer
 DB     FIXNONE
        DW      SACH0+ARMINUS   ;53

;***************************
; PULSE Pulse + Bandpass (39)
;***************************
; Pulse is generated by taking advantage of sign extenstion into ACCH.
; RAMPn = -32k to +32k, PWn = 0 to +32k
; When Ramp + PW < 0, then ACCH = FFFFH, else ACCH = 0.
PULSEBP DB      39
 DB     FIXDATA
        DW      LAC0+RAMP1A     ;1      Update Ramp A
 DB     FIXDATA
        DW      ADD0+FOINC1A    ;2
 DB     FIXDATA
        DW      SACL+RAMP1A     ;3
 DB     FIXDATA
        DW      ADD0+PW1        ;4      ACC = -PWn + RAMP1A
 DB     FIXNONE
        DW      SUB15+HIGHBIT   ;5      Convert FFFF and 0000
 DB     FIXNONE
        DW      SACH1+TEMP4     ;6
; Envelope Shaper               ;       u31 * u31 = u30
 DB FIXDATA
        DW      PSPLT+ENV1      ;7
 DB FIXNONE
        DW      MPY+TEMP4       ;8      P = Waveform * ENVn
 DB FIXDATA
        DW      LTP+A01         ;9      Into ACC           (s31b)
 DB FIXNONE
        DW      SACH0+TEMP4     ;10      and back into buffer (s15b)
;  Bandpass Filter
 DB FIXNONE
        DW      MPY+TEMP4       ;11     times input
 DB FIXDATA
        DW      LTP+YN2         ;12     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;13
 DB FIXDATA
        DW      LTD+YN1         ;14
 DB FIXDATA
        DW      MPY+B11         ;15
 DB FIXDATA
        DW      LTA+ENV1        ;16
 DB FIXNONE
        DW      APAC            ;17
 DB FIXDATA
        DW      SACH0+YN1       ;18
; Output summer
 DB FIXNONE
        DW      ADDH+AR         ;19
 DB FIXNONE
        DW      SACH0+ARPLUS    ;20      and back into buffer (s15b)
;*** 2nd sample ***
 DB     FIXDATA
        DW      LAC0+RAMP1A     ;21     Update Ramp A
 DB     FIXDATA
        DW      ADD0+FOINC1A    ;22
 DB     FIXDATA
        DW      SACL+RAMP1A     ;23
 DB     FIXDATA
        DW      ADD0+PW1        ;24     ACC = -PWn + RAMP1A
 DB     FIXNONE
        DW      SUB15+HIGHBIT   ;25     Convert FFFF and 0000
 DB     FIXNONE
        DW      SACH1+TEMP4     ;26
; Envelope Shaper               ;       u31 * u31 = u30
 DB FIXNONE
        DW      MPY+TEMP4       ;27     P = Waveform * ENVn
 DB FIXDATA
        DW      LTP+A01         ;28     Into ACC           (s31b)
 DB FIXNONE
        DW      SACH0+TEMP4     ;29      and back into buffer (s15b)
;  Bandpass Filter
 DB FIXNONE
        DW      MPY+TEMP4       ;30     Gain times input
 DB FIXDATA
        DW      LTP+YN2         ;31     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;32
 DB FIXDATA
        DW      LTD+YN1         ;33
 DB FIXDATA
        DW      MPY+B11         ;34
 DB FIXDATA
        DW      LTA+ENV1        ;35
 DB FIXNONE
        DW      APAC            ;36
 DB FIXDATA
        DW      SACH0+YN1       ;37
; Output summer
 DB FIXNONE
        DW      ADDH+AR         ;38
 DB FIXNONE
        DW      SACH0+ARMINUS   ;39      and back into buffer (s15b)

;******************************
; NOISEBP Noise + bandpass (35)
;******************************
NOISEBP DB      35
 DB     FIXNONE
        DW      SPM0            ;1
 DB     FIXNONE
        DW      MAR+ARSET4      ;2 Set NOISE = (NOISE*13709)+13849      AR=4
 DB     FIXNONE
        DW      ZALS+ARPLUS     ;3      ACC = 13849                     AR=4
 DB     FIXNONE
        DW      PSPLT+NOISE     ;4        T = 13709
 DB     FIXNONE
        DW      MPYU+ARMINUS3   ;5        * NOISE                       AR=3
 DB     FIXDATA
        DW      LTA+ENV1        ;6        Add to ACC
 DB     FIXNONE
        DW      SACL+NOISE      ;7        save result
 DB     FIXNONE
        DW      SACH7+TEMP4     ;8
 DB     FIXNONE
        DW      SPML1           ;9
; Envelope Shaper               ;       u31 * u31 = u30
 DB     FIXNONE
        DW      MPY+TEMP4       ;10     P = Waveform * ENVn
 DB     FIXDATA
        DW      LTP+A01         ;11     Into ACC           (s31b)
 DB     FIXNONE
        DW      SACH0+TEMP4     ;12      and into buffer  (s15b)        AR=3
;  Bandpass Filter
 DB FIXNONE
        DW      MPY+TEMP4       ;13     times input
 DB FIXDATA
        DW      LTP+YN2         ;14     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;15
 DB FIXDATA
        DW      LTD+YN1         ;16
 DB FIXDATA
        DW      MPY+B11         ;17
 DB FIXDATA
        DW      LTA+ENV1        ;18
 DB FIXNONE
        DW      APAC            ;19
 DB FIXDATA
        DW      SACH0+YN1       ;20
; Sum output
 DB     FIXNONE
        DW      ADDH+AR         ;21                                     AR=3
 DB     FIXNONE
        DW      SACH0+ARPLUS    ;22      and into buffer  (s15b)        AR=3
;*** 2nd Sample ***
; Envelope Shaper               ;       u31 * u31 = u30
 DB     FIXNONE
        DW      MPY+NOISE       ;23     P = Waveform * ENVn
 DB     FIXDATA
        DW      LTP+A01         ;24     Into ACC           (s31b)
 DB     FIXNONE
        DW      SACH0+TEMP4     ;25      and into buffer  (s15b)        AR=3
;  Bandpass Filter
 DB FIXNONE
        DW      MPY+TEMP4       ;26     times input
 DB FIXDATA
        DW      LTP+YN2         ;27     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;28
 DB FIXDATA
        DW      LTD+YN1         ;29
 DB FIXDATA
        DW      MPY+B11         ;30
 DB FIXNONE
        DW      APAC            ;31
 DB FIXNONE
        DW      APAC            ;32
 DB FIXDATA
        DW      SACH0+YN1       ;33
; Sum output
 DB     FIXNONE
        DW      ADDH+AR         ;34                                     AR=3
 DB     FIXNONE
        DW      SACH0+ARMINUS   ;35      and into buffer  (s15b)        AR=3

;****************************************
; TRINOISE triangle + filtered noise (37)
;****************************************
TRINOISE DB     37
; Noise Generator
 DB     FIXNONE
        DW      SPM0            ;1
 DB     FIXNONE
        DW      MAR+ARSET4      ;2 Set NOISE = (NOISE*13709)+13849      AR=4
 DB     FIXNONE
        DW      ZALS+ARPLUS     ;3      ACC = 13849                     AR=4
 DB     FIXNONE
        DW      PSPLT+NOISE     ;4        T = 13709
 DB     FIXNONE
        DW      MPYU+ARMINUS3   ;5        * NOISE                       AR=3
 DB     FIXDATA
        DW      LTA+A01         ;6        Add to ACC
 DB     FIXNONE
        DW      SACL+NOISE      ;7        save result
 DB     FIXNONE
        DW      SPML1           ;8
;  Bandpass Filter
 DB FIXNONE
        DW      MPY+NOISE       ;9      times input
 DB FIXDATA
        DW      LTP+YN2         ;10     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;11
 DB FIXDATA
        DW      LTD+YN1         ;12
 DB FIXDATA
        DW      MPY+B11         ;13
 DB FIXDATA
        DW      LTA+PW1         ;14
 DB FIXNONE
        DW      APAC            ;15
 DB FIXNONE
        DW      SACH0+TEMP5     ;16
; Triangle generator
 DB     FIXDATA
        DW      LAC0+RAMP1A     ;17    Update ramp A
 DB     FIXDATA
        DW      ADD0+FOINC1A    ;18
 DB     FIXDATA
        DW      SACL+RAMP1A     ;19
 DB     FIXNONE
        DW      PSPABS          ;20     Convert to triangle
 DB     FIXNONE
        DW      SUB14+ONE       ;21
 DB     FIXNONE
        DW      SACL0+TEMP4     ;22
;  Mixer
 DB     FIXNONE
        DW      MPY+TEMP4       ;23     Triangle * PW
 DB     FIXNONE
        DW      LAC0+M7FFF      ;24     Plus Noise * (7FFF-PW)
 DB     FIXDATA
        DW      SUB0+PW1        ;25
 DB     FIXNONE
        DW      SACL0+TEMP4     ;26     TEMP4 = (7FFF - PW)
 DB     FIXNONE
        DW      LTP+TEMP4       ;27
 DB     FIXNONE
        DW      MPY+TEMP5       ;28     (7FFF - PW) * filtered Noise
 DB     FIXDATA
        DW      LTA+ENV1        ;29
 DB     FIXNONE
        DW      SACH1+TEMP4     ;30

; Envelope Shaper               ;       u31 * u31 = u30
 DB     FIXNONE
        DW      MPY+TEMP4       ;31     P = Waveform * ENVn
 DB     FIXNONE
        DW      ZALH+AR         ;32
 DB     FIXNONE
        DW      APAC            ;33     Into ACC           (s31b)
 DB     FIXNONE
        DW      SACH0+ARPLUS    ;34      and into buffer  (s15b)
 DB     FIXNONE
        DW      ZALH+AR         ;35
 DB     FIXNONE
        DW      APAC            ;36
 DB     FIXNONE
        DW      SACH0+ARMINUS   ;37     and next point

;***********************************************
; RAMPTRI       1 triangle/ramp + Bandpass (45)
;***********************************************
RAMPTRI DB      45
 DB     FIXDATA
        DW      LAC0+RAMP1A     ;1      Update ramp A
 DB     FIXDATA
        DW      ADD0+FOINC1A    ;2
 DB     FIXDATA
        DW      SACL0+RAMP1A    ;3
 DB     FIXDATA
        DW      LAC14+RAMP1A    ;4
 DB     FIXDATA
        DW      ADD14+PW1       ;5
 DB     FIXNONE
        DW      PSPABS          ;6      Convert to triangle
 DB     FIXNONE
        DW      SUB13+M7FFF     ;7
 DB     FIXDATA
        DW      SUB13+PW1       ;8
 DB     FIXNONE
        DW      SACH1+TEMP4     ;9
; Envelope Shaper (placed here allows filter to remove clicks)
 DB     FIXDATA
        DW      PSPLT+ENV1      ;10
 DB     FIXNONE
        DW      MPY+TEMP4       ;11     P = Waveform * ENVn
 DB     FIXDATA
        DW      LTP+A01         ;12
 DB     FIXNONE
        DW      SACH0+TEMP4     ;13
;  Bandpass Filter
 DB FIXNONE
        DW      MPY+TEMP4       ;14     Gain times input
 DB FIXDATA
        DW      LTP+YN2         ;15     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;16
 DB FIXDATA
        DW      LTD+YN1         ;17
 DB FIXDATA
        DW      MPY+B11         ;18
 DB FIXDATA
        DW      LTA+ENV1        ;19
 DB FIXNONE
        DW      APAC            ;20
 DB FIXDATA
        DW      SACH0+YN1       ;21
; Output summer
 DB FIXNONE
        DW      ADDH+AR         ;22
 DB FIXNONE
        DW      SACH0+ARPLUS    ;23      and into buffer (s15b)
;*** 2nd sample ***
 DB FIXDATA
        DW      LAC0+RAMP1A     ;24     Update ramp A
 DB FIXDATA
        DW      ADD0+FOINC1A    ;25
 DB FIXDATA
        DW      SACL0+RAMP1A    ;26
 DB FIXDATA
        DW      LAC14+RAMP1A    ;27
 DB FIXDATA
        DW      ADD14+PW1       ;28
 DB FIXNONE
        DW      PSPABS          ;29     Convert to triangle
 DB FIXNONE
        DW      SUB13+M7FFF     ;30
 DB FIXDATA
        DW      SUB13+PW1       ;31
 DB FIXNONE
        DW      SACH1+TEMP4     ;32
; Envelope Shaper               ;       u31 * u31 = u30
 DB FIXNONE
        DW      MPY+TEMP4       ;33     P = Waveform * ENVn
 DB FIXDATA
        DW      LTP+A01         ;34
 DB FIXNONE
        DW      SACH0+TEMP4     ;35
;  Bandpass Filter
 DB FIXNONE
        DW      MPY+TEMP4       ;36     Gain times input
 DB FIXDATA
        DW      LTP+YN2         ;37     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;38
 DB FIXDATA
        DW      LTD+YN1         ;39
 DB FIXDATA
        DW      MPY+B11         ;40
 DB FIXDATA
        DW      LTA+ENV1        ;41
 DB FIXNONE
        DW      APAC            ;42
 DB FIXDATA
        DW      SACH0+YN1       ;43
; Output summer
 DB FIXNONE
        DW      ADDH+AR         ;44
 DB FIXNONE
        DW      SACH0+ARMINUS   ;45      and into buffer (s15b)

;***********************************************
; RAMPSUB       1 triangle/ramp + Bandpass (50)
;***********************************************
RAMPSUB DB      50
 DB     FIXDATA
        DW      LAC0+RAMP1B     ;1      Update ramp B
 DB     FIXDATA
        DW      ADD0+FOINC1A    ;2      (Use A's inc)
 DB     FIXDATA
        DW      SACL0+RAMP1B    ;3
 DB     FIXDATA
        DW      LAC0+RAMP1A     ;4      Update ramp A
 DB     FIXDATA
        DW      ADD0+FOINC1A    ;5
 DB     FIXDATA
        DW      SACL0+RAMP1A    ;6
 DB     FIXDATA
        DW      LAC14+RAMP1A    ;7
 DB     FIXDATA
        DW      ADD14+PW1       ;8
 DB     FIXNONE
        DW      PSPABS          ;9      Convert to triangle
 DB     FIXNONE
        DW      SUB13+M7FFF     ;10
 DB     FIXDATA
        DW      SUB13+PW1       ;11
 DB     FIXDATA
        DW      ADD15+RAMP1B    ;12
 DB     FIXNONE
        DW      SACH0+TEMP4     ;13
; Envelope Shaper               ;       u31 * u31 = u30
 DB     FIXDATA
        DW      PSPLT+ENV1      ;14
 DB     FIXNONE
        DW      MPY+TEMP4       ;15     P = Waveform * ENVn
 DB     FIXDATA
        DW      LTP+A01         ;16
 DB     FIXNONE
        DW      SACH0+TEMP4     ;17
;  Bandpass Filter
 DB FIXNONE
        DW      MPY+TEMP4       ;18     Gain times input
 DB FIXDATA
        DW      LTP+YN2         ;19     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;20
 DB FIXDATA
        DW      LTD+YN1         ;21
 DB FIXDATA
        DW      MPY+B11         ;22
 DB FIXDATA
        DW      LTA+ENV1        ;23
 DB FIXNONE
        DW      APAC            ;24
 DB FIXDATA
        DW      SACH0+YN1       ;25
; Output summer
 DB     FIXNONE
        DW      ADDH+AR         ;26
 DB     FIXNONE
        DW      SACH0+ARPLUS    ;27      and into buffer (s15b)
;*** 2nd sample ***
 DB     FIXDATA
        DW      LAC0+RAMP1A     ;28     Update ramp A
 DB     FIXDATA
        DW      ADD0+FOINC1A    ;29
 DB     FIXDATA
        DW      SACL0+RAMP1A    ;30
 DB     FIXDATA
        DW      LAC14+RAMP1A    ;31
 DB     FIXDATA
        DW      ADD14+PW1       ;32
 DB     FIXNONE
        DW      PSPABS          ;33     Convert to triangle
 DB     FIXNONE
        DW      SUB13+M7FFF     ;34
 DB     FIXDATA
        DW      SUB13+PW1       ;35
 DB     FIXDATA
        DW      ADD15+RAMP1B    ;36
 DB     FIXNONE
        DW      SACH0+TEMP4     ;37
; Envelope Shaper               ;       u31 * u31 = u30
 DB     FIXNONE
        DW      MPY+TEMP4       ;38     P = Waveform * ENVn
 DB     FIXDATA
        DW      LTP+A01         ;39
 DB     FIXNONE
        DW      SACH0+TEMP4     ;40
;  Bandpass Filter
 DB FIXNONE
        DW      MPY+TEMP4       ;41     Gain times input
 DB FIXDATA
        DW      LTP+YN2         ;42     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;43
 DB FIXDATA
        DW      LTD+YN1         ;44
 DB FIXDATA
        DW      MPY+B11         ;45
 DB FIXDATA
        DW      LTA+ENV1        ;46
 DB FIXNONE
        DW      APAC            ;47
 DB FIXDATA
        DW      SACH0+YN1       ;48
; Output summer
 DB     FIXNONE
        DW      ADDH+AR         ;49
 DB     FIXNONE
        DW      SACH0+ARMINUS   ;50      and into buffer (s15b)

;***********************************
; RINGBP  Tri * Tri -> BP  (56)
;***********************************
RINGBP  DB      56
 DB     FIXDATA
        DW      LAC0+RAMP1A     ;1      Update ramp A
 DB     FIXDATA
        DW      ADD0+FOINC1A    ;2
 DB     FIXDATA
        DW      SACL0+RAMP1A    ;3
 DB     FIXNONE
        DW      PSPABS          ;4      Convert to triangle
 DB     FIXNONE
        DW      SUB14+ONE       ;5      Restore to +/- 0
 DB     FIXNONE
        DW      SACL1+TEMP4     ;6
 DB     FIXNONE
        DW      PSPLT+TEMP4     ;7      T = Triangle B
 DB     FIXDATA
        DW      LAC0+RAMP1C     ;8      Update ramp C
 DB     FIXDATA
        DW      ADD0+PW1        ;9      Use PW for LFO pitch
 DB     FIXDATA
        DW      SACL+RAMP1C     ;10
 DB     FIXNONE
        DW      PSPABS          ;11     Convert to triangle
 DB     FIXNONE
        DW      SUB14+ONE       ;12     Restore to +/- 0
 DB     FIXNONE
        DW      SACL1+TEMP4     ;13
 DB     FIXNONE
        DW      MPY+TEMP4       ;14     P = Tri A * Tri C
 DB     FIXDATA
        DW      LTP+A01         ;15
 DB     FIXNONE
        DW      SACH0+TEMP4     ;16
;  Bandpass Filter
 DB FIXNONE
        DW      MPY+TEMP4       ;17     times input
 DB FIXDATA
        DW      LTP+YN2         ;18     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;19
 DB FIXDATA
        DW      LTD+YN1         ;20
 DB FIXDATA
        DW      MPY+B11         ;21
 DB FIXDATA
        DW      LTA+ENV1        ;22
 DB FIXNONE
        DW      APAC            ;23
 DB FIXDATA
        DW      SACH0+YN1       ;24
; Envelope Shaper               ;       u31 * u31 = u30
 DB     FIXDATA
        DW      MPY+YN1         ;25     P = Waveform * ENVn
 DB     FIXNONE
        DW      ZALH+AR         ;26     Add it to buffer
 DB     FIXNONE
        DW      APAC            ;27
 DB     FIXNONE
        DW      SACH0+ARPLUS    ;28
;*** 2nd Sample ***
 DB     FIXDATA
        DW      LAC0+RAMP1A     ;29     Update ramp A
 DB     FIXDATA
        DW      ADD0+FOINC1A    ;30
 DB     FIXDATA
        DW      SACL0+RAMP1A    ;31
 DB     FIXNONE
        DW      PSPABS          ;32     Convert to triangle
 DB     FIXNONE
        DW      SUB14+ONE       ;33     Restore to +/- 0
 DB     FIXNONE
        DW      SACL1+TEMP4     ;34
 DB     FIXNONE
        DW      PSPLT+TEMP4     ;35     T = Triangle B
 DB     FIXDATA
        DW      LAC0+RAMP1C     ;36     Update ramp C
 DB     FIXDATA
        DW      ADD0+PW1        ;37     Use PW for LFO pitch
 DB     FIXDATA
        DW      SACL+RAMP1C     ;38
 DB     FIXNONE
        DW      PSPABS          ;39     Convert to triangle
 DB     FIXNONE
        DW      SUB14+ONE       ;40     Restore to +/- 0
 DB     FIXNONE
        DW      SACL1+TEMP4     ;41
 DB     FIXNONE
        DW      MPY+TEMP4       ;42     P = Tri A * Tri C
 DB     FIXDATA
        DW      LTP+A01         ;43
 DB     FIXNONE
        DW      SACH0+TEMP4     ;44
;  Bandpass Filter
 DB FIXNONE
        DW      MPY+TEMP4       ;45     times input
 DB FIXDATA
        DW      LTP+YN2         ;46     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;47
 DB FIXDATA
        DW      LTD+YN1         ;48
 DB FIXDATA
        DW      MPY+B11         ;49
 DB FIXDATA
        DW      LTA+ENV1        ;50
 DB FIXNONE
        DW      APAC            ;51
 DB FIXDATA
        DW      SACH0+YN1       ;52
; Envelope Shaper               ;       u31 * u31 = u30
 DB     FIXDATA
        DW      MPY+YN1         ;53     P = Waveform * ENVn
 DB     FIXNONE
        DW      ZALH+AR         ;54     Add it to buffer
 DB     FIXNONE
        DW      APAC            ;55
 DB     FIXNONE
        DW      SACH0+ARMINUS   ;56



;******************************
;* RING:  Tri * Tri (no filter)
;******************************
RING  DB      42
 DB     FIXDATA
        DW      LAC0+RAMP1C     ;1      Update ramp A
 DB     FIXDATA
        DW      ADD0+PW1        ;2
 DB     FIXDATA
        DW      SACL0+RAMP1C    ;3
 DB     FIXNONE
        DW      PSPABS          ;4      Convert to triangle
 DB     FIXNONE
        DW      SUB14+ONE       ;5      Restore to +/- 0
 DB     FIXNONE
        DW      SACL0+TEMP4     ;6
 DB     FIXNONE
        DW      PSPLT+TEMP4     ;7      T = Triangle B
 DB     FIXDATA
        DW      LAC0+RAMP1A     ;8      Update ramp C
 DB     FIXDATA
        DW      ADD0+FOINC1A    ;9      Use PW for 2nd pitch
 DB     FIXDATA
        DW      SACL+RAMP1A     ;10
 DB     FIXNONE
        DW      PSPABS          ;11     Convert to triangle
 DB     FIXNONE
        DW      SUB14+ONE       ;12     Restore to +/- 0
 DB     FIXNONE
        DW      SACL0+TEMP4     ;13
 DB     FIXNONE
        DW      MPY+TEMP4       ;14     P = Tri A * Tri C
 DB     FIXNONE
        DW      LAC15+TEMP4     ;15     Add carrier back in
 DB     FIXDATA
        DW      LTA+ENV1        ;16
 DB     FIXNONE
        DW      SACH0+TEMP4     ;17
; Envelope Shaper
 DB     FIXNONE
        DW      MPY+TEMP4       ;18     P = Waveform * ENVn
 DB     FIXNONE
        DW      ZALH+AR         ;19     Add it to buffer
 DB     FIXNONE
        DW      APAC            ;20
 DB     FIXNONE
        DW      SACH0+ARPLUS    ;21
; 2nd sample
 DB     FIXDATA
        DW      LAC0+RAMP1C     ;22     Update ramp A
 DB     FIXDATA
        DW      ADD0+PW1        ;23
 DB     FIXDATA
        DW      SACL0+RAMP1C    ;24
 DB     FIXNONE
        DW      PSPABS          ;25     Convert to triangle
 DB     FIXNONE
        DW      SUB14+ONE       ;26     Restore to +/- 0
 DB     FIXNONE
        DW      SACL0+TEMP4     ;27
 DB     FIXNONE
        DW      PSPLT+TEMP4     ;28     T = Triangle B
 DB     FIXDATA
        DW      LAC0+RAMP1A     ;29     Update ramp C
 DB     FIXDATA
        DW      ADD0+FOINC1A    ;30     Use PW for 2nd pitch
 DB     FIXDATA
        DW      SACL+RAMP1A     ;31
 DB     FIXNONE
        DW      PSPABS          ;32     Convert to triangle
 DB     FIXNONE
        DW      SUB14+ONE       ;33     Restore to +/- 0
 DB     FIXNONE
        DW      SACL0+TEMP4     ;34
 DB     FIXNONE
        DW      MPY+TEMP4       ;35     P = Tri A * Tri C
 DB     FIXNONE
        DW      LAC15+TEMP4     ;36
 DB     FIXDATA
        DW      LTA+ENV1        ;37
 DB     FIXNONE
        DW      SACH0+TEMP4     ;38
; Envelope Shaper
 DB     FIXNONE
        DW      MPY+TEMP4       ;39     P = Waveform * ENVn
 DB     FIXNONE
        DW      ZALH+AR         ;40     Do 2nd sample
 DB     FIXNONE
        DW      APAC            ;41
 DB     FIXNONE
        DW      SACH0+ARMINUS   ;42


;**********************
;* Ramp + (Ramp * Tri) -> bp
;**********************
RAMPRING DB     29
 DB     FIXDATA
        DW      LAC0+RAMP1C     ;1      Update ramp A
 DB     FIXDATA
        DW      ADD0+PW1        ;2      Use PW/4 for mod Fo
 DB     FIXDATA
        DW      SACL0+RAMP1C    ;3
 DB     FIXNONE
        DW      PSPABS          ;4      Convert to triangle
 DB     FIXNONE
        DW      SUB14+ONE       ;5      Restore to +/- 0
 DB     FIXNONE
        DW      SACL0+TEMP4     ;6
 DB     FIXNONE
        DW      PSPLT+TEMP4     ;7      T = Triangle B
 DB     FIXDATA
        DW      LAC0+RAMP1A     ;8      Update ramp A
 DB     FIXDATA
        DW      ADD1+FOINC1A    ;9
 DB     FIXDATA
        DW      SACL+RAMP1A     ;10
 DB     FIXDATA
        DW      MPY+RAMP1A      ;11     P = Ramp A * Tri C
 DB     FIXDATA
        DW      LTP+A01         ;12
 DB     FIXDATA
        DW      ADD15+RAMP1A    ;13     Add carrier back in
 DB     FIXNONE
        DW      SACH0+TEMP4     ;14
;  Bandpass Filter
 DB FIXNONE
        DW      MPY+TEMP4       ;15     times input
 DB FIXDATA
        DW      LTP+YN2         ;16     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;17
 DB FIXDATA
        DW      LTD+YN1         ;18
 DB FIXDATA
        DW      MPY+B11         ;19
 DB FIXDATA
        DW      LTA+ENV1        ;20
 DB FIXNONE
        DW      APAC            ;21
 DB FIXDATA
        DW      SACH0+YN1       ;22
; Envelope Shaper               ;       u31 * u31 = u30
 DB     FIXDATA
        DW      MPY+YN1         ;23     P = Waveform * ENVn
 DB     FIXNONE
        DW      ZALH+AR         ;24     Add it to buffer
 DB     FIXNONE
        DW      APAC            ;25
 DB     FIXNONE
        DW      SACH0+ARPLUS    ;26
 DB     FIXNONE
        DW      ZALH+AR         ;27     Do 2nd sample
 DB     FIXNONE
        DW      APAC            ;28
 DB     FIXNONE
        DW      SACH0+ARMINUS   ;29

;**********************
;* Ramp * Tri -> bp
;**********************
RAMPRINGNC DB     28
 DB     FIXDATA
        DW      LAC0+RAMP1C     ;1      Update ramp A
 DB     FIXDATA
        DW      ADD0+PW1        ;2      Use PW/4 for mod Fo
 DB     FIXDATA
        DW      SACL0+RAMP1C    ;3
 DB     FIXNONE
        DW      PSPABS          ;4      Convert to triangle
 DB     FIXNONE
        DW      SUB14+ONE       ;5      Restore to +/- 0
 DB     FIXNONE
        DW      SACL0+TEMP4     ;6
 DB     FIXNONE
        DW      PSPLT+TEMP4     ;7      T = Triangle B
 DB     FIXDATA
        DW      LAC0+RAMP1A     ;8      Update ramp A
 DB     FIXDATA
        DW      ADD1+FOINC1A    ;9
 DB     FIXDATA
        DW      SACL+RAMP1A     ;10
 DB     FIXDATA
        DW      MPY+RAMP1A      ;11     P = Ramp A * Tri C
 DB     FIXDATA
        DW      LTP+A01         ;12
 DB     FIXNONE
        DW      SACH1+TEMP4     ;13
;  Bandpass Filter
 DB FIXNONE
        DW      MPY+TEMP4       ;14     times input
 DB FIXDATA
        DW      LTP+YN2         ;15     into ACC, T = B2
 DB FIXDATA
        DW      MPY+B21         ;16
 DB FIXDATA
        DW      LTD+YN1         ;17
 DB FIXDATA
        DW      MPY+B11         ;18
 DB FIXDATA
        DW      LTA+ENV1        ;19
 DB FIXNONE
        DW      APAC            ;20
 DB FIXDATA
        DW      SACH0+YN1       ;21
; Envelope Shaper               ;       u31 * u31 = u30
 DB     FIXDATA
        DW      MPY+YN1         ;22     P = Waveform * ENVn
 DB     FIXNONE
        DW      ZALH+AR         ;23     Add it to buffer
 DB     FIXNONE
        DW      APAC            ;24
 DB     FIXNONE
        DW      SACH0+ARPLUS    ;25
 DB     FIXNONE
        DW      ZALH+AR         ;26     Do 2nd sample
 DB     FIXNONE
        DW      APAC            ;27
 DB     FIXNONE
        DW      SACH0+ARMINUS   ;28

_WFSUBEND EQU $
 PUBLIC _WFSUBEND


_DATA ENDS
      END

