#define IS_TRUK2 0
#define TRACE_ON 0
/*********************************************************************/
/*                         AUDIODD.C                                 */
/*                                                                   */
/*  This module contains the strategy routine.  It is called by      */
/*  the strategy entry point routine in DOSDD.ASM.  All code in      */
/*  this module is device-independent.  Where device specific        */
/*  processing needs to be done, it is done within functions named   */
/*  with the prefix "dev_".  Thus, the device specific note on       */
/*  routine is call "dev_noteon".  These device specific functions   */
/*  can be grouped together in a C module named so as to identify    */
/*  the device (for example, MPU.C).                                 */
/*  DOS / OS/2 differences are handled by the preprocessor via the   */
/*  "OS2" preprocessor definition.  This is passed using the CL /G   */
/*  parm.                                                            */
/*                                                                   */
/*                                                                   */
/* 5 - 6/16/91  B.Ritthaler  Merged in SPV/2 support                 */
/* 6 - 6/24/91  B.Ritthaler  Added multiple and variable length      */
/*                           buffer support.                         */
/* 61491 Added IS_K12 changes to remove MIDI support                 */
/* 62591 Holding lock until IOBUF changes                            */
/* 9 - 7/03/91  B.Ritthaler  Merged in Ron's changes for 7/10/91     */
/* 7/16/91 BRR10 - Setting up global vars (operation, etc..) if BESTFIT*/
/* 7/17/91 BRR11 - Replace AUDIO_CHANGE if one in request queue already*/
/*                 with current AUDIO_CHANGE request                 */
/* 71891 RJL - Fixed AUDIO_BUFFER q cap's value                      */
/* 7/22/91 BRR15 - Add callback support                              */
/* 7/24/91 BRR17 - Destroy any streams not already destroyed at CLOSE*/
/* 7/25/91 BRR16 - Fix buf_times for AUDIO_BUFFER call for POS_MSECS */
/* 7/31/91 BRR21 - UnLock iobufs in AUDIO_HPI before processing new  */
/*                 ones.                                             */
/* 8/01/91 BRR25 - Check rc for UnLock and PhystoGDT in AUDIO_HPI call*/
/* 8/02/91 BRR28 - Display error message if initialization fails     */
/* 8/06/91 BRR31 - New AUDIO_CHANGE structure modifications          */
/* 8/08/91 BRR38 - Don't Lock internal IOBUF buffers                 */
/* 8/09/91 BRR41 - Fix DeInstall Trap D                              */
/* 8/15/91 BRR44 - Modifications for OS/2 2.0 driver-Real Mode mostly*/
/* 8/16/91 CD MME.07-destroy stream for the closing trk only         */
/* 8/28/91 BRR50 - Added support for CBIOBUF flag for callback.      */
/* 9/4/91  BRR53 - initialize position = 0 in audio_hpi              */
/* 9/4/91  BRR54 - Make 'Tempo' 'tempo' cause externals are 'tempo'. */
/* 9/6/91  BRR58 - TIMER variable additions                          */
/* 9/9/91  BRR60 - Set position_type = MIDI_CLOCKS if MIDI mode      */
/* 9/12/91 BRR65 - Add call to DevIOCTL wait in AUDIO_WAIT           */
/* 9/17/91 BRR70 - Condense code - take out operation checks         */
/*                               - take common stuff out of dsp_run  */
/* 9/17/91 BRR71 - Don't VerifyAccess entire audio_change structure  */
/*                 if not using inputs_listed/outputs_listed         */
/* 9/18/91 MME.12- Message changes.                                  */
/* 9/25/91 MME.13-Destroy only the streams for the closing track     */
/*                This really needs to be destroy only the stream    */
/*                for the closing sysfilenum. How to do this?        */
/* 9/26/91 BRR90 - Don't return error if CLAIM_HDWR done and another */
/*                 init comes through.                               */
/* 9/30/91 BRR96 - Changes for DevChange to not pass pointers.       */
/*10/02/91 BRR104- Changes to AUD_CONTROL when setting QUEUELOCK to  */
/*                 hopefully alleviate TRAP6 in Dos Box              */
/*10/08/91 BRR113- Set AUDIO_UNDERRUN/OVERRUN for AUDIO_BUFFER       */
/*10/10/91 BRR115- Init CALLBACK vars on OPEN                        */
/*10/11/91 BRR125- Add midi_clock_counter to send position back in   */
/*                 msecs for MIDI                                    */
/*10/10/91 BRR127- Do VerifyAccess on AUDIO_STATUS pointers          */
/*10/18/91 BRR142- Add CB_DS_VAL to AUDIO_HPI and call_callback func */
/*10/22/91 BRR108- Combine Windows in with driver.                   */
/*10/22/91 BRR131- Use queue_data instead of add_char - also fix up  */
/*                 queue_data in case of CHAIN_BUFFERS or IOBUF_LOCK */
/*10/24/91 BRR150- Check Version level on AUDIO_STATUS for size of   */
/*                 audio_change structure is different               */
/*10/25/91 BRR151- Check to see if DD is down level from application */
/*10/28/91 BRR150- More changes for AUDIO_STATUS-using wrong ptr     */
/*10/31/91 BRR155- Add TIMING_SYSEX_QUEUED for MIDIFLAGS             */
/*10/31/91 BRR156- Clear UNDERRUN flag for AUDIO_WAIT just in case   */
/*10/31/91 BRR169- Don't decrement count if count = 0 in DoOutput    */
/*11/01/91 BRR170- Change some .Virt's to .Ptr's for V86 mode        */
/*11/05/91 BRR177- Change OPEN for multiple OPEN for MME streams     */
/*11/05/91 BRR178- Change setup_shadows so that .PTR no used to      */
/*                 determine .PTR.                                   */
/*11/10/91 BRR183- Call DevDeInit for AUDIO_INIT IDLE mode.          */
/*11/14/91 BRR189- Reset TRK_ARRAY to 0 if open fails                */
/*11/19/91 BRR193- Decrement count in DoOutput before call get_next  */
/*11/19/91 BRR194- ReInit xmitbuf to internal bufs at DeInit time    */
/*                 and move init_ptrs to INIT from OPEN.             */
/*11/20/91 BRR196- Check to see if already INITed before INITing     */
/*11/21/91 BRR197- Don't want OPENCOUNT to be non-zero at AUDIO_INIT */
/*                 time if DOS driver.                               */
/*11/22/91 BRR44 - Add OS/2 2.0 V86 support - see Wes                */
/*12/02/91 BRR202- Fixes for aliasing in Cruiser Virtural Mode - Wes */
/*12/04/91 BRR204- Make sure newx and newr are not NULL in SetBuffer */
/*12/05/91 BRR206- Add AUDIO_UPDATE IOCTL support                    */
/*12/10/91 BRR208- Put in conditional compiles for TRUK2 driver      */
/*12/10/91 BRR209- Combine SET_XHPI and SET_RHPI into SET_HPI        */
/*12/11/91 BRR212- Check return code from INIT.                      */
/*12/16/91 BRR210- Fix aliasing with > 2 buffers in V86 of OS/2      */
/*12/20/91 BRR213- Update Stream Table TrackNum in AUDIO_INIT        */
/* 1/06/92 BRR215- Add DevStop call.                                 */
/* 1/06/92 BRR216- Add DevPause call.                                */
/* 1/06/92 BRR217- Add DevResume call.                               */
/* 1/06/92 BRR218- Clear the PAUSED bit in AUDIO_STOP.               */
/* 1/06/92 BRR219- Check return code from DevClose                   */
/* 1/07/92 BRR222- Add VDD support.                                  */
/* 1/07/92 BRR223- Take out TrkModeSave, can use phys=2 instead      */
/* 1/10/92 BRR224- Add AUDIO_NOTIFY support                          */
/* 1/10/92 BRR225- Don't replace request if AUDIO_CHANGE request     */
/* 1/17/92 BRR231- Reset RECIO.lock_handle not XMITIO.lock_handle    */
/* 1/23/92 CMC01 - Add volume_delay parameter to DevMstVolume        */
/* 1/23/92 BRR239- Return error for odd buffer sizes passed down     */
/* 1/23/92 BRR245- Return error for buffer sizes > 64K               */
/* 1/29/92 BRR248- Don't call aud_control for OS/2                   */
/* 1/30/92 BRR249- Implement rollover_time into calculations         */
/* 1/31/92 BRR251- Fix problems with 2 track processing              */
/* 1/31/92 BRR253- Don't set QUEUE_LOCK=0 in queue request - it may  */
/*                 already be set to 1 on entry - so just inc/dec it */
/* 2/01/92 BRR254- Set up buf.Ptr after GDT set up with offset       */
/*                 Don't set linear addr on page boundary            */
/* 2/05/92 BRR257- Return error from HPI if no VDD present.          */
/* 2/06/92 BRR259- Make init_queue_vars routine for AVC midi to work */
/* 2/07/92 BRR206- AUDIO_UPDATE support in OS/2 device driver        */
/* 2/07/92 BRR260- Do 2 VerifyAccesses for iobuf                     */
/* 2/07/92 BRR261- Clear semaphore one last time before releasing it */
/* 2/10/92 WES262- Add V86 callback support                          */
/* 2/12/92 BRR265- Make version track dependent                      */
/* 2/12/92 BRR266- Replace midi_clock_count with pos_buffer_count    */
/* 2/14/92 BRR271- Return error on AUDIO_HPI if > 16 buffers         */
/* 2/19/92 BRR186- Add support for DOS 2 tracks                      */
/* 2/27/92 BRR284- Purge queue and data for a STOP                   */
/* 3/02/92 BRR288  MIDI using 100% CPU.                              */
/* 3/02/92 BRR289  If count = 0, do a DevAllNotesOff() for MIDI      */
/* 3/05/92 WES299  Add GetHChVDM(void) routine                       */
/* 3/06/92 BRR300  Add trk_assigned_at_init support                  */
/* 3/06/92 BRR304  Don't set INITFLAGS to INITED if IOCTLinit fails  */
/* 3/13/92 BRR308  Increment pstream when searching through table    */
/* 3/16/92 BRR317  Don't check for odd buffer size if buffer coming  */
/*                 through the IDC interface.                        */
/* 3/24/92 BRR320  Fix up PHYS addr sent down in '0C' and '03'       */
/*                 ioctl requests.                                   */
/* 3/24/92 BRR321  Add FindSysFileNum routine                        */
/* 3/26/92 BRR330  Fix check for started in check_if_stopped         */
/*                 Don't reset INITFLAGS in init_queue_vars          */
/* 3/27/92 BRR331  Set XMIT_INTERNAL and REC_INTERNAL for DOS dd     */
/*                 Allow buffer lengths upto/including 0x10000       */
/* 4/07/92 BRR361  Update count for rec buffers in audio_update      */
/* 4/07/92 BRR362  Undo ptr 361                                      */
/* 4/07/92 BRR363  Update count for rec when rtning buffers in update*/
/* 4/07/92 BRR359  Inc/Dec HPILOCK instead of setting to 0 or 1      */
/* 4/07/92 BRR365  Don't add ROLLOVER_TIME when reporting CUMULATIVE */
/* 4/07/92 BRR366  Don't PAUSE if not STARTED for IDLE AUDIO_INIT.   */
/* 4/11/92 RJL3621 Fix excessive MIDI interrupt handler duration     */
/* 4/14/92 BRR386  Fixes to check_if_stopped                         */
/* 4/14/92 BRR379  Take out support of cumulative_time and reported_time*/
/* 4/16/92 BRR391  Throw away a F8 for every time we leave interrupt */
/*                 because MAX_MIDI_BYTES was reached.               */
/* 4/16/92 BRR398  Don't call SetClock from init_queue_vars unless   */
/*                 running MIDI.                                     */
/* 4/17/92 BRR397  Call aud_control immediately if SPV/2 mode        */
/* 4/21/92 BRR409  Don't clear TRK_HVDM if just doing a DeInit       */
/* 4/22/92 BRR414  Don't write over rc set in devioctlinit           */
/* 4/22/92 BRR415  Still reset tempo and ppqn etc in init_queue_vars */
/* 4/24/92 BRR419  Don't call AUDIO_WAIT for MIDI mode.              */
/* 4/30/92 BRR431  Allow DOS driver to call aud_control immediately  */
/* 4/30/92 BRR434  Take out check for Claim_hdwr - let DevIOCTLinit  */
/*                 do it.                                            */
/* 4/30/92 BRR439  Init audio_init.rc = 0                            */
/* 5/01/92 BRR438  Set DEVICE NOT READY bit instead of WRITE_PROTECT */
/*                 in status                                         */
/* 5/18/92 BRR???  Add AUDIO_CONTINUOUS_NOTIFY support.              */
/*                 Change iobuf->delay to iobuf->moreflags support.  */
/*********************************************************************/


/*****************************************************************************/
/* DEFINEs                                                                   */
/*****************************************************************************/

#define  EVER_STARTED     2
#define  RUNNING          1

/*****************************************************************************/
/* Include DEFINEs                                                           */
/*****************************************************************************/

#if IS_OS2
#define  INCL_DOSINFOSEG
#define  INCL_DOS
#include <os2.h>
#endif

/*****************************************************************************/
/* Include Files                                                             */
/*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "audiodd.h"
#include "auddef.h"
#include "audproto.h"
#include "audiodd2.h"

/* OS/2 Specific Include Files                                               */
#if IS_OS2
   #include "mme.h"
   #include "os2medef.h"
   #include "ssm.h"
   #include "shdd.h"
#endif

/*****************************************************************************/
/* External Function declarations                                            */
/*****************************************************************************/

#if IS_OS2
   extern unsigned long GetStreamBasedOnTrack (PSTREAM far *ppStream, SHORT trk);
#endif

/*****************************************************************************/
/* Internal Function declarations                                            */
/*****************************************************************************/

unsigned long    CurrentPosition   (int trk);
int              init_ptrs         (int trk);
int              InitInternalIOBuf (IOB buf,char buf_type,int trk);

/* OS/2 Specific Internal Function Declarations                              */
   #if IS_OS2
      int        callback_shdd     (unsigned long event,int trk);
   #endif

/* Not K12 Specific Internal Function Declarations                           */
#if NOT_K12
   void          get_next_byte     (int trk);
#endif
#if NOT_DOS_K12
   void          CopyBlock         (char far *source,char far *target,int size);
#endif

/*****************************************************************************/
/* External Variable Declarations                                            */
/*****************************************************************************/

extern unsigned int     max_num_opens;

#if NUM_TRACKS > 1
   extern unsigned long    app_version[];
   extern long             bits_per_sample[];
   extern long             bsize[];
   extern void             (far * callback_func[])(void);
   extern int              channels[];
   extern unsigned long    flags[];                    /* audio flags        */
   extern int              hpilock[];                  /* Serializes access  */
   extern unsigned int     initflags[];                /* 1=INITED, 2=WAITING*/
   extern char             irdata[][RBUFFERSIZE];
   extern struct iobuf     iriobuf[];
   extern char             ixdata[][XBUFFERSIZE];
   extern struct iobuf     ixiobuf[];
   extern unsigned int     midiflags[];
   extern int              mode[];
   extern unsigned long    operation[];
   extern unsigned long    prev_recio_count[];
   extern unsigned long    prev_xmitio_count[];
   extern unsigned short   rec_internal[];
   extern struct vscb      recbuf[];
   extern struct vscb      recio[];
   extern unsigned long    recmax[];
   extern unsigned long    rollover_time[];
   extern long             srate[];
   extern char far        *Srhead[];
   extern char far        *Srtail[];
   extern char far        *Sxhead[];
   extern char far        *Sxtail[];
   extern unsigned int     trk_array[];
   extern unsigned short   xmit_internal[];
   extern struct vscb      xmitbuf[];
   extern struct vscb      xmitio[];
   extern unsigned long    xmitmax[];
#else
   extern unsigned long    app_version;
   extern long             bits_per_sample;
   extern long             bsize;
   extern void             (far * callback_func)(void);
   extern int              channels;
   extern unsigned long    flags;                      /* audio flags        */
   extern int              hpilock;                    /* Serializes access  */
   extern unsigned int     initflags;                  /* 1=INITED, 2=WAITING*/
   extern char             irdata[RBUFFERSIZE];
   extern struct iobuf     iriobuf;
   extern char             ixdata[XBUFFERSIZE];
   extern struct iobuf     ixiobuf;
   extern unsigned int     midiflags;
   extern int              mode;
   extern unsigned long    operation;
   extern unsigned long    prev_recio_count;
   extern unsigned long    prev_xmitio_count;
   extern unsigned short   rec_internal;
   extern struct vscb      recbuf;
   extern struct vscb      recio;
   extern unsigned long    recmax;
   extern unsigned long    rollover_time;
   extern long             srate;
   extern char far        *Srhead;                     /* Shadow rx head ptr */
   extern char far        *Srtail;                     /* Shadow rx tail ptr */
   extern char far        *Sxhead;                     /* Shadow tx head ptr */
   extern char far        *Sxtail;                     /* Shadow tx tail ptr */
   extern unsigned int     trk_array;
   extern unsigned short   xmit_internal;
   extern struct vscb      xmitbuf;
   extern struct vscb      xmitio;
   extern unsigned long    xmitmax;
#endif

/* OS/2 Specific External Variable Declarations                              */
#if IS_OS2
      extern ACPAMME        AcpaMME;
      extern unsigned char  os2_version;

   #if NUM_TRACKS > 1
      extern HSEM           callback_sem[];
      extern void far      *GDTrecbuf[];
      extern void far      *GDTrecio[];
      extern unsigned int   GDTselector1[];
      extern unsigned int   GDTselector2[];
      extern unsigned int   GDTselector3[];
      extern unsigned int   GDTselector4[];
      extern void far      *GDTxmitbuf[];
      extern void far      *GDTxmitio[];
      extern unsigned long  last_reported_time[];
      extern unsigned long  trk_hvdm[];
      extern unsigned char  trk_mode[];
      extern unsigned long  VCB_Hndl[];
      extern char           V86_mode[];
   #else
      extern HSEM           callback_sem;
      extern void far      *GDTrecbuf;
      extern void far      *GDTrecio;
      extern unsigned int   GDTselector1;
      extern unsigned int   GDTselector2;
      extern unsigned int   GDTselector3;
      extern unsigned int   GDTselector4;
      extern void far      *GDTxmitbuf;
      extern void far      *GDTxmitio;
      extern unsigned long  last_reported_time;
      extern unsigned long  trk_hvdm;
      extern unsigned char  trk_mode;
      extern unsigned long  VCB_Hndl;
      extern char           V86_mode;
   #endif
#endif

/* NOT K12 Specific External Variable Declarations                           */
#if NOT_K12
   extern unsigned char         qcaps_sysex[];
   extern unsigned char         qid_sysex[];
   #if NUM_TRACKS > 1
      extern long               delay[];
      extern unsigned char far *prvtimemsg[];                 /* Ptr to prv  */
                                                              /* time msg    */
      extern unsigned char      rec_buffer_array[][MAX_NUM_BUFFERS];
      extern unsigned char      xmit_buffer_array[][MAX_NUM_BUFFERS];
   #else
      extern long               delay;
      extern unsigned char far *prvtimemsg;                   /* Ptr to prv  */
                                                              /* time msg    */
      extern unsigned char      rec_buffer_array[MAX_NUM_BUFFERS];
      extern unsigned char      xmit_buffer_array[MAX_NUM_BUFFERS];
   #endif
#endif

/* AVC 1.03 Specific External Variable Declarations                          */
#if IS_AVC103
   extern int               avc103_mode;
   extern int               miscflags;
   extern HSEM              SemHndl1;
#endif

/*****************************************************************************/
/* Internal Variable Declarations                                            */
/*****************************************************************************/

   IOB                      iobuf;

#if NUM_TRACKS > 1
   long                     cb_status[NUM_TRACKS];
   unsigned char            data_processed[NUM_TRACKS];
   unsigned char            last_time[NUM_TRACKS];
   unsigned int             last_rec_head_segnum[NUM_TRACKS];
   unsigned int             last_rec_tail_segnum[NUM_TRACKS];
   unsigned int             last_xmit_head_segnum[NUM_TRACKS];
   unsigned int             last_xmit_tail_segnum[NUM_TRACKS];
   unsigned long            pos_buffer_count[NUM_TRACKS];
   unsigned int             timingflags[NUM_TRACKS] = { SYNC_OUTPUT };
#else
   long                     cb_status;
   unsigned char            data_processed;
   unsigned char            last_time;
   unsigned int             last_rec_head_segnum;
   unsigned int             last_rec_tail_segnum;
   unsigned int             last_xmit_head_segnum;
   unsigned int             last_xmit_tail_segnum;
   unsigned long            pos_buffer_count;
   unsigned int             timingflags = { SYNC_OUTPUT };
#endif


/* OS/2 Specific Internal Variable Declarations                              */
#if IS_OS2
   unsigned int             open_array[MAX_NUM_BUFFERS][2];
#endif

/* Not K12 Specific Internal Variable Declarations                           */
#if NOT_K12
      char                  ch;
      int                   max_midi_bytes;
      unsigned char         qsize_sysex[10]    = {0xf0,0,0,0x3a,5,2,0,4,0,0xf7};
      unsigned char         time_string[5]     = {0x0f0,0,0,0x3a,0x01};

   #if NUM_TRACKS > 1
      unsigned char         byte2[NUM_TRACKS];
      long                  catchup_count[NUM_TRACKS];
      unsigned char         curoutstat[NUM_TRACKS];
      int                   ppqn[NUM_TRACKS] = {24};   /* Pulses per quarter */
                                                       /* note (default)     */
      int                   ppqncntr[NUM_TRACKS] = {1};
      int                   ppqndiv[NUM_TRACKS] = {1};
      unsigned char far    *prvtimecounthi[NUM_TRACKS] = {NULL};
      unsigned char far    *prvtimecountlo[NUM_TRACKS] = {NULL}; /* Msg count*/
                                                              /* field ptr   */
      int                   sysex_count[NUM_TRACKS];
      unsigned char         sysex_save[NUM_TRACKS][128];
      unsigned int          tempo[NUM_TRACKS] = {1200};
   #else
      unsigned char         byte2;
      long                  catchup_count;
      unsigned char         curoutstat;
      int                   ppqn = {24};               /* Pulses per quarter */
                                                       /* note (default)     */
      int                   ppqncntr = {1};
      int                   ppqndiv = {1};
      unsigned char far    *prvtimecounthi = {NULL};
      unsigned char far    *prvtimecountlo = {NULL};          /* Msg count   */
                                                              /* field ptr   */
      int                   sysex_count;
      unsigned char         sysex_save[128];
      unsigned int          tempo = {1200};
   #endif
#endif

/* Not K12 and NOT OS2 Specific Internal Variable Declarations               */
#if NOT_DOS_K12
   #if NUM_TRACKS > 1
      struct request_block *free_req[NUM_TRACKS];             /* ptr 1st free*/
                                                              /* req_q block */
      unsigned int          notify_den[NUM_TRACKS];
      unsigned int          notify_num[NUM_TRACKS];
      int                   num_reqs[NUM_TRACKS];             /* # of reqs   */
                                                              /* currently   */
                                                              /* in queue    */
      int                   queue_lock[NUM_TRACKS] = {0,0};   /* Serializes  */
                                                              /* access to   */
                                                              /* req queue   */
      struct request_block  req_q[NUM_TRACKS][MAXREQS];       /* here are the*/
                                                              /* blocks      */
      struct request_block *req_q_head[NUM_TRACKS];           /* ptr to first*/
                                                              /* req_q block */
                                                              /* in queue    */
   #else
      struct request_block *free_req;                         /* ptr 1st free*/
                                                              /* req_q block */
      unsigned int          notify_den;
      unsigned int          notify_num;
      int                   num_reqs;                         /* # of reqs   */
                                                              /* currently   */
                                                              /* in queue    */
      int                   queue_lock             = {0};     /* Serializes  */
                                                              /* access to   */
                                                              /* req queue   */
      struct request_block  req_q[MAXREQS];                   /* here are the*/
                                                              /* blocks      */
      struct request_block *req_q_head;                       /* ptr to first*/
                                                              /* req_q block */
                                                              /* in queue    */
   #endif
#endif

/* AVC 1.03 Specific Internal Variable Declarations                          */
#if IS_AVC103
   char                     ctrlflags;
   int                      midicntr;
#endif

/*****************************************************************************/
/* Set HPI                                                                   */
/*****************************************************************************/
int set_hpi(newbuf,trk,phys,op)            /* Set Transmit iobuf             */
                                           /* phys = 0 - normal extern buffs */
                                           /* phys = 1 - MME external buffs  */
                                           /* phys = 2 - internal buffers    */
                                           /* phys = 3 - audio_update buffer */

/* For V86 mode, the vscb.Phys addresses are in reality LINEAR addressed */
/* We will need to do a LinToGDT instead of PhysToGDT all the time now - */
/* thus the addition of the AddrToGDT routine.                           */

struct iobuf far *newbuf;
int trk;
int phys;                            /* 1 if newbuf is physical addr    */
char op;
{

   struct vscb *io, *buf;
#if IS_OS2
   unsigned int x;
   int realmode;
   char far *saveBUF;           /* Place to save addr struc virt pointer  */
   void far *GDTio;
   void far *GDTbuf;
   unsigned int iosel, bufsel;
   unsigned long lockhandle;
   short rc=0;
   unsigned long  linear_addr;  /* V86 linear address                     */
#endif


   if (op == 0) { /* transmit */
      io = &XMITIO;
      buf = &XMITBUF;
#if IS_OS2
      GDTio = GDTXMITIO;
      GDTbuf = GDTXMITBUF;
      iosel = GDTSELECTOR1;
      bufsel = GDTSELECTOR3;
#endif
   } else { /* receive */
      io = &RECIO;
      buf = &RECBUF;
#if IS_OS2
      GDTio = GDTRECIO;
      GDTbuf = GDTRECBUF;
      iosel = GDTSELECTOR2;
      bufsel = GDTSELECTOR4;
#endif
   } /* endif */

#if IS_OS2

   /* Is this interrupt time - MME calling us? */
   if(phys==1){
      io->Phys = newbuf->pIobufPhys ;
      (IOB)io->Virt = newbuf;

      io->GDT = io->Ptr = GDTio;
      if (PhysToGDTSelector(io->Phys,sizeof(struct iobuf)
               + ((((IOB)newbuf)->num_buffers-1) * sizeof(struct addrs)),
                  iosel)) {
         return(-1);
      }

      buf->Phys = ((IOB)io->Ptr)->buf[0].Phys;
      buf->Virt = ((IOB)io->Ptr)->buf[0].Virt;

      buf->GDT = buf->Ptr = GDTbuf;
      if (PhysToGDTSelector(buf->Phys,           /* Map it to GDT */
                        (unsigned)((IOB)io->Ptr)->buf[0].length,
                        bufsel)) {
         return(-1);
      }
      buf->length = ((IOB)io->Ptr)->buf[0].length;

      /* Check to see if valid buffer size                         */
      if (buf->length > 0x00010000)
         rc=-1;

      iobuf = (IOB)io->Ptr;

   /* Not interrupt time - we can get our own physical addresses */
   }else{
      /* determine if this is V86 mode or not                          */
      if ((os2_version >= 20) && (TRK_MODE == REALMODE)) {
         V86_MODE = 1;
         /* If using hpi buffers and VDD not loaded - then HPI cannot be done*/
         if ((!TRK_HVDM) && (phys != 2)) {
            return(-1);
         }
      } else {
         V86_MODE = 0;
      } /* endif */

      /* Is this AUDIO_UPDATE - if so only concerned with updating the */
      /* BUF not the IOBUF pointers.....                               */

      /* Initialize the .GDT address to point to right selector     */
      io->GDT = GDTio;

      /* Want to do special processing for V86 mode (if not internal */
      /* buffers) and for 0:32 apps to set up the .Virt addr         */

      if (V86_MODE && (phys != 2)) {

         /*******************************************************/
         /****   V86 mode                                    ****/
         /*******************************************************/

         /* get linear addr from newbuf addr */
         linear_addr = v86toLin(newbuf);
         io->Phys = (char far *)linear_addr; /* we don't really need this, but */
                                 /* might be nice for debugging    */

         /* VMLock the buffer */
         io->length = sizeof(struct iobuf);
         if (!(lockhandle = LnLock(linear_addr,io->length))) {
            return(-1);
         }

         /* map linear address to GDT selector that is good always */
         if (AddrToGDTselector((void far *)linear_addr, sizeof(struct iobuf),iosel)) {
            return(-1);
         }

         /* Now that we can access the iobuf, check to see if there */
         /* is more than 1 buffer in the array and remap the size   */
         /* if there is....                                         */
         if (((IOB)io->GDT)->num_buffers > 1) {

            io->length = sizeof(struct iobuf) + ((((IOB)io->GDT)->num_buffers-1)
                      * sizeof(struct addrs));

            /* UnLock the buffer first, then lock it again with the */
            /* new longer length for the extra buffers.....         */
            if (LnUnlock(lockhandle)) {
               return(-1);
            }

            if (!(lockhandle = LnLock(linear_addr,io->length))) {
               return(-1);
            }

            if  (AddrToGDTselector((void far *)linear_addr, (unsigned)io->length, iosel)) {
               return(-1);
            }

         }  /* endif */

         /* save the lock handle in the iobuf structure now that I can */
         /* address it                                                 */
         ((IOB)io->GDT)->lock_handle = lockhandle;

         /* Now set up our .Virt address to something we can use */
         io->Virt = io->GDT;

      } else { /* Non-V86 mode */            /* OS/2 Mode: 16:16 or 0:32   */

         if (os2_version >= 20) {
            /* assume 16:16 address */
            linear_addr = VirtToLin(newbuf);
         } else {
            linear_addr = 1; /* any non-zero number is fine */
         } /* endif */

         if (linear_addr == 0L) {

            /*******************************************************/
            /****   0:32 mode                                   ****/
            /*******************************************************/

            io->Virt =(char far *) ((((ULONG)newbuf & 0xffff0000) << 3)
                          + 0x70000 +  ((ULONG)newbuf & 0x0000ffff));

         } else { /* 16:16 app - addr passed down is good */

            /*******************************************************/
            /****  16:16 mode                                   ****/
            /*******************************************************/

            io->Virt = (char far *)newbuf;

         } /* endif */

      } /* endif */

      /* At this point the .Virt addr in the iobuf has been initialized */
      /* to an address that can be accessed now.                        */
      /* For V86 mode .Virt = GDT address                               */
      /* For 0:32 apps .Virt = thunked virtual to 16:16 virtual         */
      /* For 16:16 apps .Virt = newbuf address passed down              */

      /* Now lets work on the BUF portion of this.......                   */

      buf->Virt = ((IOB)io->Virt)->buf[0].Virt;
      buf->GDT = GDTbuf;

      _asm{                   /* Determine if we're in Real Mode  */
         smsw  ax             ; get current msw
         rcr   ax,1           ; Protect bit into C
         mov   ax,0           ; Set AX = 0
         jc    is_protmode    ; Skip if protect mode
         mov   ax,1           ; Set AX = 1 if Real Mode
      is_protmode:
         mov   realmode,ax
      }

      /* Set our usable address */
      if(realmode){

         /* For realmode, we want to use virtual address                */

         /* Don't want to change iobuf pointer if here for audio_update */
         io->Ptr = io->Virt;
         buf->Ptr = buf->Virt;

      }else{

         /* For protect mode we want to use GDT selectors               */

         /* Don't want to change iobuf pointer if here for audio_update */
         io->Ptr = io->GDT;

      } /* endif */

      /* Set Physical addresses */

      /* If this is an external buffer, then we need to Lock and Verify */
      /* if protect mode, the iobuf                                     */

      if (phys == 0) {
         if (!V86_MODE) { /* already LnLock done above if V86 - */
            if (!(((IOB)io->Virt)->lock_handle =
                Lock((char far *)io->Virt,1,0))) {
               return(-1);
            } /* endif */
         } /* endif */
         if(!realmode){
            if (VerifyAccess(io->Virt,sizeof(struct iobuf),1)) {
                return(-1);
            } /* endif */
            if (((IOB)io->Virt)->num_buffers > 1) {
               if (VerifyAccess(io->Virt,sizeof(struct iobuf) +
                   ((((IOB)io->Virt)->num_buffers-1)*sizeof(struct addrs)),1)) {
                   return(-1);
               } /* endif */
            } /* endif */
         } /* endif */
      } /* endif */


      /* Now let's work on the array of buffers.....                        */

      for (x=0; x<((IOB)io->Virt)->num_buffers; x++) {

         if (((IOB)io->Virt)->buf[x].Virt) {

             /* Check to see if valid buffer size                */
            if (((IOB)io->Virt)->buf[x].length & 1)
               rc=-1;
            /* Check to see if valid buffer size                 */
            if (((IOB)io->Virt)->buf[x].length > 0x00010000)
               rc=-1;

            /* Want to do special processing for V86 mode (if not internal */
            /* buffers) and for 0:32 apps to set up the .Virt addr         */

            /* .Virt is going to change for V86 and 0:32 apps, so save   */
            /* so it can be restored when we're done......               */
            saveBUF = ((IOB)io->Virt)->buf[x].Virt;

            if (V86_MODE && (phys != 2)) {

               /*******************************************************/
               /****   V86 mode                                    ****/
               /*******************************************************/

               /* get linear addr from buf[x].Virt addr and save in */
               /* .Phys address for future LinToGDTs at int time    */
               linear_addr=v86toLin(((IOB)io->Virt)->buf[x].Virt);
               ((IOB)io->Virt)->buf[x].Phys = (char far *)linear_addr;

               if (!(((IOB)io->Virt)->buf[x].lock_handle =
                    LnLock(linear_addr,((IOB)io->Virt)->buf[x].length))) {
                  return(-1);
               }

               /* map linear address to one we can use - might as   */
               /* well use real GDT....we'll set it up to the first */
               /* buffer in the array later......                   */
               if (AddrToGDTselector((void far *)linear_addr,
                              (unsigned) ((IOB)io->Virt)->buf[x].length,
                              bufsel)) {
                  return(-1);
               }

               /* Now set up the .Virt address to one we can use for */
               /* processing Locks and Verifies......                */
               ((IOB)io->Virt)->buf[x].Virt = buf->GDT;

            } else { /* Non-V86 mode */

               if (os2_version >= 20) {
                  /* assume 16:16 address */
                  linear_addr = VirtToLin(((IOB)io->Virt)->buf[x].Virt);
               } else {
                  linear_addr = 1; /* any non-zero number is fine */
               } /* endif */

               if (linear_addr == 0L) {

                  /*******************************************************/
                  /****   0:32 mode                                   ****/
                  /*******************************************************/

                  ((IOB)io->Virt)->buf[x].Virt = (char far *)
                      ((((ULONG)((IOB)io->Virt)->buf[x].Virt & 0xffff0000) << 3)
                      + 0x70000
                      + ((ULONG)((IOB)io->Virt)->buf[x].Virt & 0x0000ffff));

               /* else - virtual address that is there we can use already */

               } /* endif */

            } /* endif */                                                      /*wb*/


            /* Now lock down and verify the buffer if not internal buffer */
            if (phys != 2) {
               if (!V86_MODE) {
                  if (!(((IOB)io->Virt)->buf[x].lock_handle =   // Lock for
                     Lock(((IOB)io->Virt)->buf[x].Virt,1,0))) { // VirtToPhys
                     return(-1);
                  }
               } /* endif */
               if(!realmode){
                  if (VerifyAccess(((IOB)io->Virt)->buf[x].Virt,
                           (unsigned)((IOB)io->Virt)->buf[x].length,1)) {
                     return(-1);
                  } /* endif */
               } /* endif */
            } else {
               ((IOB)io->Virt)->buf[x].lock_handle = 0;
            } /* endif */

            /* Now we need to set up the physical address to get the GDT */
            /* address for all but the V86 mode - we have the GDT addr   */
            /* already set up from above                                 */
            if (!V86_MODE || (phys == 2))
               ((IOB)io->Virt)->buf[x].Phys =
                        VirtToPhys(((IOB)io->Virt)->buf[x].Virt);

            /* restore original value of .Virt address */
            ((IOB)io->Virt)->buf[x].Virt = saveBUF; /*Restore buf[x].Virtwb*/

            /* Now we want the handle for the VDM to be added to the */
            /* linear address that we calculated so it will be correct */
            /* at interrupt time - this is only for V86 address */
            if (V86_MODE && (phys != 2))
               ((IOB)io->Virt)->buf[x].Phys = (char far *)(TRK_HVDM +
                  (ULONG)(((IOB)io->Virt)->buf[x].Phys));

         } else {
            ((IOB)io->Virt)->buf[x].Phys = 0;
         } /* endif */

      } /* endfor */

      /* don't want first buffer to trk_hvdm in it, so that it will */
      /* pass the lintogdt at strategy time, and also so that it    */
      /* will be remapped at interrupt time the first time through  */
      if (V86_MODE && (phys != 2))
         if (((IOB)io->Virt)->buf[0].Phys) {
            buf->Phys = (char far *)((ULONG)(((IOB)io->Virt)->buf[0].Phys)
                      - TRK_HVDM);
         } else {
            buf->Phys = 0;
         } /* endif */
      else
         buf->Phys = ((IOB)io->Virt)->buf[0].Phys;

      buf->length = ((IOB)io->Virt)->buf[0].length;

      /* Make sure not a NULL addr - which might happen with AUDIO_UPDATE */
      if (buf->Phys) {
         /* Now set up the .GDT address                              */
         if (AddrToGDTselector(buf->Phys,                 /* Map it to GDT */
                     (unsigned)buf->length,
                     bufsel)) {
            return(-1);
         }
      } /* endif */

      buf->Ptr = buf->GDT;  //includes any offset

      /* Set up our .GDT address for the IOBUF - dont' want to do this */
      /* if this is an AUDIO_UPDATE buffer or V86 - done above         */
      if (!V86_MODE || (phys == 2)) {
         io->Phys = VirtToPhys(io->Virt);          /* Convert to phys addr */

         if (PhysToGDTSelector(io->Phys,           /* Map it to GDT  */
                     sizeof(struct iobuf)
                     + ((((IOB)io->Virt)->num_buffers-1)
                     * sizeof(struct addrs)),
                     iosel)) {
            return(-1);
         }
      } /* endif */

   } /* endif */

   return(rc);
#else

   /* DOS mode */
   io->Virt = io->Ptr = (char far *)newbuf;
   buf->Virt = buf->Ptr =
                       ((IOB)io->Virt)->buf[0].Virt;
   buf->length = ((IOB)io->Virt)->buf[0].length;

   return(0);
#endif

}

/*****************************************************************************/
/* Init_Ptrs                                                                 */
/*****************************************************************************/
int init_ptrs(trk)
int trk;
{
#if IS_OS2
   int realmode;
#endif

   _asm cli;

#if IS_OS2
      _asm{                   /* Determine if we're in Real Mode  */
         smsw  ax             ; get current msw
         rcr   ax,1           ; Protect bit into C
         mov   ax,0           ; Set AX = 0
         jc    is_protmode    ; Skip if protect mode
         mov   ax,1           ; Set AX = 1 if Real Mode
      is_protmode:
         mov   realmode,ax
      }
#endif

   IRIOBUF.size = RBUFFERSIZE;                   /* Fill in RECIO fields */
   IRIOBUF.head = IRIOBUF.tail = (char far *)IRDATA;  /* Reset pointers       */
   IRIOBUF.buf[0].Virt = (char far *)IRDATA;
   IRIOBUF.buf[0].length = RBUFFERSIZE;
   RECMAX = 0;                                   /* Maximum count        */
   REC_INTERNAL = 1;
   if (InitInternalIOBuf(&IRIOBUF,1,trk)) {
      return(-1);
   } /* endif */

   IXIOBUF.size = XBUFFERSIZE;                   /* Fill in XMITIO fields*/
   IXIOBUF.head = IXIOBUF.tail = (char far *)IXDATA;  /* Reset queue ptrs     */
   IXIOBUF.buf[0].Virt = (char far *)IXDATA;
   IXIOBUF.buf[0].length = XBUFFERSIZE;
   XMITMAX = 0;                                  /* Maximum count        */
   XMIT_INTERNAL = 1;
   if (InitInternalIOBuf(&IXIOBUF,0,trk)) {
      return(-1);
   } /* endif */

   _asm sti;
   return(0);
} /* end init_ptrs */

/*****************************************************************************/
/* InitInternalIOBuf                                                         */
/*****************************************************************************/

int InitInternalIOBuf(buf,buf_type,trk)
IOB  buf;
char buf_type;
int  trk;
{

   buf->count = 0;                            /* # bytes in buffer    */
   buf->position = 0;                         /* position counter     */
   buf->moreflags = 0;
   buf->runflags = 0;                         /* flags = stopped      */
   buf->lock_handle = 0;
   buf->num_buffers = 1;
   buf->buf[0].lock_handle = 0;
   buf->head_segnum = 0;
   buf->tail_segnum = 0;

   if (set_hpi(buf,trk,2,buf_type)) {
      return(-1);
   } /* endif */

   return(0);

} /* end InitInternalIOBuf */

/*****************************************************************************/
/* is_running                                                                */
/*****************************************************************************/

int is_running(trk)
int trk;
{
   return(xmit_running(trk) | rec_running(trk));
}

/*****************************************************************************/
/* xmit_running                                                              */
/*****************************************************************************/

int xmit_running(trk)
int trk;
{
   if((OPERATION_G != RECORD)                        /* or a compute */
   && (((IOB)XMITIO.Ptr)->runflags & STARTED)        /*  and xmit started     */
   && !(((IOB)XMITIO.Ptr)->runflags & PAUSED)){      /*  and xmit not paused  */
      return((int)PLAY);                    /*   then we're running           */
   }
   return(0);
}

/*****************************************************************************/
/* rec_running                                                               */
/*****************************************************************************/

int rec_running(trk)
int trk;
{
   if ((OPERATION_G != PLAY)                         /* or a compute */
   && (((IOB)RECIO.Ptr)->runflags & STARTED)         /*  and rec started      */
   && !(((IOB)RECIO.Ptr)->runflags & PAUSED)){       /*  and rec not paused   */
      return((int)RECORD);                  /*  then we're running            */
   }
   return(0);
}

/*****************************************************************************/
/* determine_mode                                                            */
/*****************************************************************************/

int determine_mode(dptr)
AIP dptr;
{
   extern int   num_modes;          /* # entries in mode_table[]           */
   extern struct mode_data mode_table[];
   int i;

   for(i=0; i<num_modes; i++){
      if(mode_table[i].mode != dptr->mode){
         continue;
      }
      if(!(mode_table[i].dont_care & DATAFLAGS)){          /* Ignore flags?*/
         if((dptr->flags & mode_table[i].flags_mask)^mode_table[i].flags){
            continue;                           /*   doesn't match         */
         }
      }
      if(!(mode_table[i].dont_care & BPS)){     /* Ignore bits_per_sample? */
         if((dptr->bits_per_sample < mode_table[i].bps_low)
          ||(dptr->bits_per_sample > mode_table[i].bps_high)){
            continue;                           /*    doesn't match        */
         }
      }
      if(!(mode_table[i].dont_care & SRATE)){   /* Ignore sample rate?     */
         if((dptr->srate < mode_table[i].srate_low)
          ||(dptr->srate > mode_table[i].srate_high)){
            continue;                           /*    doesn't match        */
         }
      }
      if(!(mode_table[i].dont_care & CHANNELS)){   /* Ignore channels?     */
         if((dptr->channels < mode_table[i].channels_low)
          ||(dptr->channels > mode_table[i].channels_high)){
            continue;                           /*    doesn't match        */
         }
      }
      if(!(mode_table[i].dont_care & BSIZE)){   /* Ignore block size?      */
         if(dptr->bsize != mode_table[i].bsize){
            continue;                           /*    doesn't match        */
         }
      }
      break;                                    /* Found it. All done      */
   }
#if IS_TRUK2
   if (dptr->operation == RECORD) {
      if ((dptr->channels == 2) ||
#if IS_ACPA
          (dptr->mode == SPV2BCPCM) ||
          (dptr->mode == SPV2PCM) ||
          (dptr->mode == SPV2NONE)
#endif
          (dptr->srate == 22050) ||       //this covers ADPCM modes also
          (dptr->srate == 44100)) {
          i=num_modes;
       } /* endif */
    } /* endif */
#endif

   return(i);
}

#if NOT_DOS_K12

/*****************************************************************************/
/* aud_control                                                               */
/*****************************************************************************/

int aud_control(trk)
int trk;
{
   int rc=0;
   struct request_block *req;
   char pos_not_passed;
   unsigned long pos;

   if(QUEUE_LOCK != 0)               /* Is the queue being updated?   */
      return(0);

   QUEUE_LOCK=1;


   if ((NUM_REQS == 0) ||             /* Are there any requests?       */
      (REQ_Q_HEAD == NULL) ||
      ((OPERATION_G != RECORD)                         /* or a compute */
      &&  (REQ_Q_HEAD->req_position >
           ((IOB)XMITIO.Ptr)->position))
      || ((OPERATION_G != PLAY)                         /* or a compute */
      &&  (REQ_Q_HEAD->req_position >
           ((IOB)RECIO.Ptr)->position)) ) {
      QUEUE_LOCK=0;
      return(0);
   }

   /* Remove request from queue */
   req = REQ_Q_HEAD;
   REQ_Q_HEAD = req->req_next;

   /* Now process the request */
   switch(req->req_type){
      case AUDIO_CHANGE:
         rc = DevChange(
                   &req->req_change,
                   req->req_change_dev_info,
                   req->req_any_dev_info,
                   req->req_change_mode_info,
                   req->req_any_mode_info,
                   trk);
         break;
      case AUDIO_STOP:                       /* Stop current operation        */

         StopTrk(trk);
         break;                                 /*                               */

      case AUDIO_PAUSE:                         /* suspend current operation     */

         PauseTrk(trk);
         break;

      case AUDIO_CONTINUOUS_NOTIFY:          /* notify app of recurring time */

         if (NOTIFY_DEN) {

            /* Call Device Specific code so that they can set up the card to */
            /* interrupt at the specified time. If the "pos" time has        */
            /* already passed - DevNotify will return non-zero, therefore    */
            /* we need to determine the next time we want an interrupt.      */
            pos_not_passed = 1;
            if (OPERATION_G == PLAY) {
               pos = ((IOB)XMITIO.Ptr)->position;
            } else {
               pos = ((IOB)RECIO.Ptr)->position;
            } /* endif */
            while (pos_not_passed) {

               pos = ((pos*NOTIFY_DEN/NOTIFY_NUM) + 1) *
                      NOTIFY_NUM / NOTIFY_DEN;

               /* Call the device specific code to setup the DSP code to     */
               /* interrupt at "pos" time. DevNotify returns '0' if time     */
               /* is set, '1' if time requested has already passed.          */
               pos_not_passed = DevNotify(pos,trk);

            } /* end while */

            /* Actually queue up the next AUDIO_NOTIFY time                  */
            queue_request(AUDIO_CONTINUOUS_NOTIFY,          /* Request type  */
                  pos,                                      /* position #    */
                  (void far *)req->req_notify_hEvent,       /* event handle  */
                  trk);

         } /* endif */

      /* let it fall through to do the actual callback processing */

      case AUDIO_NOTIFY:                              /* notify app of time */

#if IS_OS2
         if (((OPERATION_G == PLAY) &&
              (((IOB)XMITIO.Ptr)->runflags & CHAIN_BUFFERS)) ||
             ((OPERATION_G == RECORD) &&
              (((IOB)RECIO.Ptr)->runflags & CHAIN_BUFFERS))) {

            if (callback_shdd(req->req_notify_hEvent,trk)) {
               REQ_Q_HEAD = req;
               QUEUE_LOCK=0;
               return(-1);
            } /* endif */

         } else { /* Not MMPM */
#endif
            if (OPERATION_G == PLAY) {
               CB_STATUS |= (long)CBNOTIFY << 16;
            } else {
               CB_STATUS |= CBNOTIFY;
            } /* endif */
#if IS_OS2
         } /* endif */
#endif

      break;

   } /* end switch */

   /* Now put this request block onto the free chain */
   NUM_REQS--;
   req->req_next = FREE_REQ;
   FREE_REQ = req;

   QUEUE_LOCK=0;
   return(rc);
}


#if IS_OS2

/*****************************************************************************/
/* callback_shdd                                                             */
/*****************************************************************************/

int  callback_shdd(event,trk)
unsigned long event;
int trk;
{

#if IS_OS2
    SHD_REPORTEVENT   ShdEvent ;
    PSTREAM           pStream;
#endif

   /***********************
       Call SHDReportEvent
    ***********************/

   ShdEvent.ulFunction   = SHD_REPORT_EVENT;

   /* Get the stream handle */
   pStream = AcpaMME.paStream;
   if (GetStreamBasedOnTrack(&pStream, trk) == -1) {
      return(-1);
   }
   ShdEvent.hStream      = pStream->hStream;

   ShdEvent.hEvent       = event;

   /* Get the current position value */
   ShdEvent.ulStreamTime = CurrentPosition(trk);

   ((PSHDFN)pStream->ADSHEntry)(&ShdEvent);
   return(0);

} /* endif callback_shdd */
#endif

/*****************************************************************************/
/* queue_request                                                             */
/*****************************************************************************/

int queue_request(type,pos,changes,trk)
int   type;
unsigned long pos;
struct audio_change far *changes;
int   trk;
{
   struct request_block *req,*prvreq,*nxtreq;

   QUEUE_LOCK++;

   if(NUM_REQS >= MAXREQS){
      QUEUE_LOCK--;
      return(-1);
   }

   /* Unchain a block from the free queue                                  */
   req = FREE_REQ;                        /*    get a request_block        */
   FREE_REQ = req->req_next;              /*    update free_req ptr        */
   NUM_REQS++;                            /*    inc count of # reqs        */

   req->req_next = NULL;                  /*    zero out our next ptr      */

   /* Fill in the block                                                       */
   req->req_type = type;
   req->req_position = pos;
   if (changes) {
      if (type == AUDIO_CHANGE) {

         if (APP_VERSION >= VERSION_01000005) {
            if (changes->mode_info == NULL) {
               req->req_any_mode_info = 0;
            } else {
               req->req_any_mode_info = 1;
               if (MODE_G == MIDI) {
                  CopyBlock((char far *)changes->mode_info,
                            (char far *)req->req_change_mode_info,
                            sizeof(struct midi_mode_info_struct));
               } else if ((MODE_G == SPV2NONE) ||
                          (MODE_G == SPV2PCM) ||
                          (MODE_G == SPV2BCPCM)) {
                  CopyBlock((char far *)changes->mode_info,
                            (char far *)req->req_change_mode_info,
                            sizeof(struct spv2_mode_info_struct));
               } /* endif */
            } /* endif */
            CopyBlock((char far *)changes,
                      (char far *)(&req->req_change),
                      sizeof(struct audio_change));
         } else {
            req->req_any_mode_info = 0;
            CopyBlock((char far *)changes,
                      (char far *)(&req->req_change),
                      sizeof(struct audio_change_v00));
         } /* endif */

         if (changes->dev_info == NULL) {
            req->req_any_dev_info = 0;
         } else {
            req->req_any_dev_info = 1;
            CopyBlock((char far *)changes->dev_info,
                      (char far *)req->req_change_dev_info,
                      sizeof(struct track_info));
         } /* endif */

#if IS_OS2
      } else { /* AUDIO_NOTIFY request */
         req->req_notify_hEvent = (unsigned long)changes;
#endif
      } /* endif */
   } /* endif */

   /* Queue this event onto the request queue                             */
   if(!REQ_Q_HEAD){                      /* If nothing in queue           */
      REQ_Q_HEAD = req;                  /*  queue it to the front        */
   }else{                                /* Otherwise, find where it goes */
      /* Locate where in the chain this request's position is     */
      for(prvreq = (struct request_block *)&REQ_Q_HEAD, nxtreq = REQ_Q_HEAD;
         nxtreq!=NULL && nxtreq->req_position <= req->req_position;
         prvreq=nxtreq, nxtreq=nxtreq->req_next);
      req->req_next = nxtreq;            /* Set our next pointer          */
      prvreq->req_next = req;            /*  and set prv req's next to us */
   } /* endif */

   QUEUE_LOCK--;
   return(0);
}

/*****************************************************************************/
/* CopyBlock                                                                 */
/*****************************************************************************/

void CopyBlock(source,target,size)
char far *source;
char far *target;
int size;
{

   int x;

   for (x=0; x<size; x++) {
      *(target++) = *(source++);
   } /* endfor */

} /* end CopyBlock */

#endif

/*****************************************************************************/
/* midiread                                                                  */
/*****************************************************************************/

int midiread(trk)
int trk;
{
   int  ch;

   _asm cli;
   if(((IOB)RECIO.Ptr)->count){             /* Is any data queued?           */
      if(((IOB)RECIO.Ptr)->count > RECMAX) RECMAX = ((IOB)RECIO.Ptr)->count;
      ch = *SRTAIL++;                       /*  if so, get it                */
      check_wrap((IOB)RECIO.Ptr,1,trk,TAIL,RX);
      if (LAST_REC_TAIL_SEGNUM) {
#if IS_OS2
         /* Now map new GDT */
         AddrToGDTselector(RECBUF.Phys,
                           (unsigned)RECBUF.length,
                           GDTSELECTOR4);
#endif
         SRTAIL = RECBUF.Ptr;
         ((IOB)RECIO.Ptr)->tail = RECBUF.Virt;    /*  wrap if needed          */
      } else {
         ((IOB)RECIO.Ptr)->tail++;
      }
      if( (((IOB)RECIO.Ptr)->count-- == 0)      /* Decrement our counter      */
          || (((IOB)RECIO.Ptr)->tail == ((IOB)RECIO.Ptr)->head)){  // Tail=Head?
         ((IOB)RECIO.Ptr)->count = 0;           /* Clear our counter          */
         MIDIFLAGS &= 0xfffa;                   /* Clear timing flags         */
      }
   }else{
      ch = -1;                                  /* No data, return -1         */
   }
   _asm sti;
   return(ch);
}

#if NOT_DOS_K12

/*****************************************************************************/
/* queue_data                                                                */
/*****************************************************************************/

void queue_data(data,len,trk)
unsigned char *data;
int len,trk;
{
   _asm cli;
   while(len--){
      *SRHEAD++ = *data++;                   /* Queue data byte            */
      check_wrap((IOB)RECIO.Ptr,1,trk,HEAD,RX);
      if (LAST_REC_HEAD_SEGNUM) {
#if IS_OS2
         /* Now map new GDT */
         AddrToGDTselector(RECBUF.Phys,
                           (unsigned)RECBUF.length,
                           GDTSELECTOR4);

         if(((IOB)RECIO.Ptr)->runflags & CHAIN_BUFFERS){
             get_next_buf((IOB)RECIO.Virt,trk,1);
         }else{
#endif
         ((IOB)RECIO.Ptr)->head = RECBUF.Virt;    /* If so, do it         */
#if IS_OS2
         }
#endif
         SRHEAD = RECBUF.Ptr;
      } else {
         ((IOB)RECIO.Ptr)->head++;
      }

      if(!(((IOB)RECIO.Ptr)->runflags & CHAIN_BUFFERS)){
         if (((IOB)RECIO.Ptr)->runflags & IOBUF_LOCK) {
            PREV_RECIO_COUNT++;
         } else {
            if(++((IOB)RECIO.Ptr)->count >= ((IOB)RECIO.Ptr)->size){
                ((IOB)RECIO.Ptr)->count = ((IOB)RECIO.Ptr)->size;
               _asm sti;
               return;                       /* Buffer full, so quit here  */
            }
         } /* endif */
      }
   }
   _asm sti;
}
#endif

#if NOT_K12
/*****************************************************************************/
/* DoOutput                                                                  */
/*                                                                           */
/*  This subroutine will parse an output string, and either output the       */
/*  data, or process IBM System Exclusive commands.  It is called by         */
/*  either the OUTPUT command routine, or the interrupt handler when         */
/*  DELAY counts down to 0 (output synchronization).                         */
/*****************************************************************************/
void DoOutput(trk)
int trk;
{
   unsigned char byte3,midichan;
   unsigned char ch;
   static int serialize = 0;
   int x;
   int loop_count = 0;

   #if TRACE_ON
   trace(0x01);
   #endif

   if(serialize++){                             /* Serialize access        */
      serialize--;
      #if TRACE_ON
      trace(0x21);
      #endif
      return;
   }

   MIDIFLAGS &= 0xffff-OUTSYNC;

   if (((IOB)XMITIO.Ptr)->count) {
      /* Check if callback should be called                    */
      if (((IOB)XMITIO.Ptr)->runflags & CBBLOCK)
         CB_STATUS |= CBBLOCK;
      if (((IOB)XMITIO.Ptr)->runflags & CBDATA)
         CB_STATUS |= CBDATA;
   } /* endif */

   while(((IOB)XMITIO.Ptr)->count){
      if(++loop_count > max_midi_bytes){  // Have we processed enough bytes?
         MIDIFLAGS |= OUTSYNC;            // If so, put rest off for next int
         DELAY = 1;                       // Set delay of 1
         CATCHUP_COUNT++;                 // Inc counter to skip F8's
         serialize--;                     // free serialization lock
         #if TRACE_ON
         trace(0x31);
         #endif
         return;                          //  and we're outta here
      }
      _asm cli;

      ch = *SXTAIL++;
      ((IOB)XMITIO.Ptr)->count--;

      /* moved into get_next_byte routine and called before exit */

      _asm sti;

      if(ch==0xf8){                             /* Timing?                 */
         if ((TIMINGFLAGS & 0x800) && (!CATCHUP_COUNT)) {
            MIDIFLAGS |= OUTSYNC;
            DELAY = 1;
            get_next_byte(trk);
            serialize--;

            #if TRACE_ON
            trace(0x41);
            #endif
            return;
         } else {
            CATCHUP_COUNT--;
         }
      }else if(ch==0xf6){                       /* End-Of-Block marker?    */
#if IS_AVC103
         if(avc103_mode){
            midicntr++;                         /*  inc midi counter       */
            if((miscflags & SEM_ACTIVE)         /* Is semaphore active?    */
            && !(ctrlflags & 1)){               /*  ints disabled?         */
               SemClear(SemHndl1);              /*  go clear semaphore     */
            }
         }
#endif
         /* Do not output this char to MIDI port!                          */

      }else if(ch==0xf0){                       /* Start of sysex?         */
         SYSEX_SAVE[0] = ch;
         SYSEX_SAVE[4] = 0;                     /* Clear subid             */
         SYSEX_COUNT = 1;
         MIDIFLAGS |= SYSEX_IN_PROG;       /* Set sysex flag          */
         MIDIFLAGS &= ~THIRDBYTE;          /* Clear 3rd byte flag     */

      }else if(MIDIFLAGS & SYSEX_IN_PROG){
         if(ch!=0xf7){                          /* EOX?                    */
            if(ch & 0x80){                      /* Unexpected status?      */
               MIDIFLAGS &= ~SYSEX_IN_PROG;/* Clear 'in-prog' flag    */
               SYSEX_COUNT = 0;            /*   and sysex count       */
               CUROUTSTAT = ch;            /* Save running status     */
               MIDIFLAGS |= NEW_STATUS;    /* Set new status flag     */
            }else if(SYSEX_COUNT<3){
               SYSEX_SAVE[SYSEX_COUNT++] = ch;  /* Save data               */
            }else if(SYSEX_COUNT == 3){         /* Is this our Sys-Ex?     */
               SYSEX_SAVE[3]=ch;
               SYSEX_COUNT = 4;
               if(ch!=0x3a || SYSEX_SAVE[1]!=0 || SYSEX_SAVE[2]!=0){
                  for(x=0; x<4; x++){           /* Output it               */
                     DevWrite(SYSEX_SAVE[x],trk);
                  }
                  SYSEX_SAVE[3] = 0;
               }
            }else if(SYSEX_SAVE[3] != 0x3a){
               DevWrite(ch,trk);
            }else{
               SYSEX_SAVE[SYSEX_COUNT++] = ch;
               if(SYSEX_COUNT > 127) SYSEX_COUNT = 127;
            }
         }else{                                 /* Process SysEx (ch == 0xf7)*/
            if(SYSEX_SAVE[3] != 0x3a){
               DevWrite(0xf7,trk);
            }else switch(SYSEX_SAVE[4]){        /* Switch based on subid   */
               case 0:                          /* Queue empty message     */
                  break;                        /*   discard it            */
               case 1:                          /* Timing SysEx            */
                  if(TIMINGFLAGS & 0x800){ /* Is output sync enab?    */
                     DELAY = (SYSEX_SAVE[6]<<7)+SYSEX_SAVE[5];
                     MIDIFLAGS &= ~SYSEX_IN_PROG;
                     SYSEX_COUNT = 0;

                     /* Check to see if we have any catching up to do  */
                     if (CATCHUP_COUNT) {

                        /* Look to see if the delay is longer than the       */
                        /* catchup that we have to do                        */
                        if (DELAY >= CATCHUP_COUNT) {

                           DELAY -= CATCHUP_COUNT;
                           CATCHUP_COUNT = 0;

                        } else { /* delay shorter than the catchup */

                           CATCHUP_COUNT -= DELAY;
                           DELAY = 0;

                        } /* endif */

                     } /* endif */

                     /* Are we still done for now - or can we do more        */
                     /* after our catching up?                               */
                     if (DELAY) {
                        MIDIFLAGS |= OUTSYNC;
                        get_next_byte(trk);
                        serialize--;
                        #if TRACE_ON
                        trace(0x51);
                        #endif
                        return;
                     } /* endif */
                  }
                  break;
               case 2:                          /* Device Dependent        */
                  DevDepSX(SYSEX_SAVE[5],SYSEX_SAVE[6],SYSEX_SAVE[7]);
                  break;
               case 3:                          /* Device driver command?  */
                  switch(SYSEX_SAVE[5]){        /* Process command id's    */
                     case 1:                    /* Timing generation       */
                        TIMINGFLAGS = (SYSEX_SAVE[6]<<8)+SYSEX_SAVE[8];
                        if(SYSEX_SAVE[7] & 0x40){         /* prescale down */
                           PPQNDIV = ((SYSEX_SAVE[7] & 0x3f)+1)*3;
                           PPQNCNTR = PPQNDIV;
                           PPQN = 24;
                        }else{                  /* prescale up             */
                           PPQN = ((SYSEX_SAVE[7] & 0x1f)+1)*24;
                           PPQNDIV = 1;
                           PPQNCNTR = 1;
                        }
                        SetClock(trk);
                        break;
                     case 2:                    /* Tempo control         */
                        TEMPO = (SYSEX_SAVE[7]<<7)+SYSEX_SAVE[6];
                        SetClock(trk);
                        break;
                     case 3:                    /* Voice selection         */
                        DevVoiceSel(SYSEX_SAVE[6],SYSEX_SAVE[7],SYSEX_SAVE[8]);
                        break;
                     case 4:                    /* Output Paths            */
                        break;
                     case 5:                    /* Input Paths             */
                        break;
                     case 6:                    /* Configure # notes & chan */
                        break;
                     case 7:                    /* Track Volume            */
                        DevTrkVolume(SYSEX_SAVE[6]<<8,
                               SYSEX_SAVE[7]+(SYSEX_SAVE[8]<<7),
                               trk);
                        break;
                     case 8:                    /* Track Balance           */
                        DevTrkBalance(SYSEX_SAVE[6]<<8,
                               SYSEX_SAVE[7]+(SYSEX_SAVE[8]<<7),
                               trk);
                        break;
                     case 9:                    /* Master Volume           */
                        DevMstVolume((SYSEX_SAVE[6]<<1)+(SYSEX_SAVE[7]<<8),0,trk);
                        break;
                     default:
                        break;
                  }/*inner switch*/
                  break;
               case 4:                          /* Query?                  */
                  switch(SYSEX_SAVE[5]){
                     case 1:                    /* Query device cap's      */
                        queue_data(qcaps_sysex,10,trk);
                        break;
                     case 2:                    /* Query output queue size */
                        queue_data(qsize_sysex,10,trk);
                        break;
                     case 4:                    /* Query device ID         */
                        queue_data(qid_sysex,10,trk);
                        break;
                     default:
                        break;
                  }/*inner switch*/
                  break;
               case 6:                          /* Timbre                  */
                  switch(SYSEX_SAVE[5]){
                     case  1:                   /* Query Timbre parameter  */
                        DevQTimbreParm((SYSEX_SAVE[6]<<14)
                                + (SYSEX_SAVE[7]<<7)+SYSEX_SAVE[8]);
                        break;
                     case  3:                   /* Set Timbre Parameter    */
                        DevSetTimbreParm((SYSEX_SAVE[6]<<14)
                                        +(SYSEX_SAVE[7]<<7)+SYSEX_SAVE[8],
                                          SYSEX_SAVE[9]+(SYSEX_SAVE[10]<<7));
                        break;
                     case  4:                   /* Request Timbre Block    */
                        DevReqTimbreBlk((SYSEX_SAVE[6]<<7)+SYSEX_SAVE[7]);
                        break;
                     case  6:                   /* Write Timbre Block      */
                        DevWriteTimbreBlk((SYSEX_SAVE[6]<<7)+SYSEX_SAVE[7],
                                          SYSEX_SAVE[8], &SYSEX_SAVE[9]);
                        break;
                     default:
                        break;
                     break;
                  }/*inner switch*/
               default:
                  break;
            }/*outer switch*/
            MIDIFLAGS &= 0xffff-SYSEX_IN_PROG;
            SYSEX_COUNT = 0;
         }
      }else if(ch & 0x80){                      /* Status byte?            */
         CUROUTSTAT = ch;                  /* Save running status     */
         MIDIFLAGS |= NEW_STATUS;          /* Set new status flag     */
         MIDIFLAGS &= ~THIRDBYTE;          /* Clear 3rd byte flag     */
      }else if(MIDIFLAGS & THIRDBYTE){     /* 3rd byte?               */
         MIDIFLAGS &= ~THIRDBYTE;          /* Clear 3rd byte flag     */
         byte3 = ch;                            /* Save current byte       */
         ch = CUROUTSTAT & (unsigned char)0xf0;
         midichan = CUROUTSTAT & (unsigned char)0x0f;
         if(ch==0x80){                          /* Note off?               */
            DevNoteOff(midichan,BYTE2,byte3);
         }else if(ch==0x90){                    /* Note On?                */
            DevNoteOn(midichan,BYTE2,byte3);
         }else if(ch==0xa0){                    /* Poly AFTERTOUCH         */
            DevAfterTouch(midichan,BYTE2,byte3);
         }else if(ch==0xb0){                    /* CONTROL CHANGE          */
            DevControlChange(midichan,BYTE2,byte3);
         }else if(ch==0xe0){                    /* PITCH BEND              */
            DevPitchBend(midichan,BYTE2,byte3);
         }else if(CUROUTSTAT==0xf2){       /* MTC                     */
            DevMTC(BYTE2,byte3);
         }
      }else{                                    /* Not 3rd byte            */
         BYTE2 = ch;                       /* Save 2nd byte           */
         midichan = CUROUTSTAT & (unsigned char)0x0f;
         if(CUROUTSTAT < 0xc0){            /* < C0?                   */
            MIDIFLAGS |= THIRDBYTE;        /* Set 3rd byte flag       */
         }else if(CUROUTSTAT < 0xd0){      /* PROGRAM CHANGE?         */
            DevProgramChange(midichan,BYTE2);
         }else if(CUROUTSTAT < 0xe0){      /* Channel Pressure (AFTERTOUCH) */
            DevChannelPressure(midichan,BYTE2);
         }else if(CUROUTSTAT < 0xf0){      /* PITCHBEND               */
            MIDIFLAGS |= THIRDBYTE;        /*  set 3rd byte flag      */
         }else if(CUROUTSTAT==0xf2){       /* MTC                     */
            MIDIFLAGS |= THIRDBYTE;        /*  set 3rd byte flag      */
         }else CUROUTSTAT = 0;             /* Bad or unknown stuff.   */
      }
      get_next_byte(trk);
   }

   serialize--;
   #if TRACE_ON
   trace(0x11);
   #endif
   return;
}

/*****************************************************************************/
/* get_next_byte                                                             */
/*****************************************************************************/

void get_next_byte(int trk) {

      check_wrap((IOB)XMITIO.Ptr,1,trk,TAIL,TX);
      if (LAST_XMIT_TAIL_SEGNUM) {
#if IS_OS2
         /* Now map new GDT */
         AddrToGDTselector(XMITBUF.Phys,
                           (unsigned)XMITBUF.length,
                           GDTSELECTOR3);
         if(((IOB)XMITIO.Ptr)->runflags & CHAIN_BUFFERS){
            get_next_buf((IOB)XMITIO.Virt,trk,0);
         }
#endif
         SXTAIL = XMITBUF.Ptr;
         ((IOB)XMITIO.Ptr)->tail = XMITBUF.Virt;
      } else {
         ((IOB)XMITIO.Ptr)->tail++;
      } /* endif */

} /* end get_next_byte */

/*****************************************************************************/
/*  QTimeSX                                                                  */
/*                                                                           */
/*  This function will queue a time system exclusive message.                */
/*    F0 00 00 3A 01 ll mm F7                                                */
/*****************************************************************************/

void QTimeSX(trk)
int trk;
{

   if(MIDIFLAGS & TIMING_SYSEX_QUEUED){
      if(++(*PRVTIMECOUNTLO) > 0x7f){     /* If so, increment it's count     */
         *PRVTIMECOUNTLO = 0;
         if(++(*PRVTIMECOUNTHI) > 0x7f){
            *PRVTIMECOUNTLO = 0x7f;
            *PRVTIMECOUNTHI = 0x7f;
            MIDIFLAGS &= 0xfffe;     /* Clear flag to queue another      */
         }
      }
   }
   if(!(MIDIFLAGS & TIMING_SYSEX_QUEUED)){
      _asm cli;
      PRVTIMEMSG = ((IOB)RECIO.Ptr)->head;       /* Save pointer to this loc  */
      queue_data(time_string,5,trk);

      PRVTIMECOUNTLO = ((IOB)RECIO.Ptr)->head;   /* Save pointer to count lsb  */
      ch = 0x01;
      queue_data(&ch,1,trk);
      PRVTIMECOUNTHI = ((IOB)RECIO.Ptr)->head;   /* Save pointer to count msb */
      ch = 0x00;
      queue_data(&ch,1,trk);
      ch = 0x0f7;
      queue_data(&ch,1,trk);
      MIDIFLAGS |= 7;                          /* Set rec ready & timer flags */
      _asm sti;
   }
}


#endif /* NOT_K12 */

/*****************************************************************************/
/*  check_wrap                                                               */
/*                                                                           */
/*  This function will determine if num_bytes will fit in the current        */
/*  buf. If not it will go to the next buffer.                               */
/*                                                                           */
/*  Returns: # bytes that fit in the current buffer                          */
/*****************************************************************************/

unsigned long check_wrap(iobuf_ptr,num_bytes,trk,head_tail,tx_rx)
IOB iobuf_ptr;
unsigned long num_bytes;
int trk;
char head_tail;  /* 0 - head, 1 - tail */
char tx_rx;  /* 0 - xmit, 1 - rec */
{
unsigned long  x;
struct vscb  *data_buf;
unsigned int far *segnum;
char far     *curr_ptr;
#if IS_OS2
void far     *GDTptr;
#endif
unsigned int far *wrap_flag;
#if NOT_K12
unsigned char *buff_array;
#endif

   if (head_tail) { /* Tail pointer */
      curr_ptr = iobuf_ptr->tail;
      segnum = &(iobuf_ptr->tail_segnum);
      if (tx_rx) {
         wrap_flag = &(LAST_REC_TAIL_SEGNUM);
      } else {
         wrap_flag = &(LAST_XMIT_TAIL_SEGNUM);
      } /* endif */
   } else { /* Head pointer */
      curr_ptr = iobuf_ptr->head;
      segnum = &(iobuf_ptr->head_segnum);
      if (tx_rx) {
         wrap_flag = &(LAST_REC_HEAD_SEGNUM);
      } else {
         wrap_flag = &(LAST_XMIT_HEAD_SEGNUM);
      } /* endif */
   } /* endif */
   if (tx_rx) {  /* Receive buffer */
#if NOT_K12
      buff_array = REC_BUFFER_ARRAY;
#endif
      data_buf = &RECBUF;
#if IS_OS2
      GDTptr = GDTRECBUF;
#endif
   } else { /* Transmit buffer */
#if NOT_K12
      buff_array = XMIT_BUFFER_ARRAY;
#endif
      data_buf = &XMITBUF;
#if IS_OS2
      GDTptr = GDTXMITBUF;
#endif
   } /* endif */

   /* Check to see if enough room in current buffer for all of data */
   x = (unsigned long)(data_buf->Virt  - curr_ptr) + data_buf->length;
   if (x <= num_bytes) {
      /* Not enough room - go to next buffer or wrap around */
#if NOT_K12
      buff_array[*segnum] = 0;
#endif
      if (*segnum >= iobuf_ptr->num_buffers-1) {
         /* wrap back to first buffer */
           *segnum = 0;
      } else {
         /* inc segnum */
         (*segnum)++;
      } /* endif */
      /* set up for new buffer */
      data_buf->Virt = iobuf_ptr->buf[*segnum].Virt;
      data_buf->length = iobuf_ptr->buf[*segnum].length;
#if IS_OS2
      data_buf->Phys = iobuf_ptr->buf[*segnum].Phys;
      data_buf->GDT = data_buf->Ptr = GDTptr;
      /* don't remap GDT until after the acpa_rblock/acpa_wblock is done */
#else
      data_buf->Ptr = data_buf->Virt;
#endif
      *wrap_flag = 1;
      if (iobuf_ptr->runflags & CBIOBUF)
         CB_STATUS |= CBIOBUF;
   } else {
      x = num_bytes;
      *wrap_flag = 0;
   } /* endif */
   return(x);             /* number of bytes that will fit in this buffer */
}

/*****************************************************************************/
/*  setup_shadows                                                            */
/*****************************************************************************/

void setup_shadows(int trk) {

#if IS_OS2
   int realmode;

      _asm{                   /* Determine if we're in Real Mode  */
         smsw  ax             ; get current msw
         rcr   ax,1           ; Protect bit into C
         mov   ax,0           ; Set AX = 0
         jc    is_protmode    ; Skip if protect mode
         mov   ax,1           ; Set AX = 1 if Real Mode
      is_protmode:
         mov   realmode,ax
      }
      /* Get good addresses to our I/O buffers */
      if(realmode){                 /* If real mode, get real addresses    */

/* Got a problem here - first does PhysToVirt need to be called? why not */
/* just use Virtual addr stored in xmitio - ok - if not valid anymore - why */
/* at least aren't we calling UnPhysToVirt or at least checking that it */
/* doesn't need to be done. Also - why are the .Ptr pointers being used when */
/* setting up the .Ptr pointers???????????????????????????????????? */

/* Yes, PhysToVirt needs to be called because, init_ptrs can be entered in  */
/* protect mode and therefore it's .Virt is really a GDT/LDT selector making*/
/* the .Virt addr really invalid in realmode. However, using .PTR before    */
/* setting it up is hokey and dangerous - so that's been fixed.             */

         XMITIO.Ptr = PhysToVirt(XMITIO.Phys,sizeof(struct iobuf));
         if (((IOB)XMITIO.Ptr)->num_buffers-1) {
            XMITIO.Ptr = PhysToVirt(XMITIO.Phys,sizeof(struct iobuf)
                    + ((((IOB)XMITIO.Ptr)->num_buffers-1)
                    * sizeof(struct addrs)));
         } /* endif */
         XMITBUF.Ptr=PhysToVirt(XMITBUF.Phys,(unsigned)((IOB)XMITIO.Ptr)->size);
         RECIO.Ptr = PhysToVirt(RECIO.Phys,sizeof(struct iobuf));
         if (((IOB)RECIO.Ptr)->num_buffers-1) {
            RECIO.Ptr = PhysToVirt(RECIO.Phys,sizeof(struct iobuf)
                    + ((((IOB)RECIO.Ptr)->num_buffers-1)
                    * sizeof(struct addrs)));
         } /* endif */
         RECBUF.Ptr = PhysToVirt(RECBUF.Phys,(unsigned)((IOB)RECIO.Ptr)->size);

      }else{                        /* If protect mode, use GDT selectors  */
         XMITIO.Ptr = XMITIO.GDT;
         RECIO.Ptr = RECIO.GDT;
         XMITBUF.Ptr = XMITBUF.GDT;
         RECBUF.Ptr = RECBUF.GDT;
      }

      /* Set up shadow head & tail pointers (usable to us) */
      SXHEAD = XMITBUF.Ptr + ( ((IOB)XMITIO.Ptr)->head - XMITBUF.Virt);
      SXTAIL = XMITBUF.Ptr + ( ((IOB)XMITIO.Ptr)->tail - XMITBUF.Virt);
      SRHEAD = RECBUF.Ptr + ( ((IOB)RECIO.Ptr)->head - RECBUF.Virt);
      SRTAIL = RECBUF.Ptr + ( ((IOB)RECIO.Ptr)->tail - RECBUF.Virt);
#else
      /* Set up shadow head & tail pointers (usable to us) */
      SXHEAD = ((IOB)XMITIO.Ptr)->head;
      SXTAIL = ((IOB)XMITIO.Ptr)->tail;
      SRHEAD = ((IOB)RECIO.Ptr)->head;
      SRTAIL = ((IOB)RECIO.Ptr)->tail;
#endif

} /* end setup_shadows */

#if IS_OS2


/********************* START OF SPECIFICATIONS *********************
*
* SUBROUTINE NAME:          MMEInitStreams
*
* DESCRIPTIVE NAME:
*
* FUNCTION:         Initializes the stream table at device init time.
*
* NOTES:        MME.02  -- added [trk] to Stream structure
*                   trk -- track number
*                   i   -- stream number
*
*   This procedure was moved from MMDDCMDS.C so it will go away after init.
*   pIobufPhys is a physical pointer to the iobuff structure.
*
* ENTRY POINTS:
*     LINKAGE:
*
* INPUT:
*
* EXIT-NORMAL:  NO_ERROR
*
* EXIT_ERROR:
*
* EFFECTS:
*
* INTERNAL REFERENCES:
*
* EXTERNAL REFERENCES:
*
*********************** END OF SPECIFICATIONS **********************/

void MMEInitStreams(int trk)
{
    extern unsigned int max_num_opens;
    unsigned short  i, j, BlkSize;
    unsigned short  usGDT[2];
    char far *PhysAddress;

    PSTREAM     pStream;
    void far *  paGDTsel;

      /**********************************/
      /* alloc memory for stream table, */
      /**********************************/

    BlkSize = sizeof(STREAM) * AcpaMME.usMaxNumStreams;
    max_num_opens = AcpaMME.usMaxNumStreams;

    // Allocate in high memory first.  If it fails allocate in low mem

    if (!(PhysAddress = AllocPhys(BlkSize,0)))  {    // High mem
          PhysAddress = AllocPhys(BlkSize,1);        // Low mem
    }

    paGDTsel = usGDT;

    AllocGDTSelector (paGDTsel,                 // "Array" of GDT Selectors
                      2);                       // Allocate 2

    // Set up a temporary virtual address.  Cannot use GDT selector at init time
    (char far *)AcpaMME.paStream = PhysToVirt(PhysAddress,BlkSize);

        pStream = AcpaMME.paStream;
        for (i=0; i<AcpaMME.usMaxNumStreams; i++) {
            pStream->hStream = -1;
            pStream->ulFlags = 0;

            for (j=0; j<MAXIOBUFFS; j++)    {
                pStream->Iobuff[j].runflags = 0;
                pStream->Iobuff[j].pIobufPhys =
                        VirtToPhys(&pStream->Iobuff[j]);
                pStream->Iobuff[j].num_buffers = 1;
                pStream->Iobuff[j].buf[0].Phys = NULL;
            }
            pStream++;
        }

    //*********************
    // Map to GDT selector.
    //*********************
    PhysToGDTSelector(PhysAddress,              // Physical address
                      BlkSize,                  // Length
                      usGDT[0]);                // Selector to be mapped


    // Move GDT selectors to AcpaMME
    _asm    {
                mov  ax, word ptr usGDT                 ; usGDT[0]
                mov  word ptr AcpaMME.paStream+2, ax
                xor  ax,ax
                mov  word ptr AcpaMME.paStream, ax
            }
}

/*****************************************************************************/
/*  MMEDestroyStreams                                                        */
/*                                                                           */
/* Destroy all streams allocated to a specific track.                        */
/*****************************************************************************/

void MMEDestroyStreams(int SysFileNum)
{
    extern          ACPAMME AcpaMME;
    PSTREAM         pStream;
    unsigned short  i;

    //***********************************************************************
    // Trash only the streams for the track being closed
    //*********************************************************************** */
       pStream = AcpaMME.paStream;

       for (i=0; i<AcpaMME.usMaxNumStreams; i++)   {
            if (pStream->usSysFileNum == (unsigned)SysFileNum)
                        pStream->hStream = -1;                  // Trash stream
            pStream++ ;
       }
}
#endif

/*****************************************************************************/
/* DeInitialize                                                              */
/*                                                                           */
/* Do a de-init for both AUDIO_INIT-IDLE mode and a CLOSE                    */
/*****************************************************************************/

unsigned int DeInitialize(int trk)
{
#if IS_OS2

   UnLockAllBuffers((IOB)XMITIO.Ptr,trk);
   UnLockAllBuffers((IOB)RECIO.Ptr,trk);

   /* Free up the semaphore if any */
   if (CALLBACK_SEM != 0) {
      SemClear(CALLBACK_SEM);
      SemHandle(CALLBACK_SEM,0);
   } /* endif */

   if(os2_version >= 20  &&  VCB_HNDL !=0) {
      FreeVCB_Hndl(VCB_HNDL);         // Free Virtual Callback Handle
      VCB_HNDL = 0;
   }

#endif
   TRK_ARRAY = 0;

#if NOT_K12
   if(MODE_G==MIDI) DevAllNotesOff();  /* Turn off any hung notes    */
#endif

   CALLBACK_FUNC = 0;
                                          // did AUDIO_INIT - IDLE to close it
   MODE_G = 0;
   INITFLAGS = 0;

   if (init_ptrs(trk)) {
      return(done+error+general_failure);    /* If so, flag an error */
   } else {
      return(0);
   } /* endif */

} /* end DeInitialize */

#if IS_OS2

/*****************************************************************************/
/* UnLockAllBuffers                                                          */
/*****************************************************************************/

void UnLockAllBuffers(buffer,trk)
IOB buffer;
int trk;
{

   unsigned int x;

   if (buffer) {
      for (x=0; x<buffer->num_buffers; x++) {
         if(buffer->buf[x].lock_handle) {
            UnLock_mem(buffer->buf[x].lock_handle,trk);
            buffer->buf[x].lock_handle = 0;
         } /* endif */
      } /* endif */
      if (buffer->lock_handle) {
         UnLock_mem(buffer->lock_handle,trk);
         buffer->lock_handle = 0;
      } /* endif */
   } /* endif */

} /* end UnLockAllBuffers */


/******************************************************************************/
/*   'SetProcessMode":  Sets Global variable TRK_MODE = 1(REALMODE) if calling*/
/*                      process is V86; sets TRK_MODE = 0(PROTMODE) if calling*/
/*                      process is OS/2 type.                                 */
/******************************************************************************/
void SetProcessMode(int trk)
{
   LISPtr_t LISPtr;
   LISPtr_t far *LocalSegPtr;

   LocalSegPtr = GetDOSVar(LocINFOseg);
   LISPtr = *LocalSegPtr;
   if (LISPtr->typeProcess == LIS_PT_REALMODE) {
      TRK_MODE = REALMODE;
   } else {
      TRK_MODE = PROTMODE;
   } /* endif */
}

/******************************************************************************/
/*  "v86toLin"--Routine to calculate a linear address from a v86              */
/*                 segment:offset address.                               *wb* */
/******************************************************************************/
ULONG v86toLin( void far *v86)
{
  return( (((ULONG)v86 & 0xffff0000) >> 12) + ((ULONG)v86 & 0x0000ffff) );
}


/******************************************************************************/
/*  "GetHChVDM"-- Get Claim-Hardware VDM Handle, if any.                *@wb1**/
/******************************************************************************/
ULONG  GetHChVDM(void)
{
#if NUM_TRACKS > 1
   if (mode[0] == CLAIM_HDWR)
      return trk_hvdm[0];
   if(mode[1] == CLAIM_HDWR)
      return trk_hvdm[1];
#else
   if (mode == CLAIM_HDWR)
      return trk_hvdm;
#endif
   return  (0L);
}

/******************************************************************************/
/*  "AddrToGDT"--Routine to map a GDT address from either a Linear address if */
/*               OS/2 2.0 and in V86 mode, or from a Physical address in all  */
/*               other cases.                                                 */
/******************************************************************************/
int AddrToGDTselector(void far *buf,unsigned len, int selector)
{
   int trk;
   char exit;
   char phys;

      /* Determine if transmit or receive buffer, what track it is, and */
      /* whether or not it's the internal buffers.                      */
      /* GDTselector1 - XMITIO                                          */
      /* GDTselector2 - RECIO                                           */
      /* GDTselector3 - XMITBUF                                         */
      /* GDTselector4 - RECBUF                                          */

      exit = 0;
      phys = 0;
      trk = 0;
      while ((trk<NUM_TRACKS) && (exit==0)) {
         if ((unsigned int)selector == GDTSELECTOR1) {
            if (XMIT_INTERNAL)/* check if internal buf*/
               phys = 1;                    /* then do PhysToGDT        */
            exit = 1;
         } else if ((unsigned int)selector == GDTSELECTOR2) {
            if (REC_INTERNAL) /* check if internal buf*/
               phys = 1;                    /* then do PhysToGDT        */
            exit = 1;
         } else if ((unsigned int)selector == GDTSELECTOR3) {
            if (XMIT_INTERNAL)/* check if internal buf*/
               phys = 1;                    /* then do PhysToGDT        */
            exit = 1;
         } else if ((unsigned int)selector == GDTSELECTOR4) {
            if (REC_INTERNAL) /* check if internal buf*/
               phys = 1;                    /* then do PhysToGDT        */
            exit = 1;
         } else {
            trk++;
         } /* endif */
      } /* end while */

      /* trk is now set up to the correct track OR never found which    */
      /* means that a Util pointer is being used and exit = FALSE still */
      /* If it is a Util pointer then it must be V86 mode and we want   */
      /* to do a LinToGDT                                               */
      if (((os2_version >= 20) && (TRK_MODE == REALMODE) && (!phys)) ||
          (exit == 0)) {

         /* No need to worry about page boundaries if Util pointer because */
         /* we only use these pointers now - NOT at interrupt time and we  */
         /* are making the assumption (from never seeing it happen) that   */
         /* the page boundary restriction is only needed at interrupt time */

         if (LinToGDTSelector(buf,len,selector))
            return(-1);

      } else {
         if (PhysToGDTSelector(buf,len,selector))
            return (-1);
      } /* endif */

      return(0);

} /* end AddrToGDT */

/******************************************************************************/
/*  "UnLock_mem"--Routine to UnLock memory by calling either                  */
/*               UnLock if not V86 mode, or LnUnlock if it is V86 mode        */
/******************************************************************************/
int  UnLock_mem(ULONG lockhandle, int trk)
{

   /* Note that we won't get here unless the lockhandle is non-zero */
   /* The lock handle will be zero if the internal buffers are being*/
   /* used. Therefore, no internal buffers will ever get this far.  */
   if (V86_MODE) {
      return(LnUnlock(lockhandle));
   } else {
      return(UnLock((long)lockhandle));
   } /* endif */

} /* end UnLock_mem */

#endif

/*****************************************************************************/
/* InitIOBuf                                                                 */
/*****************************************************************************/

unsigned int InitIOBuf(newbuf,iobuf,op_type,trk)
IOB newbuf;
IOB iobuf;
char op_type;
int trk;
{
   if (newbuf) {

#if IS_OS2
      UnLockAllBuffers(iobuf,trk);
#endif

      if (op_type == 0) {
         XMIT_INTERNAL = 0;
      } else {
         REC_INTERNAL = 0;
      } /* endif */

   }else{

      if (op_type == 0) {
         newbuf = (IOB)&IXIOBUF;
      } else {
         newbuf = (IOB)&IRIOBUF;
      } /* endif */

   }

   if (set_hpi(newbuf,trk,0,op_type)) {           /* Select user buffer   */
      HPILOCK--;
      return(done+error+general_failure);         /* If so, flag an error */
   } /* endif */

   iobuf->head_segnum = 0;
   iobuf->tail_segnum = 0;

   iobuf->count = 0;
   iobuf->position = 0;

} /* end InitIOBuf */

#if NOT_K12

/*****************************************************************************/
/* InitBufferArray                                                           */
/*****************************************************************************/

unsigned int InitBufferArray(max_buffers,iobuf,buffer_array,trk)
unsigned short max_buffers;
IOB iobuf;
char far *buffer_array;
int trk;
{
   unsigned int x;

   iobuf->num_buffers = 0;
   if (max_buffers > MAX_NUM_BUFFERS) {
      max_buffers = MAX_NUM_BUFFERS;
      HPILOCK--;
      return(done+error+general_failure);  /* If so, flag an err*/
   }
   for (x=0; x<max_buffers; x++) {
      if (iobuf->buf[x].length) {
          buffer_array[x] = 1;
          iobuf->num_buffers++;
      } else {
          buffer_array[x] = 0;
          iobuf->buf[x].Phys = 0;
          iobuf->buf[x].lock_handle = 0;
      } /* endif */
   } /* endfor */

} /* end InitBufferArray */

#endif

/*****************************************************************************/
/* StopTrk                                                                   */
/*****************************************************************************/

void StopTrk(trk)
int trk;
{

   init_queue_vars(trk);         /* Purge request queue            */
   if(OPERATION_G != PLAY) {     /* If record or compute operation */
      purge_data((IOB)RECIO.Ptr);/* Purge data in receive buffer   */
   } /* endif */
   if(OPERATION_G != RECORD) {   /* If play or compute operation   */
      purge_data((IOB)XMITIO.Ptr);/*Purge data in transmit buffer  */
   } /* endif */

} /* end StopTrk */

/*****************************************************************************/
/* PauseTrk                                                                  */
/*****************************************************************************/

void PauseTrk(trk)
int trk;
{

   if(OPERATION_G != PLAY) {
      ((IOB)RECIO.Ptr)->runflags |= PAUSED;       /* set paused flag */
   }
   if(OPERATION_G != RECORD) {
      ((IOB)XMITIO.Ptr)->runflags |= PAUSED;      /* set paused flag */
   }

} /* end PauseTrk */

/******************************************************************************/
/*  check_if_stopped(trk) - check to see if just stopped and need to purge    */
/*               data and the queue.                                          */
/******************************************************************************/
void check_if_stopped(int trk)
{

   if ((OPERATION_G == PLAY) ||       /* If stopped, then do any cleanup */
       (OPERATION_G == PLAY_AND_RECORD)) {
      if (!(((IOB)XMITIO.Ptr)->runflags & STARTED)) {
         if ((LAST_TIME & RUNNING) && (LAST_TIME & EVER_STARTED)) {
#if NOT_DOS_K12
             purge_req_queue(trk);
#endif
             purge_data((IOB)XMITIO.Ptr);
             LAST_TIME &= ~EVER_STARTED;
         } else {
            LAST_TIME |= RUNNING;
         } /* endif */
      } else {
         LAST_TIME |= EVER_STARTED;
      } /* endif */
   }

   if ((OPERATION_G == RECORD) ||       /* If stopped, then do any cleanup */
       (OPERATION_G == PLAY_AND_RECORD)) {
      if (!(((IOB)RECIO.Ptr)->runflags & STARTED)) {
         if ((LAST_TIME & RUNNING) && (LAST_TIME & EVER_STARTED)) {
#if NOT_DOS_K12
             purge_req_queue(trk);
#endif
             purge_data((IOB)XMITIO.Ptr);
             LAST_TIME &= ~EVER_STARTED;
         } else {
            LAST_TIME |= RUNNING;
         } /* endif */
      } else {
         LAST_TIME |= EVER_STARTED;
      } /* endif */
   }

} /* end check_if_stopped */

/******************************************************************************/
/*  init_queue_vars(trk) - initialize bunch of track dependent variables      */
/*               like req_queue and midi variables and position variables     */
/******************************************************************************/
void init_queue_vars(int trk)
{

         LAST_TIME = 0;

         MIDIFLAGS = 0;                    /* Initialize variables       */
#if NOT_K12
         CUROUTSTAT = 0;                   /* Clear running status       */
         SYSEX_COUNT = 0;                  /* No sysex in progress       */
#endif
         TIMINGFLAGS = 0x0800;             /* Sync output by default     */

#if NOT_DOS_K12
         purge_req_queue(trk);
#endif

#if NOT_K12
         CATCHUP_COUNT = 0;             /* Init # of F8's to skip       */
         DELAY = 0;
         PPQN = 24;                     /* Restore MIDI default PPQN    */
         TEMPO = 1200;
         PPQNDIV = PPQNCNTR = 1;        /* No prescaling (1x)           */
         if (MODE_G == MIDI) {
            SetClock(trk);
         } /* endif */
#endif

         ROLLOVER_TIME = 0;
         POS_BUFFER_COUNT = 0;

#if NUM_TRACKS > 1
         data_processed[trk] = 0;
#endif

} /* end init_queue_vars */

/******************************************************************************/
/* SetGlobalParms(init) - initialize global parameters to those passed in     */
/*               from the AUDIO_INIT structure.                               */
/******************************************************************************/
void SetGlobalParms(AIP init, int trk)
{
   OPERATION_G = init->operation;
   FLAGS_G = init->flags;
   MODE_G = init->mode;
   SRATE_G = init->srate;
   BITS_PER_SAMPLE_G = init->bits_per_sample;
   BSIZE_G = init->bsize;
   CHANNELS_G = init->channels;

} /* end SetGlobalParms */

/******************************************************************************/
/*  purge_data(io) - initialize bunch of track dependent variables            */
/*               like req_queue and midi variables and position variables     */
/******************************************************************************/
void purge_data(IOB io)
{
   _asm cli;
   io->runflags &= ~STARTED;
   io->head_segnum = 0;
   io->tail_segnum = 0;
   io->head = io->tail = io->buf[0].Virt;
   io->count = 0;
   _asm sti;

} /* end purge_data */

#if NOT_DOS_K12
/*****************************************************************************/
/*  purge_req_queue - initialize req_queue                                   */
/*****************************************************************************/
void purge_req_queue(int trk)
{
   unsigned int x;

   QUEUE_LOCK++;                     /* Get the queue lock         */
   NUM_REQS = 0;                     /* Initialize request blocks  */
   REQ_Q_HEAD = NULL;                /* NULL out chain head        */
   FREE_REQ = &REQ_Q[0];        /* Set ptr to first free blk  */
   for(x=0; x<MAXREQS-1; x++){            /* Initialize request blocks  */
      REQ_Q[x].req_next = &REQ_Q[x+1];   /* Set all next pointers*/
   }
   REQ_Q[MAXREQS-1].req_next = NULL;      /* Last blk next ptr = NULL   */
   QUEUE_LOCK--;                     /* release the lock           */

} /* end purge_req_queue */
#endif

/*****************************************************************************/
/* CurrentPosition                                                           */
/*****************************************************************************/
unsigned long CurrentPosition(trk)
int trk;
{

    if (OPERATION_G == RECORD) {
       return(((IOB)RECIO.Ptr)->position);
    } else { /* assume operation == PLAY */
       return(((IOB)XMITIO.Ptr)->position);
    } /* endif */

} /* end CurrentPosition */

#if IS_OS2

/*****************************************************************************/
/* GetLinearAddr - convert addr in structure passed in into linear addr if   */
/*                 we are working in a VDM session.                          */
/*****************************************************************************/
void far * GetLinearAddr(info_ptr,size,utilgdt,utilptr,trk)
void far     *info_ptr;
unsigned int  size;
unsigned int  utilgdt;
void far     *utilptr;
int           trk;
{

unsigned long Ltmp;

   if (os2_version >= 20) {
      if (TRK_MODE == REALMODE) {

         /* get linear addr from info ptr                                    */
         Ltmp = (((ULONG)info_ptr & 0xffff0000) >> 12) +
                        ((ULONG)info_ptr & 0x0000ffff);

         if (AddrToGDTselector((char far *)Ltmp, size, utilgdt)) {
           return(0);                               /* If so, flag an error  */
         } /* endif */

         info_ptr = utilptr;

      } else { /* Protect mode */            /* OS/2 Mode: 16:16 or 0:32     */

         /* assume 16:16 address                                             */
         Ltmp = VirtToLin(info_ptr);
         if (Ltmp == 0L) {
            /* assume 0:32 address */
            info_ptr =(void far *)((((ULONG)info_ptr & 0xffff0000) << 3)
                        + 0x70000 + ((ULONG)info_ptr & 0x0000ffff));
         } /* Otherwise, 16:16 address as passed is ok.                      */

      } /* endif */

   } /* endif */

   if (VerifyAccess((char far *)info_ptr,size,1))
       return(0);                                    /* If so, flag an error */

   return(info_ptr);

} /* end GetLinearAddr */

/********************* START OF SPECIFICATIONS *********************
* SUBROUTINE NAME: FindSysFileNumber
* DESCRIPTIVE NAME: Find entry in stream table for the given sysfilenumber.
* FUNCTION: To search the stream table finding a match with the given parm.
* NOTES: This routine is called from Get_Track.
* ENTRY POINTS:
*     LINKAGE:   CALL near
*
* INPUT: sysfilenum
* EXIT-NORMAL: NO_ERROR
* EXIT_ERROR: -1 if stream found in table
* INTERNAL REFERENCES: none
* EXTERNAL REFERENCES: none
*********************** END OF SPECIFICATIONS **********************/
int FindSysFileNum(unsigned int SysFileNum, int Function)
{
   unsigned short i;
   short rc=0;

   /* Loop on the number of streams in the table */
   for (i=0; i <= max_num_opens; i++) {

         /* Check for our SysFileNum */
         if (open_array[i][0] == SysFileNum) {

            /* If OPEN function, then increment the counter only and don't do */
            /* any more processing                                            */
            if (Function == 0) {

               open_array[i][1]++;
               return(-1);

            } else {  /* CLOSE funtion */

               /* If not down to zero, then extra OPENs were done and no proc-*/
               /* essing should be done.                                      */
               if (open_array[i][1]) {
                  /* Decrement the count */
                  open_array[i][1]--;
                  return(-1);
               } else {
                  /* Last one to close - so take sysfilenum out of array */
                  open_array[i][0] = 0;
                  return(0);
               } /* endif */

            } /* endif */

         } else if (open_array[i][0] == 0) {

            /* If this entry is 0, then remember it so that sysfilenum */
            /* can be added to array if need be                        */
            rc = i;

         } /* endif == SysFileNum */

   } /* endfor */

   /* If this far, then match not found for OPEN function */
   /* Return 0 entry in array                             */
   return(rc);
}
#endif

#if NOT_K12
/*****************************************************************************/
/* copyaddrs - copy addr structure from source to target                     */
/*****************************************************************************/
void copyaddrs(source,target)
struct addrs_array far *target;
struct addrs_array far *source;
{
   target->length = source->length;
   target->Virt = source->Virt;
   target->Phys = source->Phys;
   target->lock_handle = source->lock_handle;

} /* end copyaddrs */
#endif

/*****************************************************************************/
/* InitPosition                                                              */
/*****************************************************************************/
void InitPosition(time,trk)
unsigned long time;
int trk;
{

   ROLLOVER_TIME = time;
   POS_BUFFER_COUNT = 0;
#if IS_OS2
   LAST_REPORTED_TIME = 0;
#endif

} /* end InitPosition */

#if IS_OS2
/*****************************************************************************/
/* TimeOfCurrentBuffer                                                       */
/*****************************************************************************/
unsigned long TimeOfCurrentBuffer(trk)
int trk;
{
   unsigned long time;
   unsigned long ctime;

       ctime = CurrentPosition(trk);
       time = ctime - LAST_REPORTED_TIME;
       LAST_REPORTED_TIME = ctime;
       return(time);

} /* end TimeOfCurrentBuffer */
#endif
