
       TITLE  Generic Device Driver Routines

;
; Change History
;
; 1/20/92 BRR232 Return error if GENERIC request comes down without file num
;                in trk_array
; 3/06/92 BRR300 Set trk_assigned_at_init to 1 if AUDIO_INIT is setting the
;                track - and 0 if OPEN is setting the track
; 3/24/92 BRR321 Add support for multiple OPEN/CLOSE with same SysFileNum
;
;************
; Equates
;************
;
;These constants define Request Block commands
;
INIT_COMMAND        equ    00h
OPEN_COMMAND        equ    0dh
CLOSE_COMMAND       equ    0eh
GENERIC_COMMAND     equ    10h
DEINIT_COMMAND      equ    14h
;
; These constants define GENERIC_IOCTL Request Block offsets
;
FUNC_CATEGORY       equ    0dh
FUNC_CODE           equ    0eh
DD_CATEGORY         equ    80h
AUDIO_INIT_FUNC     equ    40h
;
;These constants define Request Block status
;
UNKNOWN_COMMAND     equ    03h
GENERAL_FAILURE     equ    0ch
ERROR               equ    8000h
DONE                equ    0100h
WRITE_PROTECT       equ    00h

;***********************
; Structure definitions
;***********************

RH           struc                      ; Request Header
RHlen        db     ?                   ; Length in bytes of packet
RHunit       db     ?                   ; Subunit of block device
RHcommand    db     ?                   ; Command code
RHstatus     dw     ?                   ; Status word
RHDOSLink    dd     ?                   ; Reserved
RHDevLink    dd     ?                   ; Device multiple-request link
RHdata       db     ?                   ; Input/Output media descriptor byte
IOBufAddr    dd     ?                   ; Input/Output buffer address
IOBufLen     dw     ?                   ; Input/Output buffer length
RH           ends                       ;  (Also DD ptr to parms during INIT)


;****************
; Segment layout
;****************
NULL    segment word public 'BEGDATA'
NULL    ends

_DATA   segment word public 'DATA  '    ; All code and data segments must be
                                        ; named and declared public
_DATA   ends

CONST   segment word public 'CONST'
CONST   ends

FAR_BSS segment word public 'FAR_BSS'
FAR_BSS ends

_BSS    segment word public 'BSS'
_BSS    ends

LAST_D  segment word public 'LAST_DATA'
LAST_D  ends

_TEXT   segment  byte public 'CODE'     ; Define code segment
_TEXT   ends

END_TEXT segment word public 'CODE'
END_TEXT ends
DGROUP GROUP NULL,_DATA,CONST,_BSS,LAST_D,FAR_BSS
CGROUP GROUP _TEXT,END_TEXT

_DATA   segment

extrn _off_array:byte
extrn _trk_array:word
extrn _trk_assigned_at_init:byte
extrn _open_array:word

extrn _num_opens:word                   ; current number OPEN
IFDEF TWO_TRACKS
extrn _max_num_opens:word               ; maximum number of OPENs allowed
ELSE
extrn _max_num_opens:word               ; maximum number of OPENs allowed
ENDIF

_DATA   ends

_TEXT   segment
        assume  CS:CGROUP,DS:DGROUP

        EXTRN  _MMEDestroyStreams:near
        EXTRN  _FindSysFileNum:NEAR

_Get_Track proc near
       public _Get_Track
                                        ; es:bx = request block
       xor    ax,ax
       mov    al,es:[bx+RHcommand]      ;load al with command
       cmp    ax,INIT_COMMAND           ;if INIT command
       jne    TRK_DEPENDENT_CMD
       jmp    TRK_INDEPENDENT_CMD       ; then we don't care what track
TRK_DEPENDENT_CMD:
       cmp    ax,DEINIT_COMMAND         ;else if DeInit command
       jne    STILL_TRK_DEPENDENT_CMD
       jmp    TRK_INDEPENDENT_CMD       ; then we don't care what track
STILL_TRK_DEPENDENT_CMD:
       mov    di,ax                     ;otherwise we care what track
       add    di,offset _off_array      ; get offset into request_block of SFN
       mov    si,[di]
       and    si,00ffh
       cmp    si,0                      ;check if System File Number exists
       jne    SFN_OK
       jmp    NO_SFN                    ;if none then error
SFN_OK:
       mov    dx,es:[bx+si]             ;dx = System File Number
       cmp    ax,OPEN_COMMAND           ;if OPEN command then need to start trk
       je     IOCTL_OPEN
       cmp    ax,CLOSE_COMMAND          ;if CLOSE command then need to close trk
       jne    NOT_CLOSE_COMMAND
       jmp    IOCTL_CLOSE
NOT_CLOSE_COMMAND:
       mov    ax,word ptr _trk_array    ;ax = Trk 0 System File Number
       cmp    ax,dx                     ; trk 0 command?
       jne    NOT_TRK_0
       jmp    SET_TRK_0
NOT_TRK_0:
IFDEF TWO_TRACKS
       mov    ax,word ptr _trk_array+2  ;ax = Trk 1 System File Number
       cmp    ax,dx                     ; trk 1 command?
       jne    CHECK_FOR_GENERIC         ; Check to see if AUDIO_INIT and we
       jmp    SET_TRK_1                 ;   should assign a trk now
ENDIF
CHECK_FOR_GENERIC:                      ;
       xor    ax,ax
       mov    al,es:[bx+RHcommand]      ;load al with command
       cmp    ax,GENERIC_COMMAND        ;if GENERIC command
       je     GENERIC_IOCTL
       jmp    NO_MATCH                  ; if not then rtn with error
GENERIC_IOCTL:
       mov    al,es:[bx+FUNC_CATEGORY]  ; else, check if DD Category
       cmp    ax,DD_CATEGORY            ;
       je     OUR_CATEGORY
       jmp    NO_MATCH                  ; if not then rtn with error
OUR_CATEGORY:
       mov    al,es:[bx+FUNC_CODE]      ; check if AUDIO_INIT call
       cmp    ax,AUDIO_INIT_FUNC        ;
       je     AUDIO_INIT_COMMAND        ; if it is then look for open track
       jmp    NO_MATCH                  ; else return error
AUDIO_INIT_COMMAND:
       mov    ax,word ptr _trk_array    ;ax = trk 0 System File Number
       cmp    ax,0                      ;if not used yet, then set this to trk 1
IFDEF TWO_TRACKS
       jne    TRK_1_FREE
ELSE
       jne    NO_EMPTY_TRACKS
ENDIF
       mov    byte ptr _trk_assigned_at_init,1
       mov    word ptr _trk_array,dx
       jmp    SET_TRK_0
TRK_1_FREE:
       mov    ax,word ptr _trk_array+2  ;ax = trk 1 System File Number
       cmp    ax,0                      ;if not used yet, then set this to trk 2
       je     TRK_1_EMPTY
       jmp    NO_EMPTY_TRACKS
TRK_1_EMPTY:
       mov    byte ptr _trk_assigned_at_init+2,1
       mov    word ptr _trk_array+2,dx
       jmp    SET_TRK_1

IOCTL_OPEN:                             ;dx = System File Number

       push   es                        ;save packet address
       push   bx                        ;
       mov    ax,0                      ;pass function
       push   ax                        ;
       push   dx                        ;pass sysfilenum
       call   _FindSysFileNum           ; check to see if this sysfilenum is
                                        ; already opened
       pop    dx                        ;restore sysfilenum
       add    sp,2                      ;
       pop    bx                        ;restore packet addr
       pop    es                        ;
       cmp    ax,0                      ;check if found
       jge    DO_OPEN_PROCESSING        ;
       jmp    MME_OPEN_CLOSE_WITH_NO_TRK;
DO_OPEN_PROCESSING:                     ;
       mov    cx,word ptr _num_opens    ;get number of opens
       inc    cx                        ;inc number of opens
       cmp    cx,_max_num_opens         ;#opens > max number allowed
       jle    NOT_MAX_NUM_OPENS_YET
       jmp    OPEN_ERROR                ;if yes then return error
NOT_MAX_NUM_OPENS_YET:
       mov    word ptr _num_opens,cx    ;otherwise, go ahead and let them open

       lea    si,_open_array            ;get address of array
       push   bx
       mov    bx,ax
       shl    bx,1                      ;multiply index by 4 to get
       shl    bx,1                      ; addr into array
       mov    [si+bx],dx                ;move sysfilenum into array
       pop    bx
       mov    ax,word ptr _trk_array    ;ax = trk 0 System File Number
       cmp    ax,0                      ;if not used yet, then set this to trk 1
IFDEF TWO_TRACKS
       jne    TRY_TRK_1
ELSE
       jne    MME_OPEN_CLOSE_WITH_NO_TRK
ENDIF
       mov    byte ptr _trk_assigned_at_init,0
       mov    word ptr _trk_array,dx
       jmp    SET_TRK_0
TRY_TRK_1:
       mov    ax,word ptr _trk_array+2  ;ax = trk 1 System File Number
       cmp    ax,0                      ;if not used yet, then set this to trk 2
       jne    MME_OPEN_CLOSE_WITH_NO_TRK
       mov    byte ptr _trk_assigned_at_init+2,0
       mov    word ptr _trk_array+2,dx
       jmp    SET_TRK_1                 ;otherwise error

IOCTL_CLOSE:                            ;dx = System File Number
       push   es
       push   bx
       mov    ax,1
       push   ax                        ;
       push   dx                        ;
       call   _FindSysFileNum           ; check to see if this sysfilenum is
                                        ; already opened
       pop    dx                        ;
       add    sp,2                      ;
       pop    bx
       pop    es
       cmp    ax,0                      ;
       jz     DO_CLOSE_PROCESSING       ;
       jmp    MME_OPEN_CLOSE_WITH_NO_TRK;
DO_CLOSE_PROCESSING:                    ;
       mov    ax,_num_opens             ;get number of opens
       dec    ax                        ;dec number of opens
       cmp    ax,0                      ;check to see if any still open
       jl     NO_MATCH                  ;return error if none open
       mov    _num_opens,ax             ;otherwise, let them close
IFDEF IS_OS2
       push   es                        ;save request block
       push   bx                        ;
       push   dx                        ;Pass SysFileNum
       call   _MMEDestroyStreams        ;Destroy streams
       pop    dx                        ;restore sysfilenum
       pop    bx                        ;restore request block
       pop    es                        ;
ENDIF
       mov    ax,word ptr _trk_array    ;ax = trk 0 System File Number
       cmp    ax,dx                     ;if not used yet, then set this to trk 1
       je     SET_TRK_0
IFDEF TWO_TRACKS
       mov    ax,word ptr _trk_array+2  ;ax = trk 1 System File Number
       cmp    ax,dx                     ;if not used yet, then set this to trk 2
       je     SET_TRK_1
ENDIF
       jmp    MME_OPEN_CLOSE_WITH_NO_TRK;otherwise have to assume it's MME

SET_TRK_1:
       mov    ax,1                      ;Track 1
       jmp    END_Get_Track

TRK_INDEPENDENT_CMD:
SET_TRK_0:
       mov    ax,0                      ;Track 0
       jmp    END_Get_Track

NO_SFN:
       mov    es:[bx+RHstatus],UNKNOWN_COMMAND
       mov    ax,-1
       jmp    END_Get_Track

NO_EMPTY_TRACKS:
OPEN_ERROR:
       mov    es:[bx+RHstatus],ERROR+DONE+WRITE_PROTECT
       mov    ax,-1
       jmp    END_Get_Track

NO_MATCH:                               ;Hopefully never get this one
       mov    es:[bx+RHstatus],ERROR+DONE+GENERAL_FAILURE
       mov    ax,-1
       jmp    END_Get_Track

MME_OPEN_CLOSE_WITH_NO_TRK:
       mov    es:[bx+RHstatus],DONE
       mov    ax,-1

END_Get_Track:
       ret                              ; ax = track #
_Get_Track endp

_TEXT   ends

        END
