;*****************************************************************************
;                                 OS2DD.ASM
;
;                          Written by Ron Lisle
;
; This module contains the skeleton for an OS/2 mode Audio Device Driver.
; All routines and data are device-independent.  Functions and/or data
; unique to any given device are contained in a separate file named so
; as to identify the specific device (for example, MPU401.C).
;
; Refer to the AUDIODD.DOC file for detailed information about AUDIODD.
; 6/28/91 RJL   Changed PhysToGDT call to switch to protect mode
; 8/02/91 BRR26 Change DEVICE_HLP to _DEVICE_HLP
; 8/02/91 BRR27 Move first startup message to before DevInit is called
; 8/02/91 BRR28 Display error message if initialization fails
; 8/09/91 BRR37 Add support for device sharing - multiple instances
; 8/15/91 BRR44 Add GetDOSVar dev_hlp function
; 8/19/91 RJL81 Added FreePhys devhlp.
; 8/19/91 RJL82 Added SetTimer, FreeTimer, & TimerInt routines.
; 8/26/91 BRR47 Support only 1 track hardware - don't assume 2 tracks
; 8/15/91 BRR44 Modifications for OS/2 2.0 driver - Real Mode mostly
; 8/26/91 MME.08 Added support for Performance Hooks
; 9/03/91 BRR63 Don't call aud_control until pointers for iobuf set up
; 9/18/91 MME.12
;10/23/91 BRR81  Turn off interrupts before EOI is done
;11/05/91 BRR177 Changes for Multiple OPENs and CLOSEs for MME multiple streams
;11/12/91 BRR186 Move track determination into generic ASM file for DOS to use.
;11/22/91 BRR44  Add OS/2 2.0 V86 support (see Wes)
;12/11/91 BRR210 Allocate GDTs after DevINIT is called in INIT
; 1/07/92 BRR222 Add VDD support
; 1/23/92 CMC01  Add HookUp DevHlp
; 1/23/92 CMC02  Add LINTOPAGELIST DevHlp
; 2/03/92 BRR247 Add support for automated naming convention
; 2/10/92 WES262 Add V86 callback support
; 2/10/92 CMC03  Change GetPageList
; 3/05/92 WES299 Add VDD serialization support
; 3/24/92 BRR320 Add support for function 03h and 0Ch for windows.
; 5/15/92 BRR456 OS/2 K12 fixes
; 6/10/92 CMC04  Add FOX2_TEXT support
;*****************************************************************************

      TITLE  Audio OS/2 Device Driver
      .seq                        ; Use segments in order listed
      .286c
      .286p

ifdef   PTRACE
      include       ptrace.inc    ; PTrace Macros
      include       devhlp.inc    ; DevHelp support
      include       devsym.inc
endif
;************
; Equates
;************
@DEBUG equ 0
stdout       equ    1
cr           equ    0dh
lf           equ    0ah
;
;These constants define the devhelp commands
;
DevHlp_Block        equ    4      ; Block thread
DevHlp_Run          equ    5      ; Unblock thread
DevHlp_PhysToVirt   equ    21     ; Convert physical address to virtual
DevHlp_RealToProt   equ    47     ; Switch to protect mode from real mode
DevHlp_ProtToReal   equ    48     ; Switch back to real mode from protect mode
DevHlp_MonWrite     equ    34     ; Pass data records to monitor
DevHlp_MonFlush     equ    35     ; Remove all data from stream
DevHlp_Register     equ    32     ; Install a monitor
DevHlp_DeRegister   equ    33     ; Remove a monitor
DevHlp_QueueFlush   equ    16     ; Flush queue
DevHlp_QueueWrite   equ    17     ; Put a char in the queue
DevHlp_QueueRead    equ    18     ; Get a char from the queue
DevHlp_SemRequest   equ    6      ; Claim a semaphore
DevHlp_SemHandle    equ    08h    ; get a semaphore handle
DevHlp_SemClear     equ    7      ; Release a semaphore
DevHlp_MonitorCreate equ   31     ; Create a monitor
DevHlp_QueueInit    equ    15     ; Init/Clear char queue
DevHlp_SetTimer     equ    29     ; Set timer request handler
DevHlp_ResetTimer   equ    30     ; Reset timer request handler
DevHlp_PhysToUVirt  equ    17h    ; physical address to user virtual
DevHlp_UnPhysToVirt equ    50     ; mark completion of PhysToVirt
DevHlp_VirtToPhys   equ    16h    ; virtual to physical
DevHlp_VerifyAccess equ    39     ; Verify access to memory
DevHlp_Lock         equ    19     ; Lock segment
DevHlp_Unlock       equ    20     ; Unlock segment
DevHlp_SetIRQ       equ    27     ; Set hardware interrupt handler
DevHlp_UnSetIRQ     equ    28     ; Reset hardware interrupt handler
DevHlp_EOI          equ    49     ; Issue EOI to hardware interrupt
DevHlp_AttachDD     equ    42     ; Attach to a device driver
DevHlp_LinToPageList equ   5Eh    ; Convert linear to a page list
DevHlp_AllocGDTSelector equ 2dh   ; Allocate GDT selectors
DevHlp_PhysToGDTSelector equ 2eh  ; Map physical to virtual address in GDT
DevHlp_AllocPhys    equ    18h    ; Allocate physical memory
DevHlp_FreePhys     equ    19h    ; Free physical memory
DevHlp_DevDone      equ    1      ; Flag a request packet done
DevHlp_PushReqPacket equ   9      ; Push Request Packet onto queue
DevHlp_PullReqPacket equ   0ah    ; Pull Request Packet off queue
DevHlp_PullParticular equ  0bh    ; Pull a particular Request Packet off queue
DevHlp_SortReqPacket equ   0ch    ; Sort a request packet
DevHlp_RegisterStackUsage equ 3ah ; Register stack size requirements
DevHlp_GetDOSVar    equ 24h       ; Return an address of a kernel variable
; **********   Equates for 6.167 **********************************************
DevHlp_RegisterPDD  equ     80    ; Register PDD e.p for VDD communication.
DevHlp_VMLock       equ     85    ; Lock linear address space
DevHlp_VMUnlock     equ     86    ; Unlock address range
DevHlp_VMAlloc      equ     87    ; Allocate memory
DevHlp_VMFree       equ     88    ; Free memory.
DevHlp_VirtToLin    equ     91    ; Convert virt. addrss to linear
DevHlp_LinToGDTSelector equ 92    ; Map GDT Selector to linear address range.

;***********************
; Structure definitions
;***********************
RH           struc                ; Request Header
RHlen        db     ?             ; Length in bytes of packet
RHunit       db     ?             ; Subunit of block device
RHcommand    db     ?             ; Command code
RHstatus     dw     ?             ; Status word
RHDOSLink    dd     ?             ; Reserved
RHDevLink    dd     ?             ; Device multiple-request link
RHdata       db     ?             ; Input/Output media descriptor byte
IOBufAddr    dd     ?             ; Input/Output buffer address
IOBufLen     dw     ?             ; Input/Output buffer length
RH           ends                 ;  (Also DD ptr to parms during INIT)

OFF_SYS_FILE_NUM   struc
INIT_trk           db     0
MEDIA_CHECK_trk    db     0
BUILD_BPB_trk      db     0
INPUT_trk          db     23
READ_trk           db     24
NONDES_READ_trk    db     0
INPUT_STATUS_trk   db     0
INPUT_FLUSH_trk    db     0
WRITE_trk          db     24
WRITE_VERIFY_trk   db     0
OUTPUT_STATUS_trk  db     0
OUTPUT_FLUSH_trk   db     0
OUTPUT_trk         db     23
DEVICE_OPEN_trk    db     13
DEVICE_CLOSE_trk   db     13
REMOVE_MEDIA_trk   db     0
GENERIC_trk        db     23
RESET_MEDIA_trk    db     0
GET_LDM_trk        db     0
SET_LDM_trk        db     0
DEINSTALL_trk      db     0
PORTACCESS_trk     db     0
PAR_FIXED_DISK_trk db     0
GET_FD_trk         db     0
Reserved3_trk      db     0
Reserved4_trk      db     0
Reserved5_trk      db     0
Reserved6_trk      db     0
OFF_SYS_FILE_NUM   ends

;****************
; Segment layout
;****************
NULL    segment word public 'BEGDATA'
NULL    ends

_DATA   segment word public 'DATA'; All code and data segments must be
                                  ; named and declared public
_DATA   ends

CONST   segment word public 'CONST'
CONST   ends

FAR_BSS segment word public 'FAR_BSS'
FAR_BSS ends

_BSS    segment word public 'BSS'
_BSS    ends

LAST_D  segment word public 'LAST_DATA'
LAST_D  ends

_TEXT   segment  byte public 'CODE'     ;Define code segment
_TEXT   ends

IFDEF IS_FOX
FOX2_TEXT segment byte public 'CODE'   ;Define code segment
beg_fox2_text equ $                    ;Beginning of segment
FOX2_TEXT ends
ENDIF

END_TEXT segment word public 'CODE'
END_TEXT ends

DGROUP GROUP NULL,_DATA,CONST,_BSS,LAST_D,FAR_BSS
CGROUP GROUP _TEXT,END_TEXT

;**************
; Null Segment
;**************
NULL  SEGMENT

IFDEF @AVC103
       dd     AVC103hdr
ELSE
       dd     -1
ENDIF
       dw     0C880H              ; IDC, Char, IOCTL, Open/Close/RM, Out 'til busy
       dw     Offset _TEXT:_Strat1
       dw     Offset _TEXT:DDCMDEntryPoint
_audioname db 'AUDIO'             ; 1st part of device name
       public _audioname;
_midinum db   '0$ '               ; 2nd part of device name
       public _midinum;
       dw     4 dup (0)           ; reserved words

IFDEF @AVC103
; ACPA Compatibility device header
AVC103hdr equ $
       dd     -1
       dw     08880H              ; Char, IOCTL, Open/Close/RM, Out 'til busy
       dw     Offset _TEXT:AVC103_Strategy
       dw     -1
       db     'AVC_AUD$'          ; AVC 1.03 Compatibility device name
       dw     4 dup (0)           ; reserved words
ENDIF

NULL   ends

;***************
;* Data Segment
;***************
_DATA segment

__acrtused   dw     0             ; C .OBJ files want one.  They never use it.
      public __acrtused

pddname db 'AUDIO'                ; 1st part of pdd name
pddnum  db '0$ '                  ; 2nd part of pdd name
        db 0

IFDEF IS_FOX
_beg_fox2_text equ this dword
      public _beg_fox2_text
        dw 0
        dw seg FOX2_TEXT
ENDIF

      extrn _hostbase:word        ; MACPA base I/O port for this PDD.
      extrn _hostrnge:byte        ; Count of seq. ports from 'hostbase'.
      extrn  _os2_version:byte    ; OS/2 version number in AUDIODD.C
VDDAddress   df     0             ; Vaudio" routine addressed from PDDOpen
PDDOpened    dw     0             ; Zero until VDD opens PDD, then 1.
extrn _irqnum:word   ; temp

_trk          dw     0            ; denotes which device is used
       public _trk                ;  AUDIO1$ or AUDIO2$

_device_hlp    dd     0           ; Far pointer to device helper routine
       public _device_hlp         ;  for use in CDEVHLP.ASM

PrvIntMask    db     0
IntMask       db     0FFH
DevVectAddr   dw     0

_off_array         OFF_SYS_FILE_NUM <>
        public  _off_array
extrn _trk_array:word

_num_opens         dw 0           ; current number OPEN
        public  _num_opens
IFDEF TWO_TRACKS
_max_num_opens     dw 2           ; maximum number of OPENs allowed
ELSE
_max_num_opens     dw 1           ; maximum number of OPENs allowed
ENDIF
        public  _max_num_opens

NUM_GDTS        equ     8
_GDTSelector1  DW    0
_GDTSelector1b DW    0
_GDTSelector2  DW    0
_GDTSelector2b DW    0
_GDTSelector3  DW    0
_GDTSelector3b DW    0
_GDTSelector4  DW    0
_GDTSelector4b DW    0
       public _GDTSelector1,_GDTSelector2,_GDTSelector3,_GDTSelector4

_GDTxmitio    equ    this dword   ; GDTxmitio[]
GDTptr1a      DW     0
GDTsel1a      DW     0
GDTptr1b      DW     0
GDTsel1b      DW     0
_GDTrecio     equ    this dword   ; GDTrecio[]
GDTptr2a      DW     0
GDTsel2a      DW     0
GDTptr2b      DW     0
GDTsel2b      DW     0
_GDTxmitbuf   equ    this dword   ; GDTxmitbuf[]
GDTptr3a      DW     0
GDTsel3a      DW     0
GDTptr3b      DW     0
GDTsel3b      DW     0
_GDTrecbuf    equ    this dword   ; GDTrecbuf[]
GDTptr4a      DW     0
GDTsel4a      DW     0
GDTptr4b      DW     0
GDTsel4b      DW     0
       public  _GDTxmitio,_GDTrecio,_GDTxmitbuf,_GDTrecbuf

; ***** Dynamically allocated Selectors & Pointers for V86 Addresses.
NumUtils       equ     4                  ; Num of GDT Sel's to alloc.
_UtilGDTs      DW      NumUtils DUP(0)    ; Array of selectors.
               public  _UtilGDTs          ;
_UtilPtrs      DW      2*NumUtils DUP(0)  ; Array of pointers.
               public  _UtilPtrs          ;

IF @DEBUG
TestRow       DB     0
TestCol       DB     0
ENDIF

ifdef   PTRACE
;
; PTrace Public Data
;
        PUBLIC  PTrace_DevHlp, PTraceStruct

        PTrace_DevHlp   dd     0        ; pointer to devhelp routine
        PTraceStruct    db 40 DUP(00)   ; define structure
                                        ; PTrace Structure
                                        ;    MMIOBase32 DWORD( 0:32)
                                        ;    MMIOBase16 DWORD(16:16)
                                        ;    RAS_Table  BYTE:32
endif

_DATA   ends

;*************************
LAST_D       segment
      PUBLIC END_OF_DATA
END_OF_DATA   equ    $

wlen          dw     0
initcount     dw     0

LAST_D        ends

;*************************
; Code segment
;*************************
_TEXT   segment
        assume  CS:CGROUP,DS:DGROUP

       EXTRN  _Strategy_c:NEAR
IFDEF @AVC103
       EXTRN  _AVC103_strategy_c:near
ENDIF
IFDEF @K12
       EXTRN  _DevInt:NEAR,_DevInit:NEAR
ELSE
       EXTRN  _DevInt:NEAR,_TimerInt:NEAR,_DevInit:NEAR
ENDIF
       EXTRN  _DDCmdInternalEntryPoint:far
       EXTRN  _Get_Track:NEAR
       EXTRN  _GetHChVDM:NEAR

_Strat1 proc far
       public _Strat1
       push   si
       push   dx
       push   di
       call   _Get_Track
       pop    di
       pop    dx
       pop    si
       cmp    ax,-1
       jne    Strategy
       ret
_Strat1 endp

Strategy proc far
 public Strategy
       push   ax                                 ; Track ID (0 or 1)
       push   es                                 ; *rb
       push   bx

ifdef  PTRACE
       cmp     BYTE PTR es:[bx].RHcommand,0      ; CMDInit=00
       je      Init_Cmd                          ; init command
       jmp     Not_Init
Init_Cmd:
       push    ax
       mov     ax,word ptr es:[bx].InitDevHlp+2
       mov     word ptr [PTrace_DevHlp+2],ax
       mov     ax,word ptr es:[bx].InitDevHlp
       mov     word ptr [PTrace_DevHlp],ax
       .386
       Init_PTrace     PTraceStruct, PTrace_DevHlp
       .286p
       pop      ax
Not_Init:
endif
       call   _Strategy_c                        ; Call C strategy routine

       pop    bx
       pop    es
       add    sp,2                               ; Trash track ID
       ret
Strategy endp

;/********************* START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME:          DDCMDEntryPoint 's
;*
;* DESCRIPTIVE NAME: Entry point enabling ADSH to communicate with ACPA.
;*
;* FUNCTION: Calls DDCmdInternalEntryPoint, which will execute the DDCMD
;*           requested by ADSH.
;*
;* NOTES:    CX contains the value of StreamNumber and is saved in
;*           DDCMDEntryPoint, since DDCMDEntryPoint creates its own
;*           data segment, which is the data segment used for DDCMDs
;*
;*           DO NOT modify CX register at all during DDCMDEntryPoint1.
;*           It contains the stream number which is set or DDCMDEntryPoint1
;*           and DDCMDEntryPoint2.
;*
;*           DDCMDEntryPoint1 is called if the audio device opened is AUDIO1$
;*           DDCMDEntryPoint2 is called if the audio device opened is AUDIO2$
;*
;*           DDCMDEntryPoint sets the stream used as stream 0
;*
;*
;* ENTRY POINTS:     DDCMDEntryPoint()
;*     LINKAGE:      call far
;*
;* INPUT:        Pointer to command-dependent parameter structure.
;*
;* EFFECTS:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES:
;*
;*
;* MODIFICATION HISTORY:
;* DATE      DEVELOPER         CHANGE DESCRIPTION
;* 06/19/91  Brian Czako       File modified -- tagged with
;* 08/16/91  C. Dinallo        Remove EntryPoint1 and EntryPoint2
;*********************** END OF SPECIFICATIONS **********************/

DDCMDEntryPoint proc far
 public DDCMDEntryPoint

       push   bp
       mov    bp, sp

       push   ds                                 ; create own data segment
       mov    ax, DGROUP
       mov    ds, ax

;*****************************************************************************
; Do table lookup to find which track hstream is using, see FindTrackForStream()
;*****************************************************************************
       push   +8[bp]                             ; high address
       push   +6[bp]                             ; low address
                                                 ; +4[bp] has old CS register
       call   _DDCmdInternalEntryPoint

       add    sp, 4                              ; toss calling address

       pop    ds                                 ; restore registers ds, bp
       pop    bp
       ret

DDCMDEntryPoint      endp


IFDEF @AVC103
AVC103_Strategy proc far
 public AVC103_Strategy
       push   es
       push   bx
       call   _AVC103_strategy_c
       pop    bx
       pop    es
       ret
AVC103_Strategy endp
ENDIF

;*********************************************************************
; *** Dummy IDC procs to resolve LINK problems until actual code added
; These functions need to perform the following:
;  1. Free the returned IOBUF block (or buffer)
;  2. Ensure new IOBUF block has all its fields filled in:
;       size = size of data buffer
;       head = start of buffer
;       tail = end of buffer
;       count = size of data buffer
;       position copied from previous block!
;       delay copied from previous block!
;       runflags copied from previous block!
;       selinc = 4 (probably not used anyways)
;       buffer = start of buffer (virtual address)
;  3. Count should contain not just the amount of data in buffer, but
;     also the amount following it.  This seems weird, but the audiodd code
;     needs to know when it gets to the end of a buffer that more data is
;     available.  The easiest way to do this is to add the count field from
;     each block queued to the previous block's count field.  It shouldn't
;     be necessary to propogate the count more than 1 blocks' worth.
;  4. Call set_xhpi() or set_rhpi() with the new IOBUF block.  Note here
;     that if no data is available, a new block still needs to be passed,
;     with the count fields set to 0, or perhaps runflags restored to 0.
;     The easiest way is to restore the internal buffers using init_ptrs().
;  5. Return.  No return value is expected.
;
;_get_next_xbuf proc near                        ; get_next_xbuf(IOB oldblk);
;        public  _get_next_xbuf
;        ret
;_get_next_xbuf endp
;_get_next_rbuf proc near                        ; get_next_rbuf(IOB oldblk);
;        public  _get_next_rbuf
;        ret
;_get_next_rbuf endp
;*****************************************************************************


; This is a replacement for the C compiler's stack checking routine.
; It is declared as external by the compiler, but it should never be
; called as we compile with all stack probes removed.
__chkstk proc   near
        public  __chkstk
        pop     cx
        mov     bx,sp
        sub     bx,ax
        mov     sp,bx
        jmp     cx
__chkstk endp

_inp    proc    NEAR
        public  _inp
        push    bp
        mov     bp,sp
        mov     dx,+4[bp]
        in      al,dx
        sub     ah,ah
        pop     bp
        ret
_inp    endp

_inpw   proc    NEAR
        public  _inpw
        push    bp
        mov     bp,sp
        mov     dx,+4[bp]
        in      ax,dx
        pop     bp
        ret
_inpw   endp

_outp   proc    NEAR                             ; outp(addr,byte);
        public  _outp
        push    bp
        mov     bp,sp
        mov     dx,+4[bp]
        mov     al,+6[bp]
        out     dx,al
        pop     bp
        ret
_outp   endp

_outpw  proc    NEAR                             ; outpw(addr,word);
        public  _outpw
        push    bp
        mov     bp,sp
        mov     dx,+4[bp]
        mov     ax,+6[bp]
        out     dx,ax
        pop     bp
        ret
_outpw  endp

_TestMsg proc near
        public  _TestMsg
        ret
_TestMsg endp

;*************************************************
;* DEBUG test routines (works in real mode only!)
;*************************************************
IF @DEBUG
_TestMsg proc NEAR                               ; testmsg(char *msg);
       public _TestMsg
       smsw   ax                                 ; get current msw
       rcr    ax,1                               ; Protect bit into C
       jnc    is_realmode                        ; Return if not real mode
       ret                                       ; Return if protect mode
is_realmode:
       push   bp
       mov    bp,sp
       mov    bp,+4[bp]                          ; Message must be 16 bytes long!
       push   es
       mov    ax,ds
       mov    es,ax
       mov    AH,19
       mov    AL,1
       mov    cx,16
       mov    DH,TestRow
       mov    DL,TestCol
       inc    TestRow
       cmp    DH,24
       jb     TestMsg_ROK
       mov    TestRow,0
       add    TestCol,10
       cmp    TestCol,70
       jb     TestMsg_ROK
       mov    TestCol,0
TestMsg_ROK:
       mov    BH,0
       mov    BL,7
       int    10H
       pop     es
       pop    bp
       ret
_TestMsg endp
ENDIF

_Block  PROC    near                             ; void Block(long id,long timelimit,int enbld);
      public _Block
        push    bp
        mov     bp,sp
        push    di
        mov     bx,+4[bp]                        ; ID low
        mov     ax,+6[bp]                        ; ID high
        mov     di,+10[bp]                       ; time limit high
        mov     cx,+8[bp]                        ; time limit low (millisec's)
        mov     DH,+10[bp]                       ; interruptible flag
        mov     dl,DevHlp_Block
        call    dword ptr _device_hlp
        pop     di
        pop     bp
_Block  endp

_SetIRQ PROC  near                               ; SetIRQ(intlvl,shared,intproc)
      public  _SetIRQ
       push   bp
       mov    bp,sp
       mov    bx,+4[bp]                          ; intlvl
       mov    dh,+6[bp]                          ; shared
       mov    ax,+8[bp]                          ; intproc
       mov    dl,DevHlp_SetIRQ
       call   dword ptr _device_hlp
       jc     SIRQ_err1
       sub    ax,ax                              ; Return 0
       pop    bp
       ret
SIRQ_err1:
       mov     ax,-1                             ; Return error -1
       pop     bp
       ret
_SetIRQ ENDP

_UnSetIRQ PROC  near                             ; UnSetIRQ(intlvl)
      public  _UnSetIRQ
        push    bp
        mov     bp,sp
        mov     bx,+4[bp]                        ; intlvl
        mov     dl,DevHlp_UnSetIRQ
        call    dword ptr _device_hlp
        jc      USIRQ_err1
        sub     ax,ax                            ; Return 0
        pop     bp
        ret
USIRQ_err1:
        mov     ax,-1                            ; Return error -1
        pop     bp
        ret
_UnSetIRQ ENDP

_eoi proc near                                   ; eoi(irqnum)
      public  _eoi
        cli
        push    bp
        mov     bp,sp
        mov     al,+4[bp]                        ; IRQ number
        mov     dl,DevHlp_EOI
        call    dword ptr _device_hlp
        jc      EOIerr
        sub     ax,ax
        pop     bp
        ret
EOIerr:
        mov     ax,-1
        pop     bp
        ret
_eoi endp

_PhysToUVirt PROC       NEAR    ; char far *PhysToUVirt(char far *addr,type,count)
      public  _PhysToUVirt
        push    bp
        mov     bp,sp
        push    es
        mov     bx,+4[bp]                        ; addr low
        mov     ax,+6[bp]                        ; addr high
        mov     cx,+10[bp]                       ; count
        mov     dh,+8[bp]                        ; type 0=get read/exec, 1=get read/write, 2=free
        mov     dl,DevHlp_PhysToUVirt
        call    dword ptr _device_hlp
        jc      P2UVerr
        mov     dx,es                            ; Return pointer in DX:AX
        mov     ax,bx
        pop     es
        pop     bp
        ret
P2UVerr:
        sub     dx,dx                            ; Return 0 if error
        sub     ax,ax
        pop     es
        pop     bp
        ret
_PhysToUVirt ENDP

_PhysToVirt PROC        NEAR    ; char far *PhysToVirt(char far *addr,count)
      public  _PhysToVirt
        push    bp
        mov     bp,sp
        push    es
        push    di
        mov     bx,+4[bp]                        ; addr low
        mov     ax,+6[bp]                        ; addr high
        mov     cx,+8[bp]                        ; count
        mov     dh,1                             ; leave result in ES:DI (0=DS:SI, 1=ES:DI)
        mov     dl,DevHlp_PhysToVirt
        call    dword ptr _device_hlp
        jc      P2Verr
        mov     dx,es                            ; Return pointer in DX:AX
        mov     ax,di
        pop     di
        pop     es
        pop     bp
        ret
P2Verr:
        sub     dx,dx                            ; Return 0 if error
        sub     ax,ax
        pop     di
        pop     es
        pop     bp
        ret
_PhysToVirt ENDP

_UnPhysToVirt PROC      NEAR                     ; int UnPhysToVirt(void);
      public  _UnPhysToVirt
        push    es
        mov     dl,DevHlp_UnPhysToVirt
        call    dword ptr _device_hlp
        jnz     UPTVswitch                       ; Did a switch occur?
        sub     ax,ax                            ; If not, return 0
        pop     es
        ret
UPTVswitch:                                      ; If so, return -1
        mov     ax,-1
        pop     es
        ret
_UnPhysToVirt ENDP

_RealToProt PROC     NEAR                        ; void RealToProt(void);
       public _RealToProt
       mov    dl,DevHlp_RealToProt
       call    dword ptr _device_hlp
       jc      RTPnoswitch                       ; Did a switch occur?
       sub     ax,ax                             ; If not, return 0
       ret
RTPnoswitch:                                     ; If so, return -1
       mov     ax,-1
       ret
_RealToProt ENDP

_ProtToReal PROC     NEAR                        ; void ProtToReal(void);
       public _ProtToReal
       mov    dl,DevHlp_ProtToReal
       call    dword ptr _device_hlp
       jc      PTRnoswitch                       ; Did a switch occur?
       sub     ax,ax                             ; If not, return 0
       ret
PTRnoswitch:                                     ; If so, return -1
       mov     ax,-1
       ret
_ProtToReal ENDP

_VirtToPhys PROC        NEAR    ; char far *VirtToPhys(char far *addr);
      public  _VirtToPhys
        push    bp
        mov     bp,sp
        push    ds
      push   es
        push    si
      mov    ax,ds
      mov    es,ax
        mov     si,+4[bp]                        ; addr low
        mov     ds,+6[bp]                        ; addr high
        mov     dl,DevHlp_VirtToPhys
        call    dword ptr es:_device_hlp
        jc      V2Perr
        mov     dx,ax                            ; Return pointer in DX:AX
        mov     ax,bx
        pop     si
        pop    es
        pop     ds
        pop     bp
        ret
V2Perr:
        sub     dx,dx                            ; Return 0 if error
        sub     ax,ax
        pop     si
        pop    es
        pop     ds
        pop     bp
        ret
_VirtToPhys ENDP

_VerifyAccess PROC      NEAR    ; int VerifyAccess(char far *addr,int len,wflag);
      public  _VerifyAccess
        push    bp
        mov     bp,sp
        push    di
        mov     di,+4[bp]                        ; offset
        mov     ax,+6[bp]                        ; selector or segment
        mov     cx,+8[bp]                        ; length
        mov     dh,+10[bp]                       ; write flag (0 if read, 1 if r/w)
        mov     dl,DevHlp_VerifyAccess
        call    dword ptr _device_hlp
        jc      VAerr
        sub     ax,ax                            ; Return 0 if ok
        pop     di
        pop     bp
        ret
VAerr:
        mov     ax,-1                            ; Return -1 if error
        pop     di
        pop     bp
        ret
_VerifyAccess ENDP

_Lock   PROC    NEAR            ; long Lock(char far *addr,int type, int nowait);
      public  _Lock
        push    bp
        mov     bp,sp
        mov     ax,+6[bp]                        ; segment
        mov     bh,+8[bp]                        ; type (0=short-term, any memory)
        mov     bl,+10[bp]                       ; nowait flag
        mov     dl,DevHlp_Lock
        call    dword ptr _device_hlp
      jc     Lockerr
        mov     dx,ax                            ; Return lock handle
        mov     ax,bx
        pop     bp
        ret
Lockerr:                                         ; Error, return 0
      sub    dx,dx
      sub    ax,ax
      pop    bp
      ret
_Lock   ENDP

_Unlock PROC    NEAR                             ; void Unlock(long lockhandle);
      public  _Unlock
        push    bp
        mov     bp,sp
        mov     bx,+4[bp]                        ; Lock handle low
        mov     ax,+6[bp]                        ;       "       high
        mov     dl,DevHlp_Unlock
        call    dword ptr _device_hlp
        jc      ULerr
        sub     ax,ax                            ; Return 0 = no errors
        pop     bp
        ret
ULerr:
        mov     ax,-1                            ; Return error
        pop     bp
        ret
_Unlock ENDP

_SemHandle PROC NEAR                    ; long SemHandle(long key,char usage);
      public  _SemHandle
        push    bp
        mov     bp,sp
        mov     bx,+4[bp]                        ; key low
        mov     ax,+6[bp]                        ; key high
        mov     dh,+8[bp]                        ; usage flag
        mov     dl,DevHlp_SemHandle
        call    dword ptr _device_hlp
        jc      SHerr
        mov     dx,ax
        mov     ax,bx
        pop     bp
        ret
SHerr:
        sub     dx,dx
        sub     ax,ax
        pop     bp
        ret
_SemHandle ENDP

_SemClear PROC  NEAR                             ; int SemClear(long handle);
      public  _SemClear
        push    bp
        mov     bp,sp
        mov     bx,+4[bp]                        ; handle low
        mov     ax,+6[bp]                        ; handle high
        mov     dl,DevHlp_SemClear
        call    dword ptr _device_hlp
        jc      SCerr
        sub     ax,ax
        pop     bp
        ret
SCerr:
        pop     bp
        ret
_SemClear ENDP

_DevHlp_Run PROC  NEAR                           ; int DevHlp_Run(long handle);
      public  _DevHlp_Run
        push    bp
        mov     bp,sp
        mov     bx,+4[bp]                        ; handle low
        mov     ax,+6[bp]                        ; handle high
        mov     dl,DevHlp_Run
        call    dword ptr _device_hlp
        jc      RUNerr
        sub     ax,ax
        pop     bp
        ret
RUNerr:
        pop     bp
        ret
_DevHlp_Run ENDP

_AllocGDTSelector PROC NEAR           ; AllocGDTSelector(far *array, int count)
      public _AllocGDTSelector
      push   bp
      mov    bp,sp
      push   es
      push   di
      les    di,+4[bp]                           ; Address of array into ES:DI
      mov    cx,+8[bp]                           ; # selectors requested into CX
      mov    dl,DevHlp_AllocGDTSelector
      call   dword ptr _device_hlp
      jc     AGDTerr
      sub    ax,ax
      pop    di
      pop    es
      pop    bp
      ret
AGDTerr:
      mov    ax,-1
      pop    di
      pop    es
      pop    bp
      ret
_AllocGDTSelector ENDP

_PhysToGDTSelector PROC NEAR       ; int PhysToGDTSelector(*data,len,selector)
       public _PhysToGDTSelector
       push   bp
       mov    bp,sp
       sub    sp,2                               ; Set up temp variable
       push   si
       mov    byte ptr [bp-2],0                  ; Zero temp var

       smsw   ax                                 ; get current msw
       rcr    ax,1                               ; Protect bit into C
       jc     ptg_is_protmode                    ; Skip if protect mode
       mov    byte ptr [bp-2],1                  ; Remember that we were in real mode
       call   _RealToProt                        ; Switch to protect mode
ptg_is_protmode:                                 ;
       mov    bx,+4[bp]                          ; AX:BX = *data
       mov    ax,+6[bp]
       mov    cx,+8[bp]                          ; CX = length
       mov    si,+10[bp]                         ; SI = selector
       mov    dl,DevHlp_PhysToGDTSelector
       call   dword ptr _device_hlp
       jc     PTGDTerr
       sub    ax,ax
PTGDTerr:
       test   byte ptr [bp-2],1                  ; were we in real mode?
       jz     ptg_not_protmode
       call   _ProtToReal
ptg_not_protmode:
       pop    si
       add    sp,2
       pop    bp
       ret
_PhysToGDTSelector ENDP

_AllocPhys PROC NEAR                         ; AllocPhys(long size,int lowflag)
       public _AllocPhys
       push   bp
       mov    bp,sp
       mov    bx,+4[bp]                          ; Size in AX:BX
       mov    ax,+6[bp]
       mov    dh,+8[bp]                          ; <1m flag in DH
       mov    dl,DevHlp_AllocPhys
       call   dword ptr _device_hlp
       jc     APerr
       mov    dx,ax                              ; Return 32 bit address in DX:AX
       mov    ax,bx
       pop    bp
       ret
APerr:
       sub    dx,dx                              ; Error, return 0
       sub    ax,ax
       pop    bp
       ret
_AllocPhys ENDP

_GetDOSVar PROC NEAR                             ; Get address of kernel variable
      public _GetDOSVar
      push   bp
      mov    bp,sp
      mov    al,+4[bp]                           ; variable wanted
      mov    dl,DevHlp_GetDOSVar
      call   dword ptr _device_hlp
      jc     GDVerr
      mov    dx,ax                               ; Return 32 bit address in DX:AX
      mov    ax,bx
      pop    bp
      ret
GDVerr:
       sub    dx,dx                              ; Error, return 0
       sub    ax,ax
       pop    bp
       ret
_GetDOSVar ENDP

_FreePhys PROC NEAR                              ; FreePhys(void far *phys)
       public _FreePhys
       push   bp
       mov    bp,sp
       mov    bx,+4[bp]                          ; Physical address in AX:BX
       mov    ax,+6[bp]
       mov    dl,DevHlp_FreePhys
       call   dword ptr _device_hlp
       jc     FPerr
       sub    ax,ax                              ; Return 0 ok
       pop    bp
       ret
FPerr:
       mov    ax,-1                              ; Error, return -1
       pop    bp
       ret
_FreePhys ENDP


_AttachDD PROC NEAR                     ; AttachDD(char *ddname, char *ddaddr)
      public _AttachDD
      push   bp
      mov    bp,sp
      push   bx
      push   di
      push   dx

      mov    bx,+4[bp]                           ; ddname offset
      mov    di,+6[bp]                           ; ddaddr offset
      mov    dl,DevHlp_AttachDD
      call   dword ptr _device_hlp
      jc     ATTerr
      sub    ax,ax                               ; All OK, return 0
      jmp    ATTexit
ATTerr:
      mov    ax,-1                               ; Error, return -1
ATTexit:
      pop    dx
      pop    di
      pop    bx
      pop    bp
      ret
_AttachDD ENDP



_GetPageList PROC NEAR            ; GetPageList(ULONG linaddr, ULONG bytes,
                                  ;             ULONG lplistaddr)
      public _GetPageList
      .386
      push   bp
      mov    bp,sp
      push   ecx
      push   edi
      push   eax

      mov    eax,+4[bp]                          ; linear address of data
      mov    ecx,+8[bp]                          ; number of bytes
      mov    edi,+12[bp]                         ; linear address of lplistaddr
      mov    dl,DevHlp_LinToPageList
      call   dword ptr _device_hlp               ; eax contains no. of elements
      mov    edi,eax                             ; get count
      pop    eax
      jc     GPLerr                              ; jump on error

;     Number of elements in PageList array dx:ax(Hi:Lo).
      mov    ax,di                               ; Lo --> ax
      ror    edi,16                              ; get hi
      mov    dx,di                               ; Hi --> dx.
      jmp    GPLret

GPLerr:
      sub    dx,dx                               ; Return 0 if error
      sub    ax,ax

GPLret:
      pop    edi
      pop    ecx
      pop    bp
      .286p
      ret
_GetPageList ENDP

_VirtToLin  PROC        NEAR    ; char far *VirtToLin(char far *addr);
      public  _VirtToLin
        push    bp
        mov     bp,sp
        .386
        push    esi
        push    eax
        sub     esi,esi                          ; Clear esi.
        mov     si,Word Ptr +4[bp]               ; Offset --> esi
        mov     ax,+6[bp]                        ; Selector --> ax
        mov     dl,DevHlp_VirtToLin
        call    dword ptr _device_hlp            ; Returns lin. addr in eax
        mov     esi,eax
        pop     eax
        jc      V2Lerr
        mov     ax,si                            ; Lo --> ax
        ror     esi,16
        mov     dx,si                            ; Hi --> dx.
;       Linear address in dx:ax(Hi:Lo).
        jmp     V2Lret
V2Lerr:
        sub     dx,dx                            ; Return 0 if error
        sub     ax,ax
V2Lret:
        pop     esi
        .286p
        pop     bp
        ret
_VirtToLin  ENDP


_LinToGDTSelector  PROC   NEAR
; char far *LinToGDTSelector(char far *addr,count,sel)
;    ************************ modified *wb* ***********************************
;    *    Map V86 linear address to specified UtilGDTs selector.              *
;    *    (Simultaneously maps UtilPtrs using same selector).                 *
;    *    Note: NO LDT IN V86 Mode.                                           *
;    **************************************************************************
        public  _LinToGDTSelector
        push    bp
        mov     bp,sp
        .386
        push    dx
        push    ecx
        push    ebx
        mov     ebx, DWORD PTR +4[bp]            ; Linear address --> ebx.
        movzx   ecx, WORD PTR +8[bp]             ; Count --> ecx.
        mov     ax, WORD PTR +10[bp]             ; Selector -> ax.
        mov     dl, DevHlp_LinToGDTSelector      ; Map lin. addr to GDT.
        call    dword ptr _device_hlp            ; Returns lin. addr in eax
        jc      L2Gerr
        sub     ax,ax                            ; ax=0 ==> No error.
        jmp     L2Gret
L2Gerr:
        mov     ax,-1                            ; Set Error retun.
L2Gret:
        pop     ebx
        pop     ecx
        .286p
        pop     dx
        pop     bp
        ret
_LinToGDTSelector ENDP

;    **************************************************************************
;    *    "_LnLock":                                                          *
;    *    VMLock a V86 linear address, not physically contiguous, short term, *
;    *    no page list returned.  Returns 0 if error, else flat pointer to    *
;    *    lock handle to be used for VMUnlock.                                *
;    **************************************************************************
_LnLock PROC Near
; ULONG LnLock(ULONG linear_address, ULONG length)
        public  _LnLock
        push    bp
        mov     bp,sp
        .386
        push    ecx                              ; Save regs.
        push    ebx
        push    esi
        push    edi
        push    edx
; ***************  Allocate linear space for the Lock Handle *******************
        mov     eax,0                            ; Flags: Global address range
        mov     ecx,12                           ; 12 bytes for VMLock handle.
        mov     edi,0FFFFFFFFH                   ; Don't store physical address
        mov     dl, DevHlp_VMAlloc               ; Allocate 12 bytes for VMLock handle.
        call    dword ptr _device_hlp            ; Returns lin. addr in eax
        mov     esi,eax                          ; Save lock handle address in esi.
        mov     eax,0                            ; Anticipate VMAlloc error.
        jc      LnLexit                          ; Jump if error.
; *********************  Lock the buffer.  *************************************
        mov     ebx,DWORD PTR +4[bp]             ; Linear address --> ebx.
        mov     edx,ebx                          ; Save the address in edx.
        and     bx,0f000h                        ; Truncate ebx to page boundary.
        sub     edx,ebx                          ; Get buffer offset into page.
        mov     ecx,Dword PTR +8[bp]             ; Buffer length --> ecx.
        add     ecx,edx                          ; Add buffer offset to size.
        mov     edi, -1                          ; Don't return physical addresses
        mov     eax,0000001CH                    ; Long; Wait; noncontig., <16Meg, dirty, quick.
        mov     dl, DevHlp_VMLock                ; Lock & make physically contiguous.
        call    dword ptr _device_hlp            ; Returns nothing since edi is -1.
        mov     eax,esi                          ; Lock handle linear address --> eax.
        jnc     LnLexit                          ; Jump if no error.
; ************  If Lock error, free the handle space.     **********************
        mov     dl,DevHlp_VMFree                 ; Free the lock handle space.
        call    dword ptr _device_hlp            ;
        mov     eax,0                            ; Zero, indicating error, -->eax.
; **** If lock successful, eax contains handle address, otherwise zero.     ****
LnLexit:
        pop     edx
        ror     eax,16                           ; Handle high order
        mov     dx,ax                            ;   word --> dx.
        ror     eax,16                           ; Low order word --> ax.
        pop     edi
        pop     esi
        pop     ebx
        pop     ecx
        .286p
        pop     bp                               ; Restore caller's base pointer.
        ret
_LnLock ENDP

;    **************************************************************************
;    *    "_LnUnlock":                                                        *
;    *    VMUnlock the linear address space represented by the lock handle    *
;    *    passed. On return, ax=0 if no error.                            @VDD*
;    **************************************************************************
_LnUnlock PROC Near
; USHORT LnUnlock(ULONG lock_handle)
        public  _LnUnlock
        push    bp
        mov     bp,sp
        .386
        push    esi                              ; Save regs.
        push    edx
        mov     esi, DWORD PTR +4[bp]            ; Lock handle --> esi.
        mov     dl, DevHlp_VMUnlock              ; Address of lock handle still in esi.
        call    dword ptr _device_hlp            ;
        jc      LnUexit                          ; eax has error code.
        mov     ax,0                             ; Set "no error" in ax.
LnUexit:
        pop     edx
        pop     esi
        .286p
        pop     bp                               ; Restore caller's base pointer.
        ret
_LnUnlock  ENDP


;**************************************************************************
;*    "VDDEntry"--Entry point for calls from "VAUDIO", the Audio virtual  *
;*    device driver, to Physical Device driver.  The first entry comes at *
;*    VDHOpenPDD time, when the VDD entry point is passed.                *
;*           Stack @ Entry:  Return address(4 words)                      *
;*                           Variable 2    (2 words)  Specified per       *
;*                           Variable 1    (2 words)    function. .       *
;*                           Function Code (2 words)                      *
;*                                                                        *
;*                  If func = 0  (Register)                               *
;*                           v2_lo      = low 16 bits of VDD entry pt.    *
;*                           v2_hi      = high 16 bits of VDD entry pt.   *
;*                           v1_hi      = 0                               *
;*                           v1_lo      = VDD's CODE segment.             *
;*                  If func = 1  (Get MACPA base port address & range).   *
;*                           v2_lo      = low 16 bits of VDD data offset. *
;*                           v2_hi      = high 16 bits of VDD data offset.*
;*                           v1_hi      = 0                               *
;*                           v1_lo      = VDD's DATA segment              *
;*                  If func = 2  (Get hVDM of ClaimHdwre owner if any).   *
;*                           v1- v2- parms not used.                      *
;*                           hVDM or NULL returned in eax.                *
;**************************************************************************
v2_lo  equ    10
v2_hi  equ    12
v1_lo  equ    14
v1_hi  equ    16
func   equ    18

VDDEntry PROC  FAR
       push   bp                                 ; Set up
       mov    bp,sp                              ;  stack frame.
       push   ds                                 ; Save ds
       mov    ax,_DATA                           ; Set up _DATA
       mov    ds,ax                              ;   as DS.
       .386
       cmp    dword ptr[bp+func],1               ; Check function for get 'hostbase'.
       .286p
       je     vddGetBase                         ; Jump if function = get 'hostbase'.
       ja     vddentry1                          ; Jump, test for other functions.

;*****  Otherwise function is 0, initialize. ******************************

       mov    ax,[bp+v1_lo]                      ; VDD CS
       mov    word ptr VDDAddress+4,ax
       mov    ax,[bp+v2_lo]                      ; VDD 32-bit offset low.
       mov    word ptr VDDAddress,ax
       mov    ax,[bp+v2_hi]                      ; VDD 32-bit offset hight.
       mov    word ptr VDDAddress+2,ax
       jmp    vddgood

;***** function 1: Get MACPA hostbase and range variables for VDD use. ****
vddGetBase:
       push   es                                 ; Save
       .386
       push   eax                                ; Save.
       push   ebx                                ; Save.
       mov    ax,[bp+v2_lo]                      ; VDD Data segment
       mov    es,ax                              ;  ----> es.
       mov    ebx,[bp+v1_lo]                     ; VDD hostbase offset --> ebx.
       mov    al,_hostrnge                       ; Range of ports used by DD -->al,
       mov    es:[ebx], al                       ;   ---->VDD data location
       inc    ebx                                ; Bump ebx to VDD's 'hostbase' data loc.
       mov    ax, _hostbase                      ; Value of hostbase --> ax.
       mov    es:[ebx], ax                       ;   ---->VDD data location
       pop    ebx                                ; Restore.
       pop    eax                                ; Restore.
       .286p
       pop    es                                 ; Restore.
       jmp    vddexit

vddentry1:
       .386
       cmp    dword ptr[bp+func],3               ; Check func.= Get hVDM of hardware ownr
       jae    vddbad                             ; Jump if function out of range.

;***** function 2: Get hVDM of ClaimHdwr owner, if any.   *****************
       push   bx                                 ; Save
       push   cx                                 ;   registers
       push   si                                 ;     for "C"
       push   di                                 ;       call.
       call   _GetHChVDM                         ; Call audiodd.c func to get VDM handle.
       pop    di                                 ; Restore
       pop    si                                 ;   saved
       pop    cx                                 ;     registers
       pop    bx                                 ;        ....
       ror    eax,16                             ; Save low order word of handle.
       mov    ax,dx                              ; Put high order word of handle in eax.
       ror    eax,16                             ; Put hi/low words of handle in order.
       .286p
       jmp    vddexit

; **** 'vddbad'-- Default case (invalid parameter).  Set bad return value.
vddbad:
       mov    ax,0
       jmp    vddexit
;************ 'vddgood'- Good exit.
vddgood:
       mov    PDDOpened,1                        ; Set ind. that VDD has opened PDD.
       mov    ax,1
;************ 'vddexit' -- 32 bit return.
vddexit:
       pop    ds                                 ; Restore
       pop    bp                                 ;    saved regs
       db     66h
       ret    12
VDDEntry endp


;**************************************************************************
;*  "_HVDM"--- Call VDD to get Handle to the VDM of the current process.  *
;*             Returns HVDM if successful, else 0.                        *
;*             ULONG  HVDM(void)                                          *
;**************************************************************************
_Get_HVDM   PROC   near
        public _Get_HVDM
        nop                                      ; Space for int 3 for debug
        push   es                                ; Save
        push   bx                                ;   Regs.
        cmp    PDDOpened,0                       ; Make sure VDD has Opened PDD.
        jne    hvdm01                            ; Jump if it has.
        sub    ax,ax                             ; Otherwise set up to return
        mov    dx,ax                             ;   NULL VDM handle to caller.
        jmp    hvdmxt
hvdm01:
        push   2                                 ; Request Local Info Seg Pointer.
        call   _GetDOSVar                        ; Pointer in dx:ax
        add    sp,2                              ; Account for stack argument.
        mov    bx,ax                             ; A(Local Info Seg)
        mov    es,dx                             ;   --> es:bx.
        or     ax,dx                             ; Make sure it wasn't zero.
        jz     hvdmxt                            ; Jump if it was.
        les    bx,es:[bx]                        ; local Info Seg:offset ->es:bx.
        .386                                     ;
        push   eax                               ; Save register.
        mov    bx, es:[bx]                       ; Get process ID from Loc Info.
        mov    eax,2                             ; PDDEntry func=2=>Get HVDM
        call   FWORD PTR [VDDAddress]            ; VDM Handle --> eax.
        mov    bx,ax                             ; Save lo order handle bits in bx.
        ror    eax,16                            ; High order
        mov    dx,ax                             ;   bits --> dx.
        pop    eax                               ; Restore saved eax.
        mov    ax,bx                             ; Get lo order handle bits from bx.
        .286p
hvdmxt:
        pop    bx                                ; Restore saved ebx.
        pop    es                                ; Restore saved es.
        ret
_Get_HVDM   ENDP

;**************************************************************************
;* "_VirtCallBack"-- Call VDD to schedule Task Time Callback.             *
;*             void VirtCallBack(ULONG vcbhndl, ULONG hvdm)               *
;*  pass VCB handle to VDD in ebx, HVDM in edx.  Function = 1 -->eax.     *
;**************************************************************************
_VirtCallBack PROC near
        public _VirtCallBack
        cmp    PDDOpened,0                        ; Make sure VDD has Opened PDD.
        je     vcbxt                              ; Jump if it has; Just return.
        push   bp
        mov    bp,sp
        .386                                      ;
        push   ebx                                ;  Save regs
        push   edx                                ;   for VDD arguments.
        mov    ebx, dword ptr 4[bp]               ; VCB Handle-->ebx.
        mov    edx, dword ptr 8[bp]               ; VDM Handle-->edx.
        push   eax                                ; Save eax.
        mov    eax,1                              ; PDDEntry func=1=>Virt Callback.
        call   FWORD PTR [VDDAddress]             ; Schedule the call back.
        pop    eax                                ; Restore
        pop    edx                                ;   saved
        pop    ebx                                ;     regs.
        .286p
        pop    bp
vcbxt:
        ret
_VirtCallBack ENDP

;**************************************************************************
;* "_GetVCB_Hndl"-- Call VDD to get Virtual Callback Handle.              *
;*             Returns VCB_Hndl if successful, else 0.                    *
;*             ULONG  GetVCB_Hndl(void(far *cbfunc)(void), ULONG hvdm)    *
;*  pass A(cb function) to VDD in ebx, HVDM in edx.  Function = 3 -->eax. *
;**************************************************************************
_GetVCB_Hndl PROC near
        public _GetVCB_Hndl
        cmp    PDDOpened,0                        ; Make sure VDD has Opened PDD.
        jne    gvcb01                             ; Jump if it has.
        sub    ax,ax                              ; Otherwise set up to return
        mov    dx,ax                              ;   NULL VCB handle to caller.
        jmp    gvcbxt
gvcb01:
        push   bp
        mov    bp,sp
        .386                                      ;
        push   ebx                                ;  Save regs
        push   edx                                ;   for VDD arguments.
        mov    ebx, dword ptr 4[bp]               ; A(Callback function)-->ebx.
        mov    edx, dword ptr 8[bp]               ; VDM Handle-->edx.
        push   eax                                ; Save eax.
        mov    eax,3                              ; PDDEntry func=3=>Get CB Hndl.
        call   FWORD PTR [VDDAddress]             ; Callback Handle --> eax.
        mov    bx,ax                              ; Save lo order handle bits in bx.
        pop    edx                                ; Restore saved edx.
        ror    eax,16                             ; High order eax(handle)
        mov    dx,ax                              ;   bits --> dx.
        pop    eax                                ; Restore saved eax.
        mov    ax,bx                              ; Get lo order handle bits from bx.
        pop    ebx
        .286p
        pop    bp
gvcbxt:
        ret
_GetVCB_Hndl ENDP



;**************************************************************************
;* "_FreeVCB_Hndl"-- Call VDD to Free Virtual Callback Handle.            *
;*             void FreeVCB_Hndl( ULONG vcbhndl)                          *
;*  pass A(cb function) to VDD in ebx,   Function = 4 --> eax.            *
;**************************************************************************
_FreeVCB_Hndl PROC near
        public _FreeVCB_Hndl
        cmp    PDDOpened,0                       ; Make sure VDD has Opened PDD.
        je     fvcbxt
        push   bp
        mov    bp,sp
        .386                                     ;
        push   ebx                               ;  Save regs
        mov    ebx, dword ptr 4[bp]              ; A(Callback function)-->ebx.
        push   eax                               ; Save eax.
        mov    eax,4                             ; PDDEntry func=4=>Free CB Hndl.
        call   FWORD PTR [VDDAddress]            ; Free the Handle.
        pop    eax                               ; Restore saved eax
        pop    ebx                               ;   and esi.
        .286p
        pop    bp
fvcbxt:
        ret
_FreeVCB_Hndl ENDP

;*****************************************
; Hook Device Interrupt   GetDevInt(IRQ#)
;    (IRQ# is only valid for 2-7)
;*****************************************
_GetDevInt proc near
       public _GetDevInt

       push   bp
       mov    bp,sp
       push   es
                                                 ; SetIRQ(intlvl,shared,intproc)
       push   offset _TEXT:DevInt ; Device Proc
       push   0                                  ; Not shared
       mov    ax,+4[bp]                          ; Vector # (2-7)
       mov    DevVectAddr,ax                     ; Save it for later
       push   ax                                 ; int lvl
       call   _SetIRQ
       add    sp,6                               ; restore stack

       cmp    ax,0                               ; Did we get it ok?
       je     GDI_ok
                                                 ; If not, retry 'sharable'
       push   offset _TEXT:DevInt ; Device Proc
       push   1                                  ; Sharable
       push   word ptr +4[bp]                    ; Vector # (2-7)
       call   _SetIRQ
       add    sp,6                               ; restore stack

GDI_ok:
       pop    es                                 ; Return AX as-is (0 or -1)
       pop    bp
       ret
_GetDevInt endp

;************************
;* Free Device Interrupt
;************************
_FreeDevInt proc near
       public  _FreeDevInt

       cli

       push   word ptr DevVectAddr               ; intlvl
       call   _UnSetIRQ
       add    sp,2

       sti

       ret
_FreeDevInt endp

IFDEF @K12
ELSE
;***************************************
; Get Timer Interrupt     GetTimerInt()
;***************************************
_GetTimerInt proc near
       public _GetTimerInt

       mov    ax,offset _TEXT:TimerInt
       mov    dl,DevHlp_SetTimer
       call   dword ptr _device_hlp
       jc     GTerr
       sub    ax,ax                              ; Return 0 ok
       ret
GTerr:
       mov    ax,-1                              ; Return -1 error
       ret
_GetTimerInt endp

;*****************************************
;* Free Timer Interrupt    FreeTimerInt()
;*****************************************
_FreeTimerInt proc near
        public  _FreeTimerInt

       mov    ax,offset _TEXT:TimerInt
       mov    dl,DevHlp_ResetTimer
       call   dword ptr _device_hlp
       jc     FTerr
       sub    ax,ax                              ; Return 0 ok
       ret
FTerr:
       mov    ax,-1                              ; Return -1 error
       ret
_FreeTimerInt endp
ENDIF

;****************************************************************************
;                       Device Interrupt Handler
; This routine is invoked by the device interrupt.
; It will call the C language interrupt handler _DevInt()
;****************************************************************************

DevInt proc     far
        public  DevInt
ifdef   PTRACE
       .386
       push bx
       push si
       lea  si,_midinum
       mov  bx,WORD PTR [si]
       and  bx,000Fh
       Start_PTrace     ADSH_MAJOR,ADSH_ACPADevIntEntry,PTraceStruct,<bx>
       pop si
       pop bx
       .286p
endif

       call   _DevInt                            ; Call C interrupt handler

ifdef   PTRACE
        .386
       push bx
       push si
       lea  si,_midinum
       mov  bx,WORD PTR [si]
       and  bx,000Fh
        Stop_PTrace     ADSH_MAJOR,ADSH_ACPADevIntExit,PTraceStruct,<bx>
       pop si
       pop bx
        .286p
endif

       MOV    AH,0
       SUB    AH,AL                              ; Was 0 returned?

       RET                                       ; If so, return C cleared, else C set
DevInt endp

IFDEF @K12
ELSE
;****************************************************************************
;                       Timer Interrupt Handler
; This routine is invoked by the timer interrupt.
; It will call the C language interrupt handler _TimerInt()
;****************************************************************************

TimerInt proc far
       pusha                                     ; Save all regs
       push   es
       push   ds
       call   _TimerInt                          ; Call C Timer Interrupt handler (near)
       pop    ds
       pop    es
       popa
       ret                                       ; If so, return C cleared, else C set
TimerInt endp
ENDIF

_ReportPTraceError      PROC    NEAR
        public  _ReportPTraceError
ifdef   PTRACE
        push   bp
        mov    bp,sp
        push   bx
        mov    bx,+4[bp]                         ; cause flag 0 - dsp underrun
                                                 ;            1 - no more buffers
       .386
       Start_PTrace   ADSH_MAJOR,ADSH_ACPADevErrorEntry,PTraceStruct,<bx>
       Stop_PTrace    ADSH_MAJOR,ADSH_ACPADevErrorExit,PTraceStruct,<bx>
       .286p
       pop    bx
       pop    bp
endif
        ret
_ReportPTraceError      ENDP

_TEXT   ends

;***************************************************************************
; Everything in this segment gets thrown away following INIT
;***************************************************************************

        extrn   DOSWRITE:far

END_TEXT segment
END_OF_CODE  equ    $
      public END_OF_CODE


;-------------------------------------------------------------------------------
; Initialization procedure is placed at the end of the code so it can go away
;  once initialization has been done.
;-------------------------------------------------------------------------------
_init PROC NEAR
       public _init
       push   bp
       mov    bp,sp
       push   es
       les    bx,+4[bp]

       mov    ax,word ptr es:[bx].IOBufAddr      ;Save 32 bit pointer
       mov    word ptr _device_hlp,ax            ;  to DevHlp commands
       mov    ax,word ptr es:[bx].IOBufAddr+2
       mov    word ptr _device_hlp+2,ax

       lea    ax,CGROUP:END_OF_CODE              ;Place end of code segment into ax
       mov    word ptr es:[bx].IOBufAddr,ax      ;Transfer to the request package
       lea    ax,DGROUP:END_OF_DATA              ;Place end of data segment into
       mov    word ptr es:[bx].IOBufAddr+2,ax    ; the request package

       cmp    initcount,0                        ; Is this the first call?
       je     first_init
       pop    es                                 ; If not, then done here
       pop    bp
       ret
first_init:
       inc    initcount                          ; Increment our init counter

; Call device unique initialization routine

       les    bx,+4[bp]
       les    bx,dword ptr es:[bx].IOBufLen      ; DevInit(((IPKT)rb)->IPktParms);
       push   es
       push   bx
       call   _DevInit
       add    sp,4

       or     ax,ax
       jz     _init_ok

; Display error message...
       pop    es
       pop    bp
       ret

_init_ok:

; Allocate 8 GDT's for *xmitio[] & *recio[]

       MOV    AX,DGROUP
       MOV    ES,AX
       MOV    DI,OFFSET DGROUP:_GDTSelector1
       MOV    CX,NUM_GDTS
       MOV    DL,DevHlp_AllocGDTSelector
       CALL   dword ptr _device_hlp
       jc     init_GDT_error
       MOV    AX,_GDTSelector1                   ; Copy selectors to pointers
       MOV    GDTsel1a,AX
       MOV    AX,_GDTSelector1b
       MOV    GDTsel1b,AX
       MOV    AX,_GDTSelector2
       MOV    GDTsel2a,AX
       MOV    AX,_GDTSelector2b
       MOV    GDTsel2b,AX
       MOV    AX,_GDTSelector3
       MOV    GDTsel3a,AX
       MOV    AX,_GDTSelector3b
       MOV    GDTsel3b,AX
       MOV    AX,_GDTSelector4
       MOV    GDTsel4a,AX
       MOV    AX,_GDTSelector4b
       MOV    GDTsel4b,AX

; **** Allocate "utility" GDT's for V86 address resolution. *****
       mov    di, OFFSET _UtilGDTs
       mov    cx, NumUtils
       mov    dl,DevHlp_AllocGDTSelector
       call   dword ptr _device_hlp

; **** Make utility pointers from utility GDT Selectors.  ******
       mov    si,offset _UtilGDTs                ; Address(selectors)-->si.
       mov    di,offset _UtilPtrs                ; Address(pointers)-->di.
       mov    cx,NumUtils                        ; Number of both --> cx.
UtlPtrLoop:
       mov    ax, WORD PTR [si]                  ; Selector
       mov    WORD PTR [di+2],ax                 ;   ---> Pointer.
       add    si,2                               ; Update
       add    di,4                               ;   addresses.
       loop   UtlPtrLoop                         ; Jump if not finished.

;*********
;***** Register this device driver for VDD, if OS/2 v2.0 or greater. ****
;*********
       cmp    _os2_version,20
       jb     NoVDD
; Set ds:si = address of registration name.
       mov    si, offset dgroup:pddnum
       lea    di,_midinum
       mov    al,[di]
       mov    [si],al
       mov    si, offset dgroup:pddname
; Set es:di = address of routine being registered.
       mov    ax,_TEXT
       and    al,0fch                            ; Ensure ring 0.
       mov    es,ax
       mov    di, offset _TEXT:VDDEntry
       mov    dl,DevHlp_RegisterPDD
       call   dword ptr _device_hlp              ; Register the PDD
NoVDD:

init_GDT_error:
       xor    ax,ax                              ; return(0)
       pop    es
       pop    bp
       ret

_INIT ENDP

IFDEF @AVC103
_AVC103_INIT proc near                           ; avc103_init(*rb)
       public   _AVC103_INIT

       push   bp
       mov    bp,sp
       push   es
       les    bx,+4[bp]
       lea    ax,CGROUP:END_OF_CODE              ;Place end of code segment into ax
       mov    word ptr es:[bx].IOBufAddr,ax      ;Transfer to the request package
       lea    ax,DGROUP:END_OF_DATA              ;Place end of data segment into
       mov    word ptr es:[bx].IOBufAddr+2,ax    ; the request package

       pop    es
       pop    bp
       ret
_AVC103_INIT endp
ENDIF


END_TEXT     ENDS
        END
