
#define CURRENT_VERSION  0x01020000           /* Version of device driver */

#if IS_OS2
#define INCL_DOSSEMAPHORES
#define INCL_DOSPROCESS
#endif

/* IOCtl request id definitions */
#define AUDIO_INIT      0
#define AUDIO_STATUS    1
#define AUDIO_CONTROL   2
#define AUDIO_BUFFER    3
#define AUDIO_LOAD      4
#define AUDIO_WAIT      5
#define AUDIO_HPI       6
#define AUDIO_UPDATE    7
#define AUDIO_DIAG8_READ 12
#define AUDIO_DIAG8_WRITE 13
#define AUDIO_DIAG16_READ 14
#define AUDIO_DIAG16_WRITE 15

/*********************************/
/* AUDIO_INIT definitions        */
/*********************************/

/* This defines the O/S specific audio_init.loadpath length                */
#define  LOAD_PATH   260                  /* HPFS len of 260               */

struct audio_init {
                                          /* Verify Access call            */
   long  srate;                           /* Sampling rate in HZ           */
   long  bits_per_sample;                 /* # of bits per sample          */
   long  bsize;                           /* block size (in bytes)         */
   short mode;                            /* Audio mode                    */
   short channels;                        /* number of channels (2=stereo) */
   long  position_resolution;             /* Resolution of position info   */
   char  loadpath[LOAD_PATH];             /* path of DSP code to load      */
   unsigned long flags;                   /*                               */
   unsigned long operation;               /* operation to be performed     */
   short rc;                              /* return code for operation     */
   short slot_number;                     /* slot number of adapter        */
   short device_id;                       /* adapter type id number        */
   void  far *reserved;                   /* reserved field                */
   long  version_level;                   /* Version Level                 */
};
typedef struct audio_init far *AIP;

/* audio_init.mode definitions                                               */
#define  ADPCM      1                       /* AVC type ADPCM                */
#define  PCM        2                       /* Pulse Coded Modulation        */
#define  MU_LAW     3                       /* mu-law                        */
#define  MIDI       4                       /* MIDI data                     */
#define  A_LAW      5                       /* a-law                         */
#define  SOURCE_MIX 6                       /* External audio source         */
#define  SPV2       7                       /* Speech Viewer/2               */
#define  ADPCMXA    8                       /* XA CD ROM                     */
#define  DSSM       9                       /* DigiSpeech std mode           */
#define  DSMM       10                      /* DigiSpeech movie mode         */
#define  CVSD       11                      /* CVSD                          */
#define  SPV2BCPCM  25                      /* Speech Viewer/2               */
#define  SPV2PCM    26
#define  SPV2NONE   27
#define  CLAIM_HDWR 32000                   /* Serialize access to hardware  */
#define  IDLE       999                     /* De_Initialize the Track       */

/* audio_init.flags definitions                                            */
#define  FIXED             0x00000001l    /* Fixed length data             */
#define  LEFT_ALIGNED      0x00000002l    /* Left align bits on byte bndry */
#define  RIGHT_ALIGNED     0x00000004l    /* Right align bits on byte bndry*/
#define  TWOS_COMPLEMENT   0x00000008l    /* 2's complement data           */
#define  SIGNED            0x00000010l    /* Signed data                   */
#define  BIG_ENDIAN        0x00000020l    /* MSB's first (motorola format) */
#define  TIMER_USED        0x00020000l    /* System Timer is being used    */
#define  FOREGROUND        0x00040000l    /* Foreground operation only     */
#define  INPUT_GAIN        0x00080000l    /* Input gain is supported       */
#define  PITCH             0x00100000l    /* Pitch control is supported    */
#define  INPUT             0x00200000l    /* Input select is supported     */
#define  OUTPUT            0x00400000l    /* Output select is supported    */
#define  MONITOR           0x00800000l    /* Monitor is supported          */
#define  VOLUME            0x01000000l    /* Volume control is supported   */
#define  VOLUME_DELAY      0x02000000l    /* Volume delay is supported     */
#define  BALANCE           0x04000000l    /* Balance control is supported  */
#define  BALANCE_DELAY     0x08000000l    /* Balance delay is supported    */
#define  TREBLE            0x10000000l    /* Treble control is supported   */
#define  BASS              0x20000000l    /* Bass control supported        */
#define  BESTFIT_PROVIDED  0x40000000l    /* bestfit returned              */
#define  LOAD_CODE         0x80000000l    /* DSP load needed               */

/* audio_init.operation definitions                                        */
#define  PLAY                  0x80000001
#define  RECORD                0x80000002
#define  PLAY_AND_RECORD       0x80000003
#define  ANALYSIS              0x80000006 /* Speech Viewer/2               */
#define  DISTANCE              0x80000007 /* Speech Viewer/2               */
#define  MIGRATION             0x80000008 /* Speech Viewer/2               */


/* This define is used in integer fields to be ignored                     */
#define  AUDIO_IGNORE   -1                /* Ignore this field             */

/* audio_init.device_id definitions                                        */
#define  MINIDD         0                 /* Mini DD for serialization only*/
#define  ACPA           1                 /* IBM ACPA card                 */
#define  MACPA          2                 /* IBM M-ACPA card               */
#define  MPU_401        3                 /* Roland MPU-401 or equivalent  */
#define  SOUND_BLASTER  4                 /* Sound Blaster                 */
#define  IMF            5                 /* IBM Music Feature             */
#define  PS1            6                 /* IBM Personal System/1 Audio   */
#define  DIGISPEECH     9                 /* DigiSpeech DS201              */

/****************************/
/* AUDIO_CHANGE definitions */
/****************************/
struct devid {
   unsigned long devtype;
   unsigned long devnum;
}; /* end struct devid */

struct continuous_info {
   int numerator;
   int denominator;
}; /* end struct continuous_info */

struct midi_mode_info_struct {
   short tempo;
   short cpqn;
   short midi_switches;
   short reserved[5];
}; /* end struct devid */

struct pcm_mode_info_struct {
   short pcmflags;
   short reserved[7];
}; /* end struct devid */

struct cdxa_mode_info_struct {
   short ap1_left;
   short ap1_right;
   short ap2_left;
   short ap2_right;
   short reserved[4];
}; /* end struct devid */

struct audio_change {
   void far *dev_info;                 /* Pointer to dev dep info        */
   long   input;                       /* Input selection                */
   long   output;                      /* Output selection               */
   long   monitor;                     /* Monitor select                 */
   long   volume;                      /* Volume control setting         */
   long   volume_delay;                /* # msec's over change occurs    */
   long   balance;                     /* Balance control setting        */
   long   balance_delay;               /* # msec's which change occurs   */
   long   treble;                      /* Treble tone control setting    */
   long   bass;                        /* Bass tone control setting      */
   long   pitch;                       /* Pitch control setting          */
   struct devid input_list[8];         /* Array of up to 8 input devices */
   struct devid output_list[8];        /* Array of up to 8 output devices*/
   struct devid far *more_inputs;      /* Ptr to array of add'tl inputs  */
   struct devid far *more_outputs;     /* Ptr to array of add'tl outputs */
   long   input_gain;                  /* Input Gain                     */
   void   far *mode_info;              /* Ptr to mode specific info      */
};

/* any field in the audio_change structure that should not be changed */
#define  AUDIO_IGNORE   -1

/* audio_change.input definitions (for ACPA device) */
#define  HIGH_GAIN_MIC  0
#define  LINE_1         1
#define  LINE2          2
#define  LINES_1AND2    3
#define  LOW_GAIN_MIC   4
#define  ALL_LINES      0xffff
#define  INPUTS_LISTED  0x5555

/* audio_change.output definitions (for ACPA device) */
#define  EXTERNAL_SPEAKER  1     /* n/a */
#define  INTERNAL_SPEAKER  2
#define  OUTPUT_1          4     /* n/a */
#define  OUTPUTS_LISTED    0x5555

/* audio_status.monitor definitions (for ACPA device) */
#define  MONITOR_OFF          0
#define  MONITOR_UNCOMPRESSED 1
#define  MONITOR_COMPRESSED   2

/* Devid.devtype definitions  */

/* Input devices                  */
#define  NULL_INPUT               0
#define  STEREO_LINE_INPUT        1
#define  LEFT_LINE_INPUT          2
#define  RIGHT_LINE_INPUT         3
#define  MIC_INPUT                4
#define  BOOSTED_MIC_INPUT        5
#define  PHONE_LINE_INPUT         6
#define  HANDSET_INPUT            7
#define  SYNTH_INPUT              8
#define  DIGITAL_PHONE_LINE_INPUT 9
#define  DIGITAL_HANDSET_INPUT    10
#define  MIDI_IN_PORT             11
#define  LOOPBACK                 12
#define  DEFAULT_INPUT            0xffffffff

/* Output devices                  */
#define  NULL_OUTPUT               0
#define  STEREO_LINE_OUTPUT        1
#define  LEFT_LINE_OUTPUT          2
#define  RIGHT_LINE_OUTPUT         3
#define  SPEAKER_OUTPUT            4
#define  HEADSET_OUTPUT            5
#define  PHONE_LINE_OUTPUT         6
#define  HANDSET_OUTPUT            7
#define  MIDI_OUTPUT               8
#define  DIGITAL_PHONE_LINE_OUTPUT 9
#define  DIGITAL_HANDSET_OUTPUT    10
#define  MIDI_OUT_PORT             11
#define  DEFAULT_OUTPUT            0xffffffff

/* Defined values for devnum */
#define  DEFAULT_DEVICE       0
#define  DEVICE_1             1
#define  DEVICE_2             2

/* midi_switches definitions */
#define MIDI_THRU_OUT  1       /* Configure MIDI_Thru connector as MIDI_Out  */
#define MIDI_THRU_THRU 1       /* Configure MIDI_Thru connector as MIDI_Thru */

/* pcmflags definitions */
#define PCM_DEEMPHASIS 1

/****************************/
/* AUDIO_STATUS definitions */
/****************************/
struct audio_status {
   long  srate;                           /* sampling rate in Hz             */
   long  bits_per_sample;                 /* number of bits per sample       */
   long  bsize;                           /* block size for this rate (bytes)*/
   short mode;                            /* ADPCM, PCM, MIDI, etc.          */
   short channels;                        /* number of channels (2=stereo)   */
   unsigned long flags;                   /* variable, fixed, etc.           */
   unsigned long operation;               /* desired operation (play, etc)   */
   struct audio_change change;            /* volume, balance, etc.           */
};
typedef struct audio_status far *ASP;

/* audio_status.operation definitions */
#define  STOPPED                 0
#define  PLAYING                 1
#define  RECORDING               2
#define  PLAYING_AND_RECORDING   3
#define  UNINITIALIZED           0xffffffff

/*****************************/
/* AUDIO_CONTROL definitions */
/*****************************/
struct audio_control {
   unsigned short ioctl_request; /* desired IOCtl request to be done        */
   void     far *request_info;   /* request specific information            */
   unsigned long position;       /* # of units before request should be done*/
   short    return_code;         /* error code                              */
};
typedef struct audio_control far *ACP;

/* audio_control.ioctl_request ids */
#define AUDIO_CHANGE            0
#define AUDIO_START             1
#define AUDIO_STOP              2
#define AUDIO_PAUSE             3
#define AUDIO_RESUME            4
#define AUDIO_NOTIFY            5
#define AUDIO_CONTINUOUS_NOTIFY 6


/****************************/
/* AUDIO_BUFFER definitions */
/****************************/
struct audio_buffer {
   unsigned long flags;          /* Indicates an error condition occurred  */
   unsigned long read_buf_size;  /* Amount of data in read queue (bytes)   */
   unsigned long write_buf_size; /* Amount of data in write queue (bytes)  */
   unsigned long read_buf_time;  /* Amount of data in read queue (msecs)   */
   unsigned long write_buf_time; /* Amount of data in write queue (msecs)  */
   unsigned long read_buf_max;   /* max number of bytes ever in read q     */
   unsigned long write_buf_max;  /* max number of bytes ever in write q    */
   unsigned long position;       /* time count since beginning of operation*/
   unsigned long position_type;  /* specifies the type of position units   */
   long  read_buf_cap;           /* capacity of read queue (-1 if var)     */
   long  write_buf_cap;          /* capacity of write queue (-1 if var)    */
   long  request_buf_cap;        /* max number of requests that can be q'd */
};
typedef struct audio_buffer far *ABP;

/* These are the possible error states that can be flagged in 'flags' */
#define  AUDIO_UNDERRUN 1
#define  AUDIO_OVERRUN  2

/* These are the currently defined position_type values */
#define  POS_MSECS      0              /* Milliseconds                     */
#define  MIDI_CLOCKS    1              /* Midi Timing Clocks               */
#define  POS_BYTES      2              /* Position data is in bytes        */
#define  SMPTE_24       24             /* SMPTE 24 frames/second           */
#define  SMPTE_25       25             /* SMPTE 25 frames/second           */
#define  SMPTE_30DF     29             /* SMPTE 30 frames/second drop frame*/
#define  SMPTE_30       30             /* SMPTE 30 frames/second non-drop  */


/*********************************/
/* AUDIO_LOAD definitions        */
/*********************************/
struct audio_load {
   char  far *buffer;
   unsigned long size;
   unsigned long flags;
};
typedef struct audio_load far *ALP;

#define  LOAD_START  1
#define  LOAD_END    2
#define  LOAD_32BIT  0x10                 /* *buffer is 0:32 pointer       */

/*******************************/
/* Diagnostic definitions      */
/*******************************/
struct diag_regs8 {
   unsigned char offset;
   unsigned char data;
};
typedef struct diag_regs8 far *DR8;

struct diag_regs16 {
   unsigned short offset;
   unsigned short data;
};
typedef struct diag_regs16 far *DR16;

/*******************************/
/* Track Information Structure */
/*******************************/
struct track_info {
   unsigned short master_volume;
   unsigned short dither_percent;   /* Percent of a bit dither during record  */
   unsigned short master_volume_delay;
   unsigned short master_balance;
   unsigned short master_balance_delay;
};

/*******************/
/* IOBUF Structure */
/*******************/

struct addrs_array {           /* array of ptrs describing buffers    */
   unsigned long length;       /* note - user may pass in >1 buff     */
   char far *Virt;             /* User's virtual address              */
   char far *Phys;             /* Physical address                    */
   long lock_handle;           /* Lock Handle                         */
} ;

struct iobuf
{
   unsigned long size;            /* size in bytes of the data buffer    */
   char far *head;                /* head pointer (data added here)      */
   char far *tail;                /* tail pointer (data removed here)    */
   unsigned short head_segnum;
   unsigned short tail_segnum;
   unsigned long count;           /* # of data bytes currently queued    */
   unsigned long position;        /* Position counter                    */
// long delay;                    /* # pos units until next i/o          */
   long moreflags;                /* more control bits/flags             */
   unsigned short runflags;       /* start/stop/pause control bits       */
   char far *pIobufPhys;          /* physical address of this structure  */
   long lock_handle;              /* Handle for UnLock call of iobuf     */
   unsigned short num_buffers;    /* Number of buffers passed by app.    */
   struct addrs {                 /* array of ptrs describing buffers    */
      unsigned long length;       /* note - user may pass in >1 buff     */
      char far *Virt;             /* User's virtual address              */
      char far *Phys;             /* Physical address                    */
      long lock_handle;           /* Lock Handle                         */
   } buf[1];
};
typedef struct iobuf far *IOB;

/* iobuf.runflags equates  */
#define  STARTED        1
#define  PAUSED         2
#define  WAS_RUNNING    4           /* Flag to see if was running last int */
#define  IOB_OVERRUN    0x20        /* Overrun has occurred.               */
#define  IOB_UNDERRUN   0x40        /* Underrun has occurred.              */
#define  CHAIN_BUFFERS  0x80        /* Reserved - must be 0!               */
#define  CBDATA         0x0100      /* callback if any data                */
#define  CBBLOCK        0x0200      /* callback if any blocks              */
#define  CBIOBUF        0x0400      /* callback if changed buffers         */
#define  CBERROR        0x0800      /* callback if error detected          */
#define  CBUNDERRUN     0x1000      /* callback if underrun/overrun occurs */
#define  PADIT          0x4000      /* Pad any partial blocks with silence */
#define  IOBUF_LOCK     0x8000      /* IOBUF being updated by appl         */

/* iobuf.moreflags equates  */
//Status CBDATA         0x0100      /* callback caused by any data         */
//Status CBBLOCK        0x0200      /* callback caused by block of data    */
//Status CBIOBUF        0x0400      /* callback caused by iobuf change     */
//Status CBERROR        0x0800      /* callback caused by error detected   */
//Status CBUNDERRUN     0x1000      /* callback caused by under/overrun    */
#define  CBNOTIFY       0x2000      /* callback caused by notify request   */


/***********************/
/* AUDIO_HPI Structure */
/***********************/
struct audio_hpi
{
  void (far * ep)();            /* pointer to direct call entry point       */
  void (far * cb)();            /* pointer to callback routine/semaphore    */
  struct iobuf far *newxbuf;    /* pointer to xmit iobuf structure          */
  struct iobuf far *newrbuf;    /* pointer to receive iobuf structure       */
  unsigned short flags;         /* reserved.                                */
};
typedef struct audio_hpi far *HPI;

/* audio_hpi.flags definitions */
#define  CBXMIT   1
#define  CBREC    2
#define  CBTIMER  4

/*  Direct call interface definitions */
/*  void  (far *iobuf.ep)(int funcid, void far *data, int len);    */
/* Definitions for funcid */
#define EP_OPEN      0
#define EP_CLOSE     1
#define EP_READ      2
#define EP_WRITE     3
#define EP_INIT      4
#define EP_STATUS    5
#define EP_CONTROL   6
#define EP_BUFFER    7
#define EP_LOAD      8
#define EP_WAIT      9
#define EP_HPI       10
#define EP_UPDATE    11

/**************************/
/* AUDIO_UPDATE Structure */
/**************************/
struct audio_update
{
  char iobuf_type;              /* 0 - XMITIO, 1 - RECIO to be updated      */
  char far *buffer_address;     /* address to buffer to be added to array   */
  unsigned long buffer_length;  /* length of buffer to be added             */
  unsigned short rc;            /* return code                              */
  void far *reserved;           /* future use                               */
};
typedef struct audio_update far *UPDATE;

/* audio_update.iobuf_type definitions                                      */
#define  XMIT_IOBUF 0
#define  REC_IOBUF  1

/**************************************************/
/* Speech Viewer/2 Device Specific Data Structure */
/**************************************************/
struct spv2_mode_info_struct
{
  unsigned short pitch;
  unsigned short num_LPC_coeff;
  unsigned short rate_of_LPC;
  unsigned short hamming_width;
  unsigned short ret_signal;
  unsigned short slow_down;
};

/* audio_init.rc definitions                                               */
#define  NO_PLAY              1           /* Cannot play                   */
#define  NO_RECORD            2           /* Cannot record                 */
#define  NO_PLAY_AND_RECORD   3           /* Cannot both play and record   */
#define  INVALID_REQUEST      4           /* request was invalid           */
#define  CONFLICT             5           /* Conflicting info in request   */
#define  OVERLOADED           6           /* Out of DSP MIPS or memory     */
#define  DOWNLEVEL_DD         7           /* DD is down level from appl.   */

/* audio_control.return_code */
#define  AC_UNINITED          1       /* Device must be init'ed or loaded first    */
#define  FULL_QUEUE           2       /* Maximum # requests exceeded        */
#define  AC_UNPAUSED          3       /* Resume issued, but dev not paused  */
#define  INVALID_REQUEST      4       /* bad audio_control.ioctl_request    */
#define  AC_UNSTARTED         5       /* Device must be started first       */
#define  INVALID_INPUT_LIST   7       /* invalid change.input_list entry    */
#define  INVALID_OUTPUT_LIST  8       /* invalid change.output_list entry   */

/* audio_update.rc definitions                                              */
#define  MAX_NUM_BUFFERS_REACHED 9
#define  UPDATE_GENERAL_FAILURE  10
#define  INVALID_BUFFER_LENGTH   11

