/**************************START OF SPECIFICATIONS *************************
 *
 * SOURCE FILE NAME: AUDIODD2.H
 *
 * DESCRIPTIVE NAME: MME
 *
 * STATUS: OS/2 Release 2.0, 1.3, and DOS 3.3+
 *
 * NOTE:
 *   DEPENDENCIES:
 *   RESTRICTIONS:
 *
 * MODIFICATION HISTORY:
 * DEV/PTR   DATE   CHANGE DESCRIPTION
 * BRR6 - 6/24/91 - Add support for multiple and variable length buffers
 * BRR9 - 7/3 /91 - Merged Ron's fixes in for 7/10/91 drop
 * BRR31- 8/6 /91 - Modifications for new AUDIO_CHANGE structure
 * BRR40- 8/11/91 - Add CLEAR_CONTROL_BLOCKS description - deleted
 * BRR44- 8/15/91 - Added Local Info Seg structure description
 * BRR15- 8/20/91 - Added callback support
 * BRR65- 9/12/91 - Added DevIOCTLwait prototype
 * BRR69- 9/16/91 - Added #define for [trk] variables
 * BRR96- 9/30/91 - Changes DevChange prototype for passing structure
 * BRR105-10/04/91 - Changes DevChange prototype for passing mode_info
 * BRR142-10/18/91 - Add CB_DATA_SEGMENT #define and call_callback func
 * BRR148-10/23/91 - Change spv2_dev_info to spv2_mode_info
 * BRR155-10/31/91 - Add #define for TIMING_SYSEX_QUEUED for MIDIFLAGS
 * BRR177-11/07/91 - Add DeInitialize function prototype
 * BRR181-11/08/91 - Add Sys Info Seg Descriptions for GetDOSVar and
 *                   get_version() prototype
 * BRR183-11/10/91 - Add DevDeInit prototype
 * BRR194-11/19/91 - Change DeInitialize prototype
 * BRR44 -11/22/91 - Add 2.0 V86 support --- (see Wes)
 * BRR202-12/02/91 - Add prototypes for SetBuffers and v86toLin
 * BRR206-12/05/91 - Add UPDATE_IOCTL support
 * BRR210-12/11/91 - Change INIT prototype to return an INT
 * BRR216- 1/07/92 - Add prototype for DevPause
 * BRR217- 1/07/92 - Add prototype for DevResume
 * BRR222- 1/07/92 - Add trk_hvdm #define for num_tracks, and prototype
 *                   for Get_HVDM
 * BRR224- 1/15/92 - Add support for audio_notify
 * CMC01 -1/22/92 - Add AttachDD prototype and change req block struct
 * CMC02 -1/22/92 - Add GetPageList GetPageList prototype
 * CMC03 -1/22/92 - Change DevMstVolume & add DevMstBalance prototypes
 * BRR235- 1/23/92 - Add support odd buffer sizes
 * BRR249- 1/30/92 - Add rollover_time defines
 * BRR251- 1/31/92 - Change prototype for SetProcessMode
 *                   Add V86_mode #define's
 * BRR259- 2/06/92 - Add init_queue_vars prototype
 * WES262- 2/10/92 - Add V86 callback support
 * CMC04  -2/10/92 - Change GetPageList prototype
 * BRR265 -2/12/92 - Make version track dependent
 * BRR266 -2/12/92 - Add POS_BUFFER_COUNT, MAX_PBUFFER_COUNT,
 *                   MAX_RBUFFER_COUNT
 * BRR284 -2/27/92 - Add purge_data prototype
 * BRR286 -2/28/92 - Update DevMstVolume prototype
 * WES299 -3/05/92 - Add Kill VDM support
 * BRR300 -3/06/92 - Add trk_assigned_at_init #define's
 * BRR321 -3/24/92 - Add FindSysFileNum prototype
 * BRR379 -4/14/92 - Remove cumulative_time and reported_time
 * BRR391 -4/16/92 - Add catchup_count
 * BRR??? -5/18/92 - Add AUDIO_CONTINUOUS_NOTIFY/AUDIO_NOTIFY support/changes
 ************************** END OF SPECIFICATIONS **************************/

/* Virtual Storage Control Block */
#if IS_OS2
struct vscb {
   char far *Ptr;                   /* Our usable pointer               */
   char far *Virt;                  /* User's virtual address           */
   char far *Phys;                  /* Physical address                 */
   char far *GDT;                   /* GDT based address                */
   unsigned long length;            /* Length of buffer                 */
};
#else
struct vscb {
   char far *Ptr;                   /* Our usable pointer               */
   char far *Virt;                  /* this is for compat with OS/2     */
   unsigned long length;            /* Length of buffer                 */
};
#endif


/* mode_table structure */
struct mode_data {
   short mode;                      /* mode #                              */
   long  flags_mask;                /* relevant flags                      */
   long  flags;                     /* flag values                         */
   short bps_low;                   /* bits_per_sample lower limit         */
   short bps_high;                  /* bits_per_sample upper limit         */
   long  srate_low;                 /* srate lower limit                   */
   long  srate_high;                /* srate upper limit                   */
   short channels_low;              /* channels lower limit                */
   short channels_high;             /* channels upper limit                */
   long  bsize;                     /* block size                          */
   short dont_care;                 /* bitmap of don't-care values         */
};



/* Request queue structure */

struct request_block {
   struct request_block *req_next;  /* ptr to next req in queue (or NULL)  */
   short req_type;                  /* Request type (ie.CHANGE, START, etc)*/
   unsigned long req_position;      /* when to do the requested operation  */
   struct audio_change req_change;  /* Structure containing all fields */
   int req_change_dev_info[5];
   char req_any_dev_info;
   int req_change_mode_info[6];
   char req_any_mode_info;
   unsigned long req_notify_hEvent;
};


/* MIDI structure (1 per Midi channel) */
struct midiblk {
short   mbflags1;               /* 1 = mono, 2=omni, 4=sustain          */
char    mbvoicenum;             /* Voice number assigned this channel   */
char    mbconfig;               /* Configuration of the assigned voice  */
char    mbvolume;               /* Volume assigned to this channel      */
char    mbtranspose;            /* Transpose (+/- 127)                  */
char    mbkeyhi;                /* key range hi                         */
char    mbkeylo;                /* key range low                        */
};
/* mbflags1 definitions */
#define MONO    1
#define OMNI    2
#define SUSTAIN 4

/* Note structure (1 per sound generator) */
struct noteblk {
struct noteblk *nbnext;         /* Pointer to next note block in queue  */
struct noteblk *nbprev;         /* Pointer to previous note block       */
short   nbflags1;               /* 4=sustained off                      */
char    nbkeynum;               /* Key # of last note sounded           */
char    nbchannel;              /* MIDI channel                         */
char    nbgennum;               /* sound generator assigned to this blk */
char    nbvoicenum;             /* Currently loaded voice #             */
char    nbconfig;               /* Currently loaded configuration #     */
};

/* Structure of a request packet header */
struct  PacketHdr {
unsigned char PktLen;           /* Length in bytes of packet            */
unsigned char PktUnit;          /* Subunit number of block device       */
unsigned char PktCmd;           /* Command code                         */
unsigned short PktStatus;       /* Status word                          */
long    PktDOSLink;             /* Reserved                             */
long    PktDevLink;             /* Device multiple-request link         */
};

/*  Structure of an I/O request packet */
struct  Packet {
struct PacketHdr PktHdr;        /* 13 byte header                       */
unsigned char   PktMediaDesc;   /* Data pertaining to specific packet   */
unsigned char far *IOpData;     /* Pointer to data for read/write       */
unsigned short  IOcount;        /* length of data for read/write        */
};
typedef struct Packet far *PKT;

/*  Structure of an INIT request packet */
struct  IPacket {
struct PacketHdr IPktHdr;
unsigned char IPktNumDevs;      /* Data pertaining to specific packet   */
char far *IPktEndAddr;          /* Pointer to data for read/write       */
char far *IPktParms;            /* length of data for read/write        */
};
typedef struct IPacket far *IPKT;

/* General IOCtl Packet */
struct  GIOpkt {
struct PacketHdr GIOHdr;
unsigned char GIOcat;           /* GIO category      (major func)       */
unsigned char GIOcode;          /* GIO function code (minor func)       */
unsigned short GIOsi;           /* GIO contents of SI                   */
unsigned short GIOdi;           /* GIO contents of DI                   */
struct GIX0pkt far *GIOData;    /* GIO address of data (see GIXpkt)     */
};
typedef struct GIOpkt far *GIO;

#if IS_OS2
/*****************************************/
/* _StackUsage DevHlp structure variable */
/*****************************************/
typedef struct {                 /* used by _RegisterStackUsage() */
   unsigned short SU_cbStruct;   /* bytes in this struct     */
   unsigned short SU_flags;      /* 0 = no nested IRQs       */
   unsigned short SU_iIRQ;       /* irqnum                   */
   unsigned short SU_cbStackCLI; /* bytes in stack while CLI */
   unsigned short SU_cbStackSTI; /* bytes in stack while STI */
   unsigned short SU_cbStackEOI; /* bytes in stack while EOI */
   unsigned short SU_cNest;      /* Max count of nested irqs */
}StackUsage;
typedef StackUsage near *PStackUsage;

/* Global Info Seg Pointer */
typedef GINFOSEG *SYSPtr_t;
typedef GINFOSEG far *SYSPtr_tf;

/*Local Info Seg Structure */
typedef struct {
   PID     pidCurrent;                 /* current process id */
   PID     pidParent;                  /* process id of parent */
   USHORT  prtyCurrent;                /* priority of current thread */
   TID     tidCurrent;                 /* thread ID of current thread */
   USHORT  sgCurrent;                  /* session */
   UCHAR   rfProcStatus;               /* process status */
   UCHAR   dummy1;
   BOOL    fForeground;                /* current process has keyboard focus */
   UCHAR   typeProcess;                /* process type */
   UCHAR   dummy2;
   SEL     selEnvironment;             /* environment selector */
   USHORT  offCmdLine;                 /* command line offset */
   USHORT  cbDataSegment;              /* length of data segment */
   USHORT  cbStack;                    /* stack size */
   USHORT  cbHeap;                     /* heap size */
   HMODULE hmod;                       /* module handle of the application */
   SEL     selIDS;                     /* data segment handle of the application */
} LclINFOSEG;
typedef LclINFOSEG far *LISPtr_t;

#endif

/********************************/
/* old AUDIO_INIT definitions   */
/********************************/
struct audio_init_v005 {                  /* BRR105 */
                                          /* Verify Access call            */
   long  srate;                           /* Sampling rate in HZ           */
   long  bits_per_sample;                 /* # of bits per sample          */
   long  bsize;                           /* block size (in bytes)         */
   short mode;                            /* Audio mode                    */
   short channels;                        /* number of channels (2=stereo) */
   long  position_resolution;             /* Resolution of position info   */
   char  loadpath[LOAD_PATH];             /* path of DSP code to load      */
   unsigned long flags;                   /*                               */
   unsigned long operation;               /* operation to be performed     */
   short rc;                              /* return code for operation     */
   short slot_number;                     /* slot number of adapter        */
   short device_id;                       /* adapter type id number        */
   void  far *reserved;                   /* reserved field                */
};

/********************************/
/* old AUDIO_CHANGE definitions */
/********************************/
struct audio_change_v00 {              /* BRR71 */
   void far *dev_info;                 /* Pointer to dev dep info       */
   long   input;                       /* Input selection               */
   long   output;                      /* Output selection              */
   long   monitor;                     /* Monitor select                */
   long   volume;                      /* Volume control setting        */
   long   volume_delay;                /* # msec's over change occurs   */
   long   balance;                     /* Balance control setting       */
   long   balance_delay;               /* # msec's which change occurs  */
   long   treble;                      /* Treble tone control setting   */
   long   bass;                        /* Bass tone control setting     */
   long   pitch;                       /* Pitch control setting         */
};

/********************************/
/* old AUDIO_STATUS definitions */
/********************************/
struct audio_status_v00 {                 //BRR150
   long  srate;                           /* sampling rate in Hz           */
   long  bits_per_sample;                 /* number of bits per sample     */
   long  bsize;                           /* block size for this rate (bytes)*/
   short mode;                            /* ADPCM, PCM, MIDI, etc.        */
   short channels;                        /* number of channels (2=stereo) */
   unsigned long flags;                   /* variable, fixed, etc.         */
   unsigned long operation;               /* desired operation (play, etc) */
   struct audio_change_v00 change;        /* volume, balance, etc.         */
};

#if IS_WIN
/******** Modified structures for ioctl_read() & ioctl_write() ************/
struct w_audio_init {
   unsigned char func;                    /* Function ID = 0x40            */
   long  srate;                           /* Sampling rate in HZ           */
   long  bits_per_sample;                 /* # of bits per sample          */
   long  bsize;                           /* block size (in bytes)         */
   short mode;                            /* Audio mode                    */
   short channels;                        /* number of channels (2=stereo) */
   long  position_resolution;             /* Resolution of position info   */
   char  loadpath[LOAD_PATH];             /* path of DSP code to load      */
   unsigned long flags;                   /*                               */
   unsigned long operation;               /* operation to be performed     */
   short rc;                              /* return code for operation     */
   short slot_number;                     /* slot number of adapter        */
   short device_id;                       /* adapter type id number        */
   void  far *reserved;                   /* reserved field                */
};

struct w_audio_status {
   unsigned char func;                    /* Function ID = 0x41            */
   long  srate;                           /* sampling rate in Hz           */
   long  bits_per_sample;                 /* number of bits per sample     */
   long  bsize;                           /* block size for this rate (bytes)*/
   short mode;                            /* ADPCM, PCM, MIDI, etc.        */
   short channels;                        /* number of channels (2=stereo) */
   unsigned long flags;                   /* variable, fixed, etc.         */
   unsigned long operation;               /* desired operation (play, etc) */
   struct audio_change change;            /* volume, balance, etc.         */
};

struct w_audio_control {
   unsigned char func;           /* Function ID = 0x42                     */
   unsigned short ioctl_request; /* desired IOCtl request to be done       */
   void  far *request_info;      /* request specific information           */
   unsigned long position;       /* # of units before request should be done*/
   short return_code;            /* error code                             */
};

struct w_audio_load {
    unsigned char func;           /* Function ID = 0x44;                    */
    unsigned char far *buffer;
    unsigned long size;
    unsigned long flags;
};


struct w_audio_buffer {
   unsigned char func;           /* Function ID = 0x43                     */
   unsigned long flags;          /* Indicates an error condition occurred  */
   unsigned long read_buf_size;  /* Amount of data in read queue (bytes)   */
   unsigned long write_buf_size; /* Amount of data in write queue (bytes)  */
   unsigned long read_buf_time;  /* Amount of data in read queue (msecs)   */
   unsigned long write_buf_time; /* Amount of data in write queue (msecs)  */
   unsigned long read_buf_max;   /* max number of bytes ever in read q     */
   unsigned long write_buf_max;  /* max number of bytes ever in write q    */
   unsigned long position;       /* time count since beginning of operation*/
   unsigned long position_type;  /* specifies the type of position units   */
   long  read_buf_cap;           /* capacity of read queue (-1 if var)     */
   long  write_buf_cap;          /* capacity of write queue (-1 if var)    */
   long  request_buf_cap;        /* max number of requests that can be q'd */
};

struct w_audio_hpi
{
  unsigned char func;           /* Function ID = 0x46                       */
  void (far * ep)();            /* pointer to direct call entry point       */
  void (far * cb)();            /* pointer to callback routine              */
  struct iobuf far *newxbuf;    /* pointer to xmit iobuf structure          */
  struct iobuf far *newrbuf;    /* pointer to receive iobuf structure       */
  unsigned short flags;         /* reserved.                                */
};

#endif

/***************************************************************************/
/* AttachArea                                                              */
/***************************************************************************/
typedef struct AttachArea
  {
   unsigned short RealOff;          /* real mode offset of IDC entry pnt */
   unsigned short RealCS;           /* real mode CS of IDC entry pnt */
   unsigned short RealDS;           /* real mode DS of IDC DD */
   unsigned short ProtOff;          /* protect mode offset of IDC entry */
   unsigned short ProtCS;           /* protect mode CS of IDC entry pnt */
   unsigned short ProtDS;           /* protect mode DS of IDC DD */
  } ATTACHAREA;


/***************************************************************************/
/* LINTOPAGELIST structure                                                 */
/***************************************************************************/

struct plistentry
  {
   unsigned long addr;        /* physical address of a page */
   unsigned long size;        /* size of the page, in bytes */
  };

