/***************************************************************************\
*
* Module Name: SSM.H
*
* OS/2 2.0 Multimedia Extensions Sync/Stream Manager Definitions file
*  NOTE:  All structures are UNPACKED!!
*
\***************************************************************************/


#define MAX_SPI_NAME  9      /* Maximum ASCIIZ stream handler name/class &  */
                             /* device driver name                          */


/****************************************************************************/
/*                                                                          */
/*  Forward Declarations                                                    */
/*                                                                          */
/****************************************************************************/
typedef struct _heh       FAR  *PHEH;              /* Ptr to an HEH
typedef struct _dsc       FAR  *PDSC;              /* Ptr to a DSC          */
typedef struct _slave     FAR  *PSLAVE;            /* Ptr to a SLAVE        */
typedef struct _lockh     FAR  *PLOCKH;            /* Ptr to a LOCKH        */
typedef struct _hand      FAR  *PHAND;             /* Ptr to a HAND         */
typedef struct _ptrtab    FAR  *PPTRTAB;           /* Ptr to a PTRTAB       */
typedef struct _srcbuftab FAR  *PSRCBUFTAB;        /* Ptr to a buffer table entry */
typedef struct _tgtbuftab FAR  *PTGTBUFTAB;        /* Ptr to a buffer table entry */


/*                                                                          */
/* Ptr SMH parameter blocks                                                 */
/*                                                                          */
typedef struct _smh_common  FAR  *PSMH_COMMON;     /* Ptr to common part    */
typedef struct _parm_init   FAR  *PPARM_INIT;
typedef struct _parm_reg    FAR  *PPARM_REG;
typedef struct _parm_dereg  FAR  *PPARM_DEREG;
typedef struct _parm_event  FAR  *PPARM_EVENT;
typedef struct _parm_notify FAR  *PPARM_NOTIFY;
typedef struct _parm_lockm  FAR  *PPARM_LOCKM;


/*                                                                          */
/* Ptr SHC parameter blocks                                                 */
/*                                                                          */
typedef struct _shc_common    FAR  *PSHC_COMMON;   /* Ptr to common part    */
typedef struct _parm_assoc    FAR  *PPARM_ASSOC;
typedef struct _parm_close    FAR  *PPARM_CLOSE;
typedef struct _parm_create   FAR  *PPARM_CREATE;
typedef struct _parm_destroy  FAR  *PPARM_DESTROY;
typedef struct _parm_dissync  FAR  *PPARM_DISSYNC;
typedef struct _parm_disevent FAR  *PPARM_DISEVENT;
typedef struct _parm_enevent  FAR  *PPARM_ENEVENT;
typedef struct _parm_ensync   FAR  *PPARM_ENSYNC;
typedef struct _parm_gtime    FAR  *PPARM_GTIME;
typedef struct _parm_seek     FAR  *PPARM_SEEK;
typedef struct _parm_start    FAR  *PPARM_START;
typedef struct _parm_stop     FAR  *PPARM_STOP;
typedef struct _parm_gprot    FAR  *PPARM_GPROT;
typedef struct _parm_instprot FAR  *PPARM_INSTPROT;
typedef struct _parm_enumprot FAR  *PPARM_ENUMPROT;
typedef struct _parm_negotiate FAR  *PPARM_NEGOTIATE;



/* XLATOFF */
#pragma pack(4)
/* XLATON */

/****************************************************************************/
/*                                                                          */
/*  Global Type Declarations                                                */
/*                                                                          */
/****************************************************************************/
typedef ULONG  HSTREAM;               /* Stream Handle                      */
typedef HSTREAM FAR *PHSTREAM;        /* Pointer to Stream Handle           */

typedef ULONG  HEVENT;                /* Event Handle                       */
typedef HEVENT FAR *PHEVENT;          /* Pointer to Event Handle            */

typedef ULONG  HID;                   /* Stream Handler ID                  */
typedef HID  FAR *PHID;               /* Pointer to Stream Handler ID       */

typedef struct _lockh {               /* Memory locking handle (used by PDD)*/
   BYTE     lock[16];
   } LOCKH;

typedef ULONG  RC;                    /* Used for all return codes          */

typedef struct  _slave { /* slave */
   HSTREAM       hstreamSlave;          /* Handle for this slave            */
   MMTIME        mmtimeStart;           /* Offset in master stream time to start */
   } SLAVE;                             /*  this slave.                     */

/* XLATOFF */
#pragma pack(1)
/* XLATON */

typedef struct  _hand { /* hand */
   SZ            szHandlerClass[MAX_SPI_NAME]; /* Stream handler class      */
   SZ            szHandlerName[MAX_SPI_NAME];  /* Stream handler name       */
   } HAND;

/* XLATOFF */
#pragma pack()
/* XLATON */


#include "spcb.h"
#include "evcb.h"
#include "acb.h"
#include "dcb.h"

/****************************************************************************/
/* INI file support defines                                                 */
/****************************************************************************/
/* RCDATA defines:                                                          */
#define SPI_RESOURCE   1               /* RCDATA resource number            */
#define SH_DLL_TYPE    0               /* DLL type stream handler           */
#define SH_PDD_TYPE    1               /* PDD type stream handler           */
#define SPCBSIZE       72L             /* SPCB length, the Resource compiler*/
                                       /*   doesn't allow sizeof(SPCB).     */

/* XLATOFF */
/****************************************************************************/
/*                                                                          */
/*  Function Prototypes for Application event entry routine, SHC entry      */
/*  routine, SMH entry routine. All use the Pure C calling convention       */
/*                                                                          */
/****************************************************************************/
typedef RC (FAR *PEVFN) ( PEVCB  pevcb );
typedef RC (FAR *PSHCFN) ( PVOID pParmIn );
typedef RC (FAR *PSMHFN) ( PVOID pParmIn );
/* XLATON */
#ifdef XXXXX                                 /* Picked up by H2INC only     */
typedef PVOID PEVFN;                         /* Because previous function   */
typedef PVOID PSHCFN;                        /* prototypes generate errors  */
typedef PVOID PSMHFN;                        /* when parsed by H2INC.       */
#endif                                       /*                             */


/****************************************************************************/
/*                                                                          */
/*  Function Prototypes for SPI functions                                   */
/*  All use Pure C calling convention                                       */
/*  Six major categories:                                                   */
/*     - stream creation                                                    */
/*     - stream control                                                     */
/*     - event handling                                                     */
/*     - sync handling                                                      */
/*     - configuration                                                      */
/*     - stream protocol programming                                        */
/****************************************************************************/


/* XLATOFF */
/****************************************************************************/
/* Stream Creation                                                          */
/****************************************************************************/

RC APIENTRY SpiAssociate ( HSTREAM hstream,
                           HID hid,
                           PACB pacb );


RC APIENTRY SpiEnumerateHandlers ( PHAND pahand,       /* ptr to array handler name/class */
                                   PULONG pulNumHand );


RC APIENTRY SpiGetHandler ( PSZ pszHName,
                            PHID phidSrc,
                            PHID phidTgt );

RC APIENTRY SpiCreateStream ( HID hidSrc,        /* input                   */
                              HID hidTgt,        /* input                   */
                              PSPCBKEY pspcbkey, /* input                   */
                              PDCB pdcbSrc,      /* input - Src device info */
                              PDCB pdcbTgt,      /* input - Tgt device info */
                              PIMPL_EVCB pevcb,  /* input                   */
                              PEVFN EventEntry,  /* input                   */
                              HSTREAM hstreamBuf,/* input                   */
                              PHSTREAM phstream, /* output                  */
                              PHEVENT phevent ); /* output - implicit hevent*/


/****************************************************************************/
/* Stream Control                                                           */
/****************************************************************************/


RC APIENTRY SpiDestroyStream ( HSTREAM hstream );


RC APIENTRY SpiGetTime ( HSTREAM hstream,
                         PMMTIME pmmtime );

RC APIENTRY SpiSeekStream ( HSTREAM hstream,
                            ULONG ulFlags,
                            LONG  lSeekPoint );  /*mmtime or other          */

/* SpiSeekStream() ulFlags defines:                                         */
#define SPI_SEEK_ABSOLUTE   0x0000L         /* Seek from beginning of stream*/
#define SPI_SEEK_RELATIVE   0x0001L         /* Seek from current location   */
#define SPI_SEEK_FROMEND    0x0002L         /* TEMP                         */
#define SPI_SEEK_SLAVES     0x0010L         /* Seek all slave streams       */

#define SPI_SEEK_MMTIME     0x0000L         /* lSeekPoint == mmtime (default)*/
#define SPI_SEEK_BYTES      0x0100L         /* lSeekPoint == bytes          */

#define VALIDSEEKFLAGS      ( SPI_SEEK_RELATIVE |           \
                              SPI_SEEK_ABSOLUTE |           \
                              SPI_SEEK_FROMEND  |           \
                              SPI_SEEK_MMTIME |             \
                              SPI_SEEK_SLAVES |             \
                              SPI_SEEK_BYTES )


RC APIENTRY SpiStartStream ( HSTREAM hstream,
                             ULONG ulFlags );

/* SpiStartStream() ulFlags defines:                                        */
#define SPI_START_STREAM    0x0000L         /* Only start this one stream   */
#define SPI_START_SLAVES    0x0001L         /* Start this master and any slaves */
#define SPI_START_PREROLL   0x0002L         /* Start the stream, but do preroll */

#define VALIDSTARTFLAGS     ( SPI_START_STREAM |            \
                              SPI_START_SLAVES |            \
                              SPI_START_PREROLL )


RC APIENTRY SpiStopStream ( HSTREAM hstream,
                            ULONG ulFlags );

/* XLATON */
/* SpiStopStream() ulFlags defines:                                         */
#define SPI_STOP_STREAM    0x0000L         /* Only stop this one stream     */
                                           /* The default is to pause the data          */
                                           /*  stream. No change to data buffers.       */
                                           /*  synchronous call (no event notification) */
#define SPI_STOP_SLAVES    0x0001L         /* Stop this master and any slaves           */
#define SPI_STOP_FLUSH     0x0002L         /* Stop and flush all filled buffers.        */
                                           /*  Stops the Src & Tgt SH, lets the         */
                                           /*  Tgt SH run until out of buffers          */
                                           /*  thereby, "flushing" all buffers.         */
                                           /*  Tgt SH stops when out of buffers         */
                                           /*  (This is a ASYNCHRONOUS call, event      */
                                           /*   notification sent to appl when done.)   */
#define SPI_STOP_DISCARD   0x0004L         /* Stop and discard all filled buffers.      */
                                           /*  Stops the Src & Tgt SH                   */
                                           /*  then discards all buffers current for    */
                                           /*  this stream.                             */
                                           /*  (This is a ASYNCHRONOUS call, event      */
                                           /*   notification sent to appl when done.)   */


/* XLATOFF */
#define VALIDSTOPFLAGS     ( SPI_STOP_STREAM |              \
                             SPI_STOP_SLAVES |              \
                             SPI_STOP_FLUSH |               \
                             SPI_STOP_DISCARD )


/****************************************************************************/
/* Event Handling                                                           */
/****************************************************************************/


RC APIENTRY SpiDisableEvent ( HEVENT hevent );


RC APIENTRY SpiEnableEvent ( PEVCB pevcb,
                             PHEVENT phevent );


/****************************************************************************/
/* Sync Handling                                                            */
/****************************************************************************/


RC APIENTRY SpiDisableSync  ( HSTREAM hstreamMaster );


RC APIENTRY SpiEnableSync ( HSTREAM hstreamMaster,
                            PSLAVE paslaveList,
                            ULONG ulNumSlaves,
                            MMTIME mmtimeSync );


/****************************************************************************/
/* Protocol manipulation                                                    */
/****************************************************************************/

RC APIENTRY SpiGetProtocol ( HID hid,
                             PSPCBKEY pspcbkey,  /* input key               */
                             PSPCB pspcb );      /* output SPCB             */


RC APIENTRY SpiInstallProtocol ( HID hid,
                                 PSPCBKEY pspcbkey,  /* input key           */
                                 PSPCB pspcb ,       /* input SPCB          */
                                 ULONG ulFlags );    /* install flags       */

/* SpiInstallProtocol() ulFlags defines:                                    */
#define SPI_INSTALL_PROTOCOL   0x0000L         /* Install this protocol     */
#define SPI_DEINSTALL_PROTOCOL 0x0001L         /* DeInstall this protocol   */

#define VALIDINSTALLFLAGS     (SPI_INSTALL_PROTOCOL | SPI_DEINSTALL_PROTOCOL)

RC APIENTRY SpiEnumerateProtocols ( HID hid,
                                   PVOID    paSPCBKeys,        /* ptr to buffer to fill with SPCB keys */
                                   PULONG   pulNumSPCBKeys );  /* # of entries buffer on input,        */
                                                               /*  # of SPCB key on output.            */
/* XLATON */


/****************************************************************************/
/*                                                                          */
/*  Function Prototypes for SMH functions                                   */
/*  All use Pure C calling convention                                       */
/* NOTE ABOUT POINTERS:                                                     */
/*  0:32 linear addresses for ring 3 (DLL) stream handlers                  */
/*  16:16 selector/offset addresses for ring 0 (PDD) stream handlers        */
/****************************************************************************/

RC APIENTRY SMHEntryPoint ( PVOID pParmIn );

typedef struct _smh_common { /* smhfunc */
      ULONG    ulFunction;        /* SMH command function                   */
      HID      hid;               /* handler ID                             */
   } SMH_COMMON;


/****************************************************************************/
#define SMH_REGISTER           0L              /* (Valid only from ring 3 stream */
                                               /*  handler)                 */
     typedef struct  _parm_reg { /* smhreg */
        ULONG     ulFunction;                  /* SMH command function      */
        PSZ       pszSHName;                   /* Max size = 8 characters   */
        PHID      phidSrc;                     /* (9 including null)        */
        PHID      phidTgt;
        PSHCFN    pshcfnEntry;                 /* Handler entry point for SHC's  */
                                               /*  Only used for Ring 0 handlers.*/
        ULONG     ulFlags;
        ULONG     ulMaxNumStreams;             /* Max # of streams          */
        ULONG     ulMaxNumEvents;              /* Max # of events/stream    */
        } PARM_REG;
#define REGISTER_TGT_HNDLR     0x0001L         /* This handler is Target.   */
#define REGISTER_SRC_HNDLR     0x0002L         /* This handler is Source.   */
                                               /* Handlr can be both.       */
#define REGISTER_NONSTREAMING  0x0004L         /* Handler is non-streaming. */
#define VALIDREGISTERFLAGS     (REGISTER_TGT_HNDLR | REGISTER_SRC_HNDLR | REGISTER_NONSTREAMING)


/* Notes:                                                                     */
/*  - Since ring 0 (DD) stream handlers can not use the IDC interface to the  */
/*    sync/stream manager during DD initialization time, it must use the IOCTL*/
/*    function to perform the SMH_REGISTER function. The addresses are 16:16  */
/*    for this IOCTl instead of 0:32, because it comes form a device driver.  */
#define SSMDD_CATEGORY            0x0081    /* Category (For ring 0 stream handler) */
#define IOCTL_FUNC_SMH_REGISTER   0x0040    /* Function (For ring 0 stream handler) */


/****************************************************************************/
#define SMH_DEREGISTER         1L              /* SMH_Deregister()          */
     typedef struct  _parm_dereg { /* smhder */
        ULONG     ulFunction;                  /* SMH command function      */
        PSZ       pszSHName;                   /* Max size = 8 char, 9 includes */
        } PARM_DEREG;                          /* the null.                 */


/****************************************************************************/
#define SMH_REPORTEVENT        2L              /* SMH_ReportEvent()         */
     typedef struct  _parm_event { /* smhrev */
        ULONG     ulFunction;                  /* SMH command function      */
        HID       hid;
        HEVENT    hevent;                      /* Used only for explicit events   */
                                               /*  Must be 0 for sync and implicit*/
                                               /*  events (i.e. error events)     */
        PEVCB     pevcbEvent;                  /* Event status & HSTREAM          */
        } PARM_EVENT;


/****************************************************************************/
#define SMH_NOTIFY             3L              /* SMH_Notify()              */
     typedef struct  _parm_notify { /* smhnot */
        ULONG     ulFunction;       /* Input - SMH command function         */
        HID       hid;              /* Input                                */
        HSTREAM   hstream;          /* Input                                */
        ULONG     ulFlags;          /* Input/Output                         */
        ULONG     ulGetNumEntries;  /* Input/Output - # of entries in table */
        ULONG     ulRetNumEntries;  /* Input/Output - # of entries in table */
        PVOID     pGetBufTab;       /* Output - Ptr to buffer/record table  */
        PVOID     pRetBufTab;       /* Input - Ptr to buffer/record table   */
        } PARM_NOTIFY;

     typedef struct _srcbuftab { /* srcbuftab */
        PVOID    pBuffer;      /* Ptr to buffer                             */
        PVOID    pRecord;      /* Ptr to record in buffer (split-streams only)  */
        ULONG    ulLength;     /* Max buf length on GetEmpty, Filled        */
                               /* (actual) rec/buf length on ReturnFull.    */
        ULONG    ulMessageParm; /* Message to passed to application         */
        MMTIME   mmtimeOffset; /* mmtime offset from beginning of buffer    */
        } SRCBUFTAB;

     typedef struct _tgtbuftab { /* tgtbuftab */
        PVOID    pBuffer;      /* Ptr to buffer                             */
        ULONG    ulBufId;      /* Buffer ID. Passed to SH on GetFull, must  */
                               /* be passed back to SSM on ReturnEmpty.     */
        ULONG    ulLength;     /* Filled (actual) buffer length on GetFull, */
                               /* unused on ReturnEmpty.                    */
        ULONG    ulMessageParm; /* Message to passed to application         */
        MMTIME   mmtimeOffset; /* mmtime offset from beginning of buffer    */
        } TGTBUFTAB;

/*SMH_ulFlags:                                                              */
#define BUF_GETEMPTY       0x00000001L   /* Ptr returned in SMH_pGetBuffer  */
#define BUF_RETURNFULL     0x00000002L   /* Ptr passed in SMH_pRetBuffer    */
#define BUF_GETFULL        0x00000004L   /* Ptr returned in SMH_pGetBuffer  */
#define BUF_RETURNEMPTY    0x00000008L   /* Ptr passed in SMH_pRetBuffer    */
#define BUF_GIVEBUF        0x00000010L   /* Ptr passed in SMH_pRetBuffer    */
#define BUF_EOS            0x00000100L   /* End of stream. Source sets this on */
                                         /*  last buffer. Target sets it after */
                                         /*  consuming the laset buffer.       */
#define BUF_RECORDS        0x00004000L   /* One or more records (Split-stream) */
#define BUF_LASTRECORD     0x00008000L   /* (BUF_RETURNFULL only) Mark         */
                                         /* these record(s) as being the       */
                                         /* last in the buffer. So the SSM     */
                                         /* knows the maximum # of records     */
                                         /* produced for this buffer.          */
                                         /* (Split stream only)                */
/*SMH_ulFlags: (Available at ring 0 only)                                      */
#define BUF_LINEAR         0x00010000L   /* Ptrs are Global linear (Ring 0 only) */
#define BUF_PHYSICAL       0x00020000L   /* Ptrs are physical (Ring 0 only)      */
                                         /* (valid only for phyically            */
                                         /*  contiguous buffers)                 */
#define BUF_RESERVED       0x00040000L   /* Reserved                             */

#define VALIDSOURCEFLAGS (BUF_RETURNFULL|BUF_GETEMPTY|BUF_EOS|BUF_LASTRECORD|BUF_PHYSICAL|BUF_LINEAR|BUF_RECORDS|BUF_GIVEBUF)
#define VALIDTARGETFLAGS (BUF_RETURNEMPTY|BUF_GETFULL|BUF_PHYSICAL|BUF_LINEAR|BUF_EOS)


/****************************************************************************/
#define SMH_LOCKMEM            4L              /* SMH_LockMem()             */
     typedef struct  _parm_lockm { /* smhloc */
        ULONG     ulFunction;                  /* SMH command function      */
        PVOID     pBuffer;
        ULONG     ulBufSize;
        PLOCKH    plockh;
        ULONG     ulFlags;
        } PARM_LOCKM;

/*SMH_ulFlags:                                                              */
#define SSM_LOCKMEM            0x0000L         /* Lock Memory.              */
#define SSM_UNLOCKMEM          0x0001L         /* Unlock memory.            */
#define SSM_CONTIGLOCK         0x0002L         /* Lock memory contiguously. */


/****************************************************************************/



/****************************************************************************/
/*                                                                          */
/*  Function Prototypes for SHC functions (Stream Handler Functions)        */
/*  All use Pure C calling convention                                       */
/*                                                                          */
/* NOTE ABOUT POINTERS:                                                     */
/*  0:32 linear addresses for ring 3 (DLL) stream handlers                  */
/*  16:16 selector/offset addresses for ring 0 (PDD) stream handlers        */
/****************************************************************************/
typedef struct _shc_common { /* shcfunc */
      ULONG    ulFunction;        /* Handler command function               */
      HID      hid;               /* handler ID                             */
   } SHC_COMMON;


/****************************************************************************/
#define SHC_ASSOCIATE             0L
     typedef struct _parm_assoc { /* shcass */
        ULONG    ulFunction;        /* Handler command function             */
        HID      hid;               /* handler ID                           */
        HSTREAM  hstream;           /* handle of stream instance            */
        PACB     pacb;              /* pointer to associate control block   */
     } PARM_ASSOC;


/****************************************************************************/
#define SHC_CLOSE                 1L
     typedef struct _parm_close { /* shcclo */
        ULONG    ulFunction;        /* Handler command function             */
        HID      hid;               /* handler ID                           */
     } PARM_CLOSE;


/****************************************************************************/
#define SHC_CREATE                2L
     typedef struct _parm_create { /* shccrt */
        ULONG    ulFunction;        /* Handler command function             */
        HID      hid;               /* handler ID                           */
        HSTREAM  hstream;           /* handle of stream instance            */
        SPCBKEY  spcbkey;           /* type of stream to create             */
        PSPCB    pspcb;             /* Pointer to SPCB from handler         */
        HSTREAM  hstreamBuf;        /* Used for split streams or to associate*/
                                    /* another stream with this stream.     */
        PDCB     pdcb;              /* pointer to device control block      */
     } PARM_CREATE;


/****************************************************************************/
#define SHC_DESTROY               3L
     typedef struct _parm_destroy { /* shcdes */
        ULONG    ulFunction;        /* Handler command function             */
        HID      hid;               /* handler ID                           */
        HSTREAM  hstream;           /* handle of stream instance            */
     } PARM_DESTROY;


/****************************************************************************/
#define SHC_START                 4L
     typedef struct _parm_start { /* shcstr */
        ULONG    ulFunction;        /* Handler command function             */
        HID      hid;               /* handler ID                           */
        HSTREAM  hstream;           /* handle of stream instance            */
        ULONG    ulFlags;           /* Start flags                          */
     } PARM_START;

/* ulFlags:                                                                 */
#define FLUSH_START      0x0001L    /* This start is a result of a Flush Stop command. */


/****************************************************************************/
#define SHC_STOP                  5L
     typedef struct _parm_stop { /* shcstp */
        ULONG    ulFunction;        /* Handler command function             */
        HID      hid;               /* handler ID                           */
        HSTREAM  hstream;           /* handle of stream instance            */
        ULONG    ulFlags;           /* Stop flags (refer to ulFlags defines under */
                                    /*  SpiStopStream() call.               */
     } PARM_STOP;


/****************************************************************************/
#define SHC_SEEK                  6L
     typedef struct _parm_seek { /* shcsek */
        ULONG    ulFunction;        /* Handler command function             */
        HID      hid;               /* handler ID                           */
        HSTREAM  hstream;           /* handle of stream instance            */
        ULONG    ulFlags;           /* Seek flag (refer to ulFlags defines  */
                                    /*  under SpiSeekStream() call).        */
        LONG     lSeekPoint;        /* seek to point , mmtime or other      */
     } PARM_SEEK;


/****************************************************************************/
#define SHC_ENABLE_EVENT          7L
     typedef struct _parm_enevent { /* shceev */
        ULONG    ulFunction;        /* Handler command function             */
        HID      hid;               /* handler ID                           */
        HEVENT   hevent;            /* handle of event to enable            */
        PEVCB    pevcbUser;         /* User event information (e.g. hstream */
                                    /*  EventType, EventSubType)            */
     } PARM_ENEVENT;


/****************************************************************************/
#define SHC_DISABLE_EVENT         8L
     typedef struct _parm_disevent { /* shcdev */
        ULONG    ulFunction;        /* Handler command function             */
        HID      hid;               /* handler ID                           */
        HSTREAM  hstream;           /* handle to stream for this event      */
        HEVENT   hevent;            /* handle of event to disable           */
     } PARM_DISEVENT;


/****************************************************************************/
#define SHC_ENABLE_SYNC           9L
     typedef struct _parm_ensync { /* shcesy */
        ULONG    ulFunction;        /* Handler command function             */
        HID      hid;               /* handler ID                           */
        HSTREAM  hstream;           /* handle of stream instance            */
        ULONG    ulFlags;           /* Sync flags                           */
        MMTIME   mmtimeSync;        /* granularity of sync interval (if null, use default) */
        PSYNC_EVCB pevcbSyncPulse;  /* Sync pulse EVCB information          */
        ULONG    ulSyncPulseSem;    /* Optional 16 bit system               */
                                    /* Semaphore for handler                */
     } PARM_ENSYNC;

/* ulFlags:                                                                 */
#define SYNC_MASTER      0x0000L    /* The handler will be a master for this sync*/
#define SYNC_SLAVE       0x0001L    /* The handler will be a slave for this sync */


/****************************************************************************/
#define SHC_DISABLE_SYNC          10L
     typedef struct _parm_dissync { /* shcdsy */
        ULONG    ulFunction;        /* Handler command function             */
        HID      hid;               /* handler ID                           */
        HSTREAM  hstream;           /* handle of stream instance            */
     } PARM_DISSYNC;


/****************************************************************************/
#define SHC_GET_TIME              11L
     typedef struct _parm_gtime { /* shcgti */
        ULONG    ulFunction;        /* Handler command function             */
        HID      hid;               /* handler ID                           */
        HSTREAM  hstream;           /* handle of stream instance            */
        MMTIME   mmtimeCurrent;     /* Returns current stream time          */
     } PARM_GTIME;


/****************************************************************************/
#define SHC_GET_PROTOCOL          12L
     typedef struct _parm_gprot { /* shcgpt */
        ULONG    ulFunction;        /* Handler command function             */
        HID      hid;               /* handler ID                           */
        SPCBKEY  spcbkey;           /* key of SPCB                          */
        PSPCB    pspcb;             /* ptr to SPCB (output)                 */
     } PARM_GPROT;


/****************************************************************************/
#define SHC_INSTALL_PROTOCOL      13L
     typedef struct _parm_instprot { /* shcipt */
        ULONG    ulFunction;        /* Handler command function             */
        HID      hid;               /* handler ID                           */
        SPCBKEY  spcbkey;           /* key of SPCB                          */
        PSPCB    pspcb;             /* ptr to SPCB to install               */
        ULONG    ulFlags;           /* Install / Deinstall flags            */
     } PARM_INSTPROT;


/****************************************************************************/
#define SHC_ENUMERATE_PROTOCOLS   14L
     typedef struct _parm_enumprot { /* shcqpi */
        ULONG    ulFunction;        /* Handler command function             */
        HID      hid;               /* handler ID                           */
        PVOID    paSPCBKeys;        /* ptr to buffer to fill with SPCB keys */
        PULONG   pulNumSPCBKeys;    /* # of entries buffer on input,        */
                                    /*  # of SPCB key on output.            */
     } PARM_ENUMPROT;


/****************************************************************************/
#define SHC_NEGOTIATE_RESULT      15L
     typedef struct _parm_negotiate { /* shcneg */
        ULONG    ulFunction;        /* Handler command function             */
        HID      hid;               /* handler ID                           */
        HSTREAM  hstream;           /* handle of stream instance            */
        PSPCB    pspcb;             /* Ptr to negotiated SPCB               */
        ULONG    ulErrorStatus;     /* On error, indicates which field in the*/
     } PARM_NEGOTIATE;              /* SPCB failed the negotiation.         */


/****************************************************************************/

/* XLATOFF */
#pragma pack()
/* XLATON */
