/****************************************************************/
/*				      SAMPLE1.C                                 */
/*                                                              */
/*	This is the main module for the ACPA Sample1 program.       */
/*	It will determine if the ACPA card is installed,            */
/*	and determine at which base address.                        */
/*                                                              */
/*	It will read the system ID byte at F000:FFFE to determine   */
/*	whether a microchannel or family 1 bus is used.             */
/*                                                              */
/*	This program can be compiled using IBM C/2.  It will run    */
/*	under DOS 3.3.                                              */
/*                                                              */
/*	The commands used to compile this program:                  */
/*                                                              */
/*		cc /AL /W2 /Ze /G0 sample1;                             */
/*		link sample1,sample1.exe,,slibcer;                      */
/*                                                              */
/*	(C)Copyright IBM Corp. 1989.  All rights reserved.          */
/****************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<memory.h>
#include	<dos.h>
#include	<conio.h>

#define	POS_SEL		0x96
#define	POS0		0x100
#define	POS1		0x101
#define	POS2		0x102
#define	Card_ID		0x6e6c

unsigned int poslocs[4] = {	0xfdc0, 0xfdc8, 0xfdd0, 0xfdd8 };

unsigned int acpabase;

int	is_uchan = 0;			/* 1 if uchannel */

int	posdata;			/* data read from pos2 */

unsigned int	fam1locs[11] = {	/* Family 1 bus I/O locations	*/
	0x310,0x318,0x330,0x338,0x368,
	0x710,0x718,0x730,0x738,0x768,
	0x300 };

unsigned char model;				/* PC type	*/
unsigned char submodel;				/* PC subtype	*/

char	progname1[] = { "Audio Capture and Playback Adapter"};
char	progname2[] = { "Sample program 1" };
char	secnote[] = { "(C) Copyright IBM Corp. 1989.  All rights reserved." };
char	progauth[] = { "Written by Ron Lisle"};

void main(argc,argv)
int		argc;
char	*argv[];
{
	unsigned char far *p;
	int	x,y,found;

	printf("\n%s\n%s\n%s\n\n",progname1,progname2,secnote);

	/* Read system ID and determine whether Microchannel or Family 1 */
	p = &model;
	movedata(0xf000,0xfffe,FP_SEG(p),FP_OFF(p),1);
	p = &submodel;
	movedata(0xf000,0xffff,FP_SEG(p),FP_OFF(p),1);

	/* Search for card */
	found = 0;
	if(model==0xf8)	is_uchan = 1;				/* Mod 70/80 */
	else if((model==0xfc)&&(submodel==4 || submodel==5))	/* Mod 50/60 */
		is_uchan = 1;
	else is_uchan = 0;

	if(is_uchan){

		/* Do microchannel search */
		for(x=8; x<16 && !found; x++){		/* Search all 8 slots	*/
			outp(POS_SEL,x);		/* Select a slot	*/
			y = (inp(POS1)<<8)+inp(POS0);	/* Get high/low ids	*/
			if(y==Card_ID) found=1;		/* is it 6E6C?		*/
		}
		if(found){
			posdata = inp(POS2);
			acpabase = poslocs[(posdata & 0x06)>>1];
			outp(POS_SEL,0);
		}else{
			outp(POS_SEL,0);					/* Restore POS reg */
		}

	}else{		/* Do family1 bus search */
		for(x=0; x<11 && !found; x++){
			if(inp(fam1locs[x]+7)==0x6c){
				found = 1;
				acpabase = fam1locs[x];
			}
		}
	}
	printf("Audio Capture and Playback Adapter ");
	if(found) printf("found at address %x\n",acpabase);
	else printf("not found\n");
}
