/************************************/
/*                                  */
/*  MIDIC - OS/2 device driver      */
/*          Header File copyright   */
/*          IBM 1991                */
/*                                  */
/*                                  */
/*                                  */
/* This header file contains the    */
/* required OS/2 device driver      */
/* structures for the Drive header  */
/* the Request Header, the INIT_IN  */
/* packet, the INIT_OUT packet, and */
/* for this particular device       */
/* driver, also the ReadWrite pack- */
/* et.                              */
/*                                  */
/************************************/

void   near last_code();


extern void near STRAT();
extern void near ReadBytes(unsigned long,
                           unsigned long,
                           unsigned short);
extern void near WriteBytes(unsigned long,
                            unsigned long,
                            unsigned short);
extern void near int3();
extern void near SetIRQ(unsigned short,
                        void near *,
                        unsigned short);
extern void near INT_HNDLR();
extern int  pascal far DOSPUTMESSAGE(unsigned int,
                                     unsigned int,
                             unsigned char far *);

#define MIDI_DATA 0x0330
#define MIDI_CMD  0x0331
#define DUMB_MODE 0x003f
#define MPU_RESET 0x00ff

#define DAW_CHR   0x8000
#define DAW_IDC   0x4000
#define DAW_IBM   0x2000
#define DAW_SHR   0x1000
#define DAW_OPN   0x0800
#define DAW_LEVEL 0x0080
#define DAW_GIO   0x0040
#define DAW_CLK   0x0008
#define DAW_NUL   0x0004
#define DAW_SCR   0x0002
#define DAW_KBD   0x0001

#define ERR     0x8000
#define DEV     0x4000
#define BUSY    0x0200
#define DONE    0x0100

#define INIT          0x00
#define MEDIA_CHECK   0x01
#define BUILD_BPB     0x02
#define READ          0x04
#define READ_NO_WAIT  0x05
#define INPUT_STATUS  0x06
#define INPUT_FLUSH   0x07
#define WRITE         0x08
#define WRITE_VERIFY  0x09
#define OUTPUT_STATUS 0x0a
#define OUTPUT_FLUSH  0x0b
#define OPEN          0x0d
#define CLOSE         0x0e
#define REMOVABLE     0x0f
#define IOCTL         0x10
#define RESET         0x11
#define GET_DRIVE_MAP 0x12
#define SET_DRIVE_MAP 0x13
#define DEINSTALL     0x14
#define PARTITIONABLE 0x16
#define GET_FIXED_MAP 0x17


typedef struct DeviceHdr {
   struct DeviceHdr far *PtrNextHdr; /* -1, no more */
   unsigned short  HdrAttr;     /* hdr attribute    */
   void near       *Strat;      /* offset of _strat */
   void near        *IDC;       /* offset of IDC    */
   unsigned char name[8];       /* name of driver   */
   char reserved[8];            /* reserved.        */
}  DeviceHeader;

typedef struct RQpacket {
   unsigned char  req_pac_len;  /* length of packet */
   unsigned char  req_unit;     /* use for BLOCK DD */
   unsigned char  req_cmd;      /* which command... */
   unsigned short req_stat;     /* returned status. */
   unsigned long  req_resrvd;   /* for use by OS/2. */
   unsigned long  req_link;     /* used for queueing*/
}  ReqHeader;

typedef struct InitEnt {
   ReqHeader        InitEntHdr; /* space for header */
   unsigned char    units;      /* number of units. */
   unsigned char far *DevHlp;   /* Address of DevHlp*/
   unsigned char far *InitCmd;  /* ptr to commands. */
   unsigned short   drive;      /* drive # block DD */
}  InitEntry;

typedef struct InitExt {
   ReqHeader        InitExtHdr; /* space for header */
   unsigned char    units;      /* number of units. */
   unsigned short   code_off;   /* offset of code.  */
   unsigned short   data_off;   /* offset of data.  */
   unsigned char far *BPBptr;   /* address of BPB.  */
}  InitExit;

typedef struct Read {
   ReqHeader        ReadHdr;    /* space for header */
   unsigned char    media_des;  /* media descriptor */
   unsigned long    buff_addr;  /* physical address */
   unsigned short   count;      /* number of bytes  */
   unsigned long    start_sel;  /* starting sel #   */
   unsigned short   reserved;   /* for use by OS/2  */
} DeviceRead;

typedef struct Write {
   ReqHeader        WriteHdr;   /* space for header */
   unsigned char    media_des;  /* media descriptor */
   unsigned long    buff_addr;  /* physical address */
   unsigned short   count;      /* number of bytes  */
   unsigned long    start_sel;  /* starting sel #   */
   unsigned short   reserved;   /* for use by OS/2  */
} DeviceWrite;


