/*
    filename :  select.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#include <stdio.h>
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

extern  I_IMGLOB    i_glob;

/*/     Function:   iosldevice()
*       Synopsis:   select IM-1280 board. The selected board will be the
*                   destination for all high level commands.
*
*       Date:       February 12, 1990
*
*       Parameter:  int     handle;         identification of the device to
*                                           select
*                                               
*       Return value:   0 on succes, -1 on error.                                        
**/

#ifdef  ANSI
short   FTYPE iosldevice(int handle)
#else
short   FTYPE iosldevice(handle)
int     handle;
#endif
{
#if defined(I_MS_DOS) || defined(I_PHYSMAP)

    short device = handle;

#endif

#if defined(I_UNIX) || defined(I_OS2)

#ifdef  I_PHYSMAP

    /* find device index */
    for (device = 0; device < I_N_OF_DEVICES; device++)
        {
        if ( i_glob.fd[device] == handle)
            break;
        }

    if ( device == I_N_OF_DEVICES ) {
        return( -1 );
	}
#else

    i_glob.board = handle;
    return(0);

#endif

#endif


#if defined(I_MS_DOS) || defined(I_PHYSMAP)

    if ( i_glob.img_addr[device] )  /* Check if new device was opened. */
        {

/*         if (i_glob.img_addr[i_glob.img_dev]) */ 
/*             IMG_DISABLE(i_glob.img_dev); */ 

        /* Change current board. */

        i_glob.img_dev  = device;
        i_glob.imgmap   = i_glob.img_addr[device];

#ifdef  I_MS_DOS
        i_glob.img_unit = ( device - 1 ) & 1;
#endif
#ifdef  I_UNIX
        /* more magic numbers please */
        i_glob.img_unit = (((device <= 7) && (device >= 1)) ||
         ((device <= 21) && (device >= 15))) ? 0 : 1;
#endif
#ifdef  I_OS2
        /* more magic numbers please */
        i_glob.img_unit = (((device <= 7) && (device >= 1)) ||
         ((device <= 21) && (device >= 15))) ? 1 : 0;
#endif

        i_glob.board = handle;

#ifdef PHAR_LAP
        i_glob.imghra = (IMGHRA *)&(i_glob.imgmap->hra[i_glob.img_unit]);
#else
        i_glob.imghra = &((i_glob.imgmap) -> hra[i_glob.img_unit]);
#endif  /* PHAR_LAP */

        }
    else {
        return( -1 );
	}

    return( 0 );

#endif

} /* iosldevice() */ 
